/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CollectionQuery;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.search.OCDirectStructInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionInheritorsSearch
extends QueryFactory<OCFunctionSymbol, SearchParameters> {
    public static final OCFunctionInheritorsSearch INSTANCE = new OCFunctionInheritorsSearch();

    public static SearchParameters getParameters(OCSymbolWithQualifiedName symbol, OCFile context, boolean searchBySignature) {
        if (symbol == null) {
            return new SearchParameters();
        }
        OCQualifiedName qualifiedName = symbol.getResolvedQualifiedName();
        OCQualifiedName parentName = qualifiedName != null ? qualifiedName.getQualifier() : OCQualifiedName.GLOBAL;
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)symbol.getProject());
        SearchParameters parameters = searchBySignature ? SearchParameters.getSearchFunctionBySignatureParameters(context, scope, symbol.getName(), symbol.getType(), parentName) : SearchParameters.getSearchFunctionByNameParameters(context, scope, symbol.getName(), parentName);
        if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isFriendFunction() && !((OCFunctionSymbol)symbol).isCppOperator()) {
            parameters.myIsFriend = true;
        }
        parameters.myIsStatic = symbol.isStatic();
        return parameters;
    }

    public static SearchParameters getParameters(OCFunctionDeclaration function, boolean searchBySignature) {
        return OCFunctionInheritorsSearch.getParameters((OCSymbolWithQualifiedName)function.getSymbol(), function.getContainingOCFile(), searchBySignature);
    }

    public static Query<OCFunctionSymbol> search(SearchParameters parameters) {
        return OCFunctionInheritorsSearch.search(parameters, null);
    }

    public static Query<OCFunctionSymbol> search(SearchParameters parameters, @Nullable MultiMap<OCQualifiedName, OCQualifiedName> inheritanceCache) {
        if (parameters.getFunctionName() == null) {
            return new EmptyQuery();
        }
        parameters.myInheritenceCache = inheritanceCache;
        return INSTANCE.createQuery(parameters);
    }

    public static Query<OCFunctionSymbol> search(OCFunctionSymbol function, OCFile context, boolean searchBySignature) {
        return OCFunctionInheritorsSearch.search(OCFunctionInheritorsSearch.getParameters(function, context, searchBySignature));
    }

    private OCFunctionInheritorsSearch() {
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCFunctionSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(final @NotNull SearchParameters p, @NotNull Processor<OCFunctionSymbol> consumer) {
            HashSet curSubstructs;
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/jetbrains/cidr/lang/search/OCFunctionInheritorsSearch$DefaultExecutor", "processQuery"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/cidr/lang/search/OCFunctionInheritorsSearch$DefaultExecutor", "processQuery"));
            }
            final GlobalSearchScope scope = p.getScope();
            HashSet substructs = new HashSet();
            final OCQualifiedName parentStruct = p.getParentStruct();
            if (p.myInheritenceCache != null && p.myInheritenceCache.containsKey((Object)parentStruct)) {
                Collection cached = p.myInheritenceCache.get((Object)parentStruct);
                substructs.addAll(cached);
            } else {
                Query<OCStructSymbol> search = p.myIncludeOnlyDirectInheritors ? OCDirectStructInheritorsSearch.search(parentStruct, scope, p.myContext, p.myProject) : OCStructInheritorsSearch.search(parentStruct, scope, p.myContext, p.myProject);
                for (OCStructSymbol substruct : search.findAll()) {
                    substructs.add((Object)substruct.getResolvedQualifiedName(false));
                }
                if (p.myInheritenceCache != null) {
                    p.myInheritenceCache.putValues((Object)parentStruct, (Collection)substructs);
                }
            }
            HashSet hashSet = curSubstructs = p.myIsStatic ? new HashSet() : new HashSet((Collection)substructs);
            if (p.myIncludeSameSymbols) {
                curSubstructs.add((Object)parentStruct.dropArguments());
            }
            final HashMap map = new HashMap();
            Processor<OCFunctionSymbol> processor2 = p.myImplementationsThenPredefinitions || p.myPredefinitionsThenImplementations ? new Processor<OCFunctionSymbol>(){

                public boolean process(OCFunctionSymbol symbol) {
                    OCFunctionSymbol old = (OCFunctionSymbol)map.get((Object)symbol.getResolvedQualifiedName());
                    if (p.myIncludeSameSymbols || old == null || old.isPredeclaration() && p.myImplementationsThenPredefinitions || !old.isPredeclaration() && p.myPredefinitionsThenImplementations) {
                        map.put((Object)symbol.getResolvedQualifiedName(), (Object)symbol);
                    }
                    return true;
                }
            } : consumer;
            OCFile context = p.myContext;
            final VirtualFile contextFile = context != null ? context.getContainingFile().getVirtualFile() : null;
            final OCType resolved = p.myType != null ? p.myType.resolve(context) : null;
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(p.getProject(), new Processor<OCSymbol>((Processor)processor2){
                final /* synthetic */ Processor val$processor;
                {
                    this.val$processor = processor2;
                }

                public boolean process(OCSymbol symbol) {
                    OCQualifiedName parentName;
                    ProgressManager.checkCanceled();
                    if (!(symbol instanceof OCFunctionSymbol) || !scope.accept(symbol.getContainingFile())) {
                        return true;
                    }
                    OCFunctionSymbol function = (OCFunctionSymbol)symbol;
                    OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)symbol).getParent();
                    OCQualifiedName oCQualifiedName = parentName = parent != null ? parent.getResolvedQualifiedName() : null;
                    if (!(p.isFriend() || function.isFriendFunction() && !function.isCppOperator() || parentName == null && parentStruct == OCQualifiedName.GLOBAL && curSubstructs.contains((Object)OCQualifiedName.GLOBAL) || parentName != null && curSubstructs.contains((Object)parentName.dropArguments()))) {
                        return true;
                    }
                    if (function.isLocalInFile() && !Comparing.equal((Object)contextFile, (Object)function.getContainingFile())) {
                        return false;
                    }
                    OCFile file2 = function.getContainingOCFile();
                    if (resolved != null && !function.getType().equalsAfterResolving(resolved, file2)) {
                        return true;
                    }
                    return symbol.processSameSymbols(new Processor<OCSymbol>(){

                        public boolean process(OCSymbol symbol) {
                            return !(symbol instanceof OCFunctionSymbol) || val$processor.process((Object)((OCFunctionSymbol)symbol));
                        }
                    });
                }
            }, p.myFunctionName);
            if (processor2 != consumer) {
                new CollectionQuery(map.values()).forEach((Processor)consumer);
            }
        }
    }

    public static class SearchParameters {
        private GlobalSearchScope myScope;
        private Project myProject;
        private String myFunctionName;
        private OCType myType;
        private OCFile myContext;
        private OCQualifiedName myParentStruct;
        private boolean myIncludeSameSymbols;
        private boolean myIsFriend;
        private boolean myIsStatic;
        private boolean myIncludeOnlyDirectInheritors;
        private boolean myPredefinitionsThenImplementations;
        private boolean myImplementationsThenPredefinitions;
        private MultiMap<OCQualifiedName, OCQualifiedName> myInheritenceCache;

        public Project getProject() {
            return this.myProject;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }

        public String getFunctionName() {
            return this.myFunctionName;
        }

        public OCType getType() {
            return this.myType;
        }

        public OCQualifiedName getParentStruct() {
            return this.myParentStruct;
        }

        public boolean isFriend() {
            return this.myIsFriend;
        }

        public void setIncludeSameSymbols(boolean value) {
            this.myIncludeSameSymbols = value;
        }

        public void setIncludeOnlyDirectInheritors(boolean value) {
            this.myIncludeOnlyDirectInheritors = value;
        }

        public void setPredeclarationsThenImplementations(boolean value) {
            this.myPredefinitionsThenImplementations = value;
        }

        public void setImplementationsThenPredeclarations(boolean value) {
            this.myImplementationsThenPredefinitions = value;
        }

        public static SearchParameters getSearchFunctionByNameParameters(OCFile context, GlobalSearchScope scope, String name, OCQualifiedName receiverType) {
            SearchParameters result2 = new SearchParameters();
            result2.myProject = context.getProject();
            result2.myContext = context;
            result2.myScope = scope;
            result2.myFunctionName = name;
            result2.myParentStruct = receiverType;
            return result2;
        }

        public static SearchParameters getSearchFunctionBySignatureParameters(OCFile context, GlobalSearchScope scope, String name, OCType type, OCQualifiedName receiverType) {
            SearchParameters result2 = new SearchParameters();
            result2.myProject = context.getProject();
            result2.myContext = context;
            result2.myScope = scope;
            result2.myFunctionName = name;
            result2.myType = type;
            result2.myParentStruct = receiverType;
            return result2;
        }

        private SearchParameters() {
        }
    }
}

