/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SingleTargetRequestResultProcessor;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.jetbrains.cidr.lang.inspections.OCGlobalSearchScopeForUnusedCode;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.search.OCElementInMacroAndNonCompiledCodeReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementInMacroSubstitutionReferenceSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public static boolean isUsedInMacros(PsiElement element) {
        if (!(element.getUseScope() instanceof LocalSearchScope)) {
            return true;
        }
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        new OCElementInMacroSubstitutionReferenceSearch().execute(new ReferencesSearch.SearchParameters(element, element.getUseScope(), false), (Processor<PsiReference>)processor2);
        return processor2.isFound();
    }

    public boolean execute(final @NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/jetbrains/cidr/lang/search/OCElementInMacroSubstitutionReferenceSearch", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/cidr/lang/search/OCElementInMacroSubstitutionReferenceSearch", "execute"));
        }
        if (queryParameters.getScopeDeterminedByUser() instanceof OCGlobalSearchScopeForUnusedCode) {
            return true;
        }
        return (Boolean)new ReadAction<Boolean>(){

            protected void run(@NotNull Result<Boolean> result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/search/OCElementInMacroSubstitutionReferenceSearch$1", "run"));
                }
                result2.setResult((Object)OCElementInMacroSubstitutionReferenceSearch.this.doExecute(queryParameters, (Processor<PsiReference>)consumer));
            }
        }.execute().getResultObject();
    }

    public boolean doExecute(final @NotNull ReferencesSearch.SearchParameters p, final @NotNull Processor<PsiReference> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/jetbrains/cidr/lang/search/OCElementInMacroSubstitutionReferenceSearch", "doExecute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/cidr/lang/search/OCElementInMacroSubstitutionReferenceSearch", "doExecute"));
        }
        final PsiElement target = p.getElementToSearch();
        final boolean searchForRenameConflicts = p instanceof MySearchParameters && ((MySearchParameters)p).searchForRenameConflicts();
        class MacroCallProcessor
        implements Processor<PsiReference> {
            Set<OCMacroSymbol> badMacros = new HashSet();
            Set<OCMacroSymbol> goodMacros = new HashSet();
            Map<OCMacroSymbol, PsiElement> badMacroReferences = new HashMap();
            SingleTargetRequestResultProcessor resultProcessor = new SingleTargetRequestResultProcessor(target);

            MacroCallProcessor() {
            }

            public boolean process(PsiReference psiReference) {
                PsiElement element = psiReference.getElement();
                final PsiElement macroCall = element.getParent();
                if (macroCall instanceof OCMacroCall) {
                    OCMacroSymbol macroSymbol = ((OCMacroCall)macroCall).resolveToSymbol();
                    final Ref wasGoodRef = Ref.create((Object)false);
                    boolean result2 = ((OCMacroCall)macroCall).processExpansionDependenciesWithIdent(OCElementInMacroSubstitutionReferenceSearch.getElementName(target), new Processor<PsiElement>(){

                        public boolean process(PsiElement element) {
                            OCMacroRange range = OCElementUtil.getRangeInMacroCall(element, (OCMacroCall)macroCall);
                            return resultProcessor.processTextOccurrence(element, 0, (Processor)new Processor<PsiReference>(){

                                public boolean process(PsiReference psiReference) {
                                    wasGoodRef.set((Object)true);
                                    return consumer.process((Object)psiReference);
                                }
                            });
                        }
                    });
                    if (searchForRenameConflicts && macroSymbol != null) {
                        if (((Boolean)wasGoodRef.get()).booleanValue()) {
                            this.goodMacros.add(macroSymbol);
                        } else {
                            this.badMacros.add(macroSymbol);
                            this.badMacroReferences.put(macroSymbol, element);
                        }
                    }
                    return result2;
                }
                return true;
            }
        }
        final MacroCallProcessor macroCallProcessor = new MacroCallProcessor();
        SearchScope scope = p.getEffectiveSearchScope();
        if (scope instanceof LocalSearchScope) {
            boolean result2 = PsiTreeUtil.processElements((PsiElementProcessor)new PsiElementProcessor(){
                {
                }

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/search/OCElementInMacroSubstitutionReferenceSearch$2", "execute"));
                    }
                    if (!(element instanceof OCMacroCall)) {
                        return true;
                    }
                    OCReferenceElement macroReferenceElement = ((OCMacroCall)element).getMacroReferenceElement();
                    if (macroReferenceElement != null) {
                        return macroCallProcessor.process(macroReferenceElement.getReference());
                    }
                    return true;
                }
            }, (PsiElement[])((LocalSearchScope)scope).getScope());
            if (!searchForRenameConflicts || macroCallProcessor.goodMacros.isEmpty()) {
                return result2;
            }
            scope = GlobalSearchScope.allScope((Project)target.getProject());
        }
        final PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)target.getProject());
        final SearchScope finalScope = scope;
        Processor<OCElementInMacroAndNonCompiledCodeReferencesSearch.Usage> elementsInMacroProcessor = new Processor<OCElementInMacroAndNonCompiledCodeReferencesSearch.Usage>(){
            HashSet<OCSymbol> myProcessedDirectives = new HashSet();
            {
            }

            public boolean process(OCElementInMacroAndNonCompiledCodeReferencesSearch.Usage usage) {
                OCDefineDirective directive;
                String directiveName;
                PsiElement element = usage.getElement();
                if (element instanceof OCMacroCall) {
                    OCReferenceElement macroReferenceElement = ((OCMacroCall)element).getMacroReferenceElement();
                    if (macroReferenceElement != null) {
                        return macroCallProcessor.process(macroReferenceElement.getReference());
                    }
                } else if (!(element instanceof OCDefineDirective)) {
                    return true;
                }
                if ((directiveName = (directive = (OCDefineDirective)element).getName()) == null) {
                    return true;
                }
                if (this.myProcessedDirectives.add((Object)directive.getSymbol())) {
                    ReferencesSearch.SearchParameters parameters = new ReferencesSearch.SearchParameters((PsiElement)directive, finalScope, p.isIgnoreAccessScope(), p.getOptimizer());
                    new OCElementInMacroAndNonCompiledCodeReferencesSearch().execute(parameters, this);
                }
                TextOccurenceProcessor referenceProcessor = new TextOccurenceProcessor(){
                    SingleTargetRequestResultProcessor resultProcessor;
                    {
                        this.resultProcessor = new SingleTargetRequestResultProcessor((PsiElement)directive);
                    }

                    public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/search/OCElementInMacroSubstitutionReferenceSearch$3$1", "execute"));
                        }
                        return this.resultProcessor.processTextOccurrence(element, offsetInElement, (Processor)macroCallProcessor);
                    }
                };
                return helper.processElementsWithWord(referenceProcessor, finalScope, directiveName, (short)1, true);
            }
        };
        boolean result3 = new OCElementInMacroAndNonCompiledCodeReferencesSearch().execute(p, (SearchScope)OCSearchScope.getProjectSourcesScope(target.getProject()), elementsInMacroProcessor);
        if (searchForRenameConflicts) {
            macroCallProcessor.badMacros.retainAll(macroCallProcessor.goodMacros);
            for (OCMacroSymbol macro : macroCallProcessor.badMacros) {
                consumer.process((Object)new BadMacroSubstitutionReference(macroCallProcessor.badMacroReferences.get(macro), macro));
            }
        }
        return result3;
    }

    @Nullable
    private static String getElementName(PsiElement target) {
        if (target instanceof PsiNamedElement) {
            return ((PsiNamedElement)target).getName();
        }
        return null;
    }

    public static class BadMacroSubstitutionReference
    extends PsiReferenceBase {
        private OCMacroSymbol myMacroSymbol;

        public BadMacroSubstitutionReference(@NotNull PsiElement element, OCMacroSymbol macroSymbol) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/search/OCElementInMacroSubstitutionReferenceSearch$BadMacroSubstitutionReference", "<init>"));
            }
            super(element, new TextRange(0, element.getTextLength()));
            this.myMacroSymbol = macroSymbol;
        }

        public PsiElement resolve() {
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = new Object[]{};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/OCElementInMacroSubstitutionReferenceSearch$BadMacroSubstitutionReference", "getVariants"));
            }
            return objectArray;
        }

        public OCMacroSymbol getMacroSymbol() {
            return this.myMacroSymbol;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return this.myElement;
        }
    }

    public static class MySearchParameters
    extends ReferencesSearch.SearchParameters {
        private boolean mySearchForRenameConflicts;

        public MySearchParameters(@NotNull PsiElement elementToSearch, SearchScope scope, boolean ignoreAccessScope, boolean searchForRenameConflicts) {
            if (elementToSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToSearch", "com/jetbrains/cidr/lang/search/OCElementInMacroSubstitutionReferenceSearch$MySearchParameters", "<init>"));
            }
            super(elementToSearch, scope, ignoreAccessScope);
            this.mySearchForRenameConflicts = searchForRenameConflicts;
        }

        public boolean searchForRenameConflicts() {
            return this.mySearchForRenameConflicts;
        }
    }
}

