/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.resolve.references.OCCompositeResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeResourceCompletionProvider
extends OCResourceCompletionProvider {
    private static final Function<OCResourceCompletionProvider, String> CLASS_NAME = new Function<OCResourceCompletionProvider, String>(){

        public String fun(OCResourceCompletionProvider provider) {
            return provider.getClassName();
        }
    };
    private static final Function<OCResourceCompletionProvider, String> SELECTOR = new Function<OCResourceCompletionProvider, String>(){

        public String fun(OCResourceCompletionProvider provider) {
            return provider.getArgumentSelector();
        }
    };
    @NotNull
    private final OCResourceCompletionProvider[] myProviders;

    public CompositeResourceCompletionProvider(OCResourceCompletionProvider ... providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/jetbrains/cidr/lang/resolve/references/CompositeResourceCompletionProvider", "<init>"));
        }
        super(CompositeResourceCompletionProvider.className(providers), CompositeResourceCompletionProvider.argumentSelector(providers));
        this.myProviders = providers;
    }

    private static String argumentSelector(@NotNull OCResourceCompletionProvider[] providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/jetbrains/cidr/lang/resolve/references/CompositeResourceCompletionProvider", "argumentSelector"));
        }
        return CompositeResourceCompletionProvider.assertSameValue(Arrays.asList(providers), SELECTOR);
    }

    private static String className(@NotNull OCResourceCompletionProvider[] providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/jetbrains/cidr/lang/resolve/references/CompositeResourceCompletionProvider", "className"));
        }
        return CompositeResourceCompletionProvider.assertSameValue(Arrays.asList(providers), CLASS_NAME);
    }

    public static <T, V> V assertSameValue(@NotNull Iterable<T> items, Function<T, V> property) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/cidr/lang/resolve/references/CompositeResourceCompletionProvider", "assertSameValue"));
        }
        OCLog.LOG.assertTrue(items.iterator().hasNext());
        Object result2 = null;
        for (T item : items) {
            Object value = property.fun(item);
            OCLog.LOG.assertTrue(result2 == null || result2.equals(value));
            result2 = value;
        }
        return (V)result2;
    }

    @Override
    @Nullable
    protected OCResourceReference createReference(OCExpression expression, @Nullable PsiElement referenceElement) {
        ArrayList<OCResourceReference> references = new ArrayList<OCResourceReference>();
        for (OCResourceCompletionProvider provider : this.myProviders) {
            references.add(provider.createReference(expression, referenceElement));
        }
        return new OCCompositeResourceReference(references);
    }
}

