/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveOverloadsUtil {
    @Nullable
    public static OCSymbol resolveOverloads(Collection<OCSymbol> cases, List<OCType> argTypes, @NotNull OCResolveContext context, @Nullable PsiReference reference) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "resolveOverloads"));
        }
        return OCResolveOverloadsUtil.resolveOverloads(cases, argTypes, null, null, context, reference, false, false, false);
    }

    public static OCSymbol resolveOverloads(@Nullable OCStructType type, Collection<OCSymbol> cases, List<OCType> argTypes, @Nullable List<OCExpression> argExprs, @Nullable CVQualifiers cvQualifiers, PsiReference reference, boolean allowImplicitConversions, boolean filterByParameters, boolean filterByTemplates, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "resolveOverloads"));
        }
        if (type == null) {
            return OCResolveOverloadsUtil.resolveOverloads(cases, argTypes, argExprs, cvQualifiers, context, reference, filterByParameters, filterByTemplates, false);
        }
        OCSymbol<OCElement> badResult = type.getSymbol();
        cases = new LinkedHashSet<OCSymbol>(cases);
        if (argExprs != null && argExprs.size() == 1 && argExprs.get(0) instanceof OCCompoundInitializer) {
            if (OCCodeInsightUtil.isInitializerListType(type, context.getFile())) {
                return type.getSymbol();
            }
            OCCompoundInitializer compInitializer = (OCCompoundInitializer)argExprs.get(0);
            argTypes = new ArrayList<OCType>();
            argExprs = new ArrayList<OCExpression>();
            for (OCExpression expression : compInitializer.getInitializerExpressions()) {
                argExprs.add(expression);
                argTypes.add(expression.getResolvedType());
            }
            ArrayList<OCSymbol> ctorsWithInitList = new ArrayList<OCSymbol>();
            OCSymbol result2 = OCResolveOverloadsUtil.findCtorWithInitializerList(type, argTypes, argExprs, ctorsWithInitList, context.getFile(), allowImplicitConversions);
            cases.removeAll(ctorsWithInitList);
            if (result2 != null) {
                return result2;
            }
            if (ctorsWithInitList.size() == 1) {
                badResult = (OCSymbol)ctorsWithInitList.get(0);
            }
            if (!allowImplicitConversions) {
                return badResult;
            }
        }
        boolean copyConstructorIsOK = argTypes.size() == 1 && type.isCompatible(argTypes.get(0), context.getElement());
        boolean acceprOnlyCompatible = badResult instanceof OCFunctionSymbol || copyConstructorIsOK;
        OCSymbol resolved = OCResolveOverloadsUtil.resolveOverloads(cases, argTypes, argExprs, cvQualifiers, context, reference, acceprOnlyCompatible, acceprOnlyCompatible, acceprOnlyCompatible);
        return resolved != null ? resolved : badResult;
    }

    @Nullable
    public static OCSymbol resolveOverloads(@NotNull Collection<OCSymbol> cases, List<OCType> argTypes, @Nullable List<?> argExprs, @Nullable CVQualifiers cvQualifiers, @NotNull OCResolveContext context, @Nullable PsiReference reference, boolean filterByParameters, boolean filterByTemplates, boolean warningsAreBad) {
        if (cases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cases", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "resolveOverloads"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "resolveOverloads"));
        }
        List<OCSymbol> filtered = OCResolveOverloadsUtil.resolveTemplateSpecializations(cases, argTypes, argExprs, reference, filterByTemplates, context);
        if (!(filterByParameters |= context.isInSFINAE())) {
            if (filtered.size() == 1) {
                return (OCSymbol)ContainerUtil.getFirstItem(filtered);
            }
            if (filtered.size() == 0) {
                return filterByTemplates ? null : OCResolveOverloadsUtil.filterPredeclarations(cases);
            }
        }
        ArrayList<Overload> overloads = new ArrayList<Overload>(cases.size());
        PsiElement psiContext = context.getElement();
        boolean hasMagic = false;
        for (OCSymbol symbol : filtered) {
            List<Object> paramTypes;
            boolean magic = false;
            ParamFitness fitness = ParamFitness.ok;
            int price = 0;
            if (symbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol function = (OCFunctionSymbol)symbol;
                paramTypes = OCResolveOverloadsUtil.getParameterTypes((OCFunctionSymbol)function, (PsiReference)reference, (OCResolveContext)context).types;
                if (cvQualifiers != null && (cvQualifiers.isConst() || cvQualifiers.isVolatile()) && !function.isStatic() && function.getResolvedOwner(context, false) instanceof OCStructSymbol && !function.getKind().isConstructorOrDestructor()) {
                    if (cvQualifiers.isConst() && !function.isConst()) {
                        fitness = ParamFitness.error;
                    }
                    if (cvQualifiers.isVolatile() && !function.isVolatile()) {
                        fitness = ParamFitness.error;
                    }
                }
            } else {
                paramTypes = symbol instanceof OCStructSymbol ? Collections.singletonList(((OCStructSymbol)symbol).getType()) : Collections.emptyList();
            }
            for (int i = 0; i < Math.min(argTypes.size(), paramTypes.size()); ++i) {
                OCExpressionSymbol argSymbol;
                OCType declType = ((OCType)paramTypes.get(i)).resolve(context).transformType(OCArrayToPointerChanger.INSTANCE);
                OCType actualType = argTypes.get(i);
                Object arg = argExprs != null ? argExprs.get(i) : null;
                OCExpression argExpression = arg instanceof OCExpression ? (OCExpression)arg : null;
                OCExpressionSymbol oCExpressionSymbol = argSymbol = arg instanceof OCExpressionSymbol ? (OCExpressionSymbol)arg : null;
                if (declType instanceof OCEllipsisType) {
                    fitness = ParamFitness.ellipsis;
                    price = -i;
                    break;
                }
                OCType.TypeCheckResult result2 = declType.checkCompatible(actualType, argExpression, argSymbol, psiContext, true, false, context);
                OCType.TypeCheckState state = result2.getState();
                if (state.isError(context.getElement())) {
                    fitness = ParamFitness.error;
                } else if (fitness != ParamFitness.error && state != OCType.TypeCheckState.OK && result2.getInspectionClass() != OCInspections.SignednessMismatch.class) {
                    fitness = ParamFitness.warning;
                } else if (fitness != ParamFitness.error && fitness != ParamFitness.warning && result2.isWithConversion()) {
                    fitness = ParamFitness.okWithConversion;
                    if (!result2.getTypeAfterConversion().isUnknown() && !result2.getTypeAfterConversion().isMagicInside(context)) {
                        actualType = result2.getTypeAfterConversion();
                    }
                }
                if (declType.isUnknown() || declType.isMagicInside(context)) {
                    if (declType.getGuessedUnmagicType().checkCompatible(actualType, null, null, psiContext, true, false, context).getState() != OCType.TypeCheckState.OK) {
                        ++price;
                    }
                } else if (actualType.isUnknown() || actualType.isMagicInside(context)) {
                    magic = true;
                }
                if (actualType.getTerminalType() instanceof OCMagicType || declType.getTerminalType() instanceof OCMagicType) continue;
                if (declType instanceof OCCppReferenceType && ((OCCppReferenceType)declType).isRvalueRef()) {
                    --price;
                }
                actualType = actualType instanceof OCCppReferenceType && !(declType instanceof OCCppReferenceType) ? ((OCCppReferenceType)actualType).getRefType() : actualType;
                declType = declType instanceof OCCppReferenceType && !(actualType instanceof OCCppReferenceType) ? ((OCCppReferenceType)declType).getRefType() : declType;
                price += OCTypeCompatibilityVisitor.getTypesDifference(declType, actualType, context);
            }
            if (("operator++".equals(symbol.getName()) || "operator--".equals(symbol.getName())) && (reference.getElement() instanceof OCPostfixExpression && paramTypes.size() == argTypes.size() || reference.getElement() instanceof OCPrefixExpression && paramTypes.size() == argTypes.size() + 1)) {
                fitness = ParamFitness.error;
            }
            if (fitness == ParamFitness.error || warningsAreBad && fitness == ParamFitness.warning) continue;
            overloads.add(new Overload(fitness, price, symbol));
            hasMagic |= magic;
        }
        Collections.sort(overloads);
        List<OCSymbol> result3 = new ArrayList<OCSymbol>();
        Overload prev = null;
        for (Overload overload : overloads) {
            if (prev != null && (!hasMagic && prev.compareTo(overload) != 0 || hasMagic && prev.myFitness.ordinal() <= ParamFitness.warning.ordinal() && overload.myFitness.ordinal() > ParamFitness.warning.ordinal())) break;
            result3.add(overload.mySymbol);
            prev = overload;
        }
        if (result3.size() == 1) {
            return (OCSymbol)result3.get(0);
        }
        if (!hasMagic) {
            result3 = OCResolveOverloadsUtil.filterCVFunctions(result3);
        }
        if (result3.size() == 1) {
            return result3.get(0);
        }
        if (result3.size() > 1) {
            return OCResolveOverloadsUtil.filterPredeclarations(result3, reference, context);
        }
        if (filterByParameters) {
            return null;
        }
        if (filtered.size() > 1) {
            return OCResolveOverloadsUtil.filterPredeclarations(filtered, reference, context);
        }
        return (OCSymbol)ContainerUtil.getFirstItem(filtered);
    }

    @NotNull
    private static TypesAndNames getParameterTypes(OCFunctionSymbol function, @Nullable PsiReference reference, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "getParameterTypes"));
        }
        List<? extends OCType> paramTypes = function.getType().getParameterTypes();
        List<String> paramNames = function.getType().getParameterNames();
        if (OCResolveOverloadsUtil.needsPseudoParamAdded(function, reference, context)) {
            ArrayList<? extends OCType> newParamTypes = new ArrayList<OCType>(paramTypes.size() + 1);
            newParamTypes.add(((OCStructSymbol)function.getResolvedOwner(context, false)).getType());
            newParamTypes.addAll(paramTypes);
            paramTypes = newParamTypes;
            if (paramNames != null) {
                ArrayList<String> newParamNames = new ArrayList<String>(paramTypes.size() + 1);
                newParamNames.add("<unnamed>");
                newParamNames.addAll(paramNames);
                paramNames = newParamNames;
            }
        }
        TypesAndNames typesAndNames = new TypesAndNames(paramTypes, paramNames);
        if (typesAndNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "getParameterTypes"));
        }
        return typesAndNames;
    }

    private static boolean needsPseudoParamAdded(OCFunctionSymbol function, @Nullable PsiReference reference, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "needsPseudoParamAdded"));
        }
        return reference instanceof OCOperatorReference && function.isCppMemberOperator(context);
    }

    private static int getNonInitializedParametersCount(OCFunctionSymbol function, @Nullable PsiReference reference, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "getNonInitializedParametersCount"));
        }
        int parametersCount = function.getNonInitializedParametersCount();
        if (OCResolveOverloadsUtil.needsPseudoParamAdded(function, reference, context)) {
            ++parametersCount;
        }
        return parametersCount;
    }

    private static List<OCSymbol> filterCVFunctions(List<OCSymbol> cases) {
        ArrayList<OCSymbol> result2 = new ArrayList<OCSymbol>(cases.size());
        int bestCVCount = -1;
        for (OCSymbol symbol : cases) {
            if (!(symbol instanceof OCFunctionSymbol)) continue;
            OCType symbolType = symbol.getType();
            int CVQualifiersCnt = (symbolType.isConst() ? 1 : 0) + (symbolType.isVolatile() ? 1 : 0);
            for (OCDeclaratorSymbol paramSymbol : ((OCFunctionSymbol)symbol).getParameterSymbols()) {
                OCType type = paramSymbol.getType();
                if (type instanceof OCCppReferenceType) {
                    type = ((OCCppReferenceType)type).getRefType();
                }
                if (type.isConst()) {
                    ++CVQualifiersCnt;
                }
                if (!type.isVolatile()) continue;
                ++CVQualifiersCnt;
            }
            if (bestCVCount == -1) {
                bestCVCount = CVQualifiersCnt;
            }
            if (CVQualifiersCnt < bestCVCount) {
                bestCVCount = CVQualifiersCnt;
                result2.clear();
            }
            if (CVQualifiersCnt != bestCVCount) continue;
            result2.add(symbol);
        }
        if (result2.isEmpty()) {
            return cases;
        }
        return result2;
    }

    private static OCSymbol filterPredeclarations(Collection<OCSymbol> cases) {
        for (OCSymbol symbol : cases) {
            if (!(symbol instanceof OCFunctionSymbol) || symbol.isPredeclaration()) continue;
            return symbol;
        }
        for (OCSymbol symbol : cases) {
            if (symbol.isPredeclaration()) continue;
            return symbol;
        }
        Iterator<OCSymbol> iterator = cases.iterator();
        if (iterator.hasNext()) {
            OCSymbol symbol;
            symbol = iterator.next();
            return symbol;
        }
        return null;
    }

    private static OCSymbol filterPredeclarations(List<OCSymbol> symbols, PsiReference reference, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "filterPredeclarations"));
        }
        ArrayList<OCFunctionSymbol> filtered = new ArrayList<OCFunctionSymbol>(symbols.size());
        boolean differentPredeclaredTypes = false;
        boolean differentPredeclaredReturnTypes = false;
        boolean differentDeclaredTypes = false;
        boolean differentDeclaredReturnTypes = false;
        OCFunctionType firstPredeclaredType = null;
        OCType firstPredeclaredReturnType = null;
        OCFunctionType firstDeclaredType = null;
        OCType firstDeclaredReturnType = null;
        OCSymbol implicitConstructorDef = null;
        OCSymbol implicitConstructorPredef = null;
        Collections.sort(symbols, new Comparator<OCSymbol>(){

            @Override
            public int compare(OCSymbol f1, OCSymbol f2) {
                return OCSymbolOffsetUtil.compare(f1.getComplexOffset(), f2.getComplexOffset());
            }
        });
        Collections.sort(symbols, new Comparator<OCSymbol>(){

            private int rank(OCSymbol symbol) {
                return symbol.isPredeclaration() ? 1 : 0;
            }

            @Override
            public int compare(OCSymbol f1, OCSymbol f2) {
                return this.rank(f1) - this.rank(f2);
            }
        });
        for (OCSymbol symbol : symbols) {
            if (!(symbol instanceof OCFunctionSymbol)) {
                if (symbol.isPredeclaration()) {
                    implicitConstructorPredef = symbol;
                    continue;
                }
                implicitConstructorDef = symbol;
                continue;
            }
            OCFunctionSymbol function = (OCFunctionSymbol)symbol;
            OCFunctionType functionType = function.getType();
            TypesAndNames typesAndNames = OCResolveOverloadsUtil.getParameterTypes(function, reference, context);
            functionType = new OCFunctionType(functionType.getReturnType(), typesAndNames.types, typesAndNames.names, functionType.isConst(), functionType.isVolatile());
            OCType returnType = functionType.getReturnType().resolve(context);
            if (!function.isPredeclaration()) {
                filtered.add(function);
                if (firstDeclaredType == null) {
                    firstDeclaredType = functionType;
                    firstDeclaredReturnType = returnType;
                    continue;
                }
                differentDeclaredTypes |= !functionType.equalsAfterResolving(firstDeclaredType, (PsiElement)context.getFile());
                differentDeclaredReturnTypes |= !returnType.equalsAfterResolving(firstDeclaredReturnType, (PsiElement)context.getFile());
                continue;
            }
            if (firstDeclaredType == null) {
                if (firstPredeclaredType == null) {
                    firstPredeclaredType = functionType;
                    firstPredeclaredReturnType = returnType;
                    continue;
                }
                differentPredeclaredTypes |= !functionType.equalsAfterResolving(firstPredeclaredType, (PsiElement)context.getFile());
                differentPredeclaredReturnTypes |= !returnType.equalsAfterResolving(firstPredeclaredReturnType, (PsiElement)context.getFile());
                continue;
            }
            if (differentDeclaredTypes) continue;
            differentDeclaredTypes = !functionType.equalsAfterResolving(firstDeclaredType, (PsiElement)context.getFile());
            differentDeclaredReturnTypes = !returnType.equalsAfterResolving(firstDeclaredReturnType, (PsiElement)context.getFile());
        }
        if (filtered.size() == 1 && !differentDeclaredTypes) {
            return (OCSymbol)filtered.get(0);
        }
        if (filtered.size() >= 1) {
            return differentDeclaredTypes ? new OCFunctionGroupSymbol(filtered, differentDeclaredReturnTypes ? null : firstDeclaredReturnType) : (OCFunctionSymbol)ContainerUtil.getFirstItem(filtered);
        }
        if (implicitConstructorDef != null) {
            return implicitConstructorDef;
        }
        if (implicitConstructorPredef != null) {
            return implicitConstructorPredef;
        }
        return differentPredeclaredTypes ? new OCFunctionGroupSymbol(ContainerUtil.map(symbols, (Function)new Function<OCSymbol, OCFunctionSymbol>(){

            public OCFunctionSymbol fun(OCSymbol symbol) {
                return (OCFunctionSymbol)symbol;
            }
        }), differentPredeclaredReturnTypes ? null : firstPredeclaredReturnType) : (OCSymbol)ContainerUtil.getFirstItem(symbols);
    }

    private static OCSymbol findCtorWithInitializerList(OCStructType clazz, final List<OCType> argumentTypes, final List<OCExpression> argumentExprs, final Collection<OCSymbol> allCandidates, final @Nullable PsiFile file2, final boolean implicitCtors) {
        final Ref result2 = new Ref();
        clazz.processMembers(clazz.getSymbol().getName(), new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                OCFunctionSymbol function;
                if (symbol instanceof OCFunctionSymbol && (function = (OCFunctionSymbol)symbol).isCppConstructor() && function.getNonInitializedParametersCount() == 1) {
                    OCType paramType = function.getParameterSymbols().get(0).getType().resolve(file2);
                    if (paramType instanceof OCCppReferenceType) {
                        paramType = ((OCCppReferenceType)paramType).getRefType();
                    }
                    if (paramType instanceof OCStructType) {
                        OCStructSymbol paramTypeSymbol = ((OCStructType)paramType).getSymbol();
                        List<OCTypeParameterSymbol> parameters = paramTypeSymbol.getTemplateParameters();
                        if (OCCodeInsightUtil.isInitializerListType(paramType, file2) && parameters.size() == 1) {
                            allCandidates.add(function);
                            OCTypeArgument paramSubstitution = paramTypeSymbol.getSubstitution().getSubstitutionFor(parameters.get(0));
                            if (paramSubstitution instanceof OCType) {
                                boolean isCompatible = true;
                                for (int i = 0; i < argumentExprs.size(); ++i) {
                                    OCExpression expr = (OCExpression)argumentExprs.get(i);
                                    OCType type = (OCType)argumentTypes.get(i);
                                    isCompatible &= ((OCType)paramSubstitution).isCompatible(type, expr, expr);
                                }
                                if (isCompatible) {
                                    result2.set((Object)function);
                                    return false;
                                }
                            }
                        }
                        if (implicitCtors && OCResolveOverloadsUtil.findCtorWithInitializerList((OCStructType)paramType, argumentTypes, argumentExprs, new ArrayList(), file2, false) != null) {
                            result2.set((Object)function);
                            return false;
                        }
                    }
                }
                return true;
            }
        }, new OCResolveContext((PsiElement)file2));
        return (OCSymbol)result2.get();
    }

    private static List<OCSymbol> resolveTemplateSpecializations(@NotNull Collection<OCSymbol> symbols, List<OCType> argumentTypes, @Nullable List<?> argumentExprs, @Nullable PsiReference reference, boolean acceptOnlyCompatible, final @NotNull OCResolveContext context) {
        if (symbols == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbols", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "resolveTemplateSpecializations"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "resolveTemplateSpecializations"));
        }
        ArrayList<OCSymbol> unified = new ArrayList<OCSymbol>();
        ArrayList<OCSymbol> allSymbols = new ArrayList<OCSymbol>();
        boolean isMagic = ContainerUtil.exists(argumentTypes, (Condition)new Condition<OCType>(){

            public boolean value(OCType type) {
                return type.isUnknown() || type.isMagicInside(context);
            }
        });
        for (OCSymbol symbol : symbols) {
            HashMap substitutionMap = new HashMap();
            if (symbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol function = (OCFunctionSymbol)symbol;
                List<? extends OCType> parameterTypes = OCResolveOverloadsUtil.getParameterTypes((OCFunctionSymbol)function, (PsiReference)reference, (OCResolveContext)context).types;
                int argumentsCount = argumentTypes.size();
                if (OCResolveOverloadsUtil.getNonInitializedParametersCount(function, reference, context) > argumentsCount || argumentsCount > parameterTypes.size() && !function.isVararg()) continue;
                boolean isUnified = true;
                for (int i = 0; i < Math.min(parameterTypes.size(), argumentsCount); ++i) {
                    OCExpression argumentExpr;
                    Object expression;
                    OCType paramType = parameterTypes.get(i).resolve(context);
                    OCType argumentType = argumentTypes.get(i);
                    Object v0 = expression = argumentExprs != null ? argumentExprs.get(i) : null;
                    if (paramType instanceof OCPointerType && argumentType instanceof OCIntType && (expression instanceof OCExpression && OCExpressionEvaluator.isNullCompatible(OCExpressionEvaluator.evaluate(expression)) || expression instanceof OCExpressionSymbol && OCExpressionEvaluator.isNullCompatible(OCExpressionEvaluator.evaluate(expression, context))) || paramType instanceof OCEllipsisType || OCSimpleTypeSubstitution.unify(paramType, argumentType, expression, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap, true, context) != OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                    OCExpression oCExpression = argumentExpr = expression instanceof OCExpression ? (OCExpression)expression : null;
                    if (!(paramType instanceof OCTypeParameterType) && paramType.checkCompatible(argumentType, argumentExpr, null, context.getElement(), true, true, context).getState() == OCType.TypeCheckState.OK) continue;
                    isUnified = false;
                    break;
                }
                OCSimpleTypeSubstitution substitution = OCSimpleTypeSubstitution.create((Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap);
                if (isUnified && OCResolveOverloadsUtil.isPrunedBySFINAE(function, substitution, isMagic, context)) {
                    isUnified = false;
                }
                OCSymbol substitutedFunction = substitution.substitute(symbol, context);
                allSymbols.add(substitutedFunction);
                if (!isUnified) continue;
                unified.add(substitutedFunction);
                continue;
            }
            if (symbol instanceof OCStructSymbol && argumentTypes.size() == 1 && !((OCStructSymbol)symbol).hasDeclaredConstructor()) {
                OCType argumentType = argumentTypes.get(0);
                Object argumentExpr = argumentExprs != null ? argumentExprs.get(0) : null;
                OCTypeUnificationVisitor.UnificationResult unifyResult = OCSimpleTypeSubstitution.unify(symbol.getType(), argumentType, argumentExpr, (Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap, true, context);
                OCSymbol substitutedFunction = OCSimpleTypeSubstitution.create((Map<OCTypeParameterSymbol, OCTypeArgument>)substitutionMap).substitute(symbol, context);
                allSymbols.add(substitutedFunction);
                if (unifyResult == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                unified.add(substitutedFunction);
                continue;
            }
            if (symbol instanceof OCStructSymbol && argumentTypes.size() == 0 && !((OCStructSymbol)symbol).hasDeclaredConstructor()) {
                unified.add(symbol);
                continue;
            }
            if (symbol instanceof OCStructSymbol) continue;
            unified.add(symbol);
        }
        return unified.isEmpty() && !acceptOnlyCompatible ? allSymbols : unified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPrunedBySFINAE(OCFunctionSymbol function, OCSimpleTypeSubstitution substitution, boolean isMagic, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil", "isPrunedBySFINAE"));
        }
        context = context.substitute(substitution);
        boolean oldSfinaeFlag = OCResolveContext.setInSFINAEFlag(context, true);
        try {
            for (OCDeclaratorSymbol oCDeclaratorSymbol : function.getParameterSymbols()) {
                OCType paramType = oCDeclaratorSymbol.getType().resolve(context);
                if (!paramType.isUnresolved(context)) continue;
                boolean bl = true;
                return bl;
            }
            if (function.getEffectiveType().resolve(context).isUnresolved(context)) {
                boolean bl = true;
                return bl;
            }
            context = context.useFor(function);
            for (OCTypeParameterSymbol oCTypeParameterSymbol : function.getTemplateParameters()) {
                OCType type;
                Object defaultValue = oCTypeParameterSymbol.getDefaultValue();
                if (defaultValue == null && !isMagic && function.getSubstitution().getSubstitutionFor(oCTypeParameterSymbol) == null && substitution.getSubstitutionFor(oCTypeParameterSymbol) == null) {
                    boolean bl = true;
                    return bl;
                }
                if (!(defaultValue instanceof OCType) || !(type = ((OCType)defaultValue).resolve(context)).isUnresolved(context)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            OCResolveContext.setInSFINAEFlag(context, oldSfinaeFlag);
        }
    }

    private static class TypesAndNames {
        @NotNull
        public final List<? extends OCType> types;
        @Nullable
        public final List<String> names;

        private TypesAndNames(@NotNull List<? extends OCType> types, @Nullable List<String> names) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil$TypesAndNames", "<init>"));
            }
            this.types = types;
            this.names = names;
        }
    }

    private static class Overload
    implements Comparable<Overload> {
        ParamFitness myFitness;
        int price;
        OCSymbol mySymbol;

        public Overload(ParamFitness fitness, int price, OCSymbol symbol) {
            this.myFitness = fitness;
            this.price = price;
            this.mySymbol = symbol;
        }

        @Override
        public int compareTo(Overload o) {
            if (this.myFitness.ordinal() < o.myFitness.ordinal()) {
                return -1;
            }
            if (this.myFitness == o.myFitness) {
                return this.price - o.price;
            }
            return 1;
        }
    }

    private static enum ParamFitness {
        ok,
        okWithConversion,
        warning,
        ellipsis,
        error;

    }

    public static class OCFunctionGroupSymbol
    extends OCFunctionSymbol {
        private List<OCFunctionSymbol> myOverloads;

        public OCFunctionGroupSymbol(@NotNull List<OCFunctionSymbol> overloads, @Nullable OCType returnType) {
            if (overloads == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloads", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil$OCFunctionGroupSymbol", "<init>"));
            }
            super(overloads.get(0).getProject(), overloads.get(0).getContainingFile(), 0L, overloads.get(0).getParent(), overloads.get(0).getQualifiedName(), Collections.<OCTypeParameterSymbol>emptyList(), 4, Collections.<String>emptyList(), OCFunctionGroupSymbol.getFunctionType(overloads, returnType), OCFunctionGroupSymbol.getParameters(overloads), OCFunctionGroupSymbol.getSymbolKind(overloads, OCSymbolKind.FUNCTION_PREDECLARATION), null);
            this.myOverloads = overloads;
        }

        private static List<OCDeclaratorSymbol> getParameters(List<OCFunctionSymbol> overloads) {
            return overloads.get(0).getParameterSymbols();
        }

        private static OCFunctionType getFunctionType(List<OCFunctionSymbol> overloads, @Nullable OCType returnType) {
            if (returnType == null) {
                returnType = new OCMagicType(overloads.get(0).getType().getReturnType());
            }
            return new OCFunctionType(returnType, overloads.get(0).getType().getParameterTypes());
        }

        private static OCSymbolKind getSymbolKind(List<OCFunctionSymbol> overloads, OCSymbolKind defaultKind) {
            OCSymbolKind kind = null;
            for (OCFunctionSymbol symbol : overloads) {
                if (kind == null) {
                    kind = symbol.getKind();
                    continue;
                }
                if (kind == symbol.getKind()) continue;
                return defaultKind;
            }
            return kind != null ? kind : defaultKind;
        }

        public List<OCFunctionSymbol> getOverloads() {
            return this.myOverloads;
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil$OCFunctionGroupSymbol", "deepEqualStep"));
            }
            if (first == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil$OCFunctionGroupSymbol", "deepEqualStep"));
            }
            if (second == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil$OCFunctionGroupSymbol", "deepEqualStep"));
            }
            throw new UnsupportedOperationException("this symbol is synthetic and should not be interned");
        }
    }
}

