/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclarationList;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppBaseClauseList;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeUtil {
    private OCChangeUtil() {
    }

    public static <T extends PsiElement> T addBefore(PsiElement parent, T element, @Nullable PsiElement anchor) {
        anchor = OCChangeUtil.getRealAnchorForInsertion(parent, element, anchor);
        return (T)OCChangeUtil.addHandlingMacros(parent, element, anchor, true);
    }

    public static <T extends PsiElement> T addAfter(PsiElement parent, T element, @Nullable PsiElement anchor) {
        anchor = OCChangeUtil.getRealAnchorForInsertion(parent, element, anchor);
        IElementType anchorType = OCElementUtil.getElementType(anchor);
        if (anchor != null && anchorType == OCElementTypes.OBJC_KEYWORD) {
            anchorType = OCElementUtil.getObjCKeywordElementType(anchor.getNode());
        }
        return (T)OCChangeUtil.addHandlingMacros(parent, element, anchor, anchorType == OCTokenTypes.END_KEYWORD || anchorType == OCTokenTypes.RBRACE);
    }

    public static <T extends PsiElement> T add(PsiElement parent, T element) {
        return OCChangeUtil.addBefore(parent, element, null);
    }

    @Nullable
    public static PsiElement getRealAnchorForInsertion(PsiElement parent, PsiElement anchor) {
        return OCChangeUtil.getRealAnchorForInsertion(parent, null, anchor);
    }

    @Nullable
    private static PsiElement getRealAnchorForInsertion(@Nullable PsiElement parent, @Nullable PsiElement element, @Nullable PsiElement anchor) {
        List<OCMethodSelectorPart> parameters;
        int position;
        if (parent == null) {
            return null;
        }
        if (anchor != null && !Comparing.equal((Object)anchor.getContainingFile(), (Object)parent.getContainingFile())) {
            anchor = null;
        }
        if (element != null && !(element.getContainingFile() instanceof OCFile)) {
            element = null;
        }
        if (element != null && (parent instanceof OCFile || parent instanceof OCClassDeclaration)) {
            OCDeclarationKind kind = OCDeclarationKind.getDeclarationKind(element);
            if (kind != null) {
                int startOffset = kind.getChildrenStartOffset(parent);
                int endOffset = kind.getChildrenEndOffset(parent);
                if (startOffset != -1 && endOffset != -1 && (anchor == null || anchor.getTextOffset() >= endOffset)) {
                    return OCChangeUtil.getChildAt(parent, endOffset + 1);
                }
            }
        } else if (parent instanceof OCStruct) {
            OCFunctionDeclaration function;
            String name = ((OCStruct)parent).getName();
            if (element instanceof OCFunctionDeclaration && Comparing.equal((String)(function = (OCFunctionDeclaration)element).getName(), (String)name)) {
                for (OCDeclaration member : ((OCStruct)parent).getMembers()) {
                    List<OCDeclarator> parameters2 = function.getParameters();
                    if (parameters2 == null || parameters2.size() == 0) {
                        return member;
                    }
                    if (!(member instanceof OCFunctionDeclaration)) {
                        return member;
                    }
                    if (Comparing.equal((String)((OCFunctionDeclaration)member).getName(), (String)name)) continue;
                    return member;
                }
            }
        }
        if (anchor != null && (position = anchor.getTextOffset() + (anchor.getTextLength() != 0 ? 1 : 0)) < parent.getTextRange().getEndOffset()) {
            return OCChangeUtil.getChildAt(parent, position);
        }
        if (parent instanceof OCParameterList) {
            if (!((OCParameterList)parent).getParameterDeclarations().isEmpty()) {
                parent.addBefore(OCElementFactory.create(OCTokenTypes.COMMA, parent), parent.getLastChild());
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCPropertyAttributesList) {
            if (!((OCPropertyAttributesList)parent).getAttributes().isEmpty()) {
                parent.addBefore(OCElementFactory.create(OCTokenTypes.COMMA, parent), parent.getLastChild());
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCEnum) {
            if (!((OCEnum)parent).getFields().isEmpty()) {
                parent.addBefore(OCElementFactory.create(OCTokenTypes.COMMA, parent), parent.getLastChild());
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCConstructorInitializationList) {
            if (((OCConstructorInitializationList)parent).getInitializers().size() != 0) {
                parent.add(OCElementFactory.create(OCTokenTypes.COMMA, element));
            }
            return null;
        }
        if (parent instanceof OCStructLike || parent instanceof OCBlockStatement || parent instanceof OCCppNamespace) {
            return OCChangeUtil.findChildByType(parent, OCTokenTypes.RBRACE);
        }
        if (parent instanceof OCProtocolList) {
            PsiElement rbrace = OCChangeUtil.findChildByType(parent, OCTokenTypes.GT);
            if (rbrace == null) {
                PsiElement lbrace = parent.add(OCElementFactory.create(OCTokenTypes.LT, parent));
                CodeEditUtil.markToReformatBefore(lbrace.getNode(), true);
                return parent.add(OCElementFactory.create(OCTokenTypes.GT, parent));
            }
            if (!((OCProtocolList)parent).getProtocols().isEmpty()) {
                parent.addBefore(OCElementFactory.create(OCTokenTypes.COMMA, parent), parent.getLastChild());
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCCppBaseClauseList) {
            if (((OCCppBaseClauseList)parent).getBaseClauses().isEmpty()) {
                parent.add(OCElementFactory.create(OCTokenTypes.COLON, parent));
            } else {
                parent.add(OCElementFactory.create(OCTokenTypes.COMMA, parent));
            }
            return null;
        }
        if (parent instanceof OCInstanceVariablesList) {
            PsiElement rbrace = OCChangeUtil.findChildByType(parent, OCTokenTypes.RBRACE);
            if (rbrace == null) {
                PsiElement result2 = null;
                for (PsiElement child = OCElementFactory.instanceVariableList(element).getFirstChild(); child != null; child = child.getNextSibling()) {
                    IElementType type = child.getNode().getElementType();
                    PsiElement newChild = parent.add(child);
                    if (type == OCTokenTypes.RBRACE) {
                        result2 = newChild;
                    }
                    CodeEditUtil.markToReformatBefore(newChild.getNode(), type == OCTokenTypes.LBRACE || type == OCTokenTypes.RBRACE);
                }
                return result2;
            }
            return rbrace;
        }
        if (parent instanceof OCMethod && element instanceof OCMethodSelectorPart && !(parameters = ((OCMethod)parent).getParameters()).isEmpty()) {
            OCMethodSelectorPart lastParam = parameters.get(parameters.size() - 1);
            if (lastParam.getParameter() == null) {
                OCChangeUtil.delete(lastParam);
            } else {
                parent.addAfter(OCElementFactory.spaceFromText(element), (PsiElement)lastParam);
            }
            return parent.getLastChild();
        }
        return anchor != null ? parent.getLastChild() : null;
    }

    @NotNull
    public static PsiElement findInsertionParentInFile(OCFile file2, OCNamespaceSymbol parent) {
        OCElement namespacePsi;
        ArrayList<OCNamespaceSymbol> parentsPath = new ArrayList<OCNamespaceSymbol>();
        while (parent instanceof OCNamespaceSymbol) {
            if (!(parent instanceof OCStructSymbol)) {
                parentsPath.add(0, parent);
            }
            parent = (OCNamespaceSymbol)parent.getParent();
        }
        OCNamespaceLikeSymbol current = file2.getMembersContainer(false);
        for (OCNamespaceSymbol symbol : parentsPath) {
            final VirtualFile virtualFile = file2.getContainingFile().getVirtualFile();
            CommonProcessors.FindFirstProcessor<OCNamespaceSymbol> finder = new CommonProcessors.FindFirstProcessor<OCNamespaceSymbol>(){

                protected boolean accept(OCNamespaceSymbol symbol) {
                    return virtualFile != null && virtualFile.equals(symbol.getContainingFile());
                }
            };
            current.processMembers(symbol.getName(), new OCCommonProcessors.TypeFilteredProcessor((Processor<OCNamespaceSymbol>)finder, OCNamespaceSymbol.class));
            if (!finder.isFound()) break;
            current = (OCNamespaceLikeSymbol)finder.getFoundValue();
        }
        if (current instanceof OCNamespaceSymbol && (namespacePsi = (OCElement)((OCNamespaceSymbol)current).locateDefinition()) != null) {
            OCElement oCElement = namespacePsi;
            if (oCElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil", "findInsertionParentInFile"));
            }
            return oCElement;
        }
        OCFile oCFile = file2;
        if (oCFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil", "findInsertionParentInFile"));
        }
        return oCFile;
    }

    public static void delete(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof OCParameterList || parent instanceof OCArgumentList || parent instanceof OCCompoundInitializer || parent instanceof OCTemplateArgumentList) {
            OCChangeUtil.deleteChildFromList(parent, element, ParentCleanup.LEAVE);
        } else if (parent instanceof OCClassPredeclarationList || parent instanceof OCDeclaration && element instanceof OCDeclarator || parent instanceof OCDeclarationStatement || parent instanceof OCPropertyAttributesList || parent instanceof OCProperty && element instanceof OCDeclaration || parent instanceof OCEnum || parent instanceof OCSynthesizePropertiesList || parent instanceof OCTemplateParameterList) {
            OCChangeUtil.deleteChildFromList(parent, element, ParentCleanup.DELETE);
        } else if (parent instanceof OCProtocolList || parent instanceof OCCppBaseClauseList) {
            OCChangeUtil.deleteChildFromList(parent, element, ParentCleanup.CLEAR);
        } else if (element instanceof OCStructLike && parent instanceof OCTypeElement && parent.getParent() instanceof OCDeclaration) {
            OCChangeUtil.delete(parent.getParent());
        } else if (parent instanceof OCStructLike) {
            OCChangeUtil.removeRedundantVisibilityDeclarator(element);
            OCChangeUtil.deleteHandlingMacros(element);
        } else if (parent instanceof OCInstanceVariablesList) {
            OCChangeUtil.removeRedundantVisibilityDeclarator(element);
            OCChangeUtil.deleteHandlingMacros(element);
            if (((OCInstanceVariablesList)parent).getDeclarations().isEmpty()) {
                OCChangeUtil.clear(parent);
            }
        } else if (parent instanceof OCMethod && element instanceof OCBlockStatement) {
            OCChangeUtil.deleteHandlingMacros(element);
            parent.add(OCElementFactory.create(OCTokenTypes.SEMICOLON, parent));
        } else if (parent instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)parent).getInstanceVariableRef() == null && ((OCSynthesizeProperty)parent).getPropertyRef() == element) {
            OCChangeUtil.delete(parent);
        } else if (parent instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)parent).getInstanceVariableRef() == element) {
            parent.deleteChildRange(((OCSynthesizeProperty)parent).getPropertyRef().getNextSibling(), parent.getLastChild());
        } else if (parent instanceof OCDeclarator && ((OCDeclarator)parent).getInitializer() == element) {
            ASTNode prev = TreeUtil.skipElementsBack(element.getNode().getTreePrev(), TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_CALL})}));
            if (prev != null && prev.getElementType() == OCTokenTypes.EQ) {
                OCChangeUtil.deleteHandlingMacros(prev.getPsi());
            }
            OCChangeUtil.deleteHandlingMacros(element);
        } else if (element instanceof OCTemplateParameterList) {
            ASTNode prev = TreeUtil.skipElementsBack(element.getNode().getTreePrev(), TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_CALL})}));
            if (prev != null && prev.getElementType() == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
                OCChangeUtil.deleteHandlingMacros(prev.getPsi());
            }
            OCChangeUtil.deleteHandlingMacros(element);
        } else {
            OCChangeUtil.deleteHandlingMacros(element);
        }
    }

    private static void removeRedundantVisibilityDeclarator(PsiElement element) {
        PsiElement prev;
        PsiElement next = element.getNextSibling();
        for (prev = element.getPrevSibling(); prev != null; prev = prev.getPrevSibling()) {
            if (prev instanceof OCDeclaration || OCElementUtil.getElementType(prev) == OCTokenTypes.LBRACE) {
                return;
            }
            if (OCElementUtil.isVisibilityKeyword(prev.getNode())) break;
        }
        while (next != null) {
            if (next instanceof OCDeclaration) {
                return;
            }
            if (OCElementUtil.isVisibilityKeyword(next.getNode())) break;
            next = next.getNextSibling();
        }
        if (prev != null) {
            for (next = prev.getNextSibling(); next != null && OCElementUtil.isElementEmpty(next); next = next.getNextSibling()) {
            }
            OCChangeUtil.deleteHandlingMacros(prev);
            if (next != null && OCElementUtil.getElementType(next) == OCTokenTypes.COLON) {
                OCChangeUtil.deleteHandlingMacros(next);
            }
        }
    }

    @Nullable
    private static PsiElement findChildByType(PsiElement element, IElementType type) {
        ASTNode child = element.getNode().findChildByType(type);
        return child != null ? child.getPsi() : null;
    }

    @Nullable
    private static PsiElement getChildAt(PsiElement parent, int position) {
        PsiElement element = null;
        for (PsiElement child : OCElementUtil.getAllChildren(parent)) {
            if (child.getTextRange().getEndOffset() < position || OCElementUtil.isElementEmpty(child)) continue;
            element = child;
            break;
        }
        if (element == null && (parent instanceof OCStructLike || parent instanceof OCClassDeclaration)) {
            element = parent.getLastChild();
        }
        while (element != null && element.getPrevSibling() instanceof OCMacroCall) {
            element = element.getPrevSibling();
        }
        return element;
    }

    public static boolean canBeReplacedToBlockStatement(PsiElement statement) {
        if (statement == null || !(statement instanceof OCStatement)) {
            return false;
        }
        return !(statement.getParent() instanceof OCMacroCallArgument) && !(statement.getParent() instanceof OCDeclarationOrExpression) && (!(statement.getParent() instanceof OCForStatement) || ((OCForStatement)statement.getParent()).getBody() == statement);
    }

    public static OCStatement ensureParentIsBlockStatement(OCStatement statement) {
        if (!(statement.getParent() instanceof OCBlockStatement)) {
            OCBlockStatement blockStmt = (OCBlockStatement)OCElementFactory.statementFromText("{\n}", statement);
            PsiElement statementCopy = statement.copy();
            blockStmt = (OCBlockStatement)OCChangeUtil.replaceHandlingMacros(statement, blockStmt);
            return (OCStatement)blockStmt.addBefore(statementCopy, blockStmt.getClosingBrace());
        }
        return statement;
    }

    @Nullable
    public static PsiElement getAppropriateParent(OCSymbolKind kind, PsiElement anchor) {
        if (kind.isFunction()) {
            return PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{OCFile.class, OCCppNamespace.class, OCStructLike.class});
        }
        if (kind == OCSymbolKind.LOCAL_VARIABLE) {
            return PsiTreeUtil.getParentOfType((PsiElement)anchor, OCBlockStatement.class);
        }
        if (kind == OCSymbolKind.METHOD) {
            return PsiTreeUtil.getParentOfType((PsiElement)anchor, OCClassDeclaration.class);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)anchor, OCFile.class);
    }

    public static boolean changeText(@NotNull Project project, PsiFile file2, int offset, int length, String substitution, boolean unblockDocument) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil", "changeText"));
        }
        return OCChangeUtil.changeText(project, file2, offset, length, substitution, unblockDocument, true);
    }

    public static boolean changeText(@NotNull Project project, PsiFile file2, int offset, int length, String substitution, boolean unblockDocument, boolean commitDocument) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil", "changeText"));
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        if (document == null || !file2.isValid()) {
            return false;
        }
        if (unblockDocument) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        }
        document.replaceString(offset, offset + length, (CharSequence)substitution);
        if (commitDocument) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            int endOffset = offset + substitution.length();
            if (endOffset < file2.getTextLength()) {
                ++endOffset;
            }
            OCChangeUtil.reformatTextIfNotInjected(file2, offset, endOffset);
        }
        return true;
    }

    public static void reformatTextIfNotInjected(PsiFile file2, int offset, int endOffset) {
        if (!InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2)) {
            CodeStyleManager.getInstance((Project)file2.getProject()).reformatText(file2, offset, endOffset);
        }
    }

    private static void deleteChildFromList(@NotNull PsiElement parent, @NotNull PsiElement child, ParentCleanup parentCleanup) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil", "deleteChildFromList"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil", "deleteChildFromList"));
        }
        ASTNode prev = TreeUtil.skipElementsBack(child.getNode().getTreePrev(), OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (prev != null && prev.getElementType() == OCTokenTypes.COMMA) {
            CodeEditUtil.removeChild(parent.getNode(), prev);
        } else {
            ASTNode next = TreeUtil.skipElements(child.getNode().getTreeNext(), OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
            if (next != null && next.getElementType() == OCTokenTypes.COMMA) {
                CodeEditUtil.removeChild(parent.getNode(), next);
            } else {
                if (parentCleanup == ParentCleanup.DELETE) {
                    OCChangeUtil.delete(parent);
                    return;
                }
                if (parentCleanup == ParentCleanup.CLEAR) {
                    OCChangeUtil.clear(parent);
                    return;
                }
            }
        }
        CodeEditUtil.removeChild(parent.getNode(), child.getNode());
    }

    public static void clear(PsiElement parent) {
        parent.deleteChildRange(parent.getFirstChild(), parent.getLastChild());
    }

    private static void deleteHandlingMacros(PsiElement oldElement) {
        PsiElement oldMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(oldElement);
        while (oldMacroCall instanceof OCMacroCall) {
            PsiElement node = oldMacroCall;
            oldMacroCall = oldMacroCall.getPrevSibling();
            boolean nonEmpty = node.getTextLength() > 0;
            node.delete();
            if (!nonEmpty) continue;
            break;
        }
        CodeEditUtil.removeChild(oldElement.getParent().getNode(), oldElement.getNode());
    }

    public static PsiElement addHandlingMacros(@NotNull PsiElement parent, @NotNull PsiElement child, @Nullable PsiElement anchor) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil", "addHandlingMacros"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil", "addHandlingMacros"));
        }
        return OCChangeUtil.addHandlingMacros(parent, child, anchor, true);
    }

    public static PsiElement addHandlingMacros(@NotNull PsiElement parent, @NotNull PsiElement child, @Nullable PsiElement anchor, boolean isBefore) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil", "addHandlingMacros"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil", "addHandlingMacros"));
        }
        PsiElement childMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(child);
        child = anchor == null ? parent.add(child) : (isBefore ? parent.addBefore(child, anchor) : parent.addAfter(child, anchor));
        PsiElement insertAnchor = child;
        while (childMacroCall instanceof OCMacroCall) {
            PsiElement node = childMacroCall;
            childMacroCall = childMacroCall.getPrevSibling();
            boolean nonEmpty = node.getTextLength() > 0;
            CodeEditUtil.addChild(parent.getNode(), node.getNode(), insertAnchor.getNode());
            insertAnchor = node;
            if (!nonEmpty) continue;
            break;
        }
        return child;
    }

    public static PsiElement replaceHandlingMacros(PsiElement oldElement, PsiElement newElement) {
        boolean nonEmpty;
        PsiElement node;
        if (oldElement == null || newElement == null) {
            return oldElement;
        }
        PsiElement oldMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(oldElement);
        PsiElement newMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(newElement);
        PsiElement insertAnchor = oldElement;
        while (newMacroCall instanceof OCMacroCall) {
            node = newMacroCall;
            newMacroCall = newMacroCall.getPrevSibling();
            nonEmpty = node.getTextLength() > 0;
            insertAnchor = oldElement.getParent().addBefore(node, insertAnchor);
            if (!nonEmpty) continue;
            break;
        }
        while (oldMacroCall instanceof OCMacroCall) {
            node = oldMacroCall;
            oldMacroCall = oldMacroCall.getPrevSibling();
            nonEmpty = node.getTextLength() > 0;
            CodeEditUtil.removeChild(node.getParent().getNode(), node.getNode());
            if (!nonEmpty) continue;
            break;
        }
        return oldElement.replace(newElement);
    }

    public static void safeDeleteReference(PsiElement element) {
        if (element instanceof OCReferenceElement) {
            element = element.getParent();
        }
        if (element instanceof OCSendMessageExpression) {
            List<OCExpression> arguments = ((OCSendMessageExpression)element).getArgumentExpressions();
            OCMethodSymbol responder = ((OCSendMessageExpression)element).getProbableResponders().getKnownResponder();
            PsiElement statement = OCParenthesesUtils.topmostParenthesized((OCExpression)element).getParent();
            if (arguments.size() == 1 && (responder == null || responder.isSynthetic() && responder.getAssociatedSymbol() == null)) {
                OCExpression argument = arguments.get(0);
                if (statement instanceof OCExpressionStatement) {
                    if (!OCCodeInsightUtil.hasSideEffects(argument)) {
                        OCChangeUtil.safeDeleteStatement((OCStatement)statement);
                    } else {
                        OCChangeUtil.replaceHandlingMacros(((OCExpressionStatement)statement).getExpression(), argument);
                    }
                }
            }
        } else if (element instanceof OCReferenceExpression || element instanceof OCQualifiedExpression) {
            PsiElement assignment = OCParenthesesUtils.topmostParenthesized((OCExpression)element).getParent();
            if (!(assignment instanceof OCAssignmentExpression)) {
                return;
            }
            PsiElement statement = OCParenthesesUtils.topmostParenthesized((OCExpression)assignment).getParent();
            OCExpression sourceExpression = ((OCAssignmentExpression)assignment).getSourceExpression();
            if (statement instanceof OCExpressionStatement && (sourceExpression == null || !OCCodeInsightUtil.hasSideEffects(sourceExpression))) {
                OCChangeUtil.safeDeleteStatement((OCStatement)statement);
            } else {
                OCChangeUtil.replaceHandlingMacros(assignment, sourceExpression);
            }
        }
    }

    public static void safeDeleteStatement(OCStatement statement) {
        PsiElement parent = statement.getParent();
        if (OCChangeUtil.isElseBranchStatement(statement)) {
            CodeEditUtil.removeChildren(parent.getNode(), ((OCIfStatement)parent).getElseKeyword(), statement.getNode());
        } else if (parent instanceof OCBlockStatement) {
            if (((OCBlockStatement)parent).getStatements().size() == 1 && OCChangeUtil.isElseBranchStatement((OCStatement)parent)) {
                OCChangeUtil.safeDeleteStatement((OCStatement)parent);
            } else {
                OCChangeUtil.delete(statement);
            }
        } else {
            OCChangeUtil.replaceHandlingMacros(statement, OCElementFactory.statementFromText(";", statement));
        }
    }

    private static boolean isElseBranchStatement(OCStatement statement) {
        return statement.getParent() instanceof OCIfStatement && ((OCIfStatement)statement.getParent()).getElseBranch() == statement;
    }

    static enum ParentCleanup {
        LEAVE,
        DELETE,
        CLEAR;

    }
}

