/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCTopLevelTarget;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveTopLevelProcessor
extends OCMoveProcessor<PsiElement, OCSymbol, OCTopLevelTarget> {
    protected OCMoveTopLevelProcessor(PsiElement source, String targetFileName, @Nullable OCFile targetFile, List<OCMemberInfo> selectedMemberInfos) {
        super(source, selectedMemberInfos, targetFileName);
        if (targetFile != null) {
            this.addTarget(targetFile, targetFile.getName(), null);
        }
    }

    @Override
    protected OCTopLevelTarget createTargetClass(OCFile sourceFile, OCFile mainTargetFile, String targetClassName, Set<VirtualFile> files, @Nullable OCSymbol targetSymbol, OCSymbol sourceSymbol, Project project) {
        OCFile associatedFile = mainTargetFile.getAssociatedFile();
        if (!mainTargetFile.isHeader() && associatedFile != null && associatedFile.isHeader() && !this.mySourceFile.equals(associatedFile)) {
            return new OCTopLevelTarget(sourceFile, associatedFile, files, project);
        }
        return new OCTopLevelTarget(sourceFile, mainTargetFile, files, project);
    }

    @Override
    protected void removeMember(@Nullable PsiElement element, OCSymbol symbol) {
        OCChangeUtil.delete(element);
    }
}

