/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCQualifiedDesignator;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.OCImportsOptimizer;
import com.jetbrains.cidr.lang.refactoring.OCUsageViewDescriptor;
import com.jetbrains.cidr.lang.refactoring.move.OCDependentMembersCollector;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfoStorage;
import com.jetbrains.cidr.lang.refactoring.move.OCTargetClass;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.search.OCMethodReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveProcessor<C extends PsiElement, S extends OCSymbol, T extends OCTargetClass<C, S>>
extends BaseRefactoringProcessor {
    protected C mySourceClass;
    protected S mySourceClassSymbol;
    protected List<T> myTargetClasses;
    protected String myTargetClassName;
    protected List<OCMemberInfo> mySelectedMemberInfos;
    protected List<Member> myMembers;
    protected OCFile mySourceFile;
    private Set<VirtualFile> myAllFiles = new HashSet<VirtualFile>();
    private Set<VirtualFile> mySourceFiles = new HashSet<VirtualFile>();
    protected Set<VirtualFile> myTargetFiles = new HashSet<VirtualFile>();
    protected OCElementsMover myMover = new OCElementsMover(false);
    private Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> myElemsToEscalateVisibility;
    protected MultiMap<PsiElement, String> myConflicts;
    private Boolean myProcessStructMembers;
    private boolean myImportsHandlingSkipped;

    protected OCMoveProcessor(C sourceClass, List<OCMemberInfo> selectedMemberInfos, @Nullable String targetClassName) {
        super(sourceClass.getProject());
        this.mySourceClass = sourceClass;
        this.mySourceClassSymbol = this.mySourceClass instanceof OCSymbolDeclarator ? ((OCSymbolDeclarator)this.mySourceClass).getSymbol() : null;
        this.mySelectedMemberInfos = selectedMemberInfos;
        this.myTargetClasses = new ArrayList<T>();
        this.myTargetClassName = targetClassName;
        assert (sourceClass instanceof OCFile || this.mySourceClassSymbol != null);
        this.mySourceFile = (OCFile)this.mySourceClass.getContainingFile();
        this.mySourceFiles.add(this.mySourceFile.getVirtualFile());
        for (Member member : this.locateMembers()) {
            PsiElement element = member.getElement();
            if (element == null) continue;
            this.mySourceFiles.add(element.getContainingFile().getVirtualFile());
        }
    }

    public OCMoveProcessor(C sourceClass, List<OCMemberInfo> selectedMemberInfos, @Nullable String targetClassName, Collection<S> targetSymbols) {
        this(sourceClass, selectedMemberInfos, targetClassName);
        for (OCSymbol targetSymbol : targetSymbols) {
            OCFile targetFile = targetSymbol.getContainingOCFile();
            if (targetFile == null) continue;
            this.addTarget(targetFile, targetSymbol instanceof OCClassSymbol ? targetSymbol.getPresentableName() : targetSymbol.getName(), targetSymbol);
        }
    }

    protected void addTarget(OCFile targetFile, String targetName, @Nullable S targetSymbol) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        files.add(targetFile.getVirtualFile());
        OCFile associatedFile = targetFile.getAssociatedFile();
        if (associatedFile != null) {
            files.add(associatedFile.getVirtualFile());
        }
        this.myTargetClasses.add(this.createTargetClass(this.mySourceFile, targetFile, targetName, files, targetSymbol, this.mySourceClassSymbol, this.myProject));
        this.myTargetFiles.addAll(files);
    }

    protected abstract T createTargetClass(OCFile var1, OCFile var2, String var3, Set<VirtualFile> var4, @Nullable S var5, S var6, Project var7);

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor", "createUsageViewDescriptor"));
        }
        OCUsageViewDescriptor oCUsageViewDescriptor = new OCUsageViewDescriptor((PsiElement)(this.mySourceClass != null ? this.mySourceClass : this.mySourceFile), this.getCommandName());
        if (oCUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor", "createUsageViewDescriptor"));
        }
        return oCUsageViewDescriptor;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        final HashSet usages = new HashSet();
        final List<Member> members = this.locateMembers();
        final HashSet<OCSymbol> symbols = new HashSet<OCSymbol>();
        for (Member member : members) {
            symbols.add(member.getSymbol());
        }
        for (Member member : members) {
            Object definition;
            final OCSymbol symbol = member.getSymbol();
            if (member.isInnerClassMember() || symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).getParent() != this.mySourceClassSymbol || (definition = symbol.locateDefinition()) == null) continue;
            Processor<PsiReference> processor2 = new Processor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    PsiElement element = reference.getElement();
                    if (OCMoveProcessor.this.mySourceFiles.contains(element.getContainingFile().getVirtualFile()) && !(reference instanceof OCExternalReference) && !(element instanceof OCQualifiedDesignator)) {
                        for (Member member : members) {
                            PsiElement memberElement = member.getElement();
                            if (member.getSymbol() instanceof OCFunctionSymbol) {
                                memberElement = memberElement.getParent();
                            }
                            if (!PsiTreeUtil.isAncestor((PsiElement)memberElement, (PsiElement)element, (boolean)true)) continue;
                            return true;
                        }
                    }
                    usages.add(new MoveUsage(reference, symbol));
                    return true;
                }
            };
            if (symbol instanceof OCMethodSymbol) {
                ReferencesSearch.SearchParameters parameters = new ReferencesSearch.SearchParameters(definition, (SearchScope)OCSearchScope.getProjectSourcesScope(this.myProject), false);
                new OCMethodReferencesSearch().execute(parameters, processor2);
            } else {
                ReferencesSearch.search(definition).forEach((Processor)processor2);
            }
            symbol.processSameSymbols(new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    PsiReference reference;
                    OCCppNamespaceQualifier qualifier;
                    Object definition = symbol.locateDefinition();
                    if (definition instanceof OCDeclarator && (qualifier = ((OCDeclarator)definition).getNamespaceQualifier()) != null && (reference = qualifier.getReference()) != null && reference.isReferenceTo(OCMoveProcessor.this.mySourceClass)) {
                        usages.add(new QualifierRebindUsage(reference, symbol, symbols.contains(symbol)));
                    }
                    return true;
                }
            });
        }
        UsageInfo[] usageInfoArray = usages.toArray(new UsageInfo[usages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor", "performRefactoring"));
        }
        if (!this.createNewClass()) {
            return;
        }
        this.getAllFiles(usages);
        this.locateTargetClasses();
        List<Member> members = this.locateMembers();
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (Member member : members) {
            PsiElement element = member.getElement();
            if (element == null) continue;
            elements.add(member.getSymbol() instanceof OCFunctionSymbol ? element.getParent() : element);
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof QualifierRebindUsage) || !((QualifierRebindUsage)usage).isMoved()) continue;
            OCBindUtil.encodeAsRefToParent(usage.getElement().getParent());
        }
        MultiMap<VirtualFile, Integer> nonRemovableImports = this.getNonRemovableImports();
        this.addImports();
        OCBindUtil.encodeContextInfo(elements, this.mySourceClassSymbol, false);
        this.locateTargetClasses();
        this.addSuperClasses();
        MultiMap memberToNewElements = new MultiMap();
        MultiMap targetToNewElements = new MultiMap();
        this.myElemsToEscalateVisibility = new HashMap();
        for (Member member : members) {
            OCSymbol symbol = member.getSymbol();
            PsiElement element = member.getElement();
            if (element != null && !element.isValid()) continue;
            if (element instanceof OCStructLike) {
                element = PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class);
            }
            if (element instanceof OCDeclarator) {
                element = OCNormalizeUtil.normalizeDeclarator((OCDeclarator)element);
            }
            if (element instanceof OCSynthesizeProperty) {
                element = OCNormalizeUtil.normalizeSynthesizeStatement((OCSynthesizeProperty)element);
            }
            block3: for (OCTargetClass targetClass : this.myTargetClasses) {
                OCSymbolDeclarator newMember;
                OCMemberInfoStorage memberStorage = targetClass.getMemberStorage();
                for (OCMemberInfo info : memberStorage.getClassMemberInfos(targetClass.getPsi())) {
                    if (!memberStorage.memberConflict((OCSymbolHolderVirtualPsiElement)info.getMember(), (OCSymbolHolderVirtualPsiElement)member.getMemberInfo().getMember())) continue;
                    PsiElement existingPsi = targetClass.getMemberElement(info);
                    if (member.getMemberInfo().isAbstract()) {
                        if (symbol == null || !(existingPsi instanceof OCSymbolDeclarator)) continue block3;
                        memberToNewElements.putValue((Object)symbol, (Object)((OCSymbolDeclarator)existingPsi));
                        continue block3;
                    }
                    if (!info.isAbstract()) continue;
                    OCChangeUtil.delete(existingPsi);
                    break;
                }
                if ((newMember = targetClass.addMember(element, symbol, member.getVisibility())) == null) continue;
                memberToNewElements.putValue((Object)symbol, (Object)newMember);
                targetToNewElements.putValue((Object)targetClass, newMember instanceof OCDeclarator ? newMember.getParent() : newMember);
            }
            if (element != null && !memberToNewElements.containsKey((Object)symbol)) continue;
            this.removeMember(element, symbol);
        }
        this.locateTargetClasses();
        for (OCTargetClass targetClass : this.myTargetClasses) {
            for (PsiElement element : targetToNewElements.get((Object)targetClass)) {
                OCBindUtil.decodeContextInfo(element, targetClass.getSymbol(), this.myElemsToEscalateVisibility);
            }
        }
        this.bindExternalUsages(usages, (MultiMap<OCSymbol, OCSymbolDeclarator>)memberToNewElements, this.myElemsToEscalateVisibility);
        this.addMissingImports(targetToNewElements);
        this.optimizeImports(nonRemovableImports);
        if (this.myTargetClasses.size() == 1) {
            EditorHelper.openInEditor(((OCTargetClass)this.myTargetClasses.get(0)).getPsi());
        }
    }

    protected abstract void removeMember(@Nullable PsiElement var1, OCSymbol var2);

    protected void locateTargetClasses() {
        for (OCTargetClass targetClass : this.myTargetClasses) {
            targetClass.locateTargetClass();
        }
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        OCBindUtil.escalateVisibilities(this.myProject, this.myElemsToEscalateVisibility, this.myAllFiles.toArray(new VirtualFile[this.myAllFiles.size()]));
    }

    protected void addMissingImports(MultiMap<T, PsiElement> newElements) {
        for (PsiElement newElement : newElements.values()) {
            OCImportSymbolFix.fixAllSymbolsRecursively(newElement);
        }
    }

    private void bindExternalUsages(UsageInfo[] usages, MultiMap<OCSymbol, OCSymbolDeclarator> newElementsMap, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        for (UsageInfo usage : usages) {
            OCSymbol associatedSymbol;
            if (!(usage instanceof MoveUsage)) continue;
            OCSymbol formerSymbol = ((MoveUsage)usage).getFormerSymbol();
            Collection newElements = newElementsMap.get((Object)formerSymbol);
            OCSymbolDeclarator newElement = newElements.size() == 1 ? (OCSymbolDeclarator)newElements.iterator().next() : null;
            OCSymbol symbol = newElement != null ? (OCSymbol)newElement.getSymbol() : null;
            Object targetSymbol = ((OCTargetClass)this.myTargetClasses.get(0)).getSymbol();
            if (usage instanceof QualifierRebindUsage) {
                if (!((QualifierRebindUsage)usage).isMoved()) {
                    symbol = (OCSymbol)targetSymbol;
                    newElement = null;
                }
            } else if (symbol != null && formerSymbol.isDefinition() && (associatedSymbol = symbol.getAssociatedSymbol()) != null && associatedSymbol.isPredeclaration()) {
                symbol = associatedSymbol;
                newElement = (OCSymbolDeclarator)associatedSymbol.locateDefinition();
            }
            boolean bindQualifier = symbol instanceof OCSymbolWithParent && ((OCSymbolWithParent)symbol).getParent() == targetSymbol;
            OCBindUtil.bindReferenceAndMakeVisible(usage.getReference(), symbol, newElement, elemsToEscalateVisibility, bindQualifier);
        }
    }

    protected void addSuperClasses() {
    }

    public OCFile[] getCreatedFiles() {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(this.myTargetFiles);
        files.removeAll(this.mySourceFiles);
        return ContainerUtil.map(files, (Function)new Function<VirtualFile, OCFile>(){

            public OCFile fun(VirtualFile file2) {
                return (OCFile)PsiManager.getInstance((Project)OCMoveProcessor.this.myProject).findFile(file2);
            }
        }).toArray(new OCFile[files.size()]);
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor", "getElementsToWrite"));
        }
        HashSet<Object> files = new HashSet<Object>();
        files.add(this.mySourceFile);
        for (VirtualFile file2 : this.myTargetFiles) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
            if (psiFile == null) continue;
            files.add(psiFile);
        }
        for (Member member : this.locateMembers()) {
            PsiElement element = member.getElement();
            if (element == null) continue;
            files.add(element);
        }
        HashSet<Object> hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor", "getElementsToWrite"));
        }
        return hashSet;
    }

    private List<Member> locateMembers() {
        if (this.myMembers != null) {
            return this.myMembers;
        }
        ArrayList<Member> members = new ArrayList<Member>();
        for (OCMemberInfo info : this.mySelectedMemberInfos) {
            OCSymbol member = info.getSymbol();
            if (this.mySourceClassSymbol instanceof OCClassSymbol && member instanceof OCProtocolSymbol) {
                members.add(new Member(member, null, info));
                continue;
            }
            if (this.mySourceClassSymbol instanceof OCStructSymbol && member instanceof OCStructSymbol && ((OCStructSymbol)member).getParent() != this.mySourceClassSymbol) {
                members.add(new Member(member, null, info));
                continue;
            }
            members.addAll(this.getAssociatedSymbols(info, member));
        }
        this.myMembers = members;
        return members;
    }

    protected List<Member> getAssociatedSymbols(final OCMemberInfo info, final OCSymbol member) {
        final HashSet members = new HashSet();
        final VirtualFile sourceVirtualFile = this.mySourceFile.getVirtualFile();
        OCFile associatedFile = this.mySourceFile.getAssociatedFile();
        final VirtualFile associatedVirtualFile = associatedFile != null ? associatedFile.getVirtualFile() : null;
        member.processSameSymbols(new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCSymbolWithParent && ((OCSymbolWithParent)symbol).getParent() instanceof OCStructSymbol && !((OCSymbolWithParent)symbol).getParent().equals(OCMoveProcessor.this.mySourceClassSymbol)) {
                    return true;
                }
                if (symbol instanceof OCClassSymbol && !((OCClassSymbol)symbol).isSameCategory(member)) {
                    return true;
                }
                if (symbol.isDefinition() || sourceVirtualFile != null && sourceVirtualFile.equals(symbol.getContainingFile()) || associatedVirtualFile != null && associatedVirtualFile.equals(symbol.getContainingFile())) {
                    OCMoveProcessor.addAssociatedMember(members, symbol, info);
                }
                return true;
            }
        });
        if (member instanceof OCStructSymbol) {
            ((OCStructSymbol)member).processMembers((String)null, new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    List<Member> innerMembers = OCMoveProcessor.this.getAssociatedSymbols(info, symbol);
                    if (!innerMembers.isEmpty()) {
                        if (OCMoveProcessor.this.myProcessStructMembers == null) {
                            String message = "Do you want to move the class member definitions?";
                            OCMoveProcessor.this.myProcessStructMembers = ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((Project)OCMoveProcessor.this.myProject, (String)message, (String)OCMoveProcessor.this.getCommandName(), (Icon)Messages.getQuestionIcon()) == 0;
                        }
                        if (OCMoveProcessor.this.myProcessStructMembers.booleanValue()) {
                            for (Member inner : innerMembers) {
                                inner.setInnerClassMember(true);
                                members.add(inner);
                            }
                        }
                    }
                    return true;
                }
            });
        }
        ArrayList<Member> list = new ArrayList<Member>(members);
        Collections.sort(list, new Comparator<Member>(){

            @Override
            public int compare(Member member1, Member member2) {
                return OCSymbolOffsetUtil.compare(member1.getSymbol().getComplexOffset(), member2.getSymbol().getComplexOffset());
            }
        });
        return list;
    }

    protected static void addAssociatedMember(Collection<Member> members, OCSymbol symbol, OCMemberInfo info) {
        PsiElement element;
        PsiElement psiElement = element = symbol != null ? (PsiElement)symbol.locateDefinition() : null;
        if (element != null && !symbol.isSynthetic()) {
            members.add(new Member(symbol, element, info));
        }
    }

    private boolean createNewClass() {
        OCNewFileActionBase action = this.getNewClassAction();
        if (action == null || !this.myTargetClasses.isEmpty()) {
            return true;
        }
        OCFile sampleFile = this.mySourceFile;
        if (sampleFile.isHeader()) {
            OCFile associatedFile = sampleFile.getAssociatedFile();
            OCFile oCFile = sampleFile = associatedFile != null ? associatedFile : sampleFile;
        }
        if (!action.performActionWithoutDialog(this.myTargetClassName, sampleFile, true)) {
            return false;
        }
        this.myTargetFiles = new HashSet<VirtualFile>();
        OCFile mainTargetFile = null;
        for (PsiFile file2 : action.getCreatedElements()) {
            VirtualFile virtualFile = file2.getVirtualFile();
            this.myTargetFiles.add(virtualFile);
            if (!(file2 instanceof OCFile) || !((OCFile)file2).isHeader()) continue;
            mainTargetFile = (OCFile)file2;
        }
        this.myTargetClasses.add(this.createTargetClass(this.mySourceFile, mainTargetFile, this.myTargetClassName, new HashSet<VirtualFile>(this.myTargetFiles), null, this.mySourceClassSymbol, this.myProject));
        return true;
    }

    @Nullable
    protected OCNewFileActionBase getNewClassAction() {
        return null;
    }

    private boolean processFilesWithProgress(final Collection<VirtualFile> files, final FileProcessor processor2, String title, boolean skippable) {
        if (this.myImportsHandlingSkipped) {
            return false;
        }
        final Ref finished = Ref.create((Object)false);
        Task.Modal task = new Task.Modal(this.myProject, title, skippable){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$7", "run"));
                }
                int fileCount = files.size();
                int curFile = 0;
                for (VirtualFile file2 : files) {
                    indicator.setText2(file2.getPresentableUrl());
                    indicator.setFraction((double)curFile++ / (double)fileCount);
                    PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
                    if (!(psiFile instanceof OCFile)) continue;
                    processor2.process(file2, (OCFile)psiFile);
                }
                finished.set((Object)true);
            }
        };
        if (skippable) {
            task.setCancelText("Skip");
            task.setCancelTooltipText("Skip");
        }
        ProgressManager.getInstance().run((Task)task);
        if (skippable && !((Boolean)finished.get()).booleanValue()) {
            this.myImportsHandlingSkipped = true;
        }
        return (Boolean)finished.get();
    }

    private void addImports() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        final MultiMap targetFileToUsages = new MultiMap();
        final MultiMap targetFileToSourceFiles = MultiMap.createSet();
        final MultiMap targetFileToImports = new MultiMap();
        for (Member member : this.locateMembers()) {
            for (OCTargetClass targetClass : this.myTargetClasses) {
                VirtualFile targetFile;
                PsiElement element = member.getElement();
                if (element != null) {
                    targetFile = targetClass.getTargetFile(element, member.getSymbol());
                    if (targetFile == null) continue;
                    targetFileToUsages.putValue((Object)targetFile, (Object)element);
                    targetFileToSourceFiles.putValue((Object)targetFile, (Object)((OCFile)element.getContainingFile()));
                    continue;
                }
                targetFile = targetClass.getPsi().getContainingFile().getVirtualFile();
                targetFileToUsages.putValue((Object)targetFile, (Object)new OCSymbolHolderVirtualPsiElement(member.getSymbol()));
                targetFileToSourceFiles.putValue((Object)targetFile, (Object)this.mySourceFile);
            }
        }
        List<OCIncludeDirective> importTarget = Collections.emptyList();
        for (VirtualFile virtualFile : this.myTargetFiles) {
            if (!OCFileImpl.isHeaderFile(virtualFile.getName())) continue;
            String importStr = (this.mySourceClassSymbol instanceof OCClassSymbol ? "#import \"" : "#include \"") + virtualFile.getName() + "\"";
            importTarget = Collections.singletonList((OCIncludeDirective)OCElementFactory.topLevelDeclarationFromText(importStr, this.mySourceFile));
        }
        if (this.importTargetFromSource()) {
            this.addImports(this.mySourceFile, importTarget, -1);
        } else {
            for (VirtualFile virtualFile : this.mySourceFiles) {
                OCFile sourceFile = (OCFile)psiManager.findFile(virtualFile);
                if (sourceFile == null || sourceFile.isHeader()) continue;
                this.addImports(sourceFile, importTarget, -1);
            }
        }
        this.processFilesWithProgress(targetFileToUsages.keySet(), new FileProcessor(){

            @Override
            public void process(@NotNull VirtualFile virtualFile, @NotNull OCFile psiFile) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$8", "process"));
                }
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$8", "process"));
                }
                for (final OCFile sourceFile : targetFileToSourceFiles.get((Object)virtualFile)) {
                    List usages = ContainerUtil.filter((Collection)targetFileToUsages.get((Object)virtualFile), (Condition)new Condition<PsiElement>(){

                        public boolean value(PsiElement element) {
                            return element instanceof OCSymbolHolderVirtualPsiElement || element.getContainingFile() == sourceFile;
                        }
                    });
                    targetFileToImports.putValues((Object)psiFile, OCImportsOptimizer.getUsedImports(sourceFile, usages));
                }
            }
        }, "Adding imports", false);
        if (this.importSourceFromTarget()) {
            String string = (this.mySourceClassSymbol instanceof OCClassSymbol ? "#import \"" : "#include \"") + this.mySourceFile.getName() + "\"";
            List<OCIncludeDirective> list = Collections.singletonList((OCIncludeDirective)OCElementFactory.topLevelDeclarationFromText(string, this.mySourceFile));
            for (VirtualFile file2 : this.myTargetFiles) {
                OCFile psiFile = (OCFile)PsiManager.getInstance((Project)this.myProject).findFile(file2);
                if (psiFile == null || !psiFile.isHeader()) continue;
                this.addImports(psiFile, list, -1);
            }
        } else {
            for (OCFile oCFile : targetFileToImports.keySet()) {
                List<OCIncludeDirective> existing = oCFile.findIncludeDirectives();
                this.addImports(oCFile, (List)targetFileToImports.get((Object)oCFile), oCFile.isHeader() || existing.isEmpty() ? -1 : existing.get(0).getTextOffset());
            }
        }
        for (VirtualFile virtualFile : this.myAllFiles) {
            PsiFile psiFile;
            if (this.mySourceFiles.contains(virtualFile) || this.myTargetFiles.contains(virtualFile) || !((psiFile = psiManager.findFile(virtualFile)) instanceof OCFile)) continue;
            this.addImports((OCFile)psiFile, importTarget, -1);
        }
    }

    protected boolean importTargetFromSource() {
        return false;
    }

    protected boolean importSourceFromTarget() {
        return false;
    }

    private void addImports(OCFile file2, List<OCIncludeDirective> originalImports, int beforeOffset) {
        ArrayList<PsiElement> imports = new ArrayList<PsiElement>();
        HashSet<String> addedImports = new HashSet<String>();
        for (OCIncludeDirective directive : file2.findIncludeDirectives()) {
            addedImports.add(directive.getReferenceText());
        }
        for (OCIncludeDirective directive : originalImports) {
            String directiveText = directive.getReferenceText();
            if (!(addedImports.contains(directiveText) || OCMoveProcessor.importsFile(directiveText, file2.getName()) || file2.isHeader() && this.myTargetFiles.contains(file2.getVirtualFile()) && OCMoveProcessor.importsFile(directiveText, this.mySourceFile.getName()) && !this.importSourceFromTarget())) {
                imports.add(OCImportSymbolFix.addImportToFile(file2, directive.getText(), OCImportSymbolFix.ImportStyle.INCLUDE, beforeOffset));
            }
            addedImports.add(directiveText);
        }
        for (PsiElement anImport : imports) {
            OCChangeUtil.reformatTextIfNotInjected(file2, anImport.getTextRange().getStartOffset(), anImport.getTextRange().getStartOffset());
        }
    }

    private static boolean importsFile(String directiveText, String fileName) {
        if (directiveText.endsWith(fileName)) {
            if (directiveText.length() == fileName.length()) {
                return true;
            }
            return !Character.isJavaIdentifierPart(directiveText.charAt(directiveText.length() - fileName.length()));
        }
        return false;
    }

    private MultiMap<VirtualFile, Integer> getNonRemovableImports() {
        final MultiMap result2 = new MultiMap();
        boolean success = this.processFilesWithProgress(this.myAllFiles, new FileProcessor(){

            @Override
            public void process(@NotNull VirtualFile virtualFile, @NotNull OCFile psiFile) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$9", "process"));
                }
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$9", "process"));
                }
                if (OCMoveProcessor.this.myTargetFiles.contains(virtualFile)) {
                    return;
                }
                HashSet<OCIncludeDirective> unusedImports = new HashSet<OCIncludeDirective>(OCImportsOptimizer.getUnusedImports(psiFile));
                List<OCIncludeDirective> imports = psiFile.findIncludeDirectives();
                for (int i = 0; i < imports.size(); ++i) {
                    if (!unusedImports.contains(imports.get(i))) continue;
                    result2.putValue((Object)virtualFile, (Object)i);
                }
            }
        }, "Analyzing imports", true);
        return success ? result2 : null;
    }

    private void optimizeImports(final MultiMap<VirtualFile, Integer> nonRemovableImports) {
        final ArrayList importsToDelete = new ArrayList();
        boolean success = this.processFilesWithProgress(this.myAllFiles, new FileProcessor(){

            @Override
            public void process(@NotNull VirtualFile virtualFile, @NotNull OCFile psiFile) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$10", "process"));
                }
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$10", "process"));
                }
                if (OCMoveProcessor.this.myTargetFiles.contains(virtualFile)) {
                    return;
                }
                HashSet<OCIncludeDirective> unusedImports = new HashSet<OCIncludeDirective>(OCImportsOptimizer.getUnusedImports(psiFile));
                List<OCIncludeDirective> imports = psiFile.findIncludeDirectives();
                for (int i = 0; i < imports.size(); ++i) {
                    OCIncludeDirective directive = imports.get(i);
                    if (!unusedImports.contains(directive) || nonRemovableImports.get((Object)virtualFile).contains(i)) continue;
                    importsToDelete.add(directive);
                }
            }
        }, "Removing redundant imports", true);
        if (success) {
            for (OCIncludeDirective directive : importsToDelete) {
                OCChangeUtil.delete(directive);
            }
        }
    }

    private void getAllFiles(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            this.myAllFiles.add(usage.getFile().getVirtualFile());
        }
        this.myAllFiles.addAll(this.mySourceFiles);
        this.myAllFiles.addAll(this.myTargetFiles);
    }

    public void setConflicts(MultiMap<PsiElement, String> conflicts) {
        this.myConflicts = conflicts;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor", "preprocessUsages"));
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        HashSet<OCMemberInfo> conflictingMembers = new HashSet<OCMemberInfo>();
        for (OCMemberInfo memberInfo : this.mySelectedMemberInfos) {
            if (memberInfo.isAbstract()) continue;
            block1: for (OCTargetClass targetClass : this.myTargetClasses) {
                OCMemberInfoStorage memberStorage = targetClass.getMemberStorage();
                if (memberStorage == null) continue;
                for (OCMemberInfo info : memberStorage.getClassMemberInfos(targetClass.getPsi())) {
                    OCSymbol conflictSymbol;
                    Object conflictElement;
                    if (info.isAbstract() || !memberStorage.memberConflict((OCSymbolHolderVirtualPsiElement)info.getMember(), (OCSymbolHolderVirtualPsiElement)memberInfo.getMember()) || (conflictElement = (conflictSymbol = ((OCSymbolHolderVirtualPsiElement)info.getMember()).getSymbol()) != null ? conflictSymbol.locateDefinition() : null) == null) continue;
                    this.myConflicts.putValue(conflictElement, (Object)(info.getDisplayNameWithKind() + " is already defined in the " + targetClass.getDisplayName()));
                    conflictingMembers.add(memberInfo);
                    continue block1;
                }
            }
            OCDependentMembersCollector collector = new OCDependentMembersCollector((PsiElement)this.mySourceClass, null);
            collector.collect((OCSymbolHolderVirtualPsiElement)memberInfo.getMember());
            for (OCSymbol dependency : collector.getDependenciesFromSameFile()) {
                Object element = dependency.locateDefinition();
                VirtualFile file2 = dependency.getContainingFile();
                if (file2 == null || element == null || OCFileImpl.isHeaderFile(file2.getName())) continue;
                this.myConflicts.putValue(element, (Object)(dependency.getNameWithKindUppercase() + " will be inaccessible in the moved code"));
            }
        }
        HashSet<OCSymbol> symbols = new HashSet<OCSymbol>();
        for (UsageInfo usage : usages) {
            OCSymbol symbol = ((MoveUsage)usage).getFormerSymbol();
            if (usage.getElement() instanceof OCQualifiedDesignator) {
                if (!symbols.add(symbol)) continue;
                this.myConflicts.putValue((Object)usage.getElement(), (Object)("Qualified designators for the " + symbol.getNameWithKindLowercase() + " will become unresolved"));
                continue;
            }
            if (usage.getReference() instanceof OCExternalReference) {
                if (!symbols.add(symbol)) continue;
                String componentName = ((OCExternalReference)usage.getReference()).getExternalComponentName();
                this.myConflicts.putValue((Object)usage.getElement(), (Object)(componentName + " references for the " + symbol.getNameWithKindLowercase() + " may become unresolved"));
                continue;
            }
            if (this.myTargetClasses.size() <= 1 || usage instanceof QualifierRebindUsage && ((QualifierRebindUsage)usage).isMoved() || !symbols.add(symbol)) continue;
            this.myConflicts.putValue((Object)usage.getElement(), (Object)("Some references to the " + symbol.getNameWithKindLowercase() + " will become unresolved"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.removeConflictingMembers()) {
                this.mySelectedMemberInfos.removeAll(conflictingMembers);
                this.myMembers = null;
            }
            this.prepareSuccessful();
            return true;
        }
        return this.showConflicts(this.myConflicts, usages);
    }

    protected boolean removeConflictingMembers() {
        return false;
    }

    private static interface FileProcessor {
        public void process(@NotNull VirtualFile var1, @NotNull OCFile var2);
    }

    private static class QualifierRebindUsage
    extends MoveUsage {
        private boolean myMoved;

        public QualifierRebindUsage(@NotNull PsiReference qualifier, OCSymbol symbol, boolean isMoved) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$QualifierRebindUsage", "<init>"));
            }
            super(qualifier, symbol);
            this.myMoved = isMoved;
        }

        public boolean isMoved() {
            return this.myMoved;
        }
    }

    private static class MoveUsage
    extends UsageInfo {
        private OCSymbol myFormerSymbol;

        public MoveUsage(@NotNull PsiReference reference, OCSymbol symbol) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$MoveUsage", "<init>"));
            }
            super(reference);
            this.myFormerSymbol = symbol;
        }

        public OCSymbol getFormerSymbol() {
            return this.myFormerSymbol;
        }
    }

    protected static class Member {
        private OCSymbol mySymbol;
        private PsiElement myElement;
        private OCMemberInfo myMemberInfo;
        private boolean isInnerClassMember;

        public Member(OCSymbol symbol, @Nullable PsiElement element, OCMemberInfo memberInfo) {
            this.mySymbol = symbol;
            this.myElement = element;
            this.myMemberInfo = memberInfo;
        }

        public OCSymbol getSymbol() {
            return this.mySymbol;
        }

        @Nullable
        public PsiElement getElement() {
            return this.myElement;
        }

        public OCMemberInfo getMemberInfo() {
            return this.myMemberInfo;
        }

        @Nullable
        public OCVisibility getVisibility() {
            return this.myMemberInfo.getVisibility();
        }

        public boolean isInnerClassMember() {
            return this.isInnerClassMember;
        }

        public void setInnerClassMember(boolean innerClassMember) {
            this.isInnerClassMember = innerClassMember;
        }
    }
}

