/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.refactoring.move.OCUpDownMover;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import org.jetbrains.annotations.NotNull;

public class OCDeclarationUpDownMover
extends OCUpDownMover {
    private static final Class[] ourDeclarationClasses = new Class[]{OCDeclaration.class, OCMethod.class, OCProperty.class, OCSynthesizePropertiesList.class, OCClassDeclaration.class, OCCppNamespace.class, OCCppUsingStatement.class};
    private static final Class[] ourContainerClasses = new Class[]{OCFile.class, OCClassDeclaration.class, OCInstanceVariablesList.class, OCStructLike.class, OCCppNamespace.class};

    @Override
    public boolean checkAvailable(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, @NotNull OCElementsRange range, boolean down) {
        PsiElement target;
        PsiElement firstDeclaration;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/refactoring/move/OCDeclarationUpDownMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/cidr/lang/refactoring/move/OCDeclarationUpDownMover", "checkAvailable"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/cidr/lang/refactoring/move/OCDeclarationUpDownMover", "checkAvailable"));
        }
        PsiElement lastDeclaration = range.getLastElement();
        for (firstDeclaration = range.getFirstElement(); firstDeclaration != null && !OCDeclarationUpDownMover.isDeclarationElement(firstDeclaration); firstDeclaration = firstDeclaration.getParent()) {
        }
        while (lastDeclaration != null && !OCDeclarationUpDownMover.isDeclarationElement(lastDeclaration)) {
            lastDeclaration = lastDeclaration.getParent();
        }
        if (firstDeclaration == null || lastDeclaration == null) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)firstDeclaration.getParent(), (PsiElement)lastDeclaration.getParent());
        if ((parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)parent, (Class[])ourContainerClasses)) == null) {
            return false;
        }
        while (firstDeclaration.getParent() != parent) {
            firstDeclaration = firstDeclaration.getParent();
        }
        while (lastDeclaration.getParent() != parent) {
            lastDeclaration = lastDeclaration.getParent();
        }
        if (!OCDeclarationUpDownMover.isAtTheStartOrEnd(editor, info.toMove, firstDeclaration) || !OCDeclarationUpDownMover.isAtTheStartOrEnd(editor, info.toMove, lastDeclaration)) {
            return false;
        }
        info.toMove = new LineRange(firstDeclaration, lastDeclaration);
        info.toMove2 = null;
        PsiElement psiElement = target = down ? lastDeclaration.getNextSibling() : firstDeclaration.getPrevSibling();
        while (!(target == null || OCDeclarationUpDownMover.isDeclarationElement(target) || target instanceof PsiComment && OCDeclarationUpDownMover.elementStartLine(editor, target) != info.toMove.startLine)) {
            target = down ? target.getNextSibling() : target.getPrevSibling();
        }
        info.toMove2 = target != null ? new LineRange(target) : null;
        return true;
    }

    private static boolean isAtTheStartOrEnd(@NotNull Editor editor, LineRange range, PsiElement element) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/refactoring/move/OCDeclarationUpDownMover", "isAtTheStartOrEnd"));
        }
        int startLine = OCDeclarationUpDownMover.elementStartLine(editor, element);
        int startLine2 = editor.offsetToLogicalPosition((int)element.getTextOffset()).line;
        int endLine = OCDeclarationUpDownMover.elementEndLine(editor, element) + 1;
        PsiElement leaf = PsiTreeUtil.firstChild((PsiElement)element);
        while (leaf != null && OCElementUtil.isWhitespace(leaf)) {
            leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
        }
        int startLine3 = leaf != null ? OCDeclarationUpDownMover.elementStartLine(editor, leaf) : -1;
        return startLine == range.startLine || startLine2 == range.startLine || startLine3 == range.startLine || endLine == range.startLine || startLine == range.endLine || startLine2 == range.endLine || startLine3 == range.endLine || endLine == range.endLine;
    }

    private static boolean isDeclarationElement(final PsiElement target) {
        if (OCElementUtil.isVisibilityKeyword(target.getNode())) {
            return true;
        }
        if (OCElementTypes.DIRECTIVES.contains(OCElementUtil.getElementType(target))) {
            return true;
        }
        return ContainerUtil.find((Object[])ourDeclarationClasses, (Condition)new Condition<Class>(){

            public boolean value(Class aClass) {
                return aClass.isInstance(target);
            }
        }) != null;
    }

    @Override
    protected boolean isMacroWhiteElement(PsiElement element, boolean skipMacros) {
        return super.isMacroWhiteElement(element, skipMacros) || OCElementUtil.getElementType(element) == OCTokenTypes.COMMA || OCElementUtil.getElementType(element) == OCTokenTypes.COLON;
    }
}

