/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.intentions.OCImplementCppFunctionIntentionAction;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeVisibilityIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCTargetSymbolPanel;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageWithContext;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGeneratedMethodUsage
extends OCUsageWithContext {
    public OCGeneratedMethodUsage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/refactoring/changeSignature/usages/OCGeneratedMethodUsage", "<init>"));
        }
        super(element);
    }

    @Nullable
    static OCCallable addMethod(PsiElement parent, OCChangeInfo changeInfo, @Nullable PsiElement anchor, boolean needBody, boolean isBefore) {
        if (parent == null || !OCSearchScope.isInProjectSources(parent)) {
            return null;
        }
        OCCallable newMethod = OCChangeSignatureUsageProcessor.generateMethodDefinition(changeInfo, changeInfo.getMethod(), needBody, true, false);
        if (newMethod != null) {
            if (isBefore) {
                return OCChangeUtil.addBefore(parent, newMethod, anchor);
            }
            return OCChangeUtil.addAfter(parent, newMethod, anchor);
        }
        return null;
    }

    @Override
    public boolean processUsage(OCChangeInfo changeInfo, PsiElement element, Project project) {
        OCTargetSymbolPanel.TargetSymbolsMode mode = changeInfo.getGenerated().getTargetSymbolsMode();
        OCSymbol parentClass = changeInfo.getGenerated().getMethodParent();
        OCCallable newMethod = null;
        if (changeInfo.willBeBlock()) {
            newMethod = OCChangeSignatureUsageProcessor.generateMethodDefinition(changeInfo, changeInfo.getMethod(), true, true, false);
        } else if (parentClass instanceof OCClassSymbol) {
            OCClassDeclarationBase implementation;
            ArrayList<Object> parents = new ArrayList<Object>();
            OCImplementationSymbol implementationSymbol = ((OCClassSymbol)parentClass).getImplementation();
            OCClassDeclarationBase oCClassDeclarationBase = implementation = implementationSymbol != null ? (OCClassDeclarationBase)implementationSymbol.locateDefinition() : null;
            if (mode == OCTargetSymbolPanel.TargetSymbolsMode.INTERFACE) {
                OCClassSymbol symbol = ((OCClassSymbol)parentClass).getInterfaceOrProtocol();
                parents.add(symbol != null ? (OCClassDeclarationBase)symbol.locateDefinition() : null);
                OCImportSymbolFix oCImportSymbolFix = new OCImportSymbolFix(element, symbol);
                oCImportSymbolFix.fixFirstItem(project, element.getContainingFile());
            } else if (mode == OCTargetSymbolPanel.TargetSymbolsMode.PRIVATE_CATEGORY && implementation != null) {
                Object privateCategory = OCCodeInsightUtil.getPrivateCategory(implementation);
                if (privateCategory == null) {
                    privateCategory = OCElementFactory.interfaceByName(parentClass.getName() + "()", implementation);
                    parents.add(OCChangeUtil.addBefore((PsiElement)implementation.getContainingFile(), privateCategory, implementation));
                } else {
                    parents.add(privateCategory);
                }
            }
            parents.add(implementation);
            for (OCClassDeclarationBase oCClassDeclarationBase2 : parents) {
                boolean before = !OCCompilerHelper.supportsLaterMethodDeclaration();
                OCCallable method = OCGeneratedMethodUsage.addMethod(oCClassDeclarationBase2, changeInfo, element, oCClassDeclarationBase2 instanceof OCImplementation, before);
                newMethod = method != null ? method : newMethod;
            }
        } else {
            Object parent;
            boolean isBefore = true;
            if (!(parentClass instanceof OCStructSymbol)) {
                OCSymbolKind symbolKind = changeInfo.getNewCallableKind().getSymbolKind();
                parent = OCChangeUtil.getAppropriateParent(symbolKind, changeInfo.getContext());
                if (changeInfo.getMethod() instanceof OCFunctionDefinition) {
                    if (((OCFunctionDefinition)changeInfo.getMethod()).getNamespaceQualifier() == null) {
                        if (mode == OCTargetSymbolPanel.TargetSymbolsMode.INTERFACE && parent != null) {
                            isBefore = false;
                            if (!(parent instanceof OCStruct)) {
                                OCGeneratedMethodUsage.addMethod(parent, changeInfo, element, false, true);
                            }
                        }
                    } else {
                        isBefore = false;
                    }
                }
            } else {
                parent = parentClass.locateDefinition();
            }
            newMethod = OCGeneratedMethodUsage.addMethod(parent, changeInfo, element, true, isBefore);
        }
        if (newMethod != null) {
            Editor editor;
            OCBlockStatement body = newMethod.getBody();
            List<PsiElement> statements = changeInfo.getGenerated().getMethodStatements();
            if (body != null && statements != null) {
                if ((statements = OCGeneratedMethodUsage.prepareStatements(changeInfo, statements)).size() == 1 && statements.get(0) instanceof OCBlockStatement) {
                    body = (OCBlockStatement)body.replace(statements.get(0));
                } else {
                    for (PsiElement statement : statements) {
                        if (statement instanceof OCExpression) {
                            if (changeInfo.getNewReturnType().equals("void")) {
                                OCExpressionStatement oCExpressionStatement = (OCExpressionStatement)OCElementFactory.statementFromText("x();", changeInfo.getContext());
                                OCChangeUtil.replaceHandlingMacros(oCExpressionStatement.getExpression(), statement);
                                OCChangeUtil.add(body, oCExpressionStatement);
                                continue;
                            }
                            OCReturnStatement oCReturnStatement = (OCReturnStatement)OCElementFactory.statementFromText("return x;", changeInfo.getContext());
                            OCChangeUtil.replaceHandlingMacros(oCReturnStatement.getExpression(), statement);
                            OCChangeUtil.add(body, oCReturnStatement);
                            continue;
                        }
                        if (!statement.isValid()) continue;
                        OCChangeUtil.add(body, statement);
                    }
                }
                if (newMethod instanceof OCFunctionDefinition) {
                    OCSymbol parentSymbol;
                    OCCppNamespaceQualifier oCCppNamespaceQualifier;
                    OCSymbol symbol = newMethod.getSymbol();
                    OCDeclarator declarator = ((OCFunctionDefinition)newMethod).getDeclarator();
                    OCCppNamespaceQualifier oCCppNamespaceQualifier2 = oCCppNamespaceQualifier = declarator != null ? declarator.getNamespaceQualifier() : null;
                    if (symbol instanceof OCSymbolWithQualifiedName && oCCppNamespaceQualifier != null && oCCppNamespaceQualifier.getPredeclarationInParent((OCSymbolWithQualifiedName)symbol, true) == null && (parentSymbol = OCReferenceElementImpl.getAppropriateToAppendSymbol(oCCppNamespaceQualifier, new OCResolveContext(oCCppNamespaceQualifier))) != null) {
                        OCSymbolKind kind = ((OCSymbolWithQualifiedName)symbol).getResolvedKind();
                        OCCreateNewDefinitionIntentionAction action = new OCCreateNewDefinitionIntentionAction(kind, declarator, null, parentSymbol, declarator.getName(), symbol.getResolvedType(), changeInfo.getGenerated().isStatic());
                        action.setSilentMode(true);
                        if (action.isAvailable(project, null, declarator.getContainingFile())) {
                            action.invoke(project, null, declarator.getContainingFile());
                        }
                    }
                }
                if (!changeInfo.willBeBlock()) {
                    OCBindUtil.decodeContextInfo(body);
                    OCBindUtil.removeRedundantQualifiers(body);
                }
            }
            OCImportSymbolFix.fixAllSymbolsRecursively(newMethod);
            PsiFile file2 = newMethod.getContainingFile();
            if (parentClass instanceof OCStructSymbol && newMethod instanceof OCFunctionDeclaration) {
                final OCSymbol newMethodSymbol = newMethod.getSymbol();
                if (newMethodSymbol instanceof OCFunctionSymbol) {
                    OCImplementCppFunctionIntentionAction implementAction;
                    OCType oCType = element instanceof OCQualifiedExpression ? ((OCQualifiedExpression)element).getQualifier().getResolvedType() : null;
                    OCVisibility visibility = OCVisibility.getVisibility(newMethodSymbol, element, oCType);
                    OCChangeVisibilityIntentionAction changeVisibilityAction = new OCChangeVisibilityIntentionAction((OCFunctionSymbol)newMethodSymbol, visibility);
                    if (!OCVisibility.isVisible(newMethodSymbol, visibility) && changeVisibilityAction.isAvailable(project, null, file2)) {
                        changeVisibilityAction.invoke(project, null, file2);
                        newMethod = (OCCallable)((Object)changeVisibilityAction.getNewDeclaration());
                    }
                    if ((implementAction = new OCImplementCppFunctionIntentionAction(){

                        @Override
                        protected boolean allowClassMembers() {
                            return true;
                        }

                        @Override
                        @Nullable
                        protected OCFunctionSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/refactoring/changeSignature/usages/OCGeneratedMethodUsage$1", "locateCandidate"));
                            }
                            return (OCFunctionSymbol)newMethodSymbol;
                        }
                    }).isAvailable(project, null, file2)) {
                        SmartPsiElementPointer newMethodPtr = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)newMethod);
                        implementAction.invoke(project, null, file2);
                        newMethod = (OCCallable)newMethodPtr.getElement();
                    }
                }
            } else if (changeInfo.getGenerated().isSelectMethod() && !changeInfo.willBeBlock() && (editor = EditorHelper.openInEditor((PsiElement)file2)) != null) {
                OCCodeInsightUtil.selectBody(editor, body);
            }
        }
        changeInfo.setNewMethod(newMethod);
        changeInfo.addNewMethod(newMethod);
        return true;
    }

    private static List<PsiElement> prepareStatements(final OCChangeInfo changeInfo, List<PsiElement> statements) {
        statements = ContainerUtil.filter(statements, (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return element.isValid();
            }
        });
        statements = OCBindUtil.insertRedundantQualifiers((Collection<PsiElement>)statements, false);
        List physicalStatements = ContainerUtil.filter(statements, (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return element.isPhysical();
            }
        });
        OCBindUtil.encodeContextInfo(physicalStatements, null, false);
        for (PsiElement statement : physicalStatements) {
            statement.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitReferenceExpression(OCReferenceExpression expression) {
                    OCReferenceElement referenceElement;
                    if (expression.getSelfSuperToken() != null && changeInfo.getSelfParameterName() != null && (referenceElement = expression.getReferenceElement()) != null) {
                        referenceElement.setName(changeInfo.getSelfParameterName());
                    }
                }
            });
        }
        return statements;
    }

    @Override
    public int getUsageRank() {
        return -1;
    }
}

