/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCCallableDefinitionUsage;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCFunctionDefinitionUsage
extends OCCallableDefinitionUsage<OCFunctionDeclaration> {
    public OCFunctionDefinitionUsage(@NotNull OCFunctionDeclaration element, boolean isInherited) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/refactoring/changeSignature/usages/OCFunctionDefinitionUsage", "<init>"));
        }
        super(element, isInherited);
    }

    @Override
    public boolean processUsage(OCChangeInfo changeInfo, OCFunctionDeclaration function, Project project) {
        OCParameterList parameterList;
        if (changeInfo.isParameterSetOrOrderChanged()) {
            return super.processUsage(changeInfo, function, project);
        }
        if (changeInfo.isNameChanged()) {
            PsiElement nameIdentifier;
            OCDeclarator declarator = function.getDeclarator();
            PsiElement psiElement = nameIdentifier = declarator != null ? declarator.getNameIdentifier() : null;
            if (nameIdentifier != null) {
                OCElementUtil.replaceWithIdentifier(nameIdentifier, changeInfo.getNewName(), function);
            }
        }
        if (changeInfo.isParameterTypesChanged()) {
            OCChangeSignatureUsageProcessor.processParameters(changeInfo, function, function.getParameterList(), project, this.myInherited);
        }
        if (changeInfo.isReturnTypeChanged() && !changeInfo.getOldMethodDescriptor().isConstructor()) {
            OCSymbolWithQualifiedName symbol = (OCSymbolWithQualifiedName)function.getSymbol();
            OCType newReturnType = OCElementFactory.typeElementFromText(changeInfo.getNewReturnType(), function).getType();
            if (symbol != null) {
                new OCChangeTypeIntentionAction((OCSymbol)symbol, newReturnType, true).invoke(project, null, function.getContainingFile());
            }
        }
        if ((parameterList = function.getParameterList()) != null) {
            TextRange range = parameterList.getRangeWithMacros();
            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)function.getContainingFile(), range.getStartOffset(), range.getEndOffset(), true);
        }
        return true;
    }
}

