/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCCallableDefinitionUsage<T extends OCCallable>
extends OCUsageInfo<T> {
    protected boolean myInherited;

    public OCCallableDefinitionUsage(@NotNull T element, boolean isInherited) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/refactoring/changeSignature/usages/OCCallableDefinitionUsage", "<init>"));
        }
        super(element);
        this.myInherited = isInherited;
    }

    @Override
    public int getUsageRank() {
        return 0;
    }

    @Override
    public boolean processUsage(OCChangeInfo changeInfo, T element, Project project) {
        if (!changeInfo.isParameterSetOrOrderChanged()) {
            return false;
        }
        OCCallable newMethod = null;
        OCClassDeclaration containerClass = changeInfo.getNewContainerClass();
        if (!changeInfo.willBeBlock() || element instanceof OCBlockExpression) {
            newMethod = OCChangeSignatureUsageProcessor.generateMethodDefinition(changeInfo, element, true, true, this.myInherited);
        }
        if (changeInfo.getOldMethodDescriptor().getCallableKind() != OCCallableKind.METHOD && containerClass != null && newMethod != null) {
            OCChangeUtil.delete(element);
            newMethod = OCChangeUtil.add(containerClass, newMethod);
        } else if (!changeInfo.willBeBlock() && element instanceof OCBlockExpression && newMethod != null) {
            OCChangeUtil.add((PsiElement)element.getContainingFile(), newMethod);
            OCChangeUtil.replaceHandlingMacros(element, OCElementFactory.expressionFromText(changeInfo.getNewName(), element));
        } else if (newMethod != null) {
            if (element instanceof OCFunctionDeclaration && newMethod instanceof OCFunctionDeclaration) {
                OCFunctionDeclaration oldFunction = (OCFunctionDeclaration)element;
                OCFunctionDeclaration newFunction = (OCFunctionDeclaration)newMethod;
                OCChangeUtil.replaceHandlingMacros(oldFunction.getNameIdentifier(), newFunction.getNameIdentifier());
                OCChangeUtil.replaceHandlingMacros(oldFunction.getTypeElement(), newFunction.getTypeElement());
                OCChangeUtil.replaceHandlingMacros(oldFunction.getParameterList(), newFunction.getParameterList());
                OCElementUtil.restoreFunction(oldFunction, newFunction);
                newMethod = oldFunction;
            } else {
                newMethod = (OCCallable)OCChangeUtil.replaceHandlingMacros(element, newMethod);
            }
        } else {
            OCChangeUtil.delete(element);
        }
        if (newMethod != null) {
            newMethod.accept(new OCRecursiveVisitor(){

                @Override
                public void visitReferenceElement(OCReferenceElement referenceElement) {
                    OCImportSymbolFix.fixAllSymbolsRecursively(referenceElement);
                }

                @Override
                public void visitBlockStatement(OCBlockStatement stmt) {
                }
            });
            changeInfo.addNewMethod(newMethod);
            if (element.equals(changeInfo.getOldMethodDescriptor().getMethod())) {
                changeInfo.setNewMethod(newMethod);
            }
        }
        return true;
    }
}

