/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParameterInfo
implements ParameterInfo,
Cloneable {
    private final int myOldIndex;
    private String mySelector = "";
    private String myName = "";
    private OCType myType;
    private String myTypeText;
    private boolean myEllipsisType;
    private boolean mySelfParameter;
    private Collection<PsiReference> myUsages;
    private boolean myReferenceMode;
    private String myArgumentValue;
    private final PsiElement myTypeContext;

    public OCParameterInfo(String selector, String name, OCType type, int oldIndex, PsiElement context) {
        this.myTypeContext = context;
        this.mySelector = selector.endsWith(":") ? selector.substring(0, selector.length() - 1) : selector;
        this.myName = name != null ? name : "";
        this.myType = type;
        this.myTypeText = OCParameterInfo.getTextFromType(this.myType, this.myTypeContext);
        this.myOldIndex = oldIndex;
    }

    @NotNull
    private static String getTextFromType(OCType type, PsiElement typeContext) {
        OCPointerType pointerType;
        Integer lengthInBrackets;
        if (type == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/changeSignature/OCParameterInfo", "getTextFromType"));
            }
            return "";
        }
        if (type.getClass().equals(OCPointerType.class) && (lengthInBrackets = (pointerType = (OCPointerType)type).getLengthInBrackets()) != null) {
            type = OCArrayType.to(pointerType.getRefType(), lengthInBrackets, pointerType.getARCAttribute());
        }
        String string = type.getName(typeContext);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/changeSignature/OCParameterInfo", "getTextFromType"));
        }
        return string;
    }

    public void setSelfParameter(boolean selfParameter) {
        this.mySelfParameter = selfParameter;
    }

    public void setEllipsisType(boolean ellipsisType) {
        this.myEllipsisType = ellipsisType;
    }

    public void setReferenceMode(boolean referenceMode) {
        this.myReferenceMode = referenceMode;
    }

    public void setArgumentValue(String argumentValue) {
        this.myArgumentValue = argumentValue;
    }

    public String getSelector() {
        return this.mySelector;
    }

    public String getName() {
        return this.myName;
    }

    public int getOldIndex() {
        return this.myOldIndex;
    }

    public String getDefaultValue() {
        return null;
    }

    public void setName(String name) {
        this.myName = name != null ? name : "";
    }

    public void setSelector(String selector) {
        this.mySelector = selector;
    }

    @Nullable
    public OCType getType() {
        return this.myType != null ? (this.myReferenceMode ? OCPointerType.to(this.myType) : this.myType) : null;
    }

    public String getTypeText() {
        if (this.myReferenceMode) {
            return this.myTypeText + "*";
        }
        return this.myTypeText;
    }

    public void setType(OCType type) {
        this.myType = type;
        this.myTypeText = OCParameterInfo.getTextFromType(this.myType, this.myTypeContext);
    }

    public void setTypeText(String typeText) {
        this.myTypeText = typeText;
    }

    public boolean isEllipsisType() {
        return this.myEllipsisType;
    }

    public boolean isSelfParameter() {
        return this.mySelfParameter;
    }

    public String getParameterStubText(boolean appendSelectors, boolean isSelfSuperCall) {
        StringBuilder result2 = new StringBuilder();
        if (appendSelectors) {
            result2.append(this.mySelector);
            if (this.myName.isEmpty()) {
                return result2.toString();
            }
            result2.append(':');
        }
        if (isSelfSuperCall) {
            result2.append(this.myName);
        } else if (this.isSelfParameter()) {
            result2.append("self");
        } else if (this.myArgumentValue != null) {
            result2.append(this.myArgumentValue);
        } else if (this.myType instanceof OCStructType) {
            result2.append("(").append(this.myType.getDefaultValue(this.myTypeContext)).append(")");
        } else if (this.myType != null) {
            result2.append(this.myType.getDefaultValue(this.myTypeContext));
        } else {
            result2.append("0");
        }
        return result2.toString();
    }

    public boolean isTypeChanged(String oldTypeText) {
        return !oldTypeText.replaceAll(" ", "").equals(this.myTypeText.replaceAll(" ", ""));
    }

    public boolean isUseAnySingleVariable() {
        return false;
    }

    public void setUseAnySingleVariable(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setUsages(Collection<PsiReference> usages) {
        this.myUsages = usages;
    }

    public Collection<PsiReference> getUsages() {
        return this.myUsages;
    }

    public boolean isReferenceMode() {
        return this.myReferenceMode;
    }

    public OCParameterInfo clone() {
        try {
            return (OCParameterInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

