/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentsOwner;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesHandler;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSafeDeleteProcessorDelegate
implements SafeDeleteProcessorDelegate {
    @Override
    public boolean handlesElement(PsiElement element) {
        return true;
    }

    @Override
    public NonCodeUsageSearchInfo findUsages(final @NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete, @NotNull List<UsageInfo> result2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "findUsages"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "findUsages"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "findUsages"));
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        SafeDeleteProcessor.findGenericElementUsages(element, usages, allElementsToDelete);
        result2.addAll(ContainerUtil.map(usages, (Function)new Function<UsageInfo, UsageInfo>(){

            public UsageInfo fun(UsageInfo info) {
                final PsiElement usageElement = info.getElement();
                if (OCSafeDeleteProcessorDelegate.isSafeToDelete(usageElement, element)) {
                    return new SafeDeleteReferenceSimpleDeleteUsageInfo(usageElement, ((SafeDeleteUsageInfo)info).getReferencedElement(), true){

                        @Override
                        public void deleteElement() throws IncorrectOperationException {
                            OCChangeUtil.safeDeleteReference(usageElement);
                        }
                    };
                }
                return info;
            }
        }));
        if (OCSafeDeleteProcessorDelegate.isTemplateParameter(element)) {
            ArrayList<Pair<PsiElement, OCSymbol>> list = new ArrayList<Pair<PsiElement, OCSymbol>>();
            OCSafeDeleteProcessorDelegate.getElementsToDeleteForTemplateParameter(element, list);
            for (Pair pair : list) {
                result2.add(new SafeDeleteUsageInfo((PsiElement)pair.getFirst(), element));
            }
        }
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition(allElementsToDelete), element);
    }

    public static boolean isSafeToDelete(PsiElement usageElement, @Nullable PsiElement element) {
        if (element instanceof OCStruct || element instanceof OCCppNamespace) {
            List<OCDeclarator> declarators;
            Object structSymbol = ((OCSymbolDeclarator)element).getSymbol();
            OCElement parent = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)usageElement, (Class[])new Class[]{OCStruct.class, OCCppNamespace.class, OCDeclarator.class, OCDeclaration.class});
            if (parent instanceof OCDeclaration) {
                declarators = ((OCDeclaration)parent).getDeclarators();
            } else if (parent instanceof OCDeclarator) {
                declarators = Collections.singletonList((OCDeclarator)parent);
            } else {
                return element.equals(parent);
            }
            for (OCDeclarator declarator : declarators) {
                OCSymbolWithQualifiedName owner;
                OCSymbol symbol = declarator.getSymbol();
                OCSymbolWithQualifiedName oCSymbolWithQualifiedName = owner = symbol instanceof OCSymbolWithQualifiedName ? ((OCSymbolWithQualifiedName)symbol).getResolvedOwner() : null;
                while (owner != null && !owner.equals(structSymbol)) {
                    owner = owner.getResolvedOwner();
                }
                if (owner != null) continue;
                return false;
            }
            return true;
        }
        if (new OCReadWriteAccessDetector().getExpressionAccess(usageElement) == ReadWriteAccessDetector.Access.Write) {
            return !(element instanceof OCMethod);
        }
        return false;
    }

    @Override
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "getElementsToSearch"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "getElementsToSearch"));
        }
        OCFindUsagesHandler handler2 = new OCFindUsagesHandler(element, true);
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement psiElement : handler2.getPrimaryElements()) {
            if (psiElement == null) continue;
            result2.add(psiElement);
        }
        for (PsiElement psiElement : handler2.getSecondaryElements()) {
            if (psiElement == null) continue;
            result2.add(psiElement);
        }
        Collections.sort(result2, new Comparator<PsiElement>(){

            private int order(PsiElement element) {
                return element instanceof OCSynthesizeProperty ? 1 : 0;
            }

            @Override
            public int compare(PsiElement el1, PsiElement el2) {
                return this.order(el1) - this.order(el2);
            }
        });
        return result2.isEmpty() ? null : result2;
    }

    @Override
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "getAdditionalElementsToDelete"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "getAdditionalElementsToDelete"));
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "findConflicts"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "findConflicts"));
        }
        if (element instanceof OCFile && ((OCFile)element).hasExtraTopLevelDefinitions()) {
            Set<String> set = Collections.singleton("File \"" + ((PsiFile)element).getName() + "\" has several top level declarations.");
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "findConflicts"));
            }
            return set;
        }
        if (OCSafeDeleteProcessorDelegate.isTemplateParameter(element)) {
            ArrayList<Pair<PsiElement, OCSymbol>> list = new ArrayList<Pair<PsiElement, OCSymbol>>();
            OCSafeDeleteProcessorDelegate.getElementsToDeleteForTemplateParameter(element, list);
            if (!list.isEmpty()) {
                List<String> list2 = Collections.singletonList(((OCSymbol)((Pair)list.get(0)).getSecond()).getNameWithKindUppercase() + " has usage without arguments");
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "findConflicts"));
                }
                return list2;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegate", "findConflicts"));
        }
        return list;
    }

    @Override
    public UsageInfo[] preprocessUsages(Project project, UsageInfo[] usages) {
        return usages;
    }

    @Override
    public void prepareForDeletion(final PsiElement element) throws IncorrectOperationException {
        Object symbol;
        PsiElement parent;
        if (!element.isValid()) {
            return;
        }
        if (element instanceof OCMethodSelectorPart) {
            OCMethod method = (OCMethod)element.getParent();
            OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler(method, element, true);
            handler2.removeParameter(method.getParameters().indexOf(element));
            handler2.invokeSynchronously();
        }
        if (element.getParent() instanceof OCParameterDeclaration && (parent = element.getParent().getParent()) instanceof OCParameterList) {
            OCParameterList paramList = (OCParameterList)parent;
            OCChangeSignatureHandler handler3 = OCChangeSignatureActionHandler.getHandler((OCCallable)paramList.getParent().getParent(), element, true);
            handler3.removeParameter(paramList.getParameters().indexOf(element));
            handler3.invokeSynchronously();
        }
        if ((element instanceof OCStruct || element instanceof OCCppNamespace) && ((OCElement)element).getContainingOCFile().isCpp() && (symbol = ((OCSymbolDeclarator)element).getSymbol()) instanceof OCNamespaceSymbol) {
            final ArrayList elementsToDelete = new ArrayList();
            ((OCNamespaceSymbol)symbol).processMembers((String)null, new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    Object definition;
                    OCSymbol definitionSymbol = symbol.getDefinitionSymbol();
                    Object e = definition = definitionSymbol != null ? (Object)definitionSymbol.locateDefinition() : null;
                    if (definition != null && !PsiTreeUtil.isAncestor((PsiElement)element, definition, (boolean)true)) {
                        elementsToDelete.add(definition);
                    }
                    return true;
                }
            });
            for (PsiElement psiElement : elementsToDelete) {
                OCChangeUtil.delete(psiElement);
            }
        }
        if (OCSafeDeleteProcessorDelegate.isTemplateParameter(element)) {
            List<PsiElement> elementsToDelete = OCSafeDeleteProcessorDelegate.getElementsToDeleteForTemplateParameter(element, new ArrayList<Pair<PsiElement, OCSymbol>>());
            for (PsiElement psiElement : elementsToDelete) {
                OCChangeUtil.delete(psiElement);
            }
        }
    }

    private static List<PsiElement> getElementsToDeleteForTemplateParameter(PsiElement element, final List<Pair<PsiElement, OCSymbol>> usagesWithoutArguments) {
        OCSymbol declaratorSymbol = null;
        PsiElement parameter = element instanceof OCTypeParameterDeclaration ? element : element.getParent();
        OCTemplateParameterList typeParamsList = (OCTemplateParameterList)parameter.getParent();
        PsiElement parent = typeParamsList.getParent();
        final int paramIndex = typeParamsList.getParameters().indexOf(parameter);
        final int paramsCnt = typeParamsList.getParameters().size();
        final ArrayList<PsiElement> elementsToDelete = new ArrayList<PsiElement>();
        if (parent instanceof OCFunctionDeclaration) {
            declaratorSymbol = ((OCFunctionDeclaration)parent).getSymbol();
        } else if (parent instanceof OCDeclaration) {
            OCTypeElement typeElement = ((OCDeclaration)parent).getTypeElement();
            OCType type = typeElement != null ? typeElement.getType().resolve(element.getContainingFile()) : null;
            OCSymbol<OCElement> oCSymbol = declaratorSymbol = type instanceof OCStructType ? ((OCStructType)type).getSymbol() : null;
        }
        if (paramIndex != -1 && declaratorSymbol != null) {
            final OCSymbol finalDeclaratorSymbol = declaratorSymbol;
            declaratorSymbol.processSameSymbols(new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    Object definition = symbol.locateDefinition();
                    if (definition != null) {
                        ReferencesSearch.search(definition).forEach((Processor)new Processor<PsiReference>(){

                            public boolean process(PsiReference reference) {
                                PsiElement usage = reference.getElement();
                                if (!(usage instanceof OCTemplateArgumentsOwner)) {
                                    OCLog.LOG.warn("Bad class: " + usage.getClass());
                                    return true;
                                }
                                OCTemplateArgumentList arguments = ((OCTemplateArgumentsOwner)usage).getTemplateArgumentList();
                                if (arguments == null) {
                                    usagesWithoutArguments.add(Pair.create((Object)usage, (Object)finalDeclaratorSymbol));
                                } else {
                                    if (paramIndex < arguments.getArguments().size()) {
                                        OCElement argument = (OCElement)arguments.getArguments().get(paramIndex);
                                        elementsToDelete.add(argument);
                                    }
                                    if (paramsCnt == 1) {
                                        elementsToDelete.add(arguments);
                                    }
                                }
                                return true;
                            }
                        });
                    }
                    return true;
                }
            });
        }
        return elementsToDelete;
    }

    private static boolean isTemplateParameter(PsiElement element) {
        return element instanceof OCTypeParameterDeclaration || element instanceof OCDeclarator && element.getParent().getParent() instanceof OCTemplateParameterList;
    }

    @Override
    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }
}

