/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuppressClangDiagnosticIntentionAction
extends SuppressIntentionAction {
    private SmartPsiElementPointer<PsiElement> myElementPtr;
    private String myCompiler;
    private String mySuppressOption;
    private String mySuppressScope;

    private OCSuppressClangDiagnosticIntentionAction(@Nullable PsiElement element, @Nullable OCSuppressionGroup suppressionGroup, String suppressScope) {
        this.myElementPtr = OCElementUtil.createPsiElementPointer(element);
        this.myCompiler = suppressionGroup == null ? null : suppressionGroup.compiler;
        this.mySuppressOption = suppressionGroup == null ? null : suppressionGroup.suppressionOption;
        this.mySuppressScope = suppressScope;
    }

    @NotNull
    public String getFamilyName() {
        String string = "Suppress for " + this.mySuppressScope;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = "Suppress \"" + this.mySuppressOption + "\" for " + this.mySuppressScope;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction", "getText"));
        }
        return string;
    }

    @Nullable
    protected TextRange getSuppressionRange(OCFile file2) {
        PsiElement element = OCElementUtil.getPsiElementByPointer(this.myElementPtr);
        return element != null ? OCElementUtil.getRangeWithMacros(element) : null;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction", "isAvailable"));
        }
        return element.isValid() && this.myElementPtr != null && this.mySuppressOption != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction", "invoke"));
        }
        OCFile file2 = (OCFile)element.getContainingFile();
        if (!file2.isValid() || !FileModificationService.getInstance().prepareFileForWrite((PsiFile)file2)) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument((PsiFile)file2);
        int elementOffset = OCElementUtil.getRangeWithMacros(element).getStartOffset();
        TextRange suppressionRange = this.getSuppressionRange(file2);
        if (document == null || suppressionRange == null) {
            return;
        }
        if (OCPragmaSuppressionUtils.getDiagnosticMode(file2, elementOffset, this.mySuppressOption) == OCPragmaSuppressionUtils.Mode.IGNORE) {
            return;
        }
        int startLine = document.getLineNumber(suppressionRange.getStartOffset());
        int endLine = document.getLineNumber(suppressionRange.getEndOffset());
        if (startLine >= 0 && startLine < document.getLineCount() && endLine >= 0 && endLine < document.getLineCount()) {
            int startOffset = document.getLineStartOffset(startLine);
            int endOffset = document.getLineEndOffset(endLine);
            boolean pushToStack = true;
            if (OCPragmaSuppressionUtils.findExactScope(file2, startOffset, endOffset) != null) {
                pushToStack = false;
            }
            if (pushToStack) {
                document.insertString(endOffset, (CharSequence)"\n#pragma clang diagnostic pop");
            }
            document.insertString(startOffset, (CharSequence)("#pragma " + this.myCompiler + " diagnostic ignored \"" + this.mySuppressOption + "\"\n"));
            if (pushToStack) {
                document.insertString(startOffset, (CharSequence)"#pragma clang diagnostic push\n");
            }
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
        }
    }

    public static class SuppressFixForFile
    extends SuppressFix {
        public SuppressFixForFile(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            ForFile forFile = new ForFile((OCFile)element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
            if (forFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFixForFile", "createFix"));
            }
            return forFile;
        }

        @NotNull
        public String getName() {
            if ("Suppress for file" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFixForFile", "getName"));
            }
            return "Suppress for file";
        }
    }

    public static class SuppressFixForCallable
    extends SuppressFix {
        public SuppressFixForCallable(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            ForCallable forCallable = new ForCallable(element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
            if (forCallable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFixForCallable", "createFix"));
            }
            return forCallable;
        }

        @NotNull
        public String getName() {
            if ("Suppress for method/function" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFixForCallable", "getName"));
            }
            return "Suppress for method/function";
        }
    }

    public static class SuppressFixForStatement
    extends SuppressFix {
        public SuppressFixForStatement(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            ForStatement forStatement = new ForStatement(element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
            if (forStatement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFixForStatement", "createFix"));
            }
            return forStatement;
        }

        @NotNull
        public String getName() {
            if ("Suppress for statement" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFixForStatement", "getName"));
            }
            return "Suppress for statement";
        }
    }

    private static abstract class SuppressFix
    implements SuppressQuickFix {
        @Nullable
        protected OCSuppressionGroup mySuppressionGroup;

        protected SuppressFix(@Nullable OCSuppressionGroup suppressionGroup) {
            this.mySuppressionGroup = suppressionGroup;
        }

        @NotNull
        protected abstract OCSuppressClangDiagnosticIntentionAction createFix(PsiElement var1);

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFix", "isAvailable"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFix", "isAvailable"));
            }
            return this.createFix(context).isAvailable(project, null, context);
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$SuppressFix", "applyFix"));
            }
            this.createFix(descriptor.getPsiElement()).invoke(project, null, descriptor.getPsiElement());
        }
    }

    public static class ForFile
    extends OCSuppressClangDiagnosticIntentionAction {
        private SmartPsiFileRange myRange;

        public ForFile(@Nullable OCFile file2, @Nullable TextRange range, @Nullable OCSuppressionGroup suppressionGroup) {
            super(file2, suppressionGroup, "file");
            if (file2 != null && range != null) {
                this.myRange = SmartPointerManager.getInstance((Project)file2.getProject()).createSmartPsiFileRangePointer((PsiFile)file2, range);
            }
        }

        @Override
        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$ForFile", "isAvailable"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$ForFile", "isAvailable"));
            }
            return super.isAvailable(project, editor, element) && this.myRange != null;
        }

        @Override
        @Nullable
        protected TextRange getSuppressionRange(OCFile file2) {
            Segment range = this.myRange.getRange();
            if (range == null || range.getEndOffset() > file2.getTextLength()) {
                return null;
            }
            int beforeOffset = range.getStartOffset();
            for (PsiElement child : file2.getChildren()) {
                OCPragmaSuppressionUtils.Scope scope;
                TextRange childRange = child.getTextRange();
                if (child instanceof OCPragma && (scope = OCPragmaSuppressionUtils.findScope(file2, child.getTextOffset())).getPush().getStartOffset() == child.getTextOffset()) {
                    return new TextRange(scope.getPush().getEndOffset(), scope.getPop().getStartOffset() - 1);
                }
                if ((OCElementUtil.isWhitespace(child) || child instanceof OCIncludeDirective) && childRange.getEndOffset() < beforeOffset && !(child instanceof OCPragma)) continue;
                return new TextRange(childRange.getStartOffset(), file2.getTextLength());
            }
            return file2.getTextRange();
        }
    }

    public static class ForCallable
    extends OCSuppressClangDiagnosticIntentionAction {
        private ForCallable(@Nullable OCCallable callable, @Nullable OCSuppressionGroup suppressionGroup) {
            super(callable, suppressionGroup, callable != null ? callable.getKind().toStringLowercase() : "");
        }

        public ForCallable(@Nullable PsiFile file2, @NotNull TextRange range, @Nullable OCSuppressionGroup suppressionGroup) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$ForCallable", "<init>"));
            }
            this((OCCallable)OCElementUtil.getParentOfType(file2, range, OCMethod.class, OCFunctionDeclaration.class), suppressionGroup);
        }
    }

    public static class ForStatement
    extends OCSuppressClangDiagnosticIntentionAction {
        private ForStatement(@Nullable OCElement statement, @Nullable OCSuppressionGroup suppressionGroup) {
            super(statement != null && !(statement instanceof OCFunctionDeclaration) ? statement : null, suppressionGroup, "statement");
        }

        public ForStatement(@Nullable PsiFile file2, @NotNull TextRange range, @Nullable OCSuppressionGroup suppressionGroup) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangDiagnosticIntentionAction$ForStatement", "<init>"));
            }
            this((OCElement)OCElementUtil.getParentOfType(file2, range, OCStatement.class, OCDeclaration.class), suppressionGroup);
        }
    }
}

