/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class OCRemoveInitializerIntentionAction
extends OCPsiElementQuickFix<OCDeclarator> {
    public OCRemoveInitializerIntentionAction(OCDeclarator declarator) {
        super(declarator);
    }

    @Override
    protected String getTextInternal() {
        return "Remove initializer";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getTextInternal();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCRemoveInitializerIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected boolean isAvailable(@NotNull OCDeclarator declarator) {
        if (declarator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarator", "com/jetbrains/cidr/lang/quickfixes/OCRemoveInitializerIntentionAction", "isAvailable"));
        }
        return declarator.getInitializer() != null;
    }

    @Override
    protected void invoke(PsiFile file2, @NotNull OCDeclarator declarator) {
        if (declarator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarator", "com/jetbrains/cidr/lang/quickfixes/OCRemoveInitializerIntentionAction", "invoke"));
        }
        OCChangeUtil.delete(declarator.getInitializer());
    }
}

