/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCPsiElementQuickFix<T extends PsiElement>
extends OCQuickFix {
    protected SmartPsiElementPointer<T> myElementPtr;

    protected OCPsiElementQuickFix(@Nullable T element) {
        this.myElementPtr = OCElementUtil.createPsiElementPointer(element);
    }

    protected boolean isAvailable(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/quickfixes/OCPsiElementQuickFix", "isAvailable"));
        }
        return true;
    }

    protected void invoke(PsiFile file2, @NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/quickfixes/OCPsiElementQuickFix", "invoke"));
        }
    }

    @Override
    protected boolean isAvailable() {
        T element = OCElementUtil.getPsiElementByPointer(this.myElementPtr);
        return element != null && OCCodeInsightUtil.isValid(element) && this.isAvailable(element);
    }

    @Override
    protected void invoke(PsiFile file2) {
        T element = OCElementUtil.getPsiElementByPointer(this.myElementPtr);
        if (element != null) {
            this.invoke(file2, element);
        }
    }
}

