/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public class OCPredeclareSymbolIntentionAction
extends OCPsiElementQuickFix<OCReferenceElement> {
    private String myName;
    private OCSymbolKind mySymbolKind;

    public OCPredeclareSymbolIntentionAction(OCReferenceElement element) {
        super(element);
        this.myName = element.getName();
        OCSymbolGroupContext context = element.getSymbolContext();
        if (context != null && context.isSuitableSymbolKind(OCSymbolKind.PROTOCOL)) {
            this.mySymbolKind = OCSymbolKind.PROTOCOL;
        } else if (context != null && context.isSuitableSymbolKind(OCSymbolKind.INTERFACE)) {
            this.mySymbolKind = OCSymbolKind.INTERFACE;
        } else if (context != null && context.isSuitableSymbolKind(OCSymbolKind.STRUCT) && !(element.getParent().getParent() instanceof OCCallExpression)) {
            this.mySymbolKind = OCSymbolKind.STRUCT;
        }
    }

    @Override
    protected String getTextInternal() {
        return "Predeclare " + (this.mySymbolKind == OCSymbolKind.PROTOCOL ? "protocol '" : "class '") + this.myName + "'";
    }

    @NotNull
    public String getFamilyName() {
        if ("Import/predeclare symbol" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCPredeclareSymbolIntentionAction", "getFamilyName"));
        }
        return "Import/predeclare symbol";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCPredeclareSymbolIntentionAction", "isAvailable"));
        }
        return file2 instanceof OCFile && !(file2 instanceof OCCodeFragment) && OCCodeInsightUtil.isValid((PsiElement)file2) && this.mySymbolKind != null;
    }

    @Override
    protected void invoke(PsiFile file2, @NotNull OCReferenceElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/quickfixes/OCPredeclareSymbolIntentionAction", "invoke"));
        }
        String text = this.mySymbolKind == OCSymbolKind.PROTOCOL ? "@protocol " + this.myName + ";" : (this.mySymbolKind == OCSymbolKind.INTERFACE ? "@class " + this.myName + ";" : "class " + this.myName + ";");
        OCChangeUtil.addBefore((PsiElement)file2, OCElementFactory.topLevelDeclarationFromText(text, (PsiElement)file2), element);
    }
}

