/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.quickfixes.OCCreateDefinitionIntentionAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import org.jetbrains.annotations.NotNull;

public class OCMoveDefinitionIntentionAction
extends OCCreateDefinitionIntentionAction {
    private OCSymbol myOldDefinitionSymbol;
    private String myIntentionNameSuffix;
    private PsiElement myOldDefinition;

    public OCMoveDefinitionIntentionAction(OCSymbolKind symbolKind, PsiElement usage, OCSymbol parent, OCSymbol oldDefinitionSymbol, String intentionNameSuffix) {
        super(symbolKind, usage, parent);
        this.myOldDefinitionSymbol = oldDefinitionSymbol;
        this.myIntentionNameSuffix = intentionNameSuffix;
    }

    public OCMoveDefinitionIntentionAction(OCSymbolKind symbolKind, PsiElement context, @NotNull OCSymbol parent, OCSymbol oldDefinitionSymbol) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/quickfixes/OCMoveDefinitionIntentionAction", "<init>"));
        }
        super(symbolKind, context, parent);
        this.myOldDefinitionSymbol = oldDefinitionSymbol;
        this.myIntentionNameSuffix = " to " + parent.getNameWithKindLowercase();
    }

    @Override
    public PsiElement getDefinition(Project project, Editor editor, PsiFile file2) {
        Object definition = this.myOldDefinitionSymbol.locateDefinition();
        if (definition == null) {
            return null;
        }
        if (definition instanceof OCDeclarator) {
            definition = OCNormalizeUtil.normalizeDeclarator((OCDeclarator)definition);
        }
        if (definition == null) {
            return null;
        }
        if (this.mySymbolKind == OCSymbolKind.PROPERTY) {
            definition = PsiTreeUtil.getContextOfType(definition, (Class[])new Class[]{OCProperty.class});
        }
        this.myOldDefinition = definition;
        return this.myOldDefinition;
    }

    @NotNull
    public String getText() {
        if (this.myOldDefinitionSymbol == null) {
            if ("Invalid" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCMoveDefinitionIntentionAction", "getText"));
            }
            return "Invalid";
        }
        String string = "Move declaration of " + this.myOldDefinitionSymbol.getNameWithKindLowercase() + this.myIntentionNameSuffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCMoveDefinitionIntentionAction", "getText"));
        }
        return string;
    }

    @Override
    protected boolean doCreate(Project project, Editor editor, PsiFile file2) {
        if (super.doCreate(project, editor, file2)) {
            OCChangeUtil.delete(this.myOldDefinition);
            return true;
        }
        return false;
    }
}

