/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclarationList;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSuperClassRef;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeInsightSettings;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImportSymbolFix
implements HintAction,
HighPriorityAction {
    private final PsiElement myElement;
    private final OCFile myCurrentFile;
    private final boolean myForceIncludeMode;
    private List<AutoImportItem> myUnprocessedItems;
    private boolean myItemsAreProcessed;

    public OCImportSymbolFix(@NotNull OCReferenceElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "<init>"));
        }
        this(reference, (OCSymbolGroupContext)null);
    }

    public OCImportSymbolFix(@NotNull OCReferenceElement reference, @Nullable OCSymbolGroupContext symbolContext) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "<init>"));
        }
        this.myUnprocessedItems = new ArrayList<AutoImportItem>();
        this.myItemsAreProcessed = false;
        this.myElement = reference;
        this.myCurrentFile = reference.getContainingOCFile();
        this.myForceIncludeMode = false;
        if (symbolContext == null) {
            symbolContext = OCSymbolGroupContext.union(reference.getSymbolContext(), OCSymbolKind.MACRO);
        }
        if (reference.resolveToSymbol(symbolContext) != null) {
            return;
        }
        THashSet addedFiles = new THashSet();
        for (OCSymbol symbol : reference.resolveToOverloadsSymbols(symbolContext, true)) {
            VirtualFile containingFile;
            OCSymbol toImport = OCImportSymbolFix.getSymbolToImport(symbol, false);
            if (toImport == null || (containingFile = toImport.getContainingFile()) == null || !addedFiles.add(containingFile)) continue;
            this.myUnprocessedItems.add(new AutoImportItem(this, toImport));
        }
    }

    public OCImportSymbolFix(@Nullable PsiElement element, @Nullable OCSymbol resolvedSymbolIgnoringImports) {
        this(element, resolvedSymbolIgnoringImports, false);
    }

    public OCImportSymbolFix(@Nullable PsiElement element, @Nullable OCSymbol resolvedSymbolIgnoringImports, boolean forceIncludeMode) {
        this(element, resolvedSymbolIgnoringImports, forceIncludeMode, true);
    }

    public OCImportSymbolFix(@Nullable PsiElement element, @Nullable OCSymbol resolvedSymbolIgnoringImports, boolean forceIncludeMode, boolean allowInternalHeaders) {
        OCSymbol toImport;
        this.myUnprocessedItems = new ArrayList<AutoImportItem>();
        this.myItemsAreProcessed = false;
        this.myElement = element;
        this.myCurrentFile = element != null ? (OCFile)element.getContainingFile() : null;
        this.myForceIncludeMode = forceIncludeMode;
        if (resolvedSymbolIgnoringImports != null && (toImport = OCImportSymbolFix.getSymbolToImport(resolvedSymbolIgnoringImports, allowInternalHeaders)) != null) {
            this.myUnprocessedItems.add(new AutoImportItem(this, toImport, this.calculateInsertBefore(toImport)));
        }
    }

    @Nullable
    private static OCSymbol getSymbolToImport(@Nullable OCSymbol symbol, boolean allowInternalHeaders) {
        OCFile file2;
        if (symbol == null) {
            return null;
        }
        if (symbol.getProject() == null) {
            return null;
        }
        if (!allowInternalHeaders && (file2 = symbol.getContainingOCFile()) != null && file2.getName().startsWith("_") && file2.isInLibraries()) {
            return null;
        }
        if (symbol.isPredeclaration() && (symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol)) {
            return null;
        }
        while (true) {
            OCSymbol parent;
            OCSymbol oCSymbol = parent = symbol instanceof OCSymbolWithParent ? (OCSymbol)((OCSymbolWithParent)symbol).getParent() : null;
            if (parent == null || parent.getKind() == OCSymbolKind.NAMESPACE) {
                symbol = symbol.getContainingFile() == null ? null : symbol;
                break;
            }
            if (symbol instanceof OCNamespaceSymbol) break;
            symbol = parent;
        }
        if (symbol != null && !symbol.isGlobal()) {
            return null;
        }
        return symbol;
    }

    @Nullable
    private PsiElement calculateInsertBefore(@NotNull OCSymbol symbolToImport) {
        if (symbolToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolToImport", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "calculateInsertBefore"));
        }
        if (this.myElement != null) {
            OCFile file2 = (OCFile)this.myElement.getContainingFile();
            OCFileGlobalSymbols symbols = OCFileGlobalSymbolsCache.getInstance(file2.getProject()).forFile(file2);
            Pair<OCSymbol, VirtualFile> pair = symbols.getUndefinedClasses().get(symbolToImport.getName());
            if (pair == null) {
                pair = symbols.getUndefinedProtocols().get(symbolToImport.getName());
            }
            if (pair != null) {
                return file2.findIncludeDirective((VirtualFile)pair.getSecond());
            }
        }
        return null;
    }

    public boolean hasAutoImportItems() {
        return !this.getAutoImportItems().isEmpty();
    }

    private boolean hasDifferentSymbolKinds() {
        OCSymbolKind prevKind = null;
        for (AutoImportItem each : this.getAutoImportItems()) {
            OCSymbolKind eachKind = each.mySymbolToImport.getKind();
            if (prevKind != null && prevKind != eachKind) {
                return true;
            }
            prevKind = eachKind;
        }
        return false;
    }

    @NotNull
    public synchronized List<AutoImportItem> getAutoImportItems() {
        Project project;
        if (this.myItemsAreProcessed) {
            List<AutoImportItem> list = this.myUnprocessedItems;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getAutoImportItems"));
            }
            return list;
        }
        Object object = this.myCurrentFile != null ? this.myCurrentFile.getProject() : (project = this.myElement != null ? this.myElement.getProject() : null);
        if (project == null) {
            List<AutoImportItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getAutoImportItems"));
            }
            return list;
        }
        ArrayList<AutoImportItem> toProcess = new ArrayList<AutoImportItem>(this.myUnprocessedItems);
        ArrayList<AutoImportItem> result2 = new ArrayList<AutoImportItem>(this.myUnprocessedItems.size());
        while (!toProcess.isEmpty()) {
            AutoImportItem each = (AutoImportItem)toProcess.remove(0);
            OCAutoImportHelper.ImportSpecification fileSpec = each.checkAndGetFileSpecToImport();
            if (fileSpec == null) continue;
            ImportStyle importStyle = this.getImportStyle(each);
            if (!this.isFromSameFile(each) ? OCFileSymbols.isSymbolImported(this.myCurrentFile, each.mySymbolToImport, this.myElement) : importStyle == ImportStyle.INCLUDE || each.mySymbolToImport.getOffset() <= this.myElement.getTextOffset() || each.mySymbolToImport instanceof OCImplementationSymbol) continue;
            String textToInsert = importStyle == ImportStyle.INCLUDE ? fileSpec.getImportText() : each.mySymbolToImport.getName();
            if (!this.isImportRequired(this.myCurrentFile, textToInsert)) continue;
            result2.add(each);
        }
        Collections.sort(result2, new Comparator<AutoImportItem>(){

            @Override
            public int compare(AutoImportItem o1, AutoImportItem o2) {
                VirtualFile f1 = o1.getFileToImport();
                VirtualFile f2 = o2.getFileToImport();
                assert (f1 != null && f2 != null);
                int result2 = Comparing.compare((Comparable)((Object)o1.getFileSpecToImport().getKind()), (Comparable)((Object)o2.getFileSpecToImport().getKind()));
                if (result2 != 0) {
                    return result2;
                }
                OCSymbolKind k1 = o1.mySymbolToImport.getKind();
                OCSymbolKind k2 = o2.mySymbolToImport.getKind();
                result2 = Comparing.compare((boolean)k1.isClass(), (boolean)k2.isClass());
                if (result2 != 0) {
                    return -result2;
                }
                result2 = Comparing.compare((boolean)k1.isStructLike(), (boolean)k2.isStructLike());
                if (result2 != 0) {
                    return -result2;
                }
                result2 = Comparing.compare((boolean)k1.isTypedefOrAlias(), (boolean)k2.isTypedefOrAlias());
                if (result2 != 0) {
                    return -result2;
                }
                result2 = Comparing.compare((k1 == OCSymbolKind.MACRO ? 1 : 0) != 0, (k2 == OCSymbolKind.MACRO ? 1 : 0) != 0);
                if (result2 != 0) {
                    return -result2;
                }
                result2 = Comparing.compare((boolean)k1.isCallable(), (boolean)k2.isCallable());
                if (result2 != 0) {
                    return -result2;
                }
                result2 = Comparing.compare((boolean)k1.isVariable(), (boolean)k2.isVariable());
                if (result2 != 0) {
                    return -result2;
                }
                result2 = k1.ordinal() - k2.ordinal();
                if (result2 != 0) {
                    return result2;
                }
                return StringUtil.compare((String)f1.getPath(), (String)f2.getPath(), (boolean)true);
            }
        });
        this.myUnprocessedItems = Collections.unmodifiableList(result2);
        this.myItemsAreProcessed = true;
        List<AutoImportItem> list = this.myUnprocessedItems;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getAutoImportItems"));
        }
        return list;
    }

    public boolean showHint(final @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "showHint"));
        }
        if (!OCCodeInsightSettings.getInstance().SHOW_IMPORT_POPUP) {
            return false;
        }
        Pair<String, Boolean> text = this.getText(true);
        String hintText = ShowAutoImportPass.getMessage((Boolean)text.second, StringUtil.escapeXml((String)((String)text.first)));
        TextRange range = OCElementUtil.getRangeWithMacros(this.myElement);
        HintManager.getInstance().showQuestionHint(editor, hintText, range.getStartOffset(), range.getEndOffset(), new QuestionAction(){

            public boolean execute() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PsiFile file2 = OCImportSymbolFix.this.myElement.getContainingFile();
                        if (OCImportSymbolFix.this.isAvailable(file2.getProject(), editor, file2)) {
                            OCImportSymbolFix.this.invoke(file2.getProject(), editor, file2);
                        }
                    }
                });
                return true;
            }
        });
        return true;
    }

    @NotNull
    public String getFamilyName() {
        if ("Import symbol" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getFamilyName"));
        }
        return "Import symbol";
    }

    @NotNull
    public String getText() {
        if (!this.hasAutoImportItems()) {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getText"));
            }
            return string;
        }
        String string = (String)this.getText((boolean)false).first;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getText"));
        }
        return string;
    }

    @NotNull
    public Pair<String, Boolean> getText(boolean forPopup) {
        List<AutoImportItem> items = this.getAutoImportItems();
        String text = this.hasDifferentSymbolKinds() ? (forPopup ? "which" : "symbol") + " '" + items.get(0).mySymbolToImport.getName() + "'" : (String)items.get((int)0).getTitleAndLocation().first;
        if (!forPopup) {
            text = "Import " + text;
        }
        if (items.size() == 1) {
            text = text + " from " + (String)items.get((int)0).getTitleAndLocation().second;
        }
        Pair pair = Pair.create((Object)text, (Object)(items.size() > 1 ? 1 : 0));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getText"));
        }
        return pair;
    }

    @NotNull
    private String getTextToInsert(@NotNull AutoImportItem item, @NotNull ImportStyle importStyle) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getTextToInsert"));
        }
        if (importStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStyle", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getTextToInsert"));
        }
        if (!this.myElement.isValid()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getTextToInsert"));
            }
            return "";
        }
        if (importStyle == ImportStyle.PREDECLARE) {
            String string = (item.mySymbolToImport instanceof OCProtocolSymbol ? "@protocol " : "@class ") + item.mySymbolToImport.getName() + ";";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getTextToInsert"));
            }
            return string;
        }
        PsiFile targetFile = this.myElement.getContainingFile();
        String directive = targetFile instanceof OCFile && ((OCFile)targetFile).getKind().isObjC() ? "#import" : "#include";
        String string = directive + " " + item.getFileSpecToImport().getImportText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getTextToInsert"));
        }
        return string;
    }

    @NotNull
    private ImportStyle getImportStyle(@NotNull AutoImportItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getImportStyle"));
        }
        if (this.myForceIncludeMode || !(item.mySymbolToImport instanceof OCClassSymbol)) {
            ImportStyle importStyle = ImportStyle.INCLUDE;
            if (importStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getImportStyle"));
            }
            return importStyle;
        }
        boolean isSuperclass = this.myElement.getParent() instanceof OCSuperClassRef;
        boolean isSuperProtocol = this.myElement.getParent() instanceof OCProtocolList;
        if (isSuperclass || isSuperProtocol) {
            ImportStyle importStyle = ImportStyle.INCLUDE;
            if (importStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getImportStyle"));
            }
            return importStyle;
        }
        if (this.isFromSameFile(item)) {
            ImportStyle importStyle = ImportStyle.PREDECLARE;
            if (importStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getImportStyle"));
            }
            return importStyle;
        }
        boolean isInclude = OCCodeInsightSettings.getInstance().HEADER_IMPORT_STYLE == OCCodeStyleSettings.HeaderImportStyle.IMPORT || !((OCFile)this.myElement.getContainingFile()).isHeader();
        ImportStyle importStyle = isInclude ? ImportStyle.INCLUDE : ImportStyle.PREDECLARE;
        if (importStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getImportStyle"));
        }
        return importStyle;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "isAvailable"));
        }
        if (!(file2 instanceof OCFile) || file2 instanceof OCCodeFragment) {
            return false;
        }
        if (!this.myElement.isValid() || !OCSearchScope.isInProjectSources(this.myElement)) {
            return false;
        }
        return this.hasAutoImportItems();
    }

    private boolean isImportRequired(PsiFile file2, String textToInsert) {
        for (PsiElement element : file2.getChildren()) {
            if (element instanceof OCIncludeDirective && element.getText().contains(textToInsert)) {
                return false;
            }
            if (element instanceof OCClassPredeclarationList) {
                for (OCClassPredeclaration predefinition : ((OCClassPredeclarationList)element).getPredeclarations()) {
                    if (!textToInsert.equals(predefinition.getName())) continue;
                    return false;
                }
            }
            if (element.getTextOffset() >= this.myElement.getTextOffset()) break;
        }
        return true;
    }

    private boolean isFromSameFile(@NotNull AutoImportItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "isFromSameFile"));
        }
        return this.myElement.isValid() && Comparing.equal((Object)item.mySymbolToImport.getContainingFile(), (Object)this.myElement.getContainingFile().getVirtualFile());
    }

    @NotNull
    private OCResolveRootAndConfiguration getRootAndConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getRootAndConfiguration"));
        }
        OCResolveRootAndConfiguration oCResolveRootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(this.myCurrentFile.getVirtualFile(), project);
        if (oCResolveRootAndConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "getRootAndConfiguration"));
        }
        return oCResolveRootAndConfiguration;
    }

    private static boolean accumulateImportCandidates(OCFile file2, Set<VirtualFile> acc) {
        VirtualFile mainCandidate = file2.getVirtualFile();
        if (mainCandidate == null || !acc.add(mainCandidate)) {
            return false;
        }
        int length = mainCandidate.getPath().length();
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(file2.getProject());
        FileSymbolTablesCache.getInstance(file2.getProject()).ensurePendingFilesProcessed();
        Iterator<OCFile> iterator = file2.getIncludingFiles().iterator();
        if (iterator.hasNext()) {
            OCFile ocfile = iterator.next();
            VirtualFile vfile = file2.getVirtualFile();
            if (vfile != null && ocfile != null && ocfile.isHeader() && vfile.getPath().length() < length) {
                final Ref proxyFile = new Ref((Object)true);
                for (FileSymbolTable table : cache.allTablesForFile(ocfile)) {
                    table.shallowProcessSymbols(new Processor<OCSymbol>(){

                        public boolean process(OCSymbol symbol) {
                            OCSymbolKind kind = symbol.getKind();
                            if (kind != OCSymbolKind.MACRO && kind != OCSymbolKind.UNDEF_MACRO && kind != OCSymbolKind.SYMBOL_USING_SYMBOL && kind != OCSymbolKind.NAMESPACE_USING_SYMBOL && kind != OCSymbolKind.NAMESPACE_ALIAS && kind != OCSymbolKind.IMPORT) {
                                proxyFile.set((Object)false);
                                return false;
                            }
                            return true;
                        }
                    });
                    if (((Boolean)proxyFile.get()).booleanValue()) continue;
                    break;
                }
                if (((Boolean)proxyFile.get()).booleanValue()) {
                    OCImportSymbolFix.accumulateImportCandidates(ocfile, acc);
                }
            }
            return true;
        }
        return true;
    }

    public void invoke(final @NotNull Project project, @NotNull Editor editor, final PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "invoke"));
        }
        if (this.getAutoImportItems().size() == 1) {
            this.getAutoImportItems().get(0).invoke(project, file2);
            return;
        }
        BaseListPopupStep<AutoImportItem> step = new BaseListPopupStep<AutoImportItem>("Symbol to Import", this.getAutoImportItems()){

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(AutoImportItem selectedValue, boolean finalChoice) {
                if (selectedValue == null) {
                    return FINAL_CHOICE;
                }
                if (finalChoice) {
                    selectedValue.invoke(project, file2);
                    return FINAL_CHOICE;
                }
                return FINAL_CHOICE;
            }

            public boolean hasSubstep(AutoImportItem item) {
                return false;
            }

            @NotNull
            public String getTextFor(AutoImportItem item) {
                Pair<String, String> titleAndLocation = item.getTitleAndLocation();
                String string = (String)titleAndLocation.first + " @ " + (String)titleAndLocation.second;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix$4", "getTextFor"));
                }
                return string;
            }

            public Icon getIconFor(AutoImportItem item) {
                return item.mySymbolToImport.getIcon();
            }
        };
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)step){

            @Override
            protected ListCellRenderer getListElementRenderer() {
                return new MyRenderer(this.mySpeedSearch);
            }
        };
        popup.showInBestPositionFor(editor);
    }

    public static PsiElement addImportToFile(OCFile file2, String insertText, @NotNull ImportStyle importStyle, int beforeOffset) {
        if (importStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStyle", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "addImportToFile"));
        }
        PsiElement firstImport = null;
        PsiElement lastImport = null;
        PsiElement lastLibraryImport = null;
        PsiElement lastProjectImport = null;
        PsiElement lastClassPredef = null;
        PsiElement newElement = OCElementFactory.topLevelDeclarationFromText(insertText, file2);
        OCDirective guardIfndef = OCElementUtil.getGuardIfndef(file2, false);
        PsiElement firstScanNode = guardIfndef != null ? OCElementUtil.getNextNonWhitespaceSibling(guardIfndef).getNextSibling() : file2.getFirstChild();
        boolean skipInessentialNodes = true;
        PsiElement lastInessential = null;
        for (PsiElement kid = firstScanNode; kid != null && (beforeOffset == -1 || kid.getTextOffset() < beforeOffset); kid = kid.getNextSibling()) {
            if (skipInessentialNodes) {
                if (OCElementUtil.isEssentialNode(kid)) {
                    skipInessentialNodes = false;
                } else {
                    lastInessential = kid;
                }
            }
            if (kid instanceof OCIncludeDirective) {
                if (kid.getText().contains(insertText)) {
                    return kid;
                }
                lastImport = kid;
                if (firstImport == null) {
                    firstImport = kid;
                }
                if (((OCIncludeDirective)kid).isAngleBrackets()) {
                    lastLibraryImport = kid;
                } else {
                    lastProjectImport = kid;
                }
            }
            if (!(kid instanceof OCClassPredeclarationList)) continue;
            lastClassPredef = kid;
        }
        PsiElement insertAnchor = lastImport;
        boolean insertBefore = false;
        if (importStyle == ImportStyle.INCLUDE) {
            if (((OCIncludeDirective)newElement).isAngleBrackets()) {
                if (lastLibraryImport != null) {
                    insertAnchor = lastLibraryImport;
                } else {
                    insertAnchor = firstImport;
                    insertBefore = true;
                }
            } else if (lastProjectImport != null) {
                insertAnchor = lastProjectImport;
            }
        } else {
            insertAnchor = lastClassPredef;
            if (insertAnchor == null) {
                insertAnchor = lastImport;
            }
        }
        if (insertAnchor == null) {
            insertAnchor = lastInessential;
            insertBefore = false;
        }
        if (insertAnchor == null) {
            insertAnchor = file2.getFirstChild();
            insertBefore = true;
        }
        return OCChangeUtil.addHandlingMacros(file2, newElement, insertAnchor, insertBefore);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void fixAtCaret(Editor editor, PsiFile file2, OCSymbol symbol) {
        int offset = OCImportSymbolFix.calculateOffset(editor);
        if (offset >= 0) {
            OCImportSymbolFix.fixSymbolAtOffset(editor, file2, offset, symbol);
        }
    }

    public static void fixAtCaret(Editor editor, PsiFile file2, OCSymbolGroupContext symbolContext) {
        OCReferenceElement ref;
        int offset = OCImportSymbolFix.calculateOffset(editor);
        if (offset >= 0 && (ref = (OCReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, OCReferenceElement.class, (boolean)false)) != null) {
            new OCImportSymbolFix(ref, symbolContext).fixFirstItem(file2.getProject(), file2);
        }
    }

    private static int calculateOffset(Editor editor) {
        CharSequence text = editor.getDocument().getCharsSequence();
        int offset = editor.getCaretModel().getOffset();
        if (offset >= text.length()) {
            return -1;
        }
        while (offset > 0 && Character.isJavaIdentifierPart(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return -1;
        }
        while (offset > 0 && Character.isWhitespace(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return -1;
        }
        --offset;
        while (offset > 0 && Character.isWhitespace(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return -1;
        }
        return offset;
    }

    public static void fixSymbolAtOffset(Editor editor, PsiFile file2, int offset, OCSymbol symbol) {
        OCElement ref = (OCElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, OCElement.class, (boolean)false);
        new OCImportSymbolFix(ref, symbol).fixFirstItem(file2.getProject(), file2);
    }

    public static void fixAllSymbolsRecursively(PsiElement element) {
        OCImportSymbolFix.fixAllSymbolsRecursively(element, null);
    }

    public static void fixAllSymbolsRecursively(PsiElement element, @Nullable TextRange range) {
        final PsiFile containingFile = element.getContainingFile();
        final Project project = containingFile.getProject();
        element.accept((PsiElementVisitor)new OCRecursiveVisitor(range){

            @Override
            public void visitReferenceElement(OCReferenceElement referenceElement) {
                new OCImportSymbolFix(referenceElement).fixFirstItem(project, containingFile);
            }
        });
    }

    public boolean fixFirstItem(@NotNull Project project, @NotNull PsiFile file2) {
        AutoImportItem item;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "fixFirstItem"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix", "fixFirstItem"));
        }
        if (this.isAvailable(project, null, file2) && (item = (AutoImportItem)ContainerUtil.getFirstItem(this.getAutoImportItems())) != null) {
            item.invoke(project, file2);
            return true;
        }
        return false;
    }

    private static class MyRenderer
    extends JPanel
    implements ListCellRenderer {
        final ColoredListCellRenderer<AutoImportItem> myLeft;
        final ColoredListCellRenderer<AutoImportItem> myRight;

        public MyRenderer(final SpeedSearch speedSearch) {
            super(new BorderLayout());
            this.myLeft = new ColoredListCellRenderer<AutoImportItem>(){

                protected void customizeCellRenderer(JList list, AutoImportItem value, int index, boolean selected, boolean hasFocus) {
                    MyRenderer.this.myLeft.clear();
                    Pair<String, String> titleAndLocation = value.getTitleAndLocation();
                    MyRenderer.this.myLeft.setIcon(value.mySymbolToImport.getIcon());
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)((String)titleAndLocation.first), (SimpleColoredComponent)this, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Matcher)speedSearch.getMatcher(), (Color)MyRenderer.this.getBackground(), (boolean)selected);
                }
            };
            this.myRight = new ColoredListCellRenderer<AutoImportItem>(){

                protected void customizeCellRenderer(JList list, AutoImportItem value, int index, boolean selected, boolean hasFocus) {
                    Pair<String, String> titleAndLocation = value.getTitleAndLocation();
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)((String)titleAndLocation.second), (SimpleColoredComponent)this, (SimpleTextAttributes)SimpleTextAttributes.GRAY_ATTRIBUTES, (Matcher)speedSearch.getMatcher(), (Color)MyRenderer.this.getBackground(), (boolean)selected);
                }
            };
            this.add((Component)this.myLeft, "Center");
            this.add((Component)this.myRight, "East");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color fileColor;
            FileColorManager colorManager;
            AutoImportItem item;
            PsiFile file2;
            Color bgColor;
            Color color = bgColor = isSelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
            if (!isSelected && value instanceof AutoImportItem && (file2 = (item = (AutoImportItem)value).mySymbolToImport.getContainingPsiFile()) != null && (colorManager = FileColorManager.getInstance((Project)file2.getProject())).isEnabled() && (fileColor = colorManager.getRendererBackground(file2)) != null) {
                bgColor = fileColor;
            }
            this.setBackground(bgColor);
            this.myLeft.getListCellRendererComponent(list, value, index, isSelected, false);
            this.myRight.getListCellRendererComponent(list, value, index, isSelected, false);
            return this;
        }
    }

    public class AutoImportItem {
        @NotNull
        private final OCSymbol mySymbolToImport;
        @Nullable
        private final PsiElement myInsertBefore;
        @Nullable
        private VirtualFile myCachedFileToImport;
        @Nullable
        private OCAutoImportHelper.ImportSpecification myCachedFileNameToImport;
        @Nullable
        private Pair<String, String> myCachedTitleAndLocation;
        final /* synthetic */ OCImportSymbolFix this$0;

        public AutoImportItem(@NotNull OCImportSymbolFix this$0, OCSymbol symbolToImport) {
            if (symbolToImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolToImport", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix$AutoImportItem", "<init>"));
            }
            this(this$0, symbolToImport, null);
        }

        public AutoImportItem(@NotNull OCImportSymbolFix this$0, @Nullable OCSymbol symbolToImport, PsiElement insertBefore) {
            if (symbolToImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolToImport", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix$AutoImportItem", "<init>"));
            }
            this.this$0 = this$0;
            this.mySymbolToImport = symbolToImport;
            this.myInsertBefore = insertBefore;
        }

        public String toString() {
            Pair<String, String> titleAndLocation = this.getTitleAndLocation();
            return (String)titleAndLocation.first + "@" + (String)titleAndLocation.second;
        }

        @NotNull
        public Pair<String, String> getTitleAndLocation() {
            OCQualifiedName resolvedName;
            if (this.myCachedTitleAndLocation != null) {
                Pair<String, String> pair = this.myCachedTitleAndLocation;
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix$AutoImportItem", "getTitleAndLocation"));
                }
                return pair;
            }
            String kind = this.mySymbolToImport.getKindLowercase();
            if (this.mySymbolToImport instanceof OCClassSymbol) {
                kind = "@" + kind;
            }
            String name = this.mySymbolToImport.getName();
            if (this.mySymbolToImport instanceof OCSymbolWithQualifiedName && (resolvedName = ((OCSymbolWithQualifiedName)this.mySymbolToImport).getResolvedQualifiedName(true, false)) != null) {
                name = resolvedName.getCanonicalName(true, false);
            }
            if ((this.myCachedTitleAndLocation = Pair.create((Object)(kind + " '" + name + "'"), (Object)this.getFileSpecToImport().getImportText())) == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix$AutoImportItem", "getTitleAndLocation"));
            }
            return this.myCachedTitleAndLocation;
        }

        @NotNull
        private OCAutoImportHelper.ImportSpecification getFileSpecToImport() {
            OCAutoImportHelper.ImportSpecification result2 = this.checkAndGetFileSpecToImport();
            assert (result2 != null);
            OCAutoImportHelper.ImportSpecification importSpecification = result2;
            if (importSpecification == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix$AutoImportItem", "getFileSpecToImport"));
            }
            return importSpecification;
        }

        @Nullable
        private OCAutoImportHelper.ImportSpecification checkAndGetFileSpecToImport() {
            if (this.myCachedFileNameToImport != null) {
                return this.myCachedFileNameToImport;
            }
            VirtualFile fileToImport = this.getFileToImport();
            Project project = this.mySymbolToImport.getProject();
            assert (project != null);
            this.myCachedFileNameToImport = this.getFileNameToImport(fileToImport, project, this.this$0.getRootAndConfiguration(project));
            return this.myCachedFileNameToImport;
        }

        @Nullable
        public VirtualFile getFileToImport() {
            if (this.myCachedFileToImport != null) {
                return this.myCachedFileToImport;
            }
            OCFile file2 = this.mySymbolToImport.getContainingOCFile();
            if (file2 == null) {
                return null;
            }
            this.myCachedFileToImport = this.getFileToImport(file2, this.mySymbolToImport.getName());
            return this.myCachedFileToImport;
        }

        @Nullable
        private VirtualFile getFileToImport(OCFile file2, final String idealName) {
            THashSet acc = new THashSet();
            OCImportSymbolFix.accumulateImportCandidates(file2, (Set)acc);
            List filtered = ContainerUtil.filter((Collection)acc, (Condition)new Condition<VirtualFile>(){

                public boolean value(VirtualFile virtualFile) {
                    return virtualFile.getName().equals(idealName);
                }
            });
            if (filtered.isEmpty()) {
                filtered = acc;
            }
            Project project = file2.getProject();
            VirtualFile shortestNameFile = null;
            int shortestName = Integer.MAX_VALUE;
            OCResolveRootAndConfiguration rootAndConfiguration = this.this$0.getRootAndConfiguration(file2.getProject());
            for (VirtualFile candidate : filtered) {
                int length;
                OCAutoImportHelper.ImportSpecification importSpecification = this.getFileNameToImport(candidate, project, rootAndConfiguration);
                if (importSpecification == null || (length = importSpecification.getImportPath().length()) >= shortestName) continue;
                shortestNameFile = candidate;
                shortestName = length;
            }
            return shortestNameFile;
        }

        @Nullable
        private OCAutoImportHelper.ImportSpecification getFileNameToImport(@Nullable VirtualFile fileToImport, @NotNull Project project, @NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix$AutoImportItem", "getFileNameToImport"));
            }
            if (rootAndConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootAndConfiguration", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix$AutoImportItem", "getFileNameToImport"));
            }
            if (fileToImport == null) {
                return null;
            }
            final Ref result2 = Ref.create(null);
            VirtualFile targetFile = this.this$0.myCurrentFile == null ? null : this.this$0.myCurrentFile.getVirtualFile();
            OCIncludeHelpers.processImportSpecifications(project, rootAndConfiguration, targetFile, fileToImport, new Processor<OCAutoImportHelper.ImportSpecification>(){

                public boolean process(OCAutoImportHelper.ImportSpecification specification) {
                    result2.set((Object)specification);
                    return false;
                }
            });
            return (OCAutoImportHelper.ImportSpecification)result2.get();
        }

        public void invoke(@NotNull Project project, final @NotNull PsiFile file2) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix$AutoImportItem", "invoke"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix$AutoImportItem", "invoke"));
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            VirtualFile fileToImport = this.getFileToImport();
            assert (fileToImport != null);
            VirtualFile targetFile = file2.getVirtualFile();
            for (OCAutoImportHelper each : (OCAutoImportHelper[])Extensions.getExtensions(OCAutoImportHelper.EP_NAME)) {
                each.addHeaderSearchPath(project, targetFile, fileToImport);
            }
            final ImportStyle importStyle = this.this$0.getImportStyle(this);
            final OCFile associatedFile = importStyle == ImportStyle.PREDECLARE ? ((OCFile)file2).getAssociatedFile() : null;
            new WriteCommandAction(project, "Import " + (String)this.getTitleAndLocation().first, new PsiFile[]{file2, associatedFile}){

                public void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/quickfixes/OCImportSymbolFix$AutoImportItem$3", "run"));
                    }
                    int beforeOffset = AutoImportItem.this.this$0.myElement.getTextOffset();
                    if (AutoImportItem.this.myInsertBefore != null) {
                        beforeOffset = Math.min(beforeOffset, AutoImportItem.this.myInsertBefore.getTextOffset());
                    }
                    OCImportSymbolFix.addImportToFile((OCFile)file2, AutoImportItem.this.this$0.getTextToInsert(AutoImportItem.this, importStyle), importStyle, beforeOffset);
                    if (associatedFile != null) {
                        OCImportSymbolFix.addImportToFile(associatedFile, AutoImportItem.this.this$0.getTextToInsert(AutoImportItem.this, ImportStyle.INCLUDE), ImportStyle.INCLUDE, beforeOffset);
                    }
                }
            }.execute();
        }
    }

    public static enum ImportStyle {
        INCLUDE,
        PREDECLARE;

    }
}

