/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateConstructorContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateConstructorHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateConstructorFix
extends OCGenerateConstructorHandler
implements IntentionAction {
    private final OCStructSymbol myClass;
    private boolean myAddParametersForBaseClasses;

    public OCGenerateConstructorFix(OCStructSymbol symbol, boolean addParametersForBaseClasses) {
        this.myClass = symbol;
        this.myAddParametersForBaseClasses = addParametersForBaseClasses;
    }

    @NotNull
    public String getText() {
        if (this.myAddParametersForBaseClasses) {
            if ("Create constructor matching base class(es)" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCGenerateConstructorFix", "getText"));
            }
            return "Create constructor matching base class(es)";
        }
        String string = "Create default constructor in " + this.myClass.getNameWithKindLowercase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCGenerateConstructorFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCGenerateConstructorFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCGenerateConstructorFix", "isAvailable"));
        }
        return OCSearchScope.isInProjectSources(this.myClass);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCGenerateConstructorFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/quickfixes/OCGenerateConstructorFix", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile context = editor != null ? file2.findElementAt(editor.getCaretModel().getOffset()) : file2;
        OCGenerateConstructorContext actionContext = this.myAddParametersForBaseClasses ? this.evaluateActionContext(this.myClass, (PsiElement)context) : new OCGenerateConstructorContext(this.myClass, (PsiElement)context, Collections.<Collection<OCFunctionSymbol>>emptyList());
        this.invoke(project, editor, file2, actionContext);
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCDeclaratorSymbol> candidates) {
        return false;
    }

    @Override
    @Nullable
    protected Condition<OCDeclaratorSymbol> getCandidatesFilter(OCGenerateConstructorContext actionContext) {
        return Conditions.alwaysFalse();
    }
}

