/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.intentions.OCCreateMissingSwitchCasesIntentionAction;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCCreateMissingSwitchCasesFix
extends OCCreateMissingSwitchCasesIntentionAction {
    private boolean myDefaultIsMissing;
    protected SmartPsiElementPointer<OCSwitchStatement> mySwitchStatementPtr;

    public OCCreateMissingSwitchCasesFix(OCSwitchStatement switchStatement, boolean defaultIsMissing) {
        this.myDefaultIsMissing = defaultIsMissing;
        this.mySwitchStatementPtr = OCElementUtil.createPsiElementPointer(switchStatement);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCCreateMissingSwitchCasesFix", "isAvailable"));
        }
        return OCCodeInsightUtil.isValid(OCElementUtil.getPsiElementByPointer(this.mySwitchStatementPtr));
    }

    @Override
    protected OCSwitchStatement getSwitchStatement(Editor editor, PsiFile file2) {
        return OCElementUtil.getPsiElementByPointer(this.mySwitchStatementPtr);
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myDefaultIsMissing ? "Create missing default case" : super.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCCreateMissingSwitchCasesFix", "getText"));
        }
        return string;
    }

    @Override
    protected void invoke(OCBlockStatement switchBlock, List<OCDeclaratorSymbol> missingCases) {
        if (this.myDefaultIsMissing) {
            OCChangeUtil.add(switchBlock, OCElementFactory.statementFromText("default:break;", switchBlock));
        } else {
            super.invoke(switchBlock, missingCases);
        }
    }

    @Override
    protected boolean proceedIfDefaultOrUnresolved(boolean defaultOrUnresolved) {
        return !defaultOrUnresolved;
    }
}

