/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import icons.CidrLangIcons;
import org.jetbrains.annotations.NotNull;

public class OCCreateInterfaceIntentionAction
extends OCNewFileActionBase
implements IntentionAction {
    private OCImplementationSymbol myImplementation;
    private PsiElement myImplNameIdentifier;

    public OCCreateInterfaceIntentionAction(OCImplementationSymbol anImplementation, PsiElement implNameIdentifier) {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.interface.title", new Object[0]), OCBundle.message("create.interface.description", new Object[0]), CidrLangIcons.CodeAssistantClass);
        this.myImplementation = anImplementation;
        this.myImplNameIdentifier = implNameIdentifier;
    }

    @NotNull
    public String getText() {
        if (this.myImplementation == null) {
            if ("Invalid" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCCreateInterfaceIntentionAction", "getText"));
            }
            return "Invalid";
        }
        String string = "Create interface for " + this.myImplementation.getNameWithKindLowercase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCCreateInterfaceIntentionAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCCreateInterfaceIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getDefaultName() {
        if ("Interface" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCCreateInterfaceIntentionAction", "getDefaultName"));
        }
        return "Interface";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCCreateInterfaceIntentionAction", "isAvailable"));
        }
        return super.isAvailable() && OCSearchScope.isInProjectSources(this.myImplementation);
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCCreateInterfaceIntentionAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        this.addAuxAction(new Runnable(){

            @Override
            public void run() {
                OCInterfaceSymbol interfaceSymbol = OCCreateInterfaceIntentionAction.this.myImplementation.getInterface(true, OCCreateInterfaceIntentionAction.this.myImplementation.getCategoryName());
                new OCImportSymbolFix(OCCreateInterfaceIntentionAction.this.myImplNameIdentifier, interfaceSymbol).fixFirstItem(project, file2);
                OCImportSymbolFix.fixAllSymbolsRecursively(OCCreateInterfaceIntentionAction.this.myImplNameIdentifier);
            }
        });
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.performAction(project, file2.getParent(), file2, this.myImplementation.getName());
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected String getFileTemplate(String fileName) {
        return "Objective-C Header File.h";
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        OCNewFileActionBase.NewFileNames newFileNames = new OCNewFileActionBase.NewFileNames(null, selectedName + ".h");
        if (newFileNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCCreateInterfaceIntentionAction", "getNewFileNames"));
        }
        return newFileNames;
    }

    protected CreateInterfaceDialog createDialog(String defaultName) {
        return new CreateInterfaceDialog(defaultName);
    }

    protected class CreateInterfaceDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        public CreateInterfaceDialog(String defaultName) {
            super(OCCreateInterfaceIntentionAction.this.getText(), defaultName, null);
        }
    }
}

