/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCreateDefinitionIntentionAction
implements IntentionAction {
    protected OCSymbolKind mySymbolKind;
    protected PsiElement myUsage;
    protected OCSymbol myParent;

    public OCCreateDefinitionIntentionAction(OCSymbolKind symbolKind, PsiElement usage, OCSymbol parent) {
        this.mySymbolKind = symbolKind;
        this.myUsage = usage;
        this.myParent = parent;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCCreateDefinitionIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCCreateDefinitionIntentionAction", "isAvailable"));
        }
        if (!OCCodeInsightUtil.isValid(this.myUsage) || this.myParent != null && !OCSearchScope.isInProjectSources(this.myParent)) {
            return false;
        }
        switch (this.mySymbolKind) {
            case FUNCTION_DECLARATION: 
            case METHOD: 
            case GLOBAL_VARIABLE: 
            case LOCAL_VARIABLE: 
            case PROPERTY: 
            case MACRO: {
                return true;
            }
            case STRUCT_FIELD: {
                return this.myParent != null;
            }
            case ENUM_CONST: {
                return this.myParent != null && this.myParent.getKind() == OCSymbolKind.ENUM;
            }
            case INSTANCE_VARIABLE: {
                OCMethod method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myUsage, OCMethod.class);
                return method == null || this.myUsage instanceof OCQualifiedExpression || method.isInstanceMethod();
            }
        }
        return false;
    }

    @Nullable
    protected abstract PsiElement getDefinition(Project var1, Editor var2, PsiFile var3);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCCreateDefinitionIntentionAction", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ArrayList<PsiFile> filesToWrite = new ArrayList<PsiFile>();
        filesToWrite.add(file2);
        if (this.mySymbolKind == OCSymbolKind.STRUCT_FIELD || this.mySymbolKind == OCSymbolKind.ENUM_CONST) {
            filesToWrite.add(this.myParent.getContainingOCFile());
        }
        if (FileModificationService.getInstance().preparePsiElementsForWrite(filesToWrite)) {
            this.doCreate(project, editor, file2);
        }
    }

    protected boolean doCreate(Project project, Editor editor, PsiFile file2) {
        PsiElement result2;
        PsiElement parentElement = this.myParent != null ? (PsiElement)this.myParent.locateDefinition() : null;
        PsiElement definition = this.getDefinition(project, editor, file2);
        if (definition == null) {
            return false;
        }
        if (this.mySymbolKind == OCSymbolKind.FUNCTION_DECLARATION || this.mySymbolKind == OCSymbolKind.METHOD || this.mySymbolKind == OCSymbolKind.GLOBAL_VARIABLE || this.mySymbolKind == OCSymbolKind.LOCAL_VARIABLE || this.mySymbolKind == OCSymbolKind.MACRO || this.mySymbolKind == OCSymbolKind.ENUM_CONST && this.myParent != null) {
            Object parent = this.myParent != null ? this.myParent.locateDefinition() : OCChangeUtil.getAppropriateParent(this.mySymbolKind, this.myUsage);
            if (parent == null) {
                return false;
            }
            result2 = OCChangeUtil.addBefore(parent, definition, this.myUsage);
        } else if (this.mySymbolKind == OCSymbolKind.STRUCT_FIELD || this.mySymbolKind == OCSymbolKind.PROPERTY) {
            if (this.myParent == null || parentElement == null) {
                return false;
            }
            result2 = OCChangeUtil.add(parentElement, definition);
        } else if (this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            if (this.myParent == null || parentElement == null) {
                return false;
            }
            result2 = OCChangeUtil.add(((OCClassDeclaration)parentElement).getInstanceVariablesList(), definition);
        } else {
            return false;
        }
        if (result2 != null && this.mySymbolKind != OCSymbolKind.FUNCTION_DECLARATION && this.mySymbolKind != OCSymbolKind.METHOD) {
            if (editor != null && this.mySymbolKind == OCSymbolKind.GLOBAL_VARIABLE && definition instanceof OCDeclaration) {
                editor.getCaretModel().moveToOffset(((OCDeclaration)result2).getDeclarators().get(0).getTextRange().getEndOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            } else {
                OCCodeInsightUtil.selectElement(result2);
            }
        }
        return true;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

