/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCopyElementIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    private String myIntentionName;
    private SmartPsiElementPointer mySourceElementPtr;
    private String myFamilyName;

    public OCCopyElementIntentionAction(PsiElement sourceElement, PsiElement destinationElement, String intentionName) {
        this(sourceElement, destinationElement, intentionName, intentionName);
    }

    public OCCopyElementIntentionAction(PsiElement sourceElement, PsiElement destinationElement, String intentionName, String familyName) {
        super(destinationElement);
        this.mySourceElementPtr = OCElementUtil.createPsiElementPointer(sourceElement);
        this.myIntentionName = intentionName;
        this.myFamilyName = familyName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCCopyElementIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected boolean isAvailable(@NotNull PsiElement destinationElement) {
        if (destinationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destinationElement", "com/jetbrains/cidr/lang/quickfixes/OCCopyElementIntentionAction", "isAvailable"));
        }
        return OCElementUtil.getPsiElementByPointer(this.mySourceElementPtr) != null;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCCopyElementIntentionAction", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement destinationElement = this.myElementPtr.getElement();
        Object sourceElement = OCElementUtil.getPsiElementByPointer(this.mySourceElementPtr);
        if (FileModificationService.getInstance().prepareFileForWrite(destinationElement.getContainingFile())) {
            destinationElement.replace(sourceElement);
        }
    }
}

