/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class OCChangeTextIntentionAction
extends OCPsiElementQuickFix<PsiFile> {
    private int myOffset;
    private int myLength;
    private String mySubstitution;
    private String myIntentionName;
    private String myFamilyName;

    public OCChangeTextIntentionAction(PsiFile file2, int offset, int length, String substitution, String intentionName) {
        this(file2, offset, length, substitution, intentionName, intentionName);
    }

    public OCChangeTextIntentionAction(PsiFile file2, int offset, int length, String substitution, String intentionName, String familyName) {
        super(file2);
        this.myOffset = offset;
        this.myLength = length;
        this.mySubstitution = substitution;
        this.myIntentionName = intentionName;
        this.myFamilyName = familyName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCChangeTextIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected boolean isAvailable(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/quickfixes/OCChangeTextIntentionAction", "isAvailable"));
        }
        return this.mySubstitution != null;
    }

    @Override
    protected void invoke(PsiFile curFile, @NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/quickfixes/OCChangeTextIntentionAction", "invoke"));
        }
        OCChangeUtil.changeText(file2.getProject(), file2, this.myOffset, this.myLength, this.mySubstitution, false);
    }
}

