/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeBuilder;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCTypeElementImpl
extends OCElementBase
implements OCTypeElement {
    public OCTypeElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCTypeElementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCTypeElementImpl", "accept"));
        }
        visitor.visitTypeElement(this);
    }

    @Override
    @NotNull
    public OCType getType() {
        OCType oCType = this.getRawType();
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCTypeElementImpl", "getType"));
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCType getRawType() {
        OCFile file2 = this.getContainingOCFile();
        ASTNode node = this.getNode();
        ASTNode childNode = node.getFirstChildNode();
        IElementType tt = OCElementUtil.getElementType(childNode);
        if (tt == OCTokenTypes.TYPEOF_KEYWORD || tt == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
            PsiElement[] children2 = this.getChildren();
            if (children2.length == 1 && children2[0] instanceof OCExpression) {
                OCType oCType = ((OCExpression)children2[0]).getType();
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCTypeElementImpl", "getRawType"));
                }
                return oCType;
            }
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCTypeElementImpl", "getRawType"));
            }
            return oCUnknownType;
        }
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        OCLanguageKind kind = file2.getKind();
        OCBuilderDriver<ASTNode> driver = new OCBuilderDriver<ASTNode>(file2, OCInclusionContext.empty(kind, file2), new ASTStructure(node), OCBuilderDriver.AST_NAMED_NODE_STRUCTURE, (Processor<OCSymbol>)collector);
        BuilderDriverBase.DeclarationContext context = new BuilderDriverBase.DeclarationContext(null, null, null, null, this);
        OCTypeBuilder typeBuilder = new OCTypeBuilder(kind, file2.getProject(), context);
        OCSymbolWithQualifiedName parent = OCSymbolReferenceResolver.getGlobalContextFromLocal(this);
        context = new BuilderDriverBase.DeclarationContext(null, null, parent, null, this);
        typeBuilder.setLocalContext(context);
        OCType oCType = driver.processTypeElement(node, typeBuilder, (Processor<OCSymbol>)collector, context);
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCTypeElementImpl", "getRawType"));
        }
        return oCType;
    }

    @Override
    public int getArrayLengths() {
        return this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LBRACKET})).length;
    }
}

