/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeGuesser;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSendMessageExpressionImpl
extends OCExpressionBase
implements OCSendMessageExpression {
    private final SelectorReference myReference;

    public OCSendMessageExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl", "<init>"));
        }
        super(node);
        this.myReference = new SelectorReference();
    }

    @Override
    public OCExpression getReceiverExpression() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @NotNull
    public List<OCMessageArgument> getArguments() {
        List<OCMessageArgument> list = this.findChildrenByType(OCElementTypes.MESSAGE_ARGUMENT);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl", "getArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<OCArgumentSelector> getArgumentSelectors() {
        ArrayList<OCArgumentSelector> result2 = new ArrayList<OCArgumentSelector>();
        for (OCMessageArgument argument : this.getArguments()) {
            result2.add(argument.getArgumentSelector());
        }
        ArrayList<OCArgumentSelector> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl", "getArgumentSelectors"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<OCExpression> getArgumentExpressions() {
        ArrayList<OCExpression> expressions = new ArrayList<OCExpression>();
        for (OCMessageArgument argument : this.getArguments()) {
            OCExpression expression = argument.getArgumentExpression();
            if (expression == null) continue;
            expressions.add(expression);
        }
        ArrayList<OCExpression> arrayList = expressions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl", "getArgumentExpressions"));
        }
        return arrayList;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl", "accept"));
        }
        visitor.visitSendMessageExpression(this);
    }

    @Override
    @NotNull
    public String getMessageSelector() {
        StringBuilder builder = new StringBuilder();
        for (OCMessageArgument argument : this.getArguments()) {
            builder.append(argument.getArgumentSelector().getSelectorName());
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl", "getMessageSelector"));
        }
        return string;
    }

    @Override
    public boolean isVarargCall() {
        boolean isVararg = false;
        for (OCMessageArgument argument : this.getArguments()) {
            isVararg = argument.getArgumentSelector().isEmpty();
        }
        return isVararg;
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCType guessedType;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl", "getType"));
        }
        OCType type = null;
        OCSendMessageExpression.ProbableResponders probableResponders = this.getProbableResponders();
        List<OCMethodSymbol> responders = probableResponders.getFilteredByStaticnessResponders();
        PsiFile containingFile = this.getContainingFile();
        if (responders.size() == 1) {
            type = responders.get(0).getReturnType(probableResponders.getReceiverType()).resolve(containingFile);
        } else {
            for (OCMethodSymbol method : responders) {
                OCType returnType = method.getReturnType(probableResponders.getReceiverType()).resolve(containingFile);
                if (type == null || type.isUnknown() || type.isUnresolved(context)) {
                    type = returnType;
                    continue;
                }
                if (new OCTypeEqualityAfterResolvingVisitor(returnType, true, true, false, false, true, context).equal(type)) continue;
                type = OCUnknownType.INSTANCE;
                break;
            }
        }
        if (type == null) {
            type = OCUnknownType.INSTANCE;
        }
        if (type.isUnknown() && this.getParent() instanceof OCSendMessageExpression) {
            type = OCIdType.pointerToID(this.getProject());
        }
        OCType oCType = (guessedType = this.getGuessedType()) != null ? type.cloneWithGuessedType(guessedType) : type;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl", "getType"));
        }
        return oCType;
    }

    @Nullable
    private OCType getGuessedType() {
        OCExpression receiver = this.getReceiverExpression();
        SelectorReference methodRef = this.getReference();
        List<OCMethodSymbol> symbols = methodRef.resolveToSymbols();
        if (symbols.size() != 1) {
            return null;
        }
        OCMethodSymbol method = symbols.get(0);
        if (receiver != null && method != null) {
            OCObjectTypeContext receiverContext = this.getReceiverContext();
            if (receiverContext == null) {
                return this.getType();
            }
            return OCTypeGuesser.getMethodGuessedReturnType(method, receiverContext, this, this);
        }
        return null;
    }

    @NotNull
    public SelectorReference getReference() {
        SelectorReference selectorReference = this.myReference;
        if (selectorReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl", "getReference"));
        }
        return selectorReference;
    }

    @Override
    @NotNull
    public OCSendMessageExpression.ProbableResponders getProbableResponders() {
        OCObjectTypeContext receiverContext = this.getReceiverContext();
        OCSendMessageExpression.ProbableResponders probableResponders = receiverContext != null ? receiverContext.getProbableResponders(this.getMessageSelector(), this.getProject()) : new OCSendMessageExpression.ProbableResponders(Collections.<OCMethodSymbol>emptyList(), Collections.<OCMethodSymbol>emptyList(), null, null);
        if (probableResponders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl", "getProbableResponders"));
        }
        return probableResponders;
    }

    @Override
    @NotNull
    public String getExpectedMethodSignature() {
        OCType returnExpectedType = OCExpectedTypeUtil.getExpectedType(this, true);
        if (returnExpectedType == OCUnknownType.INSTANCE) {
            returnExpectedType = OCVoidType.instance();
        }
        if (this.getMessageSelector().startsWith("init")) {
            returnExpectedType = OCIdType.pointerToID(this.getProject());
        }
        StringBuilder result2 = new StringBuilder();
        OCSendMessageExpression.ProbableResponders probableResponders = this.getProbableResponders();
        result2.append(probableResponders.isStaticContext() ? (char)'+' : '-');
        result2.append('(');
        result2.append(returnExpectedType.getName(this)).append(')');
        HashSet<String> createdNames = new HashSet<String>();
        boolean isFirstSelector = true;
        for (OCMessageArgument argument : this.getArguments()) {
            String selectorName = argument.getArgumentSelector().getSelectorName();
            result2.append(selectorName);
            OCExpression expression = argument.getArgumentExpression();
            if (expression == null) break;
            OCType paramType = OCExpectedTypeUtil.getExpressionType(expression, true);
            String suggestedName = OCNameSuggester.suggestForParameter(createdNames, isFirstSelector, selectorName, paramType, probableResponders.getKnownResponder(), expression);
            createdNames.add(suggestedName);
            result2.append('(').append(paramType.getName(this)).append(')');
            result2.append(suggestedName).append(' ');
            isFirstSelector = false;
        }
        String string = result2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl", "getExpectedMethodSignature"));
        }
        return string;
    }

    @Override
    @Nullable
    public OCObjectTypeContext getReceiverContext() {
        OCExpression receiver = this.getReceiverExpression();
        return receiver != null ? receiver.getTypeContext() : null;
    }

    private class SelectorReference
    extends PsiPolyVariantCachingReference
    implements MultiRangeReference,
    OCPolyVariantReference {
        @NotNull
        public List<OCMethodSymbol> resolveToSymbols() {
            OCSendMessageExpression.ProbableResponders responders = OCSendMessageExpressionImpl.this.getProbableResponders();
            if (responders.getKnownResponder() != null) {
                List<OCMethodSymbol> list = Collections.singletonList(responders.getKnownResponder());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl$SelectorReference", "resolveToSymbols"));
                }
                return list;
            }
            if (!responders.getFilteredByStaticnessResponders().isEmpty()) {
                List<OCMethodSymbol> list = responders.getFilteredByStaticnessResponders();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl$SelectorReference", "resolveToSymbols"));
                }
                return list;
            }
            List<OCMethodSymbol> list = responders.getAllResponders();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl$SelectorReference", "resolveToSymbols"));
            }
            return list;
        }

        @Override
        public boolean isReferenceTo(PsiElement element) {
            if (!(element instanceof OCSymbolDeclarator)) {
                return false;
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            List<OCMethodSymbol> symbols = this.resolveToSymbols();
            if (symbol == null && symbols.isEmpty()) {
                return true;
            }
            if (symbol instanceof OCPropertySymbol) {
                CommonProcessors.CollectProcessor allPropsCollector = new CommonProcessors.CollectProcessor();
                symbol.processSameSymbols((Processor<OCSymbol>)allPropsCollector);
                for (OCMethodSymbol methodSymbol : symbols) {
                    OCMethodSymbol associatedSymbol = methodSymbol.getAssociatedSymbol();
                    if (!allPropsCollector.getResults().contains(methodSymbol.getGeneratedFromProperty()) && (associatedSymbol == null || !allPropsCollector.getResults().contains(associatedSymbol.getGeneratedFromProperty()))) continue;
                    return true;
                }
            } else if (symbol instanceof OCMethodSymbol) {
                return symbols.contains(symbol) || symbols.contains(((OCMethodSymbol)symbol).getAssociatedSymbol());
            }
            return false;
        }

        @Override
        @NotNull
        protected ResolveResult[] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl$SelectorReference", "resolveInner"));
            }
            List<OCMethodSymbol> responders = this.resolveToSymbols();
            ArrayList<PsiElementResolveResult> answer = new ArrayList<PsiElementResolveResult>();
            for (OCMethodSymbol responder : responders) {
                Object definition = responder.locateDefinition();
                if (definition == null) continue;
                answer.add(new PsiElementResolveResult(definition, true));
            }
            ResolveResult[] resolveResultArray = answer.toArray(new ResolveResult[answer.size()]);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl$SelectorReference", "resolveInner"));
            }
            return resolveResultArray;
        }

        public PsiElement getElement() {
            return OCSendMessageExpressionImpl.this;
        }

        public TextRange getRangeInElement() {
            return ReferenceRange.getRange((PsiReference)this);
        }

        @NotNull
        public List<TextRange> getRanges() {
            ArrayList<TextRange> answer = new ArrayList<TextRange>();
            int parentOffset = -this.getElement().getTextRange().getStartOffset();
            for (OCMessageArgument argument : OCSendMessageExpressionImpl.this.getArguments()) {
                TextRange argumentRange;
                PsiElement id = argument.getArgumentSelector().getSelectorIdentifier();
                if (id == null || (argumentRange = id.getTextRange()).isEmpty()) continue;
                answer.add(argumentRange.shiftRight(parentOffset));
            }
            ArrayList<TextRange> arrayList = answer;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl$SelectorReference", "getRanges"));
            }
            return arrayList;
        }

        @NotNull
        public String getCanonicalText() {
            String string = OCSendMessageExpressionImpl.this.getMessageSelector();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl$SelectorReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newName) throws IncorrectOperationException {
            PsiElement identifier = OCSendMessageExpressionImpl.this.getArguments().get(0).getArgumentSelector().getSelectorIdentifier();
            if (identifier != null) {
                return identifier.replace(OCElementFactory.createIdentifier(newName, OCSendMessageExpressionImpl.this));
            }
            return OCSendMessageExpressionImpl.this;
        }

        @Override
        public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
            if (symbol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl$SelectorReference", "bindToSymbol"));
            }
            String newSelector = symbol.getName();
            if (symbol instanceof OCPropertySymbol) {
                newSelector = OCNameSuggester.isObjCGetter(OCSendMessageExpressionImpl.this.getMessageSelector()) ? ((OCPropertySymbol)symbol).getGetterName() : ((OCPropertySymbol)symbol).getSetterName();
            } else assert (symbol instanceof OCMethodSymbol) : symbol.getClass();
            if (!OCSendMessageExpressionImpl.this.getMessageSelector().equals(newSelector)) {
                this.handleElementRename(newSelector);
            }
            return this.getElement();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl$SelectorReference", "bindToElement"));
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = new Object[]{};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSendMessageExpressionImpl$SelectorReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

