/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceImpl;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCSelectorExpressionImpl
extends OCExpressionBase
implements OCSelectorExpression {
    public OCSelectorExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public String getSelector() {
        StringBuilder builder = new StringBuilder();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCElementTypes.OBJC_KEYWORD || tt == OCTokenTypes.LPAR || tt == OCTokenTypes.RPAR || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt)) continue;
            builder.append(child.getText());
        }
        String string = builder.toString().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl", "getSelector"));
        }
        return string;
    }

    @Override
    @NotNull
    public OCType getExpectedReturnType() {
        OCSendMessageExpression sendMessageExpr;
        if (OCSelectorAdHocResolver.getActionTargetContext(this) != null && (sendMessageExpr = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)this, OCSendMessageExpression.class)) != null && OCSelectorAdHocResolver.isPerformSelectorMethod(sendMessageExpr.getMessageSelector())) {
            OCType oCType = OCExpectedTypeUtil.getExpectedType(sendMessageExpr);
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl", "getExpectedReturnType"));
            }
            return oCType;
        }
        OCVoidType oCVoidType = OCVoidType.instance();
        if (oCVoidType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl", "getExpectedReturnType"));
        }
        return oCVoidType;
    }

    @Override
    public String getExpectedMethodSignature() {
        StringBuilder result2 = new StringBuilder();
        result2.append("-(");
        result2.append(this.getExpectedReturnType().getBestNameInContext(this));
        result2.append(")");
        String lastID = null;
        HashSet<String> paramNames = new HashSet<String>();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCTokenTypes.IDENTIFIER) {
                lastID = child.getText();
                result2.append(lastID);
                continue;
            }
            if (tt != OCTokenTypes.COLON && tt != OCTokenTypes.COLON2X) continue;
            for (int i = 0; i < (tt == OCTokenTypes.COLON2X ? 2 : 1); ++i) {
                String paramName = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, lastID, null, paramNames);
                paramNames.add(paramName);
                result2.append(":(id)").append(paramName).append(' ');
            }
        }
        return result2.toString();
    }

    @Override
    @NotNull
    public TextRange getSelectorRange() {
        TextRange range;
        int startOffset = 0;
        int endOffset = 0;
        ASTNode child = this.getNode().getFirstChildNode();
        ASTNode childPrev = null;
        IElementType ttPrev = null;
        int parentOffset = this.getNode().getStartOffset();
        while (child != null) {
            IElementType tt = child.getElementType();
            if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt)) {
                child = child.getTreeNext();
                continue;
            }
            if (ttPrev == OCTokenTypes.LPAR) {
                startOffset = child.getStartOffset();
            }
            if (tt == OCTokenTypes.RPAR) {
                endOffset = childPrev.getTextRange().getEndOffset();
            }
            childPrev = child;
            ttPrev = tt;
            child = child.getTreeNext();
        }
        if (endOffset < startOffset) {
            endOffset = startOffset;
        }
        TextRange textRange = (range = new TextRange(startOffset, endOffset)).isEmpty() ? range : range.shiftRight(-parentOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl", "getSelectorRange"));
        }
        return textRange;
    }

    @Override
    public List<PsiElement> getSelectorParts() {
        return this.findChildrenByType(OCTokenTypes.IDENTIFIER);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl", "accept"));
        }
        visitor.visitSelectorExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl", "getType"));
        }
        OCReferenceType oCReferenceType = OCReferenceType.fromText("SEL");
        if (oCReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl", "getType"));
        }
        return oCReferenceType;
    }

    @Override
    @NotNull
    public OCPolyVariantReference<OCMethodSymbol> getReference() {
        SelectorReference selectorReference = new SelectorReference();
        if (selectorReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl", "getReference"));
        }
        return selectorReference;
    }

    private class SelectorReference
    extends OCPolyVariantReferenceImpl<OCMethodSymbol> {
        private SelectorReference() {
        }

        public PsiElement getElement() {
            return OCSelectorExpressionImpl.this;
        }

        public TextRange getRangeInElement() {
            return OCSelectorExpressionImpl.this.getSelectorRange();
        }

        @Override
        public boolean isReferenceTo(PsiElement element) {
            if (!(element instanceof OCSymbolDeclarator)) {
                return false;
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol instanceof OCPropertySymbol) {
                String selector = OCSelectorExpressionImpl.this.getSelector();
                return symbol.getName().equals(selector) || OCNameSuggester.getObjCSetterFromGetter(symbol.getName()).equals(selector);
            }
            if (!(symbol instanceof OCMethodSymbol)) {
                return false;
            }
            List<OCMethodSymbol> symbols = this.resolveToSymbols();
            return symbols.contains(symbol) || symbols.contains(((OCMethodSymbol)symbol).getAssociatedSymbol());
        }

        @Override
        @NotNull
        public List<OCMethodSymbol> resolveToSymbols() {
            OCObjectTypeContext targetContext = OCSelectorAdHocResolver.getActionTargetContext(OCSelectorExpressionImpl.this);
            if (targetContext != null) {
                targetContext.setStaticDoesntMatter();
                List<OCMethodSymbol> list = targetContext.getProbableResponders(OCSelectorExpressionImpl.this.getSelector(), OCSelectorExpressionImpl.this.getProject()).getAllResponders();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl$SelectorReference", "resolveToSymbols"));
                }
                return list;
            }
            final HashMap result2 = new HashMap();
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCSelectorExpressionImpl.this.getProject(), new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCMethodSymbol) {
                        OCMethodSymbol oldMethod;
                        OCMethodSymbol method = SelectorReference.this.validateSymbol((OCMethodSymbol)symbol);
                        String parentName = ((OCClassSymbol)method.getParent()).getPresentableName();
                        if (method.getParent() instanceof OCProtocolSymbol) {
                            parentName = "protocol#" + parentName;
                        }
                        if ((oldMethod = (OCMethodSymbol)result2.get(parentName)) == null || oldMethod.getParent() instanceof OCImplementationSymbol && method.getParent() instanceof OCInterfaceSymbol) {
                            result2.put(parentName, method);
                        }
                    }
                    return true;
                }
            }, OCSelectorExpressionImpl.this.getSelector());
            ArrayList<OCMethodSymbol> arrayList = new ArrayList<OCMethodSymbol>(result2.values());
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl$SelectorReference", "resolveToSymbols"));
            }
            return arrayList;
        }

        private OCMethodSymbol validateSymbol(OCMethodSymbol symbol) {
            OCClassDeclarationBase parentDecl = (OCClassDeclarationBase)((OCClassSymbol)symbol.getParent()).locateDefinition();
            if (parentDecl == null) {
                return symbol;
            }
            CommonProcessors.FindFirstProcessor<OCMemberSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMemberSymbol>(){

                protected boolean accept(OCMemberSymbol symbol) {
                    return symbol instanceof OCMethodSymbol;
                }
            };
            OCResolveUtil.processMemberSymbols(symbol.getName(), parentDecl.getLastChild(), (Processor<? super OCMemberSymbol>)finder);
            return finder.isFound() ? (OCMethodSymbol)finder.getFoundValue() : symbol;
        }

        @NotNull
        public String getCanonicalText() {
            String string = OCSelectorExpressionImpl.this.getSelector();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl$SelectorReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            OCSelectorExpressionImpl element = OCSelectorExpressionImpl.this;
            newElementName = OCNameSuggester.isObjCSetter(OCSelectorExpressionImpl.this.getSelector()) && !OCNameSuggester.isObjCSetter(newElementName) ? OCNameSuggester.getObjCSetterFromGetter(newElementName) : newElementName;
            return OCChangeUtil.replaceHandlingMacros(element, OCElementFactory.expressionFromText("@selector(" + newElementName + ")", element));
        }

        @Override
        public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
            if (symbol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl$SelectorReference", "bindToSymbol"));
            }
            assert (symbol instanceof OCMethodSymbol || symbol instanceof OCPropertySymbol);
            return this.handleElementRename(symbol.getName());
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl$SelectorReference", "bindToElement"));
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
        }

        public boolean isSoft() {
            return false;
        }
    }
}

