/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCPrefixExpressionImpl
extends OCExpressionBase
implements OCPrefixExpression {
    public OCPrefixExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCPrefixExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public OCOperatorReference getReference() {
        TextRange range = OCElementUtil.getRangeInParent(this.getOperationSignNode());
        String name = this.getOperationSign().getName();
        OCExpression operand = this.getOperand();
        if (operand != null) {
            return new OCOperatorReference((OCElement)this, name, range, operand);
        }
        return null;
    }

    @Override
    public OCExpression getOperand() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        OCElementType oCElementType = (OCElementType)this.getOperationSignNode().getElementType();
        if (oCElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCPrefixExpressionImpl", "getOperationSign"));
        }
        return oCElementType;
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        ASTNode aSTNode = this.getNode().getFirstChildNode();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCPrefixExpressionImpl", "getOperationSignNode"));
        }
        return aSTNode;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCPrefixExpressionImpl", "accept"));
        }
        visitor.visitPrefixExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCExpression op;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCPrefixExpressionImpl", "getType"));
        }
        OCOperatorReference reference = this.getReference();
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols()) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                OCType oCType = operator.getEffectiveType();
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCPrefixExpressionImpl", "getType"));
                }
                return oCType;
            }
        }
        OCType oCType = (op = this.getOperand()) != null ? op.getType(context) : OCUnknownType.INSTANCE;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCPrefixExpressionImpl", "getType"));
        }
        return oCType;
    }
}

