/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import org.jetbrains.annotations.NotNull;

public class OCMacroReferenceElementImpl
extends OCReferenceElementImpl {
    public OCMacroReferenceElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCMacroReferenceElementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public OCSymbol resolveToSymbol() {
        OCSymbol symbol = super.resolveToSymbol();
        if (symbol != null) {
            return symbol;
        }
        String name = this.getCanonicalText();
        OCFile file2 = this.getContainingOCFile();
        if (file2 == null) {
            return null;
        }
        OCMacroSymbol macro = OCInclusionContextUtil.headerContext(file2).getDefinition(name);
        if (macro != null) {
            return new OCMacroSymbol(file2.getProject(), OCInclusionContextUtil.getVirtualFile(file2), this.getTextOffset(), name, macro.getParameterNames(), macro.getSubstitution());
        }
        return null;
    }

    @Override
    public boolean isSoft() {
        return true;
    }

    @Override
    public PsiElement resolve() {
        OCSymbol symbol = super.resolveToSymbol();
        if (symbol != null) {
            return symbol.locateDefinition();
        }
        return this;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return element instanceof OCDefineDirective && this.getTextWithMacros().equals(((OCDefineDirective)element).getName());
    }
}

