/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCharLiteral;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCFloatLiteral;
import com.jetbrains.cidr.lang.util.OCIntegerLiteral;
import com.jetbrains.cidr.lang.util.OCLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLiteralExpressionImpl
extends OCExpressionBase
implements OCLiteralExpression,
ContributedReferenceHost {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.psi.impl.OCLiteralExpressionImpl");

    @NotNull
    private String getLiteralText(@NotNull LiteralPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getLiteralText"));
        }
        ASTNode firstChild = this.getNode().getFirstChildNode();
        IElementType tt = firstChild.getElementType();
        OCLiteral literal = OCLiteralExpressionImpl.getLiteral(tt, this.getRawLiteralTextElements());
        if (literal instanceof OCStringLiteral) {
            OCStringLiteral stringLiteral = (OCStringLiteral)literal;
            String string = stringLiteral.getContents(presentation == LiteralPresentation.TEXT_ESCAPED);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getLiteralText"));
            }
            return string;
        }
        if (literal instanceof OCCharLiteral) {
            OCCharLiteral charLiteral = (OCCharLiteral)literal;
            String string = charLiteral.getContents(presentation == LiteralPresentation.TEXT_ESCAPED);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getLiteralText"));
            }
            return string;
        }
        String string = this.getRawLiteralText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getLiteralText"));
        }
        return string;
    }

    @Nullable
    private static OCLiteral getLiteral(@NotNull IElementType tt, @NotNull List<String> childTextElements) {
        if (tt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tt", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getLiteral"));
        }
        if (childTextElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTextElements", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getLiteral"));
        }
        if (tt == OCTokenTypes.AT || OCTokenTypes.ALL_STRINGS.contains(tt)) {
            OCStringLiteral literal = OCStringLiteral.BAD_LITERAL;
            for (String text : childTextElements) {
                literal = OCStringLiteralUtil.concatStrings(literal, OCStringLiteralUtil.parseStringLiteral(text));
            }
            return literal;
        }
        String childText = StringUtil.join(childTextElements, (String)"");
        if (tt == OCTokenTypes.CHARACTER_LITERAL) {
            return OCStringLiteralUtil.parseCharLiteral(childText);
        }
        if (tt == OCTokenTypes.INTEGER_LITERAL) {
            return new OCIntegerLiteral(childText);
        }
        if (tt == OCTokenTypes.FLOAT_LITERAL) {
            return new OCFloatLiteral(childText);
        }
        return null;
    }

    public OCLiteralExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "accept"));
        }
        visitor.visitLiteralExpression(this);
    }

    @Override
    @NotNull
    public String getUnescapedLiteralText() {
        String string = this.getLiteralText(LiteralPresentation.TEXT_UNESCAPED);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getUnescapedLiteralText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEscapedLiteralText() {
        String string = this.getLiteralText(LiteralPresentation.TEXT_ESCAPED);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getEscapedLiteralText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getRawLiteralText() {
        String string = StringUtil.join(this.getRawLiteralTextElements(), (String)"");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getRawLiteralText"));
        }
        return string;
    }

    @NotNull
    public List<ASTNode> findStringLiteralNodes() {
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!OCTokenTypes.ALL_STRINGS.contains(child.getElementType())) continue;
            nodes.add(child);
        }
        ArrayList<ASTNode> arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "findStringLiteralNodes"));
        }
        return arrayList;
    }

    @NotNull
    private List<String> getRawLiteralTextElements() {
        ASTNode firstChild = this.getNode().getFirstChildNode();
        IElementType tt = firstChild.getElementType();
        if (tt == OCTokenTypes.AT || OCTokenTypes.ALL_STRINGS.contains(tt)) {
            List list = ContainerUtil.map(this.findStringLiteralNodes(), (Function)new Function<ASTNode, String>(){

                public String fun(ASTNode node) {
                    return node.getText();
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getRawLiteralTextElements"));
            }
            return list;
        }
        List<String> list = Collections.singletonList(firstChild.getText());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getRawLiteralTextElements"));
        }
        return list;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReferenceService service = PsiReferenceService.getService();
        PsiReference[] ret = null;
        if (service != null) {
            ret = service.getContributedReferences((PsiElement)this);
        }
        if (ret == null) {
            ret = PsiReference.EMPTY_ARRAY;
            LOG.assertTrue(ret.length == 0);
        }
        if (ret == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getReferences"));
        }
        return ret;
    }

    @Override
    @Nullable
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length == 1 ? references[0] : null;
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCMacroRange macroRange;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getType"));
        }
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        String literalText = this.getRawLiteralText();
        if (tt == OCTokenTypes.INTEGER_LITERAL && ("0".equals(literalText) || "1".equals(literalText)) && (macroRange = OCElementUtil.getRangeInMacroCall(this)) != null) {
            String macroText = macroRange.getMacroCall().getText();
            if (macroText.equals("TRUE") || macroText.equals("FALSE") || macroText.equals("YES") || macroText.equals("NO")) {
                OCIntType oCIntType = OCIntType.BOOL;
                if (oCIntType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getType"));
                }
                return oCIntType;
            }
            if (macroText.equals("true") || macroText.equals("false")) {
                OCIntType oCIntType = OCIntType.BOOL_NATIVE;
                if (oCIntType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getType"));
                }
                return oCIntType;
            }
        }
        if (tt == OCElementTypes.NS_ARRAY_LITERAL) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSArray"));
            if (oCPointerType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getType"));
            }
            return oCPointerType;
        }
        if (tt == OCElementTypes.NS_DICTIONARY_LITERAL) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSDictionary"));
            if (oCPointerType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getType"));
            }
            return oCPointerType;
        }
        if (this.isNSNumberLiteral()) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSNumber"));
            if (oCPointerType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getType"));
            }
            return oCPointerType;
        }
        if (this.isNSStringLiteral()) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSString"));
            if (oCPointerType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getType"));
            }
            return oCPointerType;
        }
        OCType oCType = OCLiteralExpressionImpl.getLiteralTypeFromTT(tt, this.getContainingFile(), OCLiteralExpressionImpl.getLiteral(tt, this.getRawLiteralTextElements()));
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getType"));
        }
        return oCType;
    }

    public static OCType getLiteralType(IElementType tt, String childText, @NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getLiteralType"));
        }
        return OCLiteralExpressionImpl.getLiteralTypeFromTT(tt, file2, OCLiteralExpressionImpl.getLiteral(tt, Collections.singletonList(childText)));
    }

    private static OCType getLiteralTypeFromTT(IElementType tt, @NotNull PsiFile file2, @Nullable OCLiteral literal) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl", "getLiteralTypeFromTT"));
        }
        if (tt == OCTokenTypes.TRUE_CPP_KEYWORD || tt == OCTokenTypes.FALSE_CPP_KEYWORD) {
            return OCIntType.BOOL_NATIVE;
        }
        if (tt == OCTokenTypes.NULL_CPP_KEYWORD) {
            return OCPointerType.to(OCVoidType.instance());
        }
        if (literal != null) {
            return literal.getType(file2, OCCodeInsightUtil.isInPlainOldC((PsiElement)file2));
        }
        if (tt == OCTokenTypes.WRONG_INTEGER_LITERAL) {
            return OCIntType.INT;
        }
        if (tt == OCTokenTypes.WRONG_FLOAT_LITERAL) {
            return OCRealType.FLOAT;
        }
        if (tt == OCTokenTypes.TEMPLATE_START_MARK) {
            return OCUnknownType.INSTANCE;
        }
        if (tt == OCTokenTypes.FAKE_FALSE || tt == OCTokenTypes.FAKE_TRUE) {
            return OCIntType.INT;
        }
        if (tt == OCTokenTypes.__NULL_KEYWORD) {
            return OCPointerType.to(OCVoidType.instance());
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    public boolean isNSNumberLiteral() {
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        if (tt == OCTokenTypes.AT) {
            IElementType type = this.getNode().getLastChildNode().getElementType();
            return type == OCTokenTypes.INTEGER_LITERAL || type == OCTokenTypes.FLOAT_LITERAL || type == OCTokenTypes.CHARACTER_LITERAL;
        }
        return false;
    }

    @Override
    public boolean isNSStringLiteral() {
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        if (tt == OCTokenTypes.AT) {
            IElementType type = this.getNode().getLastChildNode().getElementType();
            return type == OCTokenTypes.STRING_LITERAL;
        }
        return false;
    }

    @Override
    public boolean isStringLiteral() {
        return !this.findStringLiteralNodes().isEmpty();
    }

    public static enum LiteralPresentation {
        TEXT_ESCAPED,
        TEXT_UNESCAPED;

    }
}

