/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConditionalExpressionImpl
extends OCExpressionBase
implements OCConditionalExpression {
    public OCConditionalExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCConditionalExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public OCExpression getCondition() {
        OCExpression cond = this.findExpression(0);
        assert (cond != null);
        OCExpression oCExpression = cond;
        if (oCExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCConditionalExpressionImpl", "getCondition"));
        }
        return oCExpression;
    }

    @Override
    public OCExpression getPositiveExpression(boolean returnConditionIfNull) {
        OCExpression expression = this.findExpression(1);
        return expression != null || !returnConditionIfNull ? expression : this.getCondition();
    }

    @Override
    public OCExpression getNegativeExpression() {
        return this.findExpression(2);
    }

    @Nullable
    private OCExpression findExpression(int n) {
        int count = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCElementTypes.EXPRESSIONS.contains(tt) && count == n) {
                return (OCExpression)child.getPsi();
            }
            if (count == 0 && tt == OCTokenTypes.QUEST) {
                count = 1;
                continue;
            }
            if (count != 1 || tt != OCTokenTypes.COLON) continue;
            count = 2;
        }
        return null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCConditionalExpressionImpl", "accept"));
        }
        visitor.visitConditionalExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCConditionalExpressionImpl", "getType"));
        }
        OCExpression leftExpr = this.getPositiveExpression(true);
        OCExpression rightExpr = this.getNegativeExpression();
        if (leftExpr != null && rightExpr != null) {
            OCType lType = leftExpr.getResolvedType(context);
            OCType rType = rightExpr.getResolvedType(context);
            OCType oCType = OCConditionalExpressionImpl.getConditionalExprType(lType, rType, OCExpressionEvaluator.isLikeNil(leftExpr, context), OCExpressionEvaluator.isLikeNil(rightExpr, context), this);
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCConditionalExpressionImpl", "getType"));
            }
            return oCType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCConditionalExpressionImpl", "getType"));
        }
        return oCUnknownType;
    }

    public static OCType getConditionalExprType(OCType lType, OCType rType, boolean leftIsNil, boolean rightIsNil, @Nullable PsiElement context) {
        boolean referencesBoth;
        boolean bl = referencesBoth = lType instanceof OCCppReferenceType && rType instanceof OCCppReferenceType;
        if (lType instanceof OCCppReferenceType) {
            lType = ((OCCppReferenceType)lType).getRefType();
        }
        if (rType instanceof OCCppReferenceType) {
            rType = ((OCCppReferenceType)rType).getRefType();
        }
        if (rightIsNil) {
            if (lType instanceof OCBlockPointerType) {
                rType = OCBlockPointerType.blockPtr(((OCBlockPointerType)lType).getRefType());
            } else if (lType instanceof OCPointerType) {
                rType = OCPointerType.to(((OCPointerType)lType).getRefType());
            }
        }
        if (leftIsNil) {
            if (rType instanceof OCBlockPointerType) {
                lType = OCBlockPointerType.blockPtr(((OCBlockPointerType)rType).getRefType());
            } else if (rType instanceof OCPointerType) {
                lType = OCPointerType.to(((OCPointerType)rType).getRefType());
            }
        }
        OCType commonType = lType.getLeastCommonType(rType, context);
        return referencesBoth ? OCCppReferenceType.to(commonType) : commonType;
    }
}

