/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallExpressionImpl
extends OCExpressionBase
implements OCCallExpression {
    public OCCallExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public OCOperatorReference getReference() {
        OCExpression function = this.getFunctionReferenceExpression();
        return this.getReference(function, function.getType());
    }

    public OCOperatorReference getReference(OCExpression function, OCType functionType) {
        ArrayList<OCType> types = new ArrayList<OCType>();
        ArrayList<OCExpression> exprs = new ArrayList<OCExpression>();
        exprs.add(function);
        exprs.addAll(this.getArguments());
        types.add(functionType);
        class OCCallOperatorReference
        extends OCOperatorReference
        implements MultiRangeReference {
            OCCallOperatorReference(OCElement element, List<OCExpression> arguments, List<OCType> paramTypes) {
                super(element, "()", TextRange.EMPTY_RANGE, arguments, paramTypes);
            }

            @NotNull
            public List<TextRange> getRanges() {
                PsiElement right;
                ArrayList<TextRange> result2 = new ArrayList<TextRange>();
                OCArgumentList argumentList = OCCallExpressionImpl.this.getArgumentList();
                TextRange argListRange = OCElementUtil.getRangeInParent(argumentList);
                PsiElement left = argumentList.getLeftPar();
                if (left != null) {
                    result2.add(OCElementUtil.getRangeInParent(left).shiftRight(argListRange.getStartOffset()));
                }
                if ((right = argumentList.getRightPar()) != null) {
                    result2.add(OCElementUtil.getRangeInParent(right).shiftRight(argListRange.getStartOffset()));
                }
                ArrayList<TextRange> arrayList = result2;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl$1OCCallOperatorReference", "getRanges"));
                }
                return arrayList;
            }
        }
        return new OCCallOperatorReference(this, exprs, types);
    }

    @Override
    @NotNull
    public OCExpression getFunctionReferenceExpression() {
        OCExpression oCExpression = (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
        if (oCExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "getFunctionReferenceExpression"));
        }
        return oCExpression;
    }

    @Override
    @NotNull
    public OCArgumentList getArgumentList() {
        OCArgumentList oCArgumentList = (OCArgumentList)this.findNotNullChildByType(OCElementTypes.ARGUMENT_LIST);
        if (oCArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "getArgumentList"));
        }
        return oCArgumentList;
    }

    @Override
    @NotNull
    public List<OCExpression> getArguments() {
        List<OCExpression> list = this.getArgumentList().getArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "getArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<OCType> getArgumentTypes(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "getArgumentTypes"));
        }
        List<OCType> list = this.getArgumentList().getArgumentTypes(context);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "getArgumentTypes"));
        }
        return list;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "accept"));
        }
        visitor.visitCallExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCType funType;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "getType"));
        }
        OCExpression funRef = this.getFunctionReferenceExpression();
        OCOperatorReference reference = this.getReference(funRef, funType = funRef.getResolvedType(context));
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols()) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                OCType oCType = operator.getEffectiveType();
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "getType"));
                }
                return oCType;
            }
        }
        OCSymbol callerSymbol = null;
        if (funRef instanceof OCReferenceExpression) {
            OCReferenceElement referenceElement = ((OCReferenceExpression)funRef).getReferenceElement();
            callerSymbol = referenceElement != null ? referenceElement.resolveToSymbol(context) : null;
        }
        OCType result2 = OCCallExpressionImpl.getCallExprType(funType, callerSymbol);
        OCType guessedType = this.getGuessedType();
        OCType oCType = guessedType != null ? result2.cloneWithGuessedType(guessedType) : result2;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "getType"));
        }
        return oCType;
    }

    @NotNull
    public static OCType getCallExprType(@Nullable OCType funType, @Nullable OCSymbol callerSymbol) {
        OCType result2;
        if (callerSymbol instanceof OCStructSymbol) {
            result2 = callerSymbol.getType();
        } else if (callerSymbol != null && callerSymbol.getKind() == OCSymbolKind.TYPEDEF) {
            result2 = funType;
        } else {
            result2 = OCUnknownType.INSTANCE;
            if (funType instanceof OCMagicType) {
                OCType oCType = funType;
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "getCallExprType"));
                }
                return oCType;
            }
            if (funType instanceof OCStructType) {
                result2 = funType;
            }
            if (funType instanceof OCPointerType) {
                funType = ((OCPointerType)funType).getRefType();
            }
            if (funType instanceof OCFunctionType) {
                result2 = ((OCFunctionType)funType).getReturnType();
            }
        }
        if (result2 instanceof OCNumericType) {
            result2 = result2.cloneWithoutCVQualifiers(callerSymbol != null ? callerSymbol.getProject() : null);
        }
        OCType oCType = result2;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl", "getCallExprType"));
        }
        return oCType;
    }

    @Nullable
    private OCType getGuessedType() {
        VirtualFile containingFile;
        OCSymbol symbol;
        OCExpression function = this.getFunctionReferenceExpression();
        if (function instanceof OCReferenceExpression && (symbol = ((OCReferenceExpression)function).resolveToSymbol()) instanceof OCFunctionSymbol && symbol.getName().startsWith("is") && (containingFile = symbol.getContainingFile()) != null && containingFile.getName().equals("ctype.h")) {
            return OCIntType.getAppropriateBool(this);
        }
        return null;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        OCExpression function = this.getFunctionReferenceExpression();
        return function instanceof OCQualifiedExpression ? Collections.singletonList(((OCQualifiedExpression)function).getQualifier()) : Collections.emptyList();
    }
}

