/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBinaryExpressionImpl
extends OCExpressionBase
implements OCBinaryExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.psi.impl.OCBinaryExpressionImpl");

    public OCBinaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCBinaryExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public OCOperatorReference getReference() {
        TextRange range = OCElementUtil.getRangeInParent(this.getOperationSignNode());
        String name = this.getOperationSign().getName();
        OCExpression left = this.getLeft();
        OCExpression right = this.getRight();
        if (left != null && right != null) {
            return new OCOperatorReference((OCElement)this, name, range, left, right);
        }
        return null;
    }

    @Override
    @Nullable
    public OCExpression getLeft() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    public OCExpression getRight() {
        boolean passedSign = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt instanceof OCPunctuatorElementType) {
                passedSign = true;
                continue;
            }
            if (!passedSign || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!(tt instanceof OCPunctuatorElementType)) continue;
            ASTNode aSTNode = child;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCBinaryExpressionImpl", "getOperationSignNode"));
            }
            return aSTNode;
        }
        throw new AssertionError((Object)("Cannot find operation sign in binary expression: " + this.getText()));
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        OCElementType oCElementType = (OCElementType)this.getOperationSignNode().getElementType();
        if (oCElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCBinaryExpressionImpl", "getOperationSign"));
        }
        return oCElementType;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCBinaryExpressionImpl", "accept"));
        }
        visitor.visitBinaryExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCBinaryExpressionImpl", "getType"));
        }
        OCOperatorReference reference = this.getReference();
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                OCType oCType = operator.getEffectiveType();
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCBinaryExpressionImpl", "getType"));
                }
                return oCType;
            }
        }
        OCExpression l = this.getLeft();
        OCExpression r = this.getRight();
        if (l == null) {
            OCType oCType = r != null ? r.getType(context) : OCUnknownType.INSTANCE;
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCBinaryExpressionImpl", "getType"));
            }
            return oCType;
        }
        if (r == null) {
            OCType oCType = l.getType(context);
            if (oCType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCBinaryExpressionImpl", "getType"));
            }
            return oCType;
        }
        OCElementType sign = this.getOperationSign();
        OCType lt = l.getResolvedType(context);
        OCType rt = r.getResolvedType(context);
        OCType oCType = OCBinaryExpressionImpl.getBinaryExprType(sign, lt, rt, this);
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCBinaryExpressionImpl", "getType"));
        }
        return oCType;
    }

    public static OCType getBinaryExprType(OCElementType sign, OCType lt, OCType rt, @Nullable PsiElement context) {
        OCType result2;
        if (OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)sign) || OCTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)sign)) {
            result2 = OCIntType.getAppropriateBool((OCElement)context);
        } else if (lt.isSubclassOfMagic(context) || rt.isSubclassOfMagic(context)) {
            result2 = OCUnknownType.INSTANCE;
        } else if (sign == OCTokenTypes.DOT_MUL || sign == OCTokenTypes.DEREF_MUL) {
            result2 = rt instanceof OCPointerType ? ((OCPointerType)rt).getRefType() : OCUnknownType.INSTANCE;
        } else {
            if (lt instanceof OCCppReferenceType) {
                lt = ((OCCppReferenceType)lt).getRefType();
            }
            if (rt instanceof OCCppReferenceType) {
                rt = ((OCCppReferenceType)rt).getRefType();
            }
            result2 = lt instanceof OCNumericType && rt instanceof OCNumericType && (sign == OCTokenTypes.PLUS || sign == OCTokenTypes.MINUS || sign == OCTokenTypes.DIV || sign == OCTokenTypes.PERC || sign == OCTokenTypes.MUL || sign == OCTokenTypes.AND || sign == OCTokenTypes.OR || sign == OCTokenTypes.XOR) ? lt.getLeastCommonType(rt, context) : (lt instanceof OCPointerType && rt instanceof OCPointerType ? OCIntType.ULONG : (lt instanceof OCPointerType && rt.isIntegerCompatible(context) ? lt : (rt instanceof OCPointerType && lt.isIntegerCompatible(context) ? rt : (!(!lt.isNumberCompatible(context) && !lt.isPointerCompatible(context) || !rt.isNumberCompatible(context) && !rt.isPointerCompatible(context)) ? lt : (lt.isCppStructType() || rt.isCppStructType() ? new OCMagicType(lt) : OCUnknownType.INSTANCE)))));
        }
        if (result2 instanceof OCNumericType) {
            result2 = result2.cloneWithoutCVQualifiers(context != null ? context.getProject() : null);
        }
        return result2;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        return Arrays.asList(this.getLeft(), this.getRight());
    }
}

