/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArgumentListImpl
extends OCElementBase
implements OCArgumentList {
    public OCArgumentListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCArgumentListImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public List<OCExpression> getArguments() {
        List<OCExpression> list = this.findChildrenByType(OCElementTypes.EXPRESSIONS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArgumentListImpl", "getArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<OCType> getArgumentTypes(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCArgumentListImpl", "getArgumentTypes"));
        }
        ArrayList<OCType> argumentTypes = new ArrayList<OCType>();
        for (OCExpression argument : this.getArguments()) {
            argumentTypes.add(argument.getResolvedType(context));
        }
        ArrayList<OCType> arrayList = argumentTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCArgumentListImpl", "getArgumentTypes"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public PsiElement getLeftPar() {
        return this.findChildByType(OCTokenTypes.LPAR);
    }

    @Override
    @Nullable
    public PsiElement getRightPar() {
        return this.findChildByType(OCTokenTypes.RPAR);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCArgumentListImpl", "accept"));
        }
        visitor.visitArgumentList(this);
    }
}

