/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCCompilerProperty;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInitialInclusionContext
extends OCInclusionContext {
    @NotNull
    private final CidrCompilerSwitches myCompilerSwitches;
    @NotNull
    private final Map<OCCompilerProperty.PropertyKey, Object> myPropertiesCache;

    protected OCInitialInclusionContext(@NotNull CidrCompilerSwitches compilerSwitches, @Nullable OCResolveConfiguration configuration, @NotNull Project project, @NotNull OCLanguageKind languageKind) {
        if (compilerSwitches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerSwitches", "com/jetbrains/cidr/lang/preprocessor/OCInitialInclusionContext", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/preprocessor/OCInitialInclusionContext", "<init>"));
        }
        if (languageKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageKind", "com/jetbrains/cidr/lang/preprocessor/OCInitialInclusionContext", "<init>"));
        }
        super(configuration, project, languageKind);
        this.myPropertiesCache = new ConcurrentHashMap<OCCompilerProperty.PropertyKey, Object>();
        this.myCompilerSwitches = compilerSwitches;
    }

    public static <T> T getPropertyFromInitialContext(@NotNull OCCompilerProperty.PropertyKey key, @NotNull OCImmutableInclusionContext fileContext) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/cidr/lang/preprocessor/OCInitialInclusionContext", "getPropertyFromInitialContext"));
        }
        if (fileContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContext", "com/jetbrains/cidr/lang/preprocessor/OCInitialInclusionContext", "getPropertyFromInitialContext"));
        }
        OCResolveConfiguration configuration = fileContext.getConfiguration();
        if (configuration == null) {
            return null;
        }
        OCInitialInclusionContext context = OCInitialInclusionContext.getInitialContext(fileContext);
        if (context == null) {
            OCLog.LOG.warn("getPropertyFromInitialContext is called for non-initial context");
            return null;
        }
        Object value = context.myPropertiesCache.get((Object)key);
        if (value != null) {
            return (T)value;
        }
        if (key.isFeature()) {
            value = OCCompilerKind.CLANG.equals((Object)configuration.getCompilerSettings().getCompiler(context.getLanguageKind())) ? context.isClangFeatureOrExtensionEnabled(key.getName()) : context.getLanguageStandard().supports(OCCompilerFeatures.getFeatureStandard(key.getName()));
        } else if (key.isMacroSize()) {
            OCMacroSymbol macro = context.getDefinition(key.getName());
            if (macro != null) {
                try {
                    short sizeInBits = Short.parseShort(macro.getSubstitution());
                    value = sizeInBits;
                }
                catch (NumberFormatException e) {
                    String message = "Bad size macro value:" + macro;
                    OCLog.LOG.error(message);
                }
            }
        } else if (key.isWarningOption()) {
            value = context.myCompilerSwitches.getCommandLineArgs().contains(key.getName());
        }
        if (value != null) {
            context.myPropertiesCache.put(key, value);
        }
        return (T)value;
    }

    @Override
    public void define(OCMacroSymbol def) {
        super.define(def);
        this.resetPropertyCache();
    }

    @Override
    public void undef(String name) {
        super.undef(name);
        this.resetPropertyCache();
    }

    private void resetPropertyCache() {
        this.myPropertiesCache.clear();
    }

    @Nullable
    private static OCInitialInclusionContext getInitialContext(@NotNull OCImmutableInclusionContext fileContext) {
        if (fileContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContext", "com/jetbrains/cidr/lang/preprocessor/OCInitialInclusionContext", "getInitialContext"));
        }
        while (!(fileContext instanceof OCInitialInclusionContext) && fileContext != null) {
            fileContext = fileContext.getParent();
        }
        return (OCInitialInclusionContext)fileContext;
    }
}

