/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCContextChangeSet {
    @NotNull
    private final String myText;
    @NotNull
    private TIntObjectHashMap<OCContextChange> myChangeMap;
    private int myLastOffset;
    private boolean myIsUpdated;
    private boolean myUsingOriginalMap;

    private OCContextChangeSet(@NotNull String text, @NotNull TIntObjectHashMap<OCContextChange> changeMap, boolean isUpdated, int lastOffset, boolean reusingMap) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet", "<init>"));
        }
        if (changeMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeMap", "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet", "<init>"));
        }
        this.myText = text;
        this.myIsUpdated = isUpdated;
        this.myChangeMap = changeMap;
        this.myLastOffset = lastOffset;
        this.myUsingOriginalMap = reusingMap;
    }

    public boolean isUpdated() {
        return this.myIsUpdated;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet", "getText"));
        }
        return string;
    }

    @Nullable
    public OCContextChange getChange(int offsetAfterInclude) {
        if (offsetAfterInclude > this.myLastOffset) {
            return null;
        }
        return (OCContextChange)this.myChangeMap.get(offsetAfterInclude);
    }

    public void setChange(int offsetAfterInclude, @NotNull OCContextChange change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet", "setChange"));
        }
        if (this.myUsingOriginalMap) {
            this.myUsingOriginalMap = false;
            this.myChangeMap = this.myChangeMap.clone();
        }
        if (offsetAfterInclude > this.myLastOffset) {
            this.myLastOffset = offsetAfterInclude;
        }
        this.myChangeMap.put(offsetAfterInclude, (Object)change);
        this.myIsUpdated = true;
    }

    @NotNull
    public static OCContextChangeSet reuse(@NotNull String newText, @Nullable OCContextChangeSet from, int validateFrom, int validateTo) {
        int diffOffset;
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet", "reuse"));
        }
        if (from == null) {
            OCContextChangeSet oCContextChangeSet = new OCContextChangeSet(newText, (TIntObjectHashMap<OCContextChange>)new TIntObjectHashMap(), true, 0, false);
            if (oCContextChangeSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet", "reuse"));
            }
            return oCContextChangeSet;
        }
        if (validateTo < 0) {
            validateTo = newText.length();
        }
        assert (validateFrom >= 0);
        assert (validateTo >= validateFrom && validateTo <= newText.length());
        int oldLastOffset = from.myLastOffset;
        String oldText = from.getText();
        validateTo = Math.min(oldText.length(), Math.min(validateTo, oldLastOffset + 1));
        if (validateTo == (diffOffset = (validateFrom = Math.min(validateTo, Math.min(Math.min(validateFrom, oldText.length()), newText.length()))) + StringUtil.commonPrefixLength((CharSequence)OCContextChangeSet.subSequence(oldText, validateFrom, validateTo), (CharSequence)OCContextChangeSet.subSequence(newText, validateFrom, newText.length())))) {
            OCContextChangeSet oCContextChangeSet = new OCContextChangeSet(newText, from.myChangeMap, false, oldLastOffset, true);
            if (oCContextChangeSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet", "reuse"));
            }
            return oCContextChangeSet;
        }
        final int[] loRef = new int[]{0};
        TIntObjectHashMap fromMap = from.myChangeMap.clone();
        fromMap.retainEntries((TIntObjectProcedure)new TIntObjectProcedure<OCContextChange>(){

            public boolean execute(int offset, OCContextChange change) {
                boolean valid;
                boolean bl = valid = change.getOffset() < diffOffset;
                if (valid && loRef[0] < offset) {
                    loRef[0] = offset;
                }
                return valid;
            }
        });
        int lastOffset = loRef[0];
        OCContextChangeSet oCContextChangeSet = new OCContextChangeSet(newText, (TIntObjectHashMap<OCContextChange>)fromMap, true, lastOffset, false);
        if (oCContextChangeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet", "reuse"));
        }
        return oCContextChangeSet;
    }

    @NotNull
    public List<OCContextChange> getChanges() {
        final ArrayList<OCContextChange> result2 = new ArrayList<OCContextChange>();
        this.myChangeMap.forEachValue((TObjectProcedure)new TObjectProcedure<OCContextChange>(){

            public boolean execute(OCContextChange object) {
                result2.add(object);
                return true;
            }
        });
        Collections.sort(result2, new Comparator<OCContextChange>(){

            @Override
            public int compare(@NotNull OCContextChange o1, @NotNull OCContextChange o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet$3", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet$3", "compare"));
                }
                return o1.getOffset() - o2.getOffset();
            }
        });
        ArrayList<OCContextChange> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet", "getChanges"));
        }
        return arrayList;
    }

    private static CharSequence subSequence(CharSequence seq, int start, int end) {
        return new CharSequenceSubSequence(seq, start, end);
    }
}

