/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLazyBlockStatementElementType;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafType;
import com.jetbrains.cidr.lang.preprocessor.OCMacroReferenceTokenType;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import gnu.trove.TLongByteHashMap;
import gnu.trove.TLongHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParsing {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.parser.OCParsing");
    private static final IElementType OBJC_CLASS_KEYWORD = new OCElementType("@class");
    public static final IElementType DUMB_ELEMENT_TYPE = new IElementType("DUMB WRAPPER", (Language)OCLanguage.getInstance());
    private static final String MSG_UNEXPECTED_END_OF_FILE = "Unexpected end of file";
    private final PsiBuilder myBuilder;
    private final IElementType myRootType;
    private final BlockParsingMode myBlocksParsingMode;
    private boolean myTemplateGTGT;
    private final boolean mySupportsAutosynthesis;
    private final boolean myDumbMode;
    private final boolean myHasNullabilityFeature;
    private MessagePassingContext myIsInMessagePassingParameter = MessagePassingContext.None;
    private boolean myIsInTemplateArgument = false;
    private boolean myIsInsideMacro = false;
    private boolean myIsInsideDirective = false;
    private boolean myIsInsideLoop = false;
    private boolean myIsInsideTypeNameParsing = false;
    private boolean myIsInsideDetectionMode = false;
    private boolean myIsCppSupport = true;
    private boolean myIsObjCSupport = true;
    @NotNull
    private OCParsingNameScope myLocalNameScope;
    @Nullable
    private List<String> myLastDeclaratorName;
    private String myLastDeclaratorSingleName;
    private int myParseUntilOffset = 0;
    private boolean myParsingInsideMacro;
    private boolean myDisableErrors = false;
    private final Map<Long, OCParsingNameScope.Kind> myTypeKindsCache;
    private final TLongByteHashMap myParseTypeFirstCache;
    private final TLongByteHashMap myTemplateArgumentListCache;
    private final TLongHashSet myNonTypeExpressionsCache;
    private final TLongHashSet myNonConstantExprInTemplateCache;
    private BlockParser BLOCK_STATEMENT_PARSER = new BlockParser(){

        @Override
        public void parseBlock() {
            OCParsing.this.parseCompoundStatement();
        }
    };
    private BlockParser TOP_LEVEL_DECLARATIONS_PARSER = new BlockParser(){

        @Override
        public void parseBlock() {
            OCParsing.this.advance();
            OCParsing.this.parseTopLevelDeclarationsUntilBrace();
        }
    };
    private static TokenSet COMMENTS_BINDABLE_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{OCElementTypes.STRUCTURE_TYPES, OCElementTypes.CLASSES, TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.DECLARATION, OCElementTypes.METHOD, OCElementTypes.FUNCTION_DEFINITION, OCElementTypes.FUNCTION_DECLARATION, OCElementTypes.PROPERTY, OCElementTypes.CLASS_PREDEF_LIST})});
    WhitespacesAndCommentsBinder COMMENT_BINDER = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            if (tokens.size() == 0) {
                return 0;
            }
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                IElementType tokenType = tokens.get(idx);
                if (tokenType == OCTokenTypes.BLOCK_COMMENT) {
                    return idx;
                }
                if (tokenType == OCTokenTypes.EOL_COMMENT) break;
            }
            int result2 = tokens.size();
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                IElementType tokenType = tokens.get(idx);
                if (OCTokenTypes.WHITESPACES.contains(tokenType)) {
                    if (StringUtil.getLineBreakCount((CharSequence)getter.get(idx)) <= 1) continue;
                    break;
                }
                if (OCTokenTypes.EOL_COMMENT != tokenType) break;
                if (!atStreamEdge && idx != 0 && (idx <= 0 || !OCTokenTypes.WHITESPACES.contains(tokens.get(idx - 1)) || !StringUtil.containsLineBreak((CharSequence)getter.get(idx - 1)))) continue;
                result2 = idx;
            }
            return result2;
        }
    };
    private static TokenSet USING_OR_NAMESPACE = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.USING_CPP_KEYWORD, OCTokenTypes.NAMESPACE_CPP_KEYWORD});
    private static TokenSet TEMPLATE_PARAMETER_SPECIFIERS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.TEMPLATE_CPP_KEYWORD, OCTokenTypes.TYPENAME_CPP_KEYWORD, OCTokenTypes.CLASS_KEYWORD});
    private static final TokenSet ourSemicolonSet = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.SEMICOLON});
    private static final TokenSet ourSemicolonOrRparSet = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.RPAR, OCTokenTypes.SEMICOLON});
    private static final TokenSet SPECIFIERS_FIRST = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.STORAGE_CLASS_SPECIFIERS, OCTokenTypes.TYPE_SPECIFIERS, OCTokenTypes.TYPE_QUALIFIERS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.INLINE_KEYWORD, OCTokenTypes.TYPEOF_KEYWORD, OCTokenTypes.DECLTYPE_CPP_KEYWORD, OCTokenTypes.UNDERLYING_TYPE_KEYWORD})});
    private static final TokenSet SINGLE_TOKEN_SPECIFIER = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.SIMPLE_TYPE_SPECIFIERS, OCTokenTypes.TYPE_QUALIFIERS, OCTokenTypes.STORAGE_CLASS_SPECIFIERS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.INLINE_KEYWORD})});
    private static final TokenSet BULLSHIT_TYPE_MODIFIERS = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.STORAGE_CLASS_SPECIFIERS, OCTokenTypes.TYPE_QUALIFIERS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.INLINE_KEYWORD, OCTokenTypes.FRIEND_CPP_KEYWORD, OCTokenTypes.VIRTUAL_CPP_KEYWORD, OCTokenTypes.EXPLICIT_CPP_KEYWORD, OCTokenTypes.MUTABLE_CPP_KEYWORD, OCTokenTypes.CONSTEXPR_CPP_KEYWORD})});
    private static final TokenSet CPP_ACCESS_SPECIFIERS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.PUBLIC_KEYWORD, OCTokenTypes.PROTECTED_KEYWORD, OCTokenTypes.PRIVATE_KEYWORD});
    private static final TokenSet CPP_ONLY_SPECIFIERS_FIRST = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.CLASS_KEYWORD, OCTokenTypes.BOOL_CPP_KEYWORD, OCTokenTypes.WCHAR_T_CPP_KEYWORD, OCTokenTypes.FRIEND_CPP_KEYWORD, OCTokenTypes.VIRTUAL_CPP_KEYWORD, OCTokenTypes.EXPLICIT_CPP_KEYWORD, OCTokenTypes.MUTABLE_CPP_KEYWORD, OCTokenTypes.TYPENAME_CPP_KEYWORD, OCTokenTypes.CONSTEXPR_CPP_KEYWORD});
    private static final TokenSet CPP_SPECIFIERS_FIRST = TokenSet.orSet((TokenSet[])new TokenSet[]{SPECIFIERS_FIRST, CPP_ONLY_SPECIFIERS_FIRST});
    private static final TokenSet CPP_EXPRESSIONS_FIRST = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.CPP_UNARY_OPERATIONS, OCTokenTypes.CPP_CAST_OPERATIONS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.TRUE_CPP_KEYWORD, OCTokenTypes.FALSE_CPP_KEYWORD, OCTokenTypes.NULL_CPP_KEYWORD})});
    private PsiBuilder.Marker myLastMacro;

    public OCParsing(PsiBuilder builder, IElementType rootType) {
        this(builder, rootType, BlockParsingMode.LAZY);
    }

    public OCParsing(PsiBuilder builder, IElementType rootType, BlockParsingMode blocksParsingMode) {
        this.myBuilder = builder;
        this.myRootType = rootType;
        this.myBlocksParsingMode = blocksParsingMode;
        this.myTypeKindsCache = new HashMap<Long, OCParsingNameScope.Kind>();
        this.myParseTypeFirstCache = new TLongByteHashMap();
        this.myNonTypeExpressionsCache = new TLongHashSet();
        this.myNonConstantExprInTemplateCache = new TLongHashSet();
        this.myTemplateArgumentListCache = new TLongByteHashMap();
        PsiBuilderImpl builderImpl = (PsiBuilderImpl)builder;
        if (builderImpl.getLexer() instanceof OCPreprocessingLexer) {
            OCPreprocessingLexer lexer = (OCPreprocessingLexer)builderImpl.getLexer();
            this.myDumbMode = false;
            OCInclusionContext globalContext = lexer.getContext();
            OCLanguageKind languageKind = globalContext.getLanguageKind();
            this.mySupportsAutosynthesis = OCCompilerHelper.supportsAutosynthesis(globalContext);
            this.myHasNullabilityFeature = OCCompilerHelper.supportsNullability(globalContext);
            this.myIsCppSupport = languageKind.isCpp();
            this.myIsObjCSupport = languageKind.isObjC();
            this.myLocalNameScope = globalContext.getNameScope().copy();
            this.myLocalNameScope.defineType("bool", false, false, -1);
            this.myLocalNameScope.defineType("wchar_t", false, false, -1);
            if (this.myIsObjCSupport) {
                this.myLocalNameScope.defineInterface("Class", -1);
            }
        } else {
            this.myDumbMode = true;
            this.mySupportsAutosynthesis = false;
            this.myHasNullabilityFeature = false;
            this.myIsCppSupport = false;
            this.myIsObjCSupport = false;
            this.myLocalNameScope = new OCParsingNameScope();
        }
    }

    public ASTNode parse() {
        assert (!this.myDumbMode);
        this.parseFileContents();
        return this.getTreeBuilt();
    }

    public ASTNode parseDumpFile() {
        assert (this.myDumbMode);
        PsiBuilder.Marker rootMarker = this.mark();
        ArrayList<DumbNodeInfo> markerStack = new ArrayList<DumbNodeInfo>();
        markerStack.add(new DumbNodeInfo(this.mark(), 0));
        while (!this.myBuilder.eof()) {
            DumbNodeInfo node = (DumbNodeInfo)markerStack.get(markerStack.size() - 1);
            while (node.childDepth > 0) {
                node = new DumbNodeInfo(this.mark(), node.childDepth - 1);
                markerStack.add(node);
            }
            IElementType type = this.myBuilder.getTokenType();
            this.myBuilder.advanceLexer();
            boolean forceClose = ((Object)((Object)OCTokenTypes.SEMICOLON)).equals(type);
            ++node.childCount;
            while (forceClose || node.childCount >= (node.childDepth > 0 ? 10 : 50)) {
                forceClose = false;
                markerStack.remove(markerStack.size() - 1);
                node.marker.done(DUMB_ELEMENT_TYPE);
                if (markerStack.isEmpty()) {
                    node = new DumbNodeInfo(node.marker.precede(), node.childDepth + 1);
                    markerStack.add(node);
                } else {
                    node = (DumbNodeInfo)markerStack.get(markerStack.size() - 1);
                }
                ++node.childCount;
            }
        }
        for (int i = markerStack.size() - 1; i >= 0; --i) {
            ((DumbNodeInfo)markerStack.get((int)i)).marker.done(DUMB_ELEMENT_TYPE);
        }
        rootMarker.done(this.myRootType);
        return this.getTreeBuilt();
    }

    public void parseFileContents() {
        assert (!this.myDumbMode);
        PsiBuilder.Marker rootMarker = this.mark();
        while (!this.eof()) {
            if (this.tryParseInlineNamespace()) continue;
            IElementType token = this.tt();
            if (OCTokenTypes.DIRECTIVES.contains(token)) {
                this.parseDirective();
            } else {
                if (token == OCTokenTypes.NAMESPACE_CPP_KEYWORD) {
                    this.parseNamespace();
                    continue;
                }
                if (this.tt() == OCTokenTypes.STATIC_ASSERT_KEYWORD) {
                    this.parseStaticAssert(this.mark());
                    continue;
                }
                if (this.parseClass() || this.parseImportModuleStatement() || this.parseCompatibilityAlias()) continue;
            }
            if (OBJC_CLASS_KEYWORD == token) {
                this.parseClassForeReflist();
                continue;
            }
            if (OCElementTypes.OBJC_ERROR_KEYWORD == token) {
                this.advance();
                continue;
            }
            if (OCTokenTypes.SEMICOLON == token) {
                this.advance();
                continue;
            }
            if (OCTokenTypes.__ASM_KEYWORD == token) {
                this.parseAsmStatement();
                continue;
            }
            boolean externBlockParsed = false;
            if (token == OCTokenTypes.EXTERN_KEYWORD) {
                externBlockParsed = this.tryParseExternBlock();
            }
            if (externBlockParsed || this.parseDeclaration(DeclarationContext.FILE) != DeclarationParsingResult.FAIL) continue;
            this.errorAndSkipToken("unexpected symbol", this.TOP_LEVEL_DECLARATIONS_PARSER, null);
        }
        rootMarker.done(this.myRootType);
    }

    private boolean tryParseInlineNamespace() {
        IElementType token = this.tt();
        if (this.myIsCppSupport && token == OCTokenTypes.INLINE_KEYWORD) {
            PsiBuilder.Marker start = this.mark();
            this.advance();
            if (this.tt() == OCTokenTypes.NAMESPACE_CPP_KEYWORD) {
                this.rollbackTo(start);
                this.parseNamespace();
                return true;
            }
            this.rollbackTo(start);
        }
        return false;
    }

    private boolean tryParseExternBlock() {
        PsiBuilder.Marker externBlock = this.mark();
        this.advance();
        if (this.tt() == OCTokenTypes.STRING_LITERAL) {
            while (this.tt() == OCTokenTypes.STRING_LITERAL) {
                this.advance();
            }
            boolean nestedExterns = false;
            if (this.tt() == OCTokenTypes.EXTERN_KEYWORD) {
                nestedExterns = this.tryParseExternBlock();
            }
            if (!nestedExterns) {
                if (this.tt() == OCTokenTypes.LBRACE) {
                    this.advance();
                    this.parseTopLevelDeclarationsUntilBrace();
                    this.expectToken(OCTokenTypes.RBRACE, "Expecting '}'");
                } else if (this.tt() == OCTokenTypes.SEMICOLON) {
                    this.advance();
                } else if (this.parseDeclaration(DeclarationContext.FILE) == DeclarationParsingResult.FAIL) {
                    this.errorAndSkipToken("Unexpected symbol", this.TOP_LEVEL_DECLARATIONS_PARSER, null);
                }
            }
            this.done(externBlock, OCElementTypes.CPP_EXTERN_BLOCK);
            return true;
        }
        this.rollbackTo(externBlock);
        return false;
    }

    private void parseTopLevelDeclarationsUntilBrace() {
        while (!this.eof() && this.tt() != OCTokenTypes.RBRACE) {
            if (this.tryParseInlineNamespace()) continue;
            IElementType token = this.tt();
            if (OCTokenTypes.DIRECTIVES.contains(token)) {
                this.parseDirective();
            } else {
                if (token == OCTokenTypes.NAMESPACE_CPP_KEYWORD) {
                    this.parseNamespace();
                    continue;
                }
                if (this.tt() == OCTokenTypes.STATIC_ASSERT_KEYWORD) {
                    this.parseStaticAssert(this.mark());
                    continue;
                }
                if (this.parseClass() || this.parseCompatibilityAlias()) continue;
            }
            if (OBJC_CLASS_KEYWORD == token) {
                this.parseClassForeReflist();
                continue;
            }
            if (OCTokenTypes.SEMICOLON == token) {
                this.advance();
                continue;
            }
            if (OCTokenTypes.__ASM_KEYWORD == token) {
                this.parseAsmStatement();
                continue;
            }
            boolean externBlockParsed = false;
            if (token == OCTokenTypes.EXTERN_KEYWORD) {
                externBlockParsed = this.tryParseExternBlock();
            }
            if (externBlockParsed || this.parseDeclaration(DeclarationContext.FILE) != DeclarationParsingResult.FAIL) continue;
            this.errorAndSkipToken("unexpected symbol", this.TOP_LEVEL_DECLARATIONS_PARSER, null);
        }
    }

    private void parseClassForeReflist() {
        new ClassParsingScope().parseClassForeReflist();
    }

    private void parseNamespace() {
        String name;
        PsiBuilder.Marker namespace = this.mark();
        boolean inline = false;
        if (this.tt() == OCTokenTypes.INLINE_KEYWORD) {
            inline = true;
            this.advance();
        }
        this.advance();
        if (this.tt() == OCTokenTypes.IDENTIFIER) {
            name = this.myBuilder.getTokenText();
            this.advance();
        } else {
            name = null;
        }
        this.parseAttributes();
        if (name != null && this.tt() == OCTokenTypes.EQ) {
            this.advance();
            this.parseNamespaceAliasReference(namespace, name);
            return;
        }
        OCParsingNameScope old = this.myLocalNameScope;
        if (name != null) {
            this.myLocalNameScope = this.myLocalNameScope.defineNamespace(name);
        }
        this.expectToken(OCTokenTypes.LBRACE, "Expecting '{'");
        this.parseTopLevelDeclarationsUntilBrace();
        this.expectToken(OCTokenTypes.RBRACE, "} expected");
        this.myLocalNameScope = old;
        if (inline && name != null) {
            this.myLocalNameScope.defineNamespaceUsing(name);
        }
        this.done(namespace, OCElementTypes.CPP_NAMESPACE);
    }

    private void parseNamespaceAliasReference(PsiBuilder.Marker namespace, String name) {
        PsiBuilder.Marker ref = this.mark();
        String singleName = this.myBuilder.getTokenText();
        List<String> ident = this.parseQualifiedCppType();
        if (ident != null) {
            this.myLocalNameScope.defineNamespaceAlias(name, ident);
        } else {
            this.myLocalNameScope.defineNamespaceAlias(name, singleName);
        }
        this.done(ref, OCElementTypes.REFERENCE_ELEMENT);
        this.expectToken(OCTokenTypes.SEMICOLON, "Expecting ';'");
        this.done(namespace, OCElementTypes.CPP_NAMESPACE_ALIAS);
    }

    private void parseNamespaceAliasStatement(PsiBuilder.Marker start) {
        assert (this.tt() == OCTokenTypes.NAMESPACE_CPP_KEYWORD);
        this.advance();
        String name = this.myBuilder.getTokenText();
        this.expectToken(OCTokenTypes.IDENTIFIER, "Expecting identifier");
        this.expectToken(OCTokenTypes.EQ, "Expecting '='");
        this.parseNamespaceAliasReference(start, name);
    }

    private void parseStaticAssert(PsiBuilder.Marker start) {
        assert (this.tt() == OCTokenTypes.STATIC_ASSERT_KEYWORD);
        this.advance();
        if (this.tt() == OCTokenTypes.LPAR) {
            this.parseExpressionList();
        } else {
            this.error("Expected '('");
        }
        this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
        this.done(start, OCElementTypes.CPP_STATIC_ASSERT_STATEMENT);
    }

    @Nullable
    public ASTNode parseExpressionText() {
        assert (!this.myDumbMode);
        PsiBuilder.Marker rootMarker = this.mark();
        this.parseExpression(true);
        while (!this.eof()) {
            this.errorAndSkipToken("unexpected symbol", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE);
        }
        rootMarker.done(this.myRootType);
        return this.getTreeBuilt();
    }

    @Nullable
    public ASTNode parseExpressionOrStatementsText() {
        assert (!this.myDumbMode);
        PsiBuilder.Marker rootMarker = this.mark();
        this.parseExpression(true);
        while (!this.eof()) {
            this.rollbackTo(rootMarker);
            rootMarker = this.mark();
            OCParsingNameScope old = this.myLocalNameScope;
            this.myLocalNameScope = this.myLocalNameScope.defineLocalScope();
            while (!this.eof()) {
                this.parseStatement(true);
            }
            this.myLocalNameScope = this.myLocalNameScope.dropAndGetParent();
            LOG.assertTrue(this.myLocalNameScope == old);
            while (!this.eof()) {
                this.errorAndSkipToken("unexpected symbol", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE);
            }
        }
        rootMarker.done(this.myRootType);
        return this.getTreeBuilt();
    }

    protected ASTNode getTreeBuilt() {
        return this.myBuilder.getTreeBuilt();
    }

    @Nullable
    public ASTNode parseTypeText() {
        assert (!this.myDumbMode);
        PsiBuilder.Marker rootMarker = this.mark();
        this.parseTypeExpression();
        while (!this.eof()) {
            this.errorAndSkipToken("unexpected symbol", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE);
        }
        rootMarker.done(this.myRootType);
        return this.getTreeBuilt();
    }

    private String expectIdentifier_lexerHack(String message, boolean isTemplate, boolean isObjClass, boolean isObjCProtocol, boolean isFriend) {
        if (OCTokenTypes.IDENTIFIER == this.tt()) {
            String text = this.myBuilder.getTokenText();
            if (isObjClass) {
                this.myLocalNameScope.defineInterface(text, this.myBuilder.getCurrentOffset());
            } else if (isObjCProtocol) {
                this.myLocalNameScope.defineProtocol(text, this.myBuilder.getCurrentOffset());
            } else {
                this.myLocalNameScope.defineType(text, isTemplate, isFriend, this.myBuilder.getCurrentOffset());
            }
            this.advance();
            return text;
        }
        this.error(message);
        return null;
    }

    private void parseSynthesizedPropertiesList() {
        assert (this.tt() == OCTokenTypes.SYNTHESIZE_KEYWORD || this.tt() == OCTokenTypes.DYNAMIC_KEYWORD);
        boolean isDynamic = this.tt() == OCTokenTypes.DYNAMIC_KEYWORD;
        PsiBuilder.Marker dcl = this.mark();
        this.advance();
        while (true) {
            PsiBuilder.Marker declarator = this.mark();
            PsiBuilder.Marker property = this.mark();
            this.expectToken(OCTokenTypes.IDENTIFIER, "Expecting property name");
            this.done(property, OCElementTypes.REFERENCE_ELEMENT);
            if (this.tt() == OCTokenTypes.EQ) {
                if (isDynamic) {
                    this.error("Instance variable reference is not allowed in '@dynamic'");
                }
                this.advance();
                PsiBuilder.Marker ivar = this.mark();
                this.expectToken(OCTokenTypes.IDENTIFIER, "Expecting ivar name");
                this.done(ivar, OCElementTypes.REFERENCE_ELEMENT);
            }
            this.done(declarator, OCElementTypes.SYNTHESIZED_PROPERTY);
            if (this.tt() != OCTokenTypes.COMMA) break;
            this.advance();
        }
        this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
        this.done(dcl, OCElementTypes.SYNTHESIZED_PROPERTIES_LIST);
    }

    private void skipTokenUntil(IElementType element) {
        PsiBuilder.Marker mark = this.mark();
        while (this.tt() != null && this.tt() != element) {
            this.advance();
        }
        this.done(mark, OCElementTypes.UNKNOWN_CPP_CODE);
    }

    private boolean skipBlock(IElementType open2, IElementType close, final boolean parseMacroCalls) {
        return OCLazyBlockStatementElementType.isSafeBlock(new Producer<IElementType>(){

            @Nullable
            public IElementType produce() {
                IElementType tt;
                if (parseMacroCalls) {
                    tt = OCParsing.this.tt();
                    OCParsing.this.advance();
                } else {
                    tt = OCParsing.this.myBuilder.getTokenType();
                    OCParsing.this.myBuilder.advanceLexer();
                }
                return tt;
            }
        }, open2, close);
    }

    private boolean parseCompatibilityAlias() {
        if (this.tt() != OCTokenTypes.COMPATIBILITY_ALIAS_KEYWORD) {
            return false;
        }
        PsiBuilder.Marker alias = this.mark();
        this.advance();
        if (this.expectToken(OCTokenTypes.IDENTIFIER, "Alias name expected")) {
            PsiBuilder.Marker ref = this.mark();
            if (this.expectToken(OCTokenTypes.IDENTIFIER, "Class name expected")) {
                this.done(ref, OCElementTypes.REFERENCE_ELEMENT);
                this.expectToken(OCTokenTypes.SEMICOLON, "Expecting ';'");
                this.done(alias, OCElementTypes.COMPATIBILITY_ALIAS);
                return true;
            }
            ref.drop();
        }
        if (this.tt() == OCTokenTypes.SEMICOLON) {
            this.advance();
        }
        this.done(alias, OCElementTypes.COMPATIBILITY_ALIAS);
        return true;
    }

    private boolean parseClass() {
        return new ClassParsingScope().parseClass();
    }

    public AngleBracketedExpressionType detectAngleBracketedExpressionType() {
        IElementType tt;
        boolean isAngleBracketedExpression = this.detectAngleBracketedExpression(true);
        if (!isAngleBracketedExpression) {
            return AngleBracketedExpressionType.NOT_AN_ANGLE_BRACKETED_EXPRESSION;
        }
        boolean definitelyNotProtocolList = false;
        boolean containsOnlyProtocols = true;
        PsiBuilder.Marker mark = this.mark();
        int depth = 1;
        this.advance();
        do {
            if ((tt = this.tt()) == OCTokenTypes.CONTRAVARIANT_KEYWORD || tt == OCTokenTypes.COVARIANT_KEYWORD || tt == OCTokenTypes.COLON) {
                this.rollbackTo(mark);
                return AngleBracketedExpressionType.GENERIC_PARAMETER_LIST;
            }
            definitelyNotProtocolList |= tt == OCTokenTypes.LT || tt == OCTokenTypes.MUL;
            if (tt == OCTokenTypes.IDENTIFIER) {
                containsOnlyProtocols = containsOnlyProtocols && this.myLocalNameScope.isProtocol(this.myBuilder.getTokenText());
            }
            depth = this.adjustDepth(depth, tt);
            this.advance();
        } while (depth > 0);
        tt = this.tt();
        this.rollbackTo(mark);
        if (depth == 0 && (tt == OCTokenTypes.COLON || tt == OCTokenTypes.LPAR)) {
            return AngleBracketedExpressionType.GENERIC_PARAMETER_LIST;
        }
        if (definitelyNotProtocolList) {
            return AngleBracketedExpressionType.GENERIC_ARGUMENT_LIST;
        }
        if (containsOnlyProtocols) {
            return AngleBracketedExpressionType.PROTOCOL_LIST;
        }
        return AngleBracketedExpressionType.UNKNOWN;
    }

    private int adjustDepth(int depth, IElementType tt) {
        if (tt == OCTokenTypes.LT) {
            ++depth;
        }
        if (tt == OCTokenTypes.GT) {
            --depth;
        }
        if (tt == OCTokenTypes.GTGT) {
            depth -= 2;
        }
        return depth;
    }

    private int detectAngleBracketedExpressionCount() {
        PsiBuilder.Marker mark = this.mark();
        int answer = 0;
        while (this.detectAngleBracketedExpression(false)) {
            ++answer;
        }
        this.rollbackTo(mark);
        return answer;
    }

    private boolean detectAngleBracketedExpression(boolean rollbackAfterCheck) {
        boolean isBracketedExpression = false;
        PsiBuilder.Marker mark = this.mark();
        int depth = 0;
        if (this.tt() == OCTokenTypes.LT) {
            ++depth;
            this.advance();
            do {
                IElementType tt = this.tt();
                depth = this.adjustDepth(depth, tt);
                if (!OCTokenTypes.ANGLE_BRACKETED_EXPRESSION_TOKENS.contains(tt)) break;
                this.advance();
            } while (depth > 0);
            boolean bl = isBracketedExpression = depth <= 0;
        }
        if (rollbackAfterCheck) {
            this.rollbackTo(mark);
        }
        return isBracketedExpression;
    }

    private boolean parseGenericRestriction() {
        if (this.tt() != OCTokenTypes.COLON) {
            return false;
        }
        this.advance();
        boolean result2 = this.parseTypeExpression(DeclarationContext.PARAMETER_LIST, TypeParsingExpectation.ANY);
        if (!result2) {
            this.error("Expected a type");
        }
        return result2;
    }

    private boolean parseGenericArguments(boolean isArgumentForSure) {
        if (this.tt() != OCTokenTypes.LT) {
            return false;
        }
        if (this.detectAngleBracketedExpressionType() == AngleBracketedExpressionType.PROTOCOL_LIST) {
            return false;
        }
        PsiBuilder.Marker list = this.mark();
        this.advance();
        while (true) {
            PsiBuilder.Marker argument = this.mark();
            if (!this.parseTypeExpression(DeclarationContext.PARAMETER_LIST, TypeParsingExpectation.ONLY_TYPES)) {
                if (isArgumentForSure) {
                    this.parseTypeExpression(DeclarationContext.PARAMETER_LIST, TypeParsingExpectation.ANY);
                } else {
                    argument.drop();
                    this.rollbackTo(list);
                    return false;
                }
            }
            this.done(argument, OCElementTypes.GENERIC_ARGUMENT);
            if (this.tt() != OCTokenTypes.COMMA) break;
            this.advance();
        }
        this.expectGt();
        this.done(list, OCElementTypes.GENERIC_ARGUMENTS_LIST);
        return true;
    }

    private boolean parseImportModuleStatement() {
        if (this.tt() != OCTokenTypes.IMPORT_MODULE_KEYWORD) {
            return false;
        }
        PsiBuilder.Marker mark = this.mark();
        this.advance();
        if (this.expectToken(OCTokenTypes.IDENTIFIER, "Module name expected")) {
            while (this.baseToken() == OCTokenTypes.DOT) {
                this.advance();
                if (this.expectToken(OCTokenTypes.IDENTIFIER, "Module name expected")) continue;
            }
        }
        if (this.baseToken() == OCTokenTypes.SEMICOLON) {
            this.advance();
        }
        this.done(mark, OCElementTypes.IMPORT_MODULE_STATEMENT);
        return true;
    }

    private void parseProperty() {
        assert (this.tt() == OCTokenTypes.PROPERTY_KEYWORD);
        PsiBuilder.Marker propertyMarker = this.mark();
        this.advance();
        if (this.tt() == OCTokenTypes.LPAR) {
            this.parsePropertyAttributes();
        }
        if (this.parseDeclaration(DeclarationContext.FILE, true, false, true, false) == DeclarationParsingResult.FAIL) {
            this.error("Property declaration expected");
        }
        this.done(propertyMarker, OCElementTypes.PROPERTY);
    }

    private void parsePropertyAttributes() {
        assert (this.tt() == OCTokenTypes.LPAR);
        PsiBuilder.Marker list = this.mark();
        this.advance();
        if (this.tt() != OCTokenTypes.RPAR) {
            while (true) {
                PsiBuilder.Marker attribute = this.mark();
                this.expectToken(OCTokenTypes.IDENTIFIER, "Attribute name expected");
                if (this.tt() == OCTokenTypes.EQ) {
                    this.advance();
                    if (this.tt() == OCTokenTypes.TEMPLATE_START_MARK) {
                        PsiBuilder.Marker placeholderExpression = this.mark();
                        do {
                            this.advance();
                        } while (this.tt() != OCTokenTypes.TEMPLATE_STOP_MARK && this.tt() != null);
                        this.advance();
                        this.done(placeholderExpression, OCElementTypes.LITERAL_EXPRESSION);
                    } else {
                        this.expectToken(OCTokenTypes.IDENTIFIER, "Attribute value expected");
                    }
                    if (this.tt() == OCTokenTypes.COLON) {
                        this.advance();
                    }
                }
                this.done(attribute, OCElementTypes.PROPERTY_ATTRIBUTE);
                if (this.tt() != OCTokenTypes.COMMA) break;
                this.advance();
            }
        }
        this.expectToken(OCTokenTypes.RPAR, "Missing ')'");
        this.done(list, OCElementTypes.PROPERTY_ATTRIBUTES_LIST);
    }

    private void parseTypeInParens(boolean isInMethodSignature) {
        this.expectToken(OCTokenTypes.LPAR, "Expecting '('");
        if (!this.parseTypeExpression(DeclarationContext.PARAMETER_LIST, TypeParsingExpectation.ANY, isInMethodSignature)) {
            this.error("Expecting type");
        }
        if (this.tt() == OCTokenTypes.IDENTIFIER && this.myBuilder.lookAhead(1) == OCTokenTypes.RPAR) {
            this.errorAndSkipToken("Unexpected token", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE);
        }
        this.expectToken(OCTokenTypes.RPAR, "Expecting ')'");
    }

    private boolean tryParseTypeInParens(TypeParsingExpectation typeExpectation) {
        PsiBuilder.Marker startMarker = this.mark();
        if (this.tt() != OCTokenTypes.LPAR) {
            startMarker.drop();
            return false;
        }
        this.advance();
        if (!this.parseTypeExpression(DeclarationContext.PARAMETER_LIST, typeExpectation) || this.tt() != OCTokenTypes.RPAR) {
            this.rollbackTo(startMarker);
            return false;
        }
        this.advance();
        startMarker.drop();
        return true;
    }

    private boolean tryParseParamDeclaration() {
        PsiBuilder.Marker startMarker = this.mark();
        if (this.tt() != OCTokenTypes.LPAR) {
            startMarker.drop();
            return false;
        }
        this.advance();
        if (!this.parseParameterDeclaration(false, TypeParsingExpectation.ONLY_TYPES) || this.tt() != OCTokenTypes.RPAR && this.tt() != OCTokenTypes.COMMA) {
            this.rollbackTo(startMarker);
            return false;
        }
        this.advance();
        startMarker.drop();
        return true;
    }

    private boolean parseTypeExpression() {
        return this.parseTypeExpression(DeclarationContext.PARAMETER_LIST, TypeParsingExpectation.ANY);
    }

    private boolean parseTypeExpression(DeclarationContext context, TypeParsingExpectation typeExpectation) {
        return this.parseTypeExpression(context, typeExpectation, false);
    }

    private boolean parseTypeExpression(DeclarationContext context, TypeParsingExpectation typeExpectation, boolean isInMethodSignature) {
        PsiBuilder.Marker typeElement = this.mark();
        IElementType tt = this.tt();
        if (OCTokenTypes.BRIDGE_CAST_KEYWORDS.contains(tt)) {
            this.advance();
            typeElement.drop();
            typeElement = this.mark();
            tt = this.tt();
        }
        if (isInMethodSignature) {
            while (this.tt() == OCTokenTypes.IDENTIFIER) {
                String text = this.myBuilder.getTokenText();
                if (OCElementTypes.PARAMETER_TYPE_QUALIFIERS.contains((Object)text)) {
                    this.advance();
                    continue;
                }
                if (!this.myHasNullabilityFeature || !OCElementTypes.PARAMETER_TYPE_NULLABILITY_QUALIFIERS.contains((Object)text) && !"null_unspecified".equals(text)) break;
                if ("nullable".equals(text)) {
                    this.remapCurrentToken(OCTokenTypes.NULLABLE_KEYWORD);
                }
                if ("nonnull".equals(text)) {
                    this.remapCurrentToken(OCTokenTypes.NONNULL_KEYWORD);
                }
                if ("null_unspecified".equals(text)) {
                    this.remapCurrentToken(OCTokenTypes.NULL_UNSPECIFIED_KEYWORD);
                }
                this.advance();
            }
        }
        if (!this.parseTypeName(context, typeExpectation)) {
            this.rollbackTo(typeElement);
            return false;
        }
        this.done(typeElement, OCElementTypes.TYPE_ELEMENT);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMethod() {
        if (this.tt() != OCTokenTypes.MINUS && this.tt() != OCTokenTypes.PLUS) {
            this.error("Method declaration expected after @optional keyword");
            return;
        }
        PsiBuilder.Marker method = this.mark();
        boolean wasParam = false;
        this.advance();
        try {
            boolean hasSemicolon;
            if (this.tt() == OCTokenTypes.LPAR) {
                this.parseTypeInParens(true);
            }
            this.parseAttributes();
            PsiBuilder.Marker selectorPart = this.mark();
            IElementType tt = this.tt();
            if (this.isValidSelectorName(tt)) {
                if (tt != OCTokenTypes.IDENTIFIER) {
                    this.remapCurrentToken(OCTokenTypes.IDENTIFIER);
                }
                this.advance();
            } else {
                this.error("Expecting method name");
            }
            while (this.tt() == OCTokenTypes.COLON) {
                this.advance();
                if (this.tt() == OCTokenTypes.LPAR) {
                    this.parseTypeInParens(true);
                }
                this.parseAttributes();
                if (this.tt() == OCTokenTypes.IDENTIFIER) {
                    this.myLocalNameScope.defineValue(this.myBuilder.getTokenText(), false, this.myBuilder.getCurrentOffset());
                }
                this.expectToken(OCTokenTypes.IDENTIFIER, "Expecting parameter name");
                if (this.isValidSelectorName(tt) || this.tt() == OCTokenTypes.COLON) {
                    this.done(selectorPart, OCElementTypes.METHOD_SELECTOR_PART);
                    selectorPart = this.mark();
                    wasParam = true;
                    IElementType tt1 = this.tt();
                    if (!this.isValidSelectorName(tt1)) continue;
                    if (tt1 != OCTokenTypes.IDENTIFIER) {
                        this.remapCurrentToken(OCTokenTypes.IDENTIFIER);
                    }
                    this.advance();
                    continue;
                }
                if (this.tt() != OCTokenTypes.RPAR) break;
                this.errorAndSkipToken("Unexpected token", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE);
            }
            if (wasParam) {
                selectorPart.drop();
            } else {
                this.done(selectorPart, OCElementTypes.METHOD_SELECTOR_PART);
            }
            while (this.tt() == OCTokenTypes.COMMA) {
                this.advance();
                if (this.tt() == OCTokenTypes.ELLIPSIS) {
                    this.advance();
                    continue;
                }
                this.parseParameterDeclaration(false);
            }
            while (this.tt() == OCTokenTypes.__ASM_KEYWORD || this.tt() == OCTokenTypes.__ATTRIBUTE_KEYWORD) {
                this.parseGccAttrubutes();
            }
            boolean bl = hasSemicolon = this.tt() == OCTokenTypes.SEMICOLON;
            if (hasSemicolon) {
                this.advance();
            }
            if (this.tt() == OCTokenTypes.LBRACE) {
                this.parseOrSkipCompoundStatement(true);
            } else if (!hasSemicolon) {
                this.error("Expecting ';' or method body");
            }
        }
        finally {
            this.done(method, OCElementTypes.METHOD);
        }
    }

    private PsiBuilder.Marker parseMemberVariables(PsiBuilder.Marker stubsEnd) {
        if (this.tt() == OCTokenTypes.LBRACE) {
            PsiBuilder.Marker members = this.mark();
            this.advance();
            while (this.tt() != OCTokenTypes.RBRACE && this.tt() != null) {
                if (OCTokenTypes.IVAR_VISIBILITY_KEYWORDS.contains(this.tt()) || this.tt() == OCElementTypes.OBJC_ERROR_KEYWORD) {
                    this.advance();
                    continue;
                }
                if (this.tryMarkStructFieldDeclaration(null, true)) continue;
                if (this.tt() == OCTokenTypes.RBRACE) break;
                this.errorAndSkipToken("Expecting member variable", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE);
            }
            this.expectToken(OCTokenTypes.RBRACE, "Missing '}'");
            this.done(members, OCElementTypes.INSTANCE_VARIABLES_LIST);
            stubsEnd.drop();
            return this.mark();
        }
        stubsEnd.precede().doneBefore((IElementType)OCElementTypes.INSTANCE_VARIABLES_LIST, stubsEnd);
        return stubsEnd;
    }

    private DeclarationParsingResult parseDeclaration(DeclarationContext context) {
        return this.parseDeclaration(context, true, false, false);
    }

    private DeclarationParsingResult parseDeclaration(DeclarationContext context, boolean withSemicolon, boolean failOnEmptyOrError, boolean requireInitializer) {
        return this.parseDeclaration(context, withSemicolon, failOnEmptyOrError, false, requireInitializer);
    }

    private DeclarationParsingResult parseDeclaration(DeclarationContext context, boolean withSemicolon, boolean failOnEmptyOrError, boolean isProperty, boolean requireInitializer) {
        PsiBuilder.Marker declarationMarker = this.mark();
        this.parseAttributes();
        ArrayList<String> localTypenames = null;
        ArrayList localTypenamesKind = null;
        boolean isTemplate = false;
        while (OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES.contains(this.tt()) || !this.myIsCppSupport && this.tt() == OCTokenTypes.AUTO_KEYWORD) {
            this.advance();
        }
        while (this.tt() == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
            isTemplate = true;
            if (localTypenames == null) {
                localTypenames = new ArrayList<String>();
                localTypenamesKind = new ArrayList();
            }
            this.parseTemplateParameterList(localTypenames, localTypenamesKind);
        }
        if (isTemplate && this.tt() == OCTokenTypes.SEMICOLON) {
            declarationMarker.drop();
            return DeclarationParsingResult.PARSED;
        }
        if (this.tt() == OCTokenTypes.USING_CPP_KEYWORD) {
            this.parseUsingStatement(declarationMarker, isTemplate);
            return DeclarationParsingResult.PARSED;
        }
        while (OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES.contains(this.tt()) || !this.myIsCppSupport && this.tt() == OCTokenTypes.AUTO_KEYWORD) {
            this.advance();
        }
        this.parseAttributes();
        IElementType first = this.tt();
        boolean isTypedef = first == OCTokenTypes.TYPEDEF_KEYWORD;
        boolean sureThatsDeclaration = first != OCTokenTypes.IDENTIFIER && CPP_SPECIFIERS_FIRST.contains(first);
        DeclarationContext effectiveContext = sureThatsDeclaration ? DeclarationContext.FILE : context;
        TypeParsingResult typeResult = this.parseDeclarationSpecifiers(effectiveContext, isTypedef, isTemplate, false, failOnEmptyOrError ? TypeParsingExpectation.NON_VALUES : TypeParsingExpectation.ANY);
        if (typeResult == TypeParsingResult.NONE) {
            declarationMarker.drop();
            this.error("Expecting type");
            return DeclarationParsingResult.FAIL;
        }
        if (typeResult == TypeParsingResult.EMPTY_TYPE_PARSED && failOnEmptyOrError) {
            declarationMarker.drop();
            return DeclarationParsingResult.FAIL;
        }
        if ((sureThatsDeclaration |= typeResult == TypeParsingResult.TYPE_PARSED_FOR_SURE) && typeResult != TypeParsingResult.EMPTY_TYPE_PARSED) {
            typeResult = TypeParsingResult.TYPE_PARSED_FOR_SURE;
        }
        IElementType declFirst = this.tt();
        DeclaratorsParsingResult parseResult = this.parseDeclarators(effectiveContext, isTypedef, isTemplate, typeResult, requireInitializer, isProperty, null);
        if (!parseResult.myType.isOk()) {
            if (failOnEmptyOrError && typeResult != TypeParsingResult.TYPE_PARSED_FOR_SURE) {
                declarationMarker.drop();
                return DeclarationParsingResult.FAIL;
            }
            if (this.tt() != OCTokenTypes.SEMICOLON) {
                if (context == DeclarationContext.FILE || sureThatsDeclaration && (declFirst == OCTokenTypes.MUL || declFirst == OCTokenTypes.IDENTIFIER || declFirst == OCTokenTypes.RBRACE)) {
                    this.error("Declarator expected");
                    this.done(declarationMarker, OCElementTypes.DECLARATION);
                    return DeclarationParsingResult.PARSED_WITHOUT_SEMICOLON;
                }
                declarationMarker.drop();
                return DeclarationParsingResult.FAIL;
            }
        }
        this.parseCpp11Attributes();
        boolean wasError = false;
        boolean KRStyle = false;
        if (!this.myIsCppSupport && context == DeclarationContext.FILE && this.tt() != OCTokenTypes.LBRACE && this.tt() != OCTokenTypes.SEMICOLON) {
            PsiBuilder.Marker start = this.mark();
            DeclarationParsingResult parsingResult = this.parseDeclaration(DeclarationContext.PARAMETER_LIST, true, false, requireInitializer);
            this.rollbackTo(start);
            if (parsingResult == DeclarationParsingResult.PARSED) {
                KRStyle = true;
                this.parseKandRParameterList();
            }
        }
        if (this.tt() == OCTokenTypes.LBRACE) {
            List<String> name = this.myLastDeclaratorName;
            String singleName = this.myLastDeclaratorSingleName;
            this.enterNamespaceOfDeclarator(name, singleName);
            this.myLastDeclaratorSingleName = null;
            this.parseOrSkipCompoundStatement(false);
            while (this.tt() == OCTokenTypes.CATCH_KEYWORD) {
                this.parseCatchSection();
            }
            this.leaveNamespaceOfDeclarator(name, singleName);
            this.done(declarationMarker, KRStyle ? OCElementTypes.FUNCTION_KR_DEFINITION : OCElementTypes.FUNCTION_DEFINITION);
        } else {
            if (this.tt() == OCTokenTypes.SEMICOLON) {
                if (withSemicolon) {
                    this.advance();
                }
            } else if (withSemicolon) {
                wasError = true;
                this.error("Missing ;");
            }
            boolean function = !isTypedef && parseResult.myType == DeclaratorsParsingResult.Type.PARSED_FUNCTION;
            this.done(declarationMarker, function ? OCElementTypes.FUNCTION_DECLARATION : OCElementTypes.DECLARATION);
        }
        return wasError ? DeclarationParsingResult.PARSED_WITHOUT_SEMICOLON : DeclarationParsingResult.PARSED;
    }

    private void parseUsingStatement(PsiBuilder.Marker start, boolean isTemplate) {
        assert (this.tt() == OCTokenTypes.USING_CPP_KEYWORD);
        this.advance();
        if (this.tt() == OCTokenTypes.NAMESPACE_CPP_KEYWORD) {
            this.advance();
            PsiBuilder.Marker ref = this.mark();
            String singleName = this.myBuilder.getTokenText();
            List<String> qualifiedName = this.parseQualifiedCppType();
            if (qualifiedName != null) {
                this.myLocalNameScope.defineNamespaceUsing(qualifiedName);
            } else if (singleName != null) {
                this.myLocalNameScope.defineNamespaceUsing(singleName);
            }
            this.done(ref, OCElementTypes.REFERENCE_ELEMENT);
            this.parseAttributes();
            this.expectToken(OCTokenTypes.SEMICOLON, "Expecting ';'");
        } else {
            PsiBuilder.Marker ref = this.mark();
            String singleName = this.myBuilder.getTokenText();
            List<String> qualifiedName = this.parseQualifiedCppType();
            if (this.tt() == OCTokenTypes.EQ) {
                ref.drop();
                this.advance();
                this.parseTypeExpression();
                if (qualifiedName != null) {
                    this.myLocalNameScope.defineType(qualifiedName.get(0), isTemplate, false, this.myBuilder.getCurrentOffset());
                } else if (singleName != null) {
                    this.myLocalNameScope.defineType(singleName, isTemplate, false, this.myBuilder.getCurrentOffset());
                }
            } else {
                if (qualifiedName != null) {
                    this.myLocalNameScope.defineSymbolUsing(qualifiedName);
                } else if (singleName != null) {
                    this.myLocalNameScope.defineSymbolUsing(singleName);
                }
                this.done(ref, OCElementTypes.REFERENCE_ELEMENT);
            }
        }
        this.done(start, OCElementTypes.CPP_USING_STATEMENT);
    }

    private void parseTemplateParameterList(List<String> result2, List<OCParsingNameScope.Kind> kinds) {
        this.advance();
        if (this.tt() == OCTokenTypes.LT) {
            PsiBuilder.Marker paramlist = this.mark();
            this.advance();
            boolean first = true;
            while (!this.eof() && this.tt() != OCTokenTypes.GT && this.tt() != OCTokenTypes.GTGT) {
                if (!first) {
                    this.expectToken(OCTokenTypes.COMMA, ", expected");
                }
                first = false;
                if (this.parseTemplateParameterDeclaration(result2, kinds)) continue;
            }
            this.expectGt();
            this.done(paramlist, OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST);
        }
    }

    private boolean parseTemplateParameterDeclaration(List<String> typenames, List<OCParsingNameScope.Kind> kinds) {
        if (this.tt() == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
            this.parseTemplateParameterList(null, null);
        }
        if (TEMPLATE_PARAMETER_SPECIFIERS.contains(this.tt())) {
            PsiBuilder.Marker templateParameter = this.mark();
            this.advance();
            if (this.tt() == OCTokenTypes.ELLIPSIS) {
                this.advance();
            }
            boolean isQualifiedName = false;
            if (this.tt() == OCTokenTypes.IDENTIFIER) {
                if (typenames != null) {
                    String typename = this.myBuilder.getTokenText();
                    typenames.add(typename);
                    kinds.add(this.myLocalNameScope.defineType(typename, true, false, this.myBuilder.getCurrentOffset()));
                }
                boolean bl = isQualifiedName = this.parseQualifiedCppType() != null;
            }
            if (this.tt() == OCTokenTypes.EQ) {
                this.advance();
                if (isQualifiedName) {
                    this.parseConstantExpressionInTemplate();
                } else {
                    this.parseTypeExpression();
                }
            }
            if (this.tt() != OCTokenTypes.GT && this.tt() != OCTokenTypes.GTGT && this.tt() != OCTokenTypes.COMMA) {
                templateParameter.rollbackTo();
                return this.parseParameterDeclaration(true);
            }
            this.done(templateParameter, OCElementTypes.CPP_TYPE_PARAMETER_DECLARATION);
            return true;
        }
        return this.parseParameterDeclaration(true);
    }

    private void parseOrSkipCompoundStatement(boolean addSelfAsVariable) {
        PsiBuilder.Marker stmt = this.mark();
        if (this.myBlocksParsingMode != BlockParsingMode.EAGER && this.skipBlock(OCTokenTypes.LBRACE, OCTokenTypes.RBRACE, false)) {
            stmt.collapse((IElementType)OCElementTypes.LAZY_BLOCK_STATEMENT);
        } else {
            stmt.rollbackTo();
            this.parseCompoundStatement(addSelfAsVariable, true);
        }
    }

    private void parseCompoundStatement() {
        this.parseCompoundStatement(false, true);
    }

    public void parseCompoundStatement(boolean addSelfAsVariable, boolean enterLocalScope) {
        PsiBuilder.Marker stmt = this.mark();
        if (this.myBlocksParsingMode != BlockParsingMode.SKIP) {
            this.expectToken(OCTokenTypes.LBRACE, "{ expected");
            OCParsingNameScope old = this.myLocalNameScope;
            if (enterLocalScope) {
                this.myLocalNameScope = this.myLocalNameScope.defineLocalScope();
            }
            if (addSelfAsVariable) {
                this.myLocalNameScope.defineValue("self", false, this.myBuilder.getCurrentOffset());
            }
            while (!this.eof() && this.tt() != OCTokenTypes.RBRACE) {
                this.parseStatement(true);
            }
            if (enterLocalScope) {
                this.myLocalNameScope = this.myLocalNameScope.dropAndGetParent();
                LOG.assertTrue(this.myLocalNameScope == old);
            }
            if (this.eof()) {
                this.error(MSG_UNEXPECTED_END_OF_FILE);
            } else {
                this.advance();
            }
        } else {
            this.skipBlock(OCTokenTypes.LBRACE, OCTokenTypes.RBRACE, true);
        }
        this.done(stmt, OCElementTypes.EAGER_BLOCK_STATEMENT);
    }

    private void parseStatement() {
        this.parseStatement(false);
    }

    private boolean tryParseNonExpressionStatement() {
        IElementType t = this.tt();
        if (t == OCTokenTypes.LBRACE) {
            this.parseCompoundStatement();
            return true;
        }
        if (t == OCTokenTypes.IF_KEYWORD) {
            this.parseIfStatement();
            return true;
        }
        if (t == OCTokenTypes.SWITCH_KEYWORD) {
            this.parseSwitchStatement();
            return true;
        }
        if (t == OCTokenTypes.CASE_KEYWORD || t == OCTokenTypes.DEFAULT_KEYWORD) {
            this.parseCaseOrDefault();
            return true;
        }
        if (t == OCTokenTypes.WHILE_KEYWORD) {
            this.parseWhileStatement();
            return true;
        }
        if (t == OCTokenTypes.DO_KEYWORD) {
            this.parseDoWhileStatement();
            return true;
        }
        if (t == OCTokenTypes.FOR_KEYWORD) {
            this.parseForStatement();
            return true;
        }
        if (t == OCTokenTypes.GOTO_KEYWORD) {
            this.parseGotoStatement();
            return true;
        }
        if (t == OCTokenTypes.CONTINUE_KEYWORD) {
            this.parseContinueStatement();
            return true;
        }
        if (t == OCTokenTypes.BREAK_KEYWORD) {
            this.parseBreakStatement();
            return true;
        }
        if (t == OCTokenTypes.RETURN_KEYWORD) {
            this.parseReturnStatement();
            return true;
        }
        if (t == OCTokenTypes.SEMICOLON) {
            this.parseEmptyStatement();
            return true;
        }
        if (t == OCTokenTypes.TRY_KEYWORD) {
            this.parseTryStatement();
            return true;
        }
        if (t == OCTokenTypes.THROW_KEYWORD && this.ttOrTypeName() == OCTokenTypes.AT) {
            this.parseThrowStatement();
            return true;
        }
        if (t == OCTokenTypes.SYNCHRONIZED_KEYWORD) {
            this.parseSynchronizedStatement();
            return true;
        }
        if (t == OCTokenTypes.AUTO_RELEASE_POOL_KEYWORD) {
            this.parseAutoReleasePoolStatement();
            return true;
        }
        if (t == OCTokenTypes.__ASM_KEYWORD) {
            this.parseAsmStatement();
            return true;
        }
        if (t == OCTokenTypes.ELSE_KEYWORD) {
            this.errorAndSkipToken("else without an if", this.BLOCK_STATEMENT_PARSER, null);
            return true;
        }
        if (this.myIsCppSupport && OCTokenTypes.CPP_UNARY_OPERATIONS.contains(this.tt())) {
            this.parseExpressionStatement();
            return true;
        }
        if (this.myIsCppSupport && this.tt() == OCTokenTypes.USING_CPP_KEYWORD) {
            this.parseUsingStatement(this.mark(), false);
            return true;
        }
        if (this.myIsCppSupport && this.tt() == OCTokenTypes.NAMESPACE_CPP_KEYWORD) {
            this.parseNamespaceAliasStatement(this.mark());
            return true;
        }
        if (this.myIsCppSupport && this.tt() == OCTokenTypes.STATIC_ASSERT_KEYWORD) {
            this.parseStaticAssert(this.mark());
            return true;
        }
        return false;
    }

    private void parseStatement(boolean skipTokenIfError) {
        if (!this.tryParseStatement()) {
            if (skipTokenIfError) {
                this.errorAndSkipToken("Syntax error", this.BLOCK_STATEMENT_PARSER, null);
            } else {
                this.error("Expecting a statement");
            }
        }
    }

    private boolean tryParseStatement() {
        this.parseCpp11Attributes();
        if (this.tryParseNonExpressionStatement()) {
            return true;
        }
        PsiBuilder.Marker start = this.mark();
        int offset = this.myBuilder.getCurrentOffset();
        IElementType t = this.tt();
        boolean isFunctionCall = false;
        if (this.tt() == OCTokenTypes.IDENTIFIER || this.tt() == OCTokenTypes.COLON2X) {
            PsiBuilder.Marker test = this.mark();
            this.parseQualifiedIdentifier();
            if (this.tt() == OCTokenTypes.LPAR) {
                this.advance();
                if (this.tt() == OCTokenTypes.MUL || this.tt() == OCTokenTypes.AND || this.tt() == OCTokenTypes.ANDAND) {
                    this.advance();
                }
                if (this.tt() == OCTokenTypes.IDENTIFIER) {
                    this.advance();
                    if (this.tt() == OCTokenTypes.RPAR) {
                        this.rollbackTo(test);
                        test = null;
                        isFunctionCall = OCParsingNameScope.isValue(this.detectTypeNameKind(false));
                    } else {
                        this.rollbackTo(test);
                        test = null;
                        isFunctionCall = true;
                    }
                }
            } else if (this.tt() == OCTokenTypes.SEMICOLON) {
                this.rollbackTo(test);
                test = null;
                isFunctionCall = OCParsingNameScope.isValue(this.detectTypeNameKind(false));
            }
            if (test != null) {
                this.rollbackTo(test);
            }
        }
        boolean parsedWithoutErrors = false;
        if (!isFunctionCall && !this.myIsInsideMacro) {
            PsiBuilder.Marker rollbackMarker = this.mark();
            int rollbackOffset = this.myBuilder.getCurrentOffset();
            parsedWithoutErrors = true;
            if (!this.tryParseDeclaration(true, true, false) || ((PsiBuilderImpl)this.myBuilder).hasErrorsAfter(rollbackMarker)) {
                this.rollbackTo(rollbackMarker);
                this.rollbackTypedefsAndClearCaches(rollbackOffset);
                rollbackMarker = this.mark();
                if (!this.tryParseNonExpressionStatement() || ((PsiBuilderImpl)this.myBuilder).hasErrorsAfter(rollbackMarker)) {
                    this.rollbackTo(rollbackMarker);
                    this.rollbackTypedefsAndClearCaches(rollbackOffset);
                    rollbackMarker = this.mark();
                    if (!this.tryParseLabeledStatement() || ((PsiBuilderImpl)this.myBuilder).hasErrorsAfter(rollbackMarker)) {
                        this.rollbackTo(rollbackMarker);
                        this.rollbackTypedefsAndClearCaches(rollbackOffset);
                        rollbackMarker = this.mark();
                        if (!this.parseExpressionStatement() || ((PsiBuilderImpl)this.myBuilder).hasErrorsAfter(rollbackMarker)) {
                            this.rollbackTo(rollbackMarker);
                            this.rollbackTypedefsAndClearCaches(rollbackOffset);
                            rollbackMarker = this.mark();
                            parsedWithoutErrors = false;
                        }
                    }
                }
            }
            rollbackMarker.drop();
        }
        if (!(parsedWithoutErrors || !isFunctionCall && this.tryParseDeclaration(true, false, false) || this.tryParseNonExpressionStatement() || this.tryParseLabeledStatement() || this.parseExpressionStatement())) {
            int newOffset = this.myBuilder.getCurrentOffset();
            this.rollbackTo(start);
            if (offset == newOffset || !this.parseExpressionStatement()) {
                PsiBuilder.Marker stmt = this.mark();
                if (this.parseDeclaration(DeclarationContext.FILE, true, false, false) != DeclarationParsingResult.FAIL) {
                    this.done(stmt, OCElementTypes.DECLARATION_STATEMENT);
                } else {
                    this.rollbackTo(stmt);
                    return false;
                }
            }
            return true;
        }
        start.drop();
        return true;
    }

    private void errorAndSkipToken(String message, @Nullable BlockParser blockParser, @Nullable IElementType errorBlockType) {
        if (this.tt() == OCTokenTypes.LBRACE && blockParser != null) {
            this.skipBlock(message, blockParser, errorBlockType);
        } else {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (this.myDisableErrors) {
                marker.drop();
            } else {
                marker.error(message);
            }
        }
    }

    private void errorAndSkipTokenUntil(String message, @Nullable BlockParser blockParser, @Nullable IElementType errorBlockType, @NotNull IElementType untilType) {
        if (untilType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "untilType", "com/jetbrains/cidr/lang/parser/OCParsing", "errorAndSkipTokenUntil"));
        }
        PsiBuilder.Marker marker = this.mark();
        while (this.tt() != null && this.tt() != untilType) {
            if (this.tt() == OCTokenTypes.LBRACE && blockParser != null) {
                this.skipBlock(message, blockParser, errorBlockType);
                continue;
            }
            this.advance();
        }
        if (this.myDisableErrors) {
            marker.drop();
        } else {
            marker.error(message);
        }
    }

    private void skipBlock(String message, @NotNull BlockParser blockParser, @Nullable IElementType errorBlockType) {
        if (blockParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockParser", "com/jetbrains/cidr/lang/parser/OCParsing", "skipBlock"));
        }
        PsiBuilder.Marker block = null;
        if (errorBlockType != null) {
            block = this.mark();
        }
        if (!this.myDisableErrors) {
            this.myBuilder.error(message);
        }
        blockParser.parseBlock();
        if (block != null) {
            this.done(block, errorBlockType);
        }
    }

    private void parseSynchronizedStatement() {
        assert (this.tt() == OCTokenTypes.SYNCHRONIZED_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        try {
            this.advance();
            if (!this.expectToken(OCTokenTypes.LPAR, "Expecting '('")) {
                return;
            }
            this.parseExpression(false);
            this.expectToken(OCTokenTypes.RPAR, "Expecting ')'");
            this.parseCompoundStatement();
        }
        finally {
            this.done(stmt, OCElementTypes.SYNCHRONIZED_STATEMENT);
        }
    }

    private void parseAutoReleasePoolStatement() {
        assert (this.tt() == OCTokenTypes.AUTO_RELEASE_POOL_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        try {
            this.advance();
            this.parseCompoundStatement();
        }
        finally {
            this.done(stmt, OCElementTypes.AUTO_RELEASE_POOL_STATEMENT);
        }
    }

    private void parseAsmStatement() {
        assert (this.tt() == OCTokenTypes.__ASM_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        this.advance();
        while (this.tt() == OCTokenTypes.VOLATILE_KEYWORD || this.tt() == OCTokenTypes.CONST_KEYWORD || this.tt() == OCTokenTypes.RESTRICT_KEYWORD) {
            this.advance();
        }
        if (this.tt() == OCTokenTypes.LBRACE) {
            this.advance();
            int scopeLevel = 1;
            while (scopeLevel > 0) {
                IElementType tt = this.tt();
                if (tt == OCTokenTypes.SEMICOLON) {
                    this.skipLine();
                } else if (tt == OCTokenTypes.LBRACE) {
                    ++scopeLevel;
                } else if (tt == OCTokenTypes.RBRACE) {
                    --scopeLevel;
                } else if (tt == null) break;
                this.advance();
            }
        } else if (this.tt() == OCTokenTypes.LPAR) {
            this.expectToken(OCTokenTypes.LPAR, "Expecting '('");
            this.parseConstantExpression();
            if (this.tt() == OCTokenTypes.COLON || this.tt() == OCTokenTypes.COLON2X) {
                this.advance();
                this.parseExtendedAsmTemplates();
            }
            this.expectToken(OCTokenTypes.RPAR, "Expecting ')'");
            this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
        } else {
            this.skipLine();
        }
        this.done(stmt, OCElementTypes.ASM_STATEMENT);
    }

    private void skipLine() {
        char c;
        int endOffset;
        CharSequence text = this.myBuilder.getOriginalText();
        for (endOffset = this.myBuilder.getCurrentOffset(); endOffset < text.length() && (c = text.charAt(endOffset)) != '\n' && c != '{' && c != '}'; ++endOffset) {
        }
        while (this.tt() != null && this.myBuilder.getCurrentOffset() < endOffset) {
            this.advance();
        }
    }

    private void parseExtendedAsmTemplates() {
        while (!this.eof() && this.tt() != OCTokenTypes.RPAR) {
            boolean first = true;
            PsiBuilder.Marker extendedAsm = this.mark();
            while (!this.eof() && this.tt() != OCTokenTypes.COLON && (first || this.tt() == OCTokenTypes.COMMA)) {
                if (!first) {
                    this.expectToken(OCTokenTypes.COMMA, "Expecting ','");
                }
                this.expectToken(OCTokenTypes.STRING_LITERAL, "Expecting an operand-constraint string");
                if (this.tt() == OCTokenTypes.LPAR) {
                    this.parseExpressionInParens();
                }
                first = false;
            }
            this.done(extendedAsm, OCElementTypes.ASM_STATEMENT_PART);
            if (this.tt() != OCTokenTypes.COLON && this.tt() != OCTokenTypes.COLON2X) break;
            this.advance();
        }
    }

    private void parseThrowStatement() {
        assert (this.tt() == OCTokenTypes.THROW_KEYWORD || this.tt() == OCTokenTypes.THROW_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        this.parseThrowExpression(this.mark());
        this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
        this.done(stmt, OCElementTypes.EXPRESSION_STATEMENT);
    }

    private void parseTryStatement() {
        assert (this.tt() == OCTokenTypes.TRY_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        this.advance();
        this.parseCompoundStatement();
        while (this.tt() == OCTokenTypes.CATCH_KEYWORD) {
            this.parseCatchSection();
        }
        if (this.tt() == OCTokenTypes.FINALLY_KEYWORD) {
            PsiBuilder.Marker fin = this.mark();
            this.advance();
            this.parseCompoundStatement();
            this.done(fin, OCElementTypes.FINALLY_SECTION);
        }
        this.done(stmt, OCElementTypes.TRY_STATEMENT);
    }

    private void parseCatchSection() {
        assert (this.tt() == OCTokenTypes.CATCH_KEYWORD);
        PsiBuilder.Marker sect = this.mark();
        this.advance();
        if (this.tt() == OCTokenTypes.LPAR) {
            this.parseParameterList();
        } else {
            this.error("Expecting catch section parameter");
        }
        this.parseCompoundStatement();
        this.done(sect, OCElementTypes.CATCH_SECTION);
    }

    private boolean tryParseLabeledStatement() {
        PsiBuilder.Marker stmt = this.mark();
        this.parseAttributes();
        if (this.tt() != OCTokenTypes.IDENTIFIER) {
            this.rollbackTo(stmt);
            return false;
        }
        this.advance();
        if (this.tt() != OCTokenTypes.COLON) {
            this.rollbackTo(stmt);
            return false;
        }
        this.advance();
        if (!this.tryParseLabeledStatement()) {
            this.parseStatement();
        }
        this.done(stmt, OCElementTypes.LABELED_STATEMENT);
        return true;
    }

    private void parseCaseOrDefault() {
        boolean isDefault = this.tt() == OCTokenTypes.DEFAULT_KEYWORD;
        PsiBuilder.Marker stmt = this.mark();
        this.advance();
        if (!isDefault) {
            this.parseConstantExpression();
            if (this.tt() == OCTokenTypes.ELLIPSIS) {
                this.advance();
                this.parseConstantExpression();
            }
        }
        this.expectToken(OCTokenTypes.COLON, "Expecting ':'");
        this.parseStatement();
        this.done(stmt, OCElementTypes.CASE_STATEMENT);
    }

    private boolean tryParseIdentExpressionStatement() {
        PsiBuilder.Marker ident = this.mark();
        if (!this.detectTypeName() && this.tt() == OCTokenTypes.SEMICOLON) {
            PsiBuilder.Marker expression = ident.precede();
            PsiBuilder.Marker statement = expression.precede();
            this.done(ident, OCElementTypes.REFERENCE_ELEMENT);
            this.done(expression, OCElementTypes.REFERENCE_EXPRESSION);
            this.advance();
            this.done(statement, OCElementTypes.EXPRESSION_STATEMENT);
            return true;
        }
        this.rollbackTo(ident);
        return false;
    }

    private boolean tryParseDeclaration() {
        return this.tryParseDeclaration(false, false, false);
    }

    private boolean tryParseDeclaration(boolean withSemicolon, boolean failOnEmptyOrError, boolean requireInitializer) {
        PsiBuilder.Marker stmt = this.mark();
        int offset = this.myBuilder.getCurrentOffset();
        boolean oldDetectionMode = this.myIsInsideDetectionMode;
        this.myIsInsideDetectionMode = true;
        DeclarationParsingResult result2 = this.parseDeclaration(DeclarationContext.CODE_BLOCK, withSemicolon, failOnEmptyOrError, requireInitializer);
        this.myIsInsideDetectionMode = oldDetectionMode;
        int offsetAfter = this.myBuilder.getCurrentOffset();
        if (result2 != DeclarationParsingResult.PARSED) {
            boolean isType;
            int newLineOffset = -1;
            int blocksLevel = 0;
            CharSequence text = this.myBuilder.getOriginalText().subSequence(offset, offsetAfter);
            for (int i = text.length() - 1; i >= 0; --i) {
                char c = text.charAt(i);
                if (c == '{') {
                    ++blocksLevel;
                    continue;
                }
                if (c == '}') {
                    --blocksLevel;
                    continue;
                }
                if (c != '\n' || blocksLevel != 0) continue;
                newLineOffset = i;
                break;
            }
            if (newLineOffset != -1) {
                this.rollbackTo(stmt);
                IElementType t = this.tt();
                boolean bl = isType = CPP_SPECIFIERS_FIRST.contains(t) && t != OCTokenTypes.IDENTIFIER || this.detectTypeName();
                if (isType || !this.tryParseLabeledStatement() && this.tryParseExpressionStatement(true) != StatementParsingResult.PARSED) {
                    this.myParseUntilOffset = offset + newLineOffset;
                    int currentOffset = this.myBuilder.getCurrentOffset();
                    PsiBuilder.Marker inner = this.mark();
                    this.parseDeclaration(DeclarationContext.CODE_BLOCK, withSemicolon, false, requireInitializer);
                    this.done(inner, OCElementTypes.DECLARATION_STATEMENT);
                    this.myParseUntilOffset = 0;
                    if (currentOffset != this.myBuilder.getCurrentOffset()) {
                        if (this.tt() == OCTokenTypes.RBRACE) {
                            return true;
                        }
                        return this.tryParseDeclaration(withSemicolon, false, requireInitializer);
                    }
                    return false;
                }
                return true;
            }
            this.rollbackTo(stmt);
            if (result2 == DeclarationParsingResult.PARSED_WITHOUT_SEMICOLON) {
                IElementType t = this.tt();
                boolean bl = isType = CPP_SPECIFIERS_FIRST.contains(t) && t != OCTokenTypes.IDENTIFIER || this.detectTypeName();
                if (isType && offset != offsetAfter) {
                    PsiBuilder.Marker inner = this.mark();
                    this.parseDeclaration(DeclarationContext.CODE_BLOCK, withSemicolon, false, requireInitializer);
                    this.done(inner, OCElementTypes.DECLARATION_STATEMENT);
                    return true;
                }
                return false;
            }
            return false;
        }
        this.rollbackTo(stmt);
        stmt = this.mark();
        this.parseDeclaration(DeclarationContext.CODE_BLOCK, withSemicolon, false, requireInitializer);
        this.done(stmt, OCElementTypes.DECLARATION_STATEMENT);
        return true;
    }

    private StatementParsingResult tryParseExpressionStatement(boolean rolbackOnError) {
        PsiBuilder.Marker stmt = this.mark();
        if (!this.parseExpression(true)) {
            this.rollbackTo(stmt);
            return StatementParsingResult.FAIL;
        }
        boolean wasSemicolon = this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
        if (!wasSemicolon && rolbackOnError) {
            this.rollbackTo(stmt);
        } else {
            this.done(stmt, OCElementTypes.EXPRESSION_STATEMENT);
        }
        return wasSemicolon ? StatementParsingResult.PARSED : StatementParsingResult.PARSED_WITHOUT_SEMICOLON;
    }

    private boolean parseExpressionStatement() {
        PsiBuilder.Marker stmt = this.mark();
        if (!this.parseExpression(true)) {
            stmt.drop();
            return false;
        }
        this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
        this.done(stmt, OCElementTypes.EXPRESSION_STATEMENT);
        return true;
    }

    private void parseEmptyStatement() {
        assert (this.tt() == OCTokenTypes.SEMICOLON);
        PsiBuilder.Marker stmt = this.mark();
        this.advance();
        this.done(stmt, OCElementTypes.EMPTY_STATEMENT);
    }

    private void parseReturnStatement() {
        assert (this.tt() == OCTokenTypes.RETURN_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        this.advance();
        if (this.tt() == OCTokenTypes.SEMICOLON) {
            this.advance();
        } else {
            this.parseExpression(false);
            this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
        }
        this.done(stmt, OCElementTypes.RETURN_STATEMENT);
    }

    private void parseBreakStatement() {
        assert (this.tt() == OCTokenTypes.BREAK_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        this.advance();
        this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
        this.done(stmt, OCElementTypes.BREAK_STATEMENT);
    }

    private void parseContinueStatement() {
        assert (this.tt() == OCTokenTypes.CONTINUE_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        this.advance();
        this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
        this.done(stmt, OCElementTypes.CONTINUE_STATEMENT);
    }

    private void parseGotoStatement() {
        assert (this.tt() == OCTokenTypes.GOTO_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        this.advance();
        PsiBuilder.Marker labelRef = this.mark();
        this.expectToken(OCTokenTypes.IDENTIFIER, "Missing goto label");
        this.done(labelRef, OCElementTypes.REFERENCE_ELEMENT);
        this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
        this.done(stmt, OCElementTypes.GOTO_STATEMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseForStatement() {
        PsiBuilder.Marker stmt;
        LoopType isCollectionLoop;
        block21: {
            assert (this.tt() == OCTokenTypes.FOR_KEYWORD);
            isCollectionLoop = this.checkIfIsCollectionLoop();
            stmt = this.mark();
            this.advance();
            try {
                if (this.expectToken(OCTokenTypes.LPAR, "Expecting '('")) break block21;
                this.done(stmt, this.myIsObjCSupport && isCollectionLoop == LoopType.OBJ_FOREACH_LOOP || isCollectionLoop == LoopType.C11_FOREACH_LOOP ? OCElementTypes.FOREACH_STATEMENT : OCElementTypes.FOR_STATEMENT);
                return;
            }
            catch (Throwable throwable) {
                this.done(stmt, this.myIsObjCSupport && isCollectionLoop == LoopType.OBJ_FOREACH_LOOP || isCollectionLoop == LoopType.C11_FOREACH_LOOP ? OCElementTypes.FOREACH_STATEMENT : OCElementTypes.FOR_STATEMENT);
                throw throwable;
            }
        }
        if (this.myIsObjCSupport && isCollectionLoop == LoopType.OBJ_FOREACH_LOOP) {
            boolean declaration = true;
            PsiBuilder.Marker declarationMarker = this.mark();
            this.parseAttributes();
            if (this.parseDeclarationSpecifiers(DeclarationContext.CODE_BLOCK) == TypeParsingResult.NONE) {
                this.rollbackTo(declarationMarker);
                declaration = false;
            }
            if (declaration) {
                DeclaratorsParsingResult declaratorsParsingResult = this.parseDeclarators(DeclarationContext.FILE, false, false, TypeParsingResult.TYPE_PARSED_FOR_SURE, null);
                if (!declaratorsParsingResult.myType.isOk()) {
                    this.rollbackTo(declarationMarker);
                    declaration = false;
                }
            }
            if (declaration) {
                if (this.tt() == OCTokenTypes.IDENTIFIER && "in".equals(this.myBuilder.getTokenText()) || this.tt() == OCTokenTypes.COLON) {
                    this.done(declarationMarker, OCElementTypes.DECLARATION);
                    this.advance();
                } else {
                    this.rollbackTo(declarationMarker);
                    declaration = false;
                }
            }
            if (!declaration) {
                this.parseExpression(false);
                if (this.tt() == OCTokenTypes.IDENTIFIER && "in".equals(this.myBuilder.getTokenText())) {
                    this.advance();
                } else {
                    this.error("Expecting in");
                }
            }
            this.parseExpression(false);
        } else if (isCollectionLoop == LoopType.C_FOR_LOOP) {
            boolean declParsed;
            if (this.tt() != OCTokenTypes.SEMICOLON && !(declParsed = this.tryParseDeclaration())) {
                this.parseExpressionStatementWithoutSemicolon();
            }
            this.expectToken(OCTokenTypes.SEMICOLON, "Expecting ';'");
            if (this.tt() != OCTokenTypes.SEMICOLON) {
                this.parseDeclarationOrExpression(ourSemicolonSet);
            }
            this.expectToken(OCTokenTypes.SEMICOLON, "Expecting ';'");
            if (this.tt() != OCTokenTypes.RPAR) {
                this.parseExpressionStatementWithoutSemicolon();
            }
        } else {
            this.myIsInsideLoop = true;
            boolean declParsed = this.tryParseDeclaration();
            if (!declParsed) {
                this.parseExpressionStatementWithoutSemicolon();
            }
            this.expectToken(OCTokenTypes.COLON, "Expecting ':'");
            this.parseExpression(false);
            this.myIsInsideLoop = false;
        }
        this.expectToken(OCTokenTypes.RPAR, "Expecting ')'");
        this.parseStatement();
        this.done(stmt, this.myIsObjCSupport && isCollectionLoop == LoopType.OBJ_FOREACH_LOOP || isCollectionLoop == LoopType.C11_FOREACH_LOOP ? OCElementTypes.FOREACH_STATEMENT : OCElementTypes.FOR_STATEMENT);
    }

    private void parseExpressionStatementWithoutSemicolon() {
        PsiBuilder.Marker estmt = this.mark();
        this.parseExpression(false);
        this.done(estmt, OCElementTypes.EXPRESSION_STATEMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoopType checkIfIsCollectionLoop() {
        PsiBuilder.Marker rollback = this.mark();
        LoopType metIn = LoopType.C_FOR_LOOP;
        int level = 0;
        int skipColon = 0;
        try {
            IElementType tt;
            while ((tt = this.tt()) != null && tt != OCTokenTypes.LBRACE && tt != OCTokenTypes.RBRACE) {
                if (level == 1) {
                    if (tt == OCTokenTypes.QUEST) {
                        ++skipColon;
                    }
                    if (tt == OCTokenTypes.SEMICOLON) {
                        LoopType loopType = metIn;
                        return loopType;
                    }
                    if (tt == OCTokenTypes.IDENTIFIER && "in".equals(this.myBuilder.getTokenText())) {
                        metIn = LoopType.OBJ_FOREACH_LOOP;
                    }
                    if (tt == OCTokenTypes.COLON) {
                        if (skipColon > 0) {
                            --skipColon;
                        } else {
                            metIn = LoopType.C11_FOREACH_LOOP;
                        }
                    }
                }
                if (tt == OCTokenTypes.LPAR || tt == OCTokenTypes.LBRACKET) {
                    ++level;
                }
                if ((tt == OCTokenTypes.RPAR || tt == OCTokenTypes.RBRACKET) && --level == 0) break;
                this.advance();
            }
            LoopType loopType = metIn;
            return loopType;
        }
        finally {
            this.rollbackTo(rollback);
        }
    }

    private void parseDoWhileStatement() {
        assert (this.tt() == OCTokenTypes.DO_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        try {
            this.advance();
            this.parseStatement();
            this.expectToken(OCTokenTypes.WHILE_KEYWORD, "Missing 'while'");
            if (!this.expectToken(OCTokenTypes.LPAR, "Missing '('")) {
                return;
            }
            this.parseExpression(false);
            this.expectToken(OCTokenTypes.RPAR, "Missing ')");
            this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
        }
        finally {
            this.done(stmt, OCElementTypes.DO_WHILE_STATEMENT);
        }
    }

    private void parseWhileStatement() {
        assert (this.tt() == OCTokenTypes.WHILE_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        try {
            this.advance();
            this.parseDeclarationOrExpressionInParens();
            this.parseStatement();
        }
        finally {
            this.done(stmt, OCElementTypes.WHILE_STATEMENT);
        }
    }

    private void parseSwitchStatement() {
        assert (this.tt() == OCTokenTypes.SWITCH_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        try {
            this.advance();
            this.parseDeclarationOrExpressionInParens();
            this.parseStatement();
        }
        finally {
            this.done(stmt, OCElementTypes.SWITCH_STATEMENT);
        }
    }

    private void parseIfStatement() {
        assert (this.tt() == OCTokenTypes.IF_KEYWORD);
        PsiBuilder.Marker stmt = this.mark();
        try {
            this.advance();
            this.parseDeclarationOrExpressionInParens();
            this.parseStatement();
            if (this.tt() == OCTokenTypes.ELSE_KEYWORD) {
                this.advance();
                this.parseStatement();
            }
        }
        finally {
            this.done(stmt, OCElementTypes.IF_STATEMENT);
        }
    }

    private void parseDeclarationOrExpressionInParens() {
        if (this.expectToken(OCTokenTypes.LPAR, "Expected '('")) {
            this.parseDeclarationOrExpression(ourSemicolonOrRparSet);
            this.expectToken(OCTokenTypes.RPAR, "Missing ')");
        }
    }

    private void parseDeclarationOrExpression(TokenSet nextTokens) {
        PsiBuilder.Marker start = this.mark();
        IElementType tt = this.tt();
        boolean parsedWithoutErrors = false;
        if (!this.myIsInsideMacro && (CPP_SPECIFIERS_FIRST.contains(tt) && tt != OCTokenTypes.IDENTIFIER || tt == OCTokenTypes.IDENTIFIER && this.detectTypeName())) {
            int rollbackOffset = this.myBuilder.getCurrentOffset();
            parsedWithoutErrors = true;
            if (!this.tryParseDeclaration(false, false, true) || ((PsiBuilderImpl)this.myBuilder).hasErrorsAfter(start)) {
                this.rollbackTo(start);
                this.rollbackTypedefsAndClearCaches(rollbackOffset);
                start = this.mark();
                if (!this.parseExpression(false) || ((PsiBuilderImpl)this.myBuilder).hasErrorsAfter(start)) {
                    this.rollbackTo(start);
                    this.rollbackTypedefsAndClearCaches(rollbackOffset);
                    start = this.mark();
                    parsedWithoutErrors = false;
                }
            }
        }
        if (!parsedWithoutErrors) {
            if (CPP_SPECIFIERS_FIRST.contains(tt) && tt != OCTokenTypes.IDENTIFIER) {
                if (!this.tryParseDeclaration()) {
                    this.parseExpression(false);
                }
            } else if (tt == OCTokenTypes.IDENTIFIER && this.detectTypeName(true)) {
                if (this.tt() == OCTokenTypes.LPAR) {
                    this.advance();
                    if (this.detectCppInitializer(DeclarationContext.CODE_BLOCK, true, false, true)) {
                        this.rollbackTo(start);
                        start = this.mark();
                        if (!this.parseExpression(false)) {
                            this.tryParseDeclaration();
                        }
                    } else if (!this.tryParseDeclaration()) {
                        this.parseExpression(false);
                    }
                } else {
                    this.rollbackTo(start);
                    start = this.mark();
                    if (!this.tryParseDeclaration()) {
                        this.parseExpression(false);
                    }
                }
            } else {
                this.rollbackTo(start);
                start = this.mark();
                boolean expressionParsed = this.parseExpression(false);
                if (!expressionParsed || !nextTokens.contains(this.tt())) {
                    start.rollbackTo();
                    start = this.mark();
                    if (!this.tryParseDeclaration()) {
                        this.error(this.myIsCppSupport ? "Declaration or expression expected" : "Expression expected");
                    }
                }
            }
        }
        this.done(start, OCElementTypes.DECLARATION_OR_EXPRESSION);
    }

    private void rollbackTypedefsAndClearCaches(int rollbackOffset) {
        this.myLocalNameScope.undefineFromIndex(rollbackOffset);
        this.myTypeKindsCache.clear();
        this.myParseTypeFirstCache.clear();
        this.myNonTypeExpressionsCache.clear();
        this.myNonConstantExprInTemplateCache.clear();
        this.myTemplateArgumentListCache.clear();
    }

    @NotNull
    private DeclaratorsParsingResult parseDeclarators(DeclarationContext context, boolean isTypedef, boolean isTemplate, TypeParsingResult isConstr, String structName) {
        DeclaratorsParsingResult declaratorsParsingResult = this.parseDeclarators(context, isTypedef, isTemplate, isConstr, false, false, structName);
        if (declaratorsParsingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParsing", "parseDeclarators"));
        }
        return declaratorsParsingResult;
    }

    @NotNull
    private DeclaratorsParsingResult parseDeclarators(DeclarationContext context, boolean isTypedef, boolean isTemplate, TypeParsingResult isConstr, boolean requireInitializer, boolean isProperty, String structName) {
        DeclaratorsParsingResult partialResult = null;
        ArrayList<String> names = new ArrayList<String>();
        while (!this.eof()) {
            this.myLastDeclaratorSingleName = null;
            DeclaratorParsingResult result2 = this.parseDeclaratorWithInitializerOrStructEntryDeclarator(context, isTypedef, isTemplate, isConstr, requireInitializer);
            if (this.myLastDeclaratorSingleName != null) {
                names.add(this.myLastDeclaratorSingleName);
            }
            if (!result2.isOk()) {
                DeclaratorsParsingResult declaratorsParsingResult = new DeclaratorsParsingResult(DeclaratorsParsingResult.Type.FAIL, names);
                if (declaratorsParsingResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParsing", "parseDeclarators"));
                }
                return declaratorsParsingResult;
            }
            int namesCnt = this.myLastDeclaratorName != null ? this.myLastDeclaratorName.size() : 0;
            boolean isConstructor = false;
            if (namesCnt > 1) {
                isConstructor = this.myLastDeclaratorName.get(namesCnt - 2) != null && this.myLastDeclaratorName.get(namesCnt - 2).equals(this.myLastDeclaratorName.get(namesCnt - 1));
            } else if (this.myLastDeclaratorName == null) {
                boolean bl = isConstructor = structName != null && structName.equals(this.myLastDeclaratorSingleName);
            }
            if (!(this.myLastDeclaratorSingleName == null || this.myIsInsideTypeNameParsing || this.myIsInsideDetectionMode || isConstructor)) {
                this.myLocalNameScope.defineValue(this.myLastDeclaratorSingleName, isTemplate, this.myBuilder.getCurrentOffset());
                if (isProperty && this.mySupportsAutosynthesis) {
                    this.myLocalNameScope.defineValue(OCNameSuggester.getClang4ImplicitIvarName(this.myLastDeclaratorSingleName), isTemplate, this.myBuilder.getCurrentOffset());
                }
            }
            partialResult = partialResult == null && result2 == DeclaratorParsingResult.PARSED_FUNCTION ? new DeclaratorsParsingResult(DeclaratorsParsingResult.Type.PARSED_FUNCTION, names) : new DeclaratorsParsingResult(DeclaratorsParsingResult.Type.PARSED, names);
            if (this.tt() != OCTokenTypes.COMMA) break;
            OCMacroReferenceTokenType token = this.asMacroToken();
            if (this.myIsInsideMacro && token != null && !token.isParamToken()) break;
            this.advance();
        }
        DeclaratorsParsingResult declaratorsParsingResult = partialResult != null ? partialResult : new DeclaratorsParsingResult(DeclaratorsParsingResult.Type.PARSED, names);
        if (declaratorsParsingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParsing", "parseDeclarators"));
        }
        return declaratorsParsingResult;
    }

    private DeclaratorParsingResult parseDeclaratorWithInitializerOrStructEntryDeclarator(DeclarationContext context, boolean isTypedef, boolean isTemplate, TypeParsingResult isConstr, boolean requireInitializer) {
        if (context == DeclarationContext.STRUCT && this.tt() == OCTokenTypes.COLON) {
            this.advance();
            PsiBuilder.Marker anonDecl = this.mark();
            this.parseConstantExpression();
            this.done(anonDecl, OCElementTypes.ANONYMOUS_DECLARATOR);
            return DeclaratorParsingResult.PARSED;
        }
        PsiBuilder.Marker declaratorMarker = this.mark();
        DeclaratorParsingResult result2 = this.parseDeclarator(context, false, isTypedef, isTemplate, true, true, isConstr);
        if (!result2.isOk()) {
            declaratorMarker.drop();
            return result2;
        }
        while (this.tt() == OCTokenTypes.__ASM_KEYWORD || this.tt() == OCTokenTypes.__ATTRIBUTE_KEYWORD) {
            this.parseGccAttrubutes();
        }
        this.parseCpp11Attributes();
        if (requireInitializer) {
            if (this.expectToken(OCTokenTypes.EQ, "Expecting '='")) {
                this.parseInitializer();
            }
        } else if ((context == DeclarationContext.FILE || context == DeclarationContext.CODE_BLOCK || context == DeclarationContext.STRUCT) && this.tt() == OCTokenTypes.EQ) {
            this.advance();
            if (!(!this.myIsCppSupport || context != DeclarationContext.STRUCT && context != DeclarationContext.FILE || this.tt() != OCTokenTypes.DEFAULT_KEYWORD && this.tt() != OCTokenTypes.DELETE_CPP_KEYWORD)) {
                this.advance();
            } else {
                this.parseInitializer();
            }
        }
        this.done(declaratorMarker, OCElementTypes.DECLARATOR);
        return result2;
    }

    private void parseAttributes() {
        this.parseAttributes(true);
    }

    private void parseAttributes(boolean parseCallConventions) {
        while (true) {
            if (OCTokenTypes.__ATTRIBUTE_KEYWORD == this.tt()) {
                this.parseGccAttrubutes();
                continue;
            }
            if (OCTokenTypes.__DECLSPEC_KEYWORD == this.tt()) {
                this.parseDeclspec();
                continue;
            }
            if (!parseCallConventions || !OCTokenTypes.CALL_CONVENTIONS.contains(this.tt())) break;
            this.parseCallConvention();
        }
        this.parseCpp11Attributes();
    }

    private void parseGccAttrubutes() {
        PsiBuilder.Marker attr = this.mark();
        this.advance();
        if (this.tt() == OCTokenTypes.LPAR) {
            this.advance();
            if (this.tt() == OCTokenTypes.LPAR) {
                this.advance();
                this.parseAttributeValuesList();
                this.expectToken(OCTokenTypes.RPAR, "Missing ')'");
            } else {
                this.parseAttributeValuesList();
            }
            this.expectToken(OCTokenTypes.RPAR, "Missing ')'");
        }
        this.done(attr, OCElementTypes.ATTRIBUTES);
    }

    private void parseCpp11Attributes() {
        block7: {
            PsiBuilder.Marker attrList;
            block6: {
                boolean parsed;
                if (!this.myIsCppSupport || this.tt() != OCTokenTypes.LBRACKET) {
                    return;
                }
                do {
                    attrList = this.mark();
                    if (this.tt() != OCTokenTypes.LBRACKET) break block6;
                    this.advance();
                    parsed = false;
                    if (this.tt() != OCTokenTypes.LBRACKET) continue;
                    this.advance();
                    PsiBuilder.Marker attr = this.mark();
                    int balance = 1;
                    IElementType tt = this.tt();
                    if (tt == OCTokenTypes.LBRACKET) {
                        ++balance;
                    }
                    if (tt == OCTokenTypes.RBRACKET) {
                        --balance;
                    }
                    while (balance > 0 && tt != null) {
                        this.advance();
                        tt = this.tt();
                        if (tt == OCTokenTypes.LBRACKET) {
                            ++balance;
                        }
                        if (tt != OCTokenTypes.RBRACKET) continue;
                        --balance;
                    }
                    this.done(attr, OCElementTypes.ATTRIBUTE);
                    if (this.tt() != OCTokenTypes.RBRACKET) continue;
                    this.advance();
                    if (this.tt() != OCTokenTypes.RBRACKET) continue;
                    this.advance();
                    this.done(attrList, OCElementTypes.ATTRIBUTES);
                    parsed = true;
                } while (parsed);
                this.rollbackTo(attrList);
                break block7;
            }
            attrList.drop();
        }
    }

    private void parseDeclspec() {
        PsiBuilder.Marker attr = this.mark();
        this.advance();
        if (this.tt() == OCTokenTypes.LPAR) {
            this.advance();
            this.parseAttributeValuesList();
            this.expectToken(OCTokenTypes.RPAR, "Missing ')'");
        }
        this.done(attr, OCElementTypes.ATTRIBUTES);
    }

    private void parseCallConvention() {
        PsiBuilder.Marker attr = this.mark();
        this.advance();
        this.done(attr, OCElementTypes.ATTRIBUTES);
    }

    private void parseAttributeValuesList() {
        while (this.tt() != OCTokenTypes.RPAR && this.tt() != null) {
            this.parseAttributeValue();
            if (this.tt() != OCTokenTypes.COMMA) break;
            this.advance();
        }
    }

    private void parseAttributeValue() {
        PsiBuilder.Marker attribute = this.mark();
        PsiBuilder.Marker attributeParams = null;
        int level = 0;
        while (level >= 0) {
            IElementType token = this.tt();
            if (token == OCTokenTypes.LPAR) {
                ++level;
            }
            if (token == OCTokenTypes.RPAR) {
                --level;
            }
            if (level == 0 && token == OCTokenTypes.COMMA || level < 0 || token == null) break;
            if (token == OCTokenTypes.RPAR && level == 0 && attributeParams != null) {
                this.done(attributeParams, OCElementTypes.ATTRIBUTE_PARAMETERS);
                attributeParams = null;
            }
            this.advance();
            if (token != OCTokenTypes.LPAR || level != 1 || attributeParams != null) continue;
            attributeParams = this.mark();
        }
        if (attributeParams != null) {
            attributeParams.drop();
        }
        this.done(attribute, OCElementTypes.ATTRIBUTE);
    }

    private void parseInitializer() {
        if (this.tt() == OCTokenTypes.LBRACE) {
            this.parseCompoundInitializer();
        } else {
            this.parseAssignmentExpression(false);
        }
    }

    private void parseCompoundInitializer() {
        assert (this.tt() == OCTokenTypes.LBRACE);
        PsiBuilder.Marker compound = this.mark();
        this.advance();
        while (!this.eof() && this.tt() != OCTokenTypes.RBRACE) {
            PsiBuilder.Marker expr;
            PsiBuilder.Marker fieldInitializer;
            IElementType t = this.tt();
            if (t == OCTokenTypes.DOT || t == OCTokenTypes.LBRACKET) {
                fieldInitializer = this.mark();
                expr = this.mark();
                int qualifiers = 0;
                while (true) {
                    IElementType token;
                    if ((token = this.tt()) == OCTokenTypes.DOT) {
                        this.advance();
                        this.expectToken(OCTokenTypes.IDENTIFIER, "field name expected");
                        this.done(expr, OCElementTypes.QUALIFIED_DESIGNATOR);
                        qualifiers = Integer.MAX_VALUE;
                    } else {
                        if (token != OCTokenTypes.LBRACKET) break;
                        this.advance();
                        this.parseAssignmentExpression(false);
                        if (this.tt() == OCTokenTypes.ELLIPSIS) {
                            this.advance();
                            this.parseAssignmentExpression(false);
                        }
                        if (this.tt() != OCTokenTypes.RBRACKET) {
                            this.rollbackTo(fieldInitializer);
                            fieldInitializer = null;
                            expr = null;
                            break;
                        }
                        this.expectToken(OCTokenTypes.RBRACKET, "Expecting ']'");
                        IElementType tt = this.tt();
                        if (this.myIsCppSupport && (tt == OCTokenTypes.LPAR || tt == OCTokenTypes.LBRACE)) {
                            this.rollbackTo(fieldInitializer);
                            fieldInitializer = null;
                            expr = null;
                            break;
                        }
                        this.done(expr, OCElementTypes.QUALIFIED_DESIGNATOR);
                        ++qualifiers;
                    }
                    expr = expr.precede();
                }
                if (expr != null) {
                    expr.drop();
                }
                if (this.tt() == OCTokenTypes.EQ) {
                    this.advance();
                } else if (qualifiers > 1) {
                    this.error("Expecting '='");
                }
                if (this.tt() == OCTokenTypes.LBRACE) {
                    this.parseCompoundInitializer();
                } else {
                    this.parseAssignmentExpression(false);
                }
                if (fieldInitializer != null) {
                    this.done(fieldInitializer, OCElementTypes.DESIGNATED_INITIALIZER);
                }
            } else if (t == OCTokenTypes.IDENTIFIER) {
                fieldInitializer = this.mark();
                expr = this.mark();
                this.expectToken(OCTokenTypes.IDENTIFIER, "field name expected");
                this.done(expr, OCElementTypes.QUALIFIED_DESIGNATOR);
                if (this.tt() == OCTokenTypes.COLON) {
                    this.expectToken(OCTokenTypes.COLON, ": expected");
                    if (this.tt() == OCTokenTypes.LBRACE) {
                        this.parseCompoundInitializer();
                    } else {
                        this.parseAssignmentExpression(false);
                    }
                    this.done(fieldInitializer, OCElementTypes.DESIGNATED_INITIALIZER);
                } else {
                    expr.drop();
                    this.rollbackTo(fieldInitializer);
                    if (!this.parseAssignmentExpression(false)) {
                        this.errorAndSkipTokenUntil("missing }", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE, OCTokenTypes.RBRACE);
                    }
                }
            } else if (t == OCTokenTypes.LBRACE) {
                this.parseCompoundInitializer();
            } else {
                if (t == OCTokenTypes.RBRACE) break;
                if (!this.parseAssignmentExpression(false)) {
                    this.errorAndSkipTokenUntil("missing }", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE, OCTokenTypes.RBRACE);
                }
            }
            if (this.tt() == OCTokenTypes.ELLIPSIS) {
                this.advance();
            }
            if (this.tt() == OCTokenTypes.RBRACE) break;
            if (this.tt() != OCTokenTypes.COMMA) {
                this.errorAndSkipTokenUntil("',' or '}' expected", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE, OCTokenTypes.RBRACE);
                continue;
            }
            this.advance();
        }
        this.expectToken(OCTokenTypes.RBRACE, "missing }");
        this.done(compound, OCElementTypes.COMPOUND_INITIALIZER);
    }

    private DeclaratorParsingResult parseDeclarator(DeclarationContext context) {
        return this.parseDeclarator(context, false, false, false, true, true, TypeParsingResult.TYPE_PARSED_FOR_SURE);
    }

    private DeclaratorParsingResult parseDeclarator(DeclarationContext context, boolean abstr, boolean isTypedef, boolean isTemplate, boolean skipEllipsis, boolean allowEmptyParamList, TypeParsingResult isConstr) {
        boolean empty = true;
        this.myLastDeclaratorName = null;
        while (OCTokenTypes.ARC_TYPE_QUALIFIERS.contains(this.tt())) {
            if (context == DeclarationContext.CODE_BLOCK) {
                context = DeclarationContext.FILE;
            }
            this.advance();
            empty = false;
        }
        boolean function = false;
        while (true) {
            if (OCTokenTypes.CALL_CONVENTIONS.contains(this.tt())) {
                function = true;
            }
            this.parseAttributes();
            IElementType tt = this.tt();
            if (tt == OCTokenTypes.MUL || tt == OCTokenTypes.XOR || this.myIsCppSupport && (tt == OCTokenTypes.AND || tt == OCTokenTypes.ANDAND)) {
                this.advance();
                this.parseCpp11Attributes();
            } else if (!this.myIsCppSupport || tt != OCTokenTypes.IDENTIFIER || !this.tryParseQualifiedPointer()) break;
            while (OCTokenTypes.TYPE_QUALIFIERS.contains(this.tt())) {
                if (context == DeclarationContext.CODE_BLOCK) {
                    context = DeclarationContext.FILE;
                }
                this.advance();
            }
            empty = false;
        }
        while (skipEllipsis && this.tt() == OCTokenTypes.ELLIPSIS) {
            this.advance();
        }
        if (this.tt() == OCTokenTypes.LPAR && context != DeclarationContext.CPP_NEW_EXPRESSION && (isConstr == TypeParsingResult.TYPE_PARSED_FOR_SURE || context != DeclarationContext.CODE_BLOCK || abstr)) {
            PsiBuilder.Marker m;
            Object object = m = function || context == DeclarationContext.PARAMETER_LIST ? this.mark() : null;
            if (function || context == DeclarationContext.PARAMETER_LIST && this.tryParseParamDeclaration()) {
                this.rollbackTo(m);
                this.parseParameterList();
                function = true;
            } else {
                this.advance();
                DeclaratorParsingResult result2 = this.parseDeclarator(context, abstr, isTypedef, isTemplate, true, true, isConstr);
                if (result2 == DeclaratorParsingResult.FAIL_EMPTY) {
                    this.error("Declarator expected");
                }
                if (!(result2 != DeclaratorParsingResult.PARSED_EMPTY || allowEmptyParamList && this.tt() == OCTokenTypes.RPAR)) {
                    if (m != null) {
                        this.rollbackTo(m);
                    }
                    return DeclaratorParsingResult.fail(empty);
                }
                this.expectToken(OCTokenTypes.RPAR, ") expected");
                if (m != null) {
                    if (result2.isEmpty()) {
                        this.rollbackTo(m);
                    } else {
                        m.drop();
                        empty = false;
                    }
                } else {
                    empty = false;
                }
                if (!result2.isOk()) {
                    return DeclaratorParsingResult.fail(empty);
                }
                if (result2 == DeclaratorParsingResult.PARSED_FUNCTION) {
                    function = true;
                }
            }
        } else if (context == DeclarationContext.PARAMETER_LIST) {
            if (!abstr && this.ttOrTypeName() == OCTokenTypes.IDENTIFIER) {
                if (!this.myIsInsideTypeNameParsing) {
                    this.myLocalNameScope.defineValue(this.myBuilder.getTokenText(), false, this.myBuilder.getCurrentOffset());
                }
                this.advance();
                empty = false;
            }
        } else if (!abstr) {
            if (this.tt() != OCTokenTypes.IDENTIFIER && this.tt() != OCTokenTypes.OPERATOR_CPP_KEYWORD && this.ttOrCppEquivalent() != OCTokenTypes.TILDE && this.tt() != OCTokenTypes.COLON2X) {
                return DeclaratorParsingResult.fail(empty);
            }
            if (isTypedef) {
                this.expectIdentifier_lexerHack("Expecting type name", false, false, false, false);
            } else {
                this.myLastDeclaratorSingleName = this.myBuilder.getTokenText();
                List<String> ident = this.parseQualifiedIdentifier(null, true, false, null);
                if (ident != null && ident.size() > 1) {
                    this.myLastDeclaratorName = ident;
                    this.myLastDeclaratorSingleName = ident.get(ident.size() - 1);
                }
            }
            empty = false;
        }
        boolean wasLpar = false;
        this.parseCpp11Attributes();
        while (context != DeclarationContext.CPP_NEW_EXPRESSION && this.tt() == OCTokenTypes.LPAR || this.tt() == OCTokenTypes.LBRACKET) {
            if (this.tt() == OCTokenTypes.LPAR) {
                wasLpar = true;
                List<String> name = this.myLastDeclaratorName;
                String singleName = this.myLastDeclaratorSingleName;
                this.enterNamespaceOfDeclarator(name, singleName);
                boolean parseExpressionList = true;
                if (isTemplate || !this.detectCppInitializer(context, false, false, true)) {
                    if (context == DeclarationContext.FILE || context == DeclarationContext.STRUCT || context == DeclarationContext.CODE_BLOCK) {
                        this.parseParameterList();
                    } else {
                        this.parseParameterList(TypeParsingExpectation.NON_VALUES);
                    }
                    this.parseAttributes(false);
                    function = true;
                    parseExpressionList = false;
                }
                this.leaveNamespaceOfDeclarator(name, singleName);
                this.myLastDeclaratorName = name;
                this.myLastDeclaratorSingleName = singleName;
                if (parseExpressionList) {
                    this.parseExpressionList();
                }
            } else {
                this.parseArrayDecl();
            }
            this.parseCpp11Attributes();
            empty = false;
        }
        if (this.myIsCppSupport && !wasLpar && this.tt() == OCTokenTypes.LBRACE && context != DeclarationContext.PARAMETER_LIST && context != DeclarationContext.TRAILING_RETURN_TYPE) {
            this.parseCompoundInitializer();
        }
        if (this.tt() == OCTokenTypes.CONST_KEYWORD) {
            if (context == DeclarationContext.STRUCT || this.myLastDeclaratorName != null && this.myLastDeclaratorName.size() > 1) {
                this.advance();
            } else {
                PsiBuilder.Marker testMark = this.mark();
                this.advance();
                DeclarationParsingResult declaration = this.parseDeclaration(DeclarationContext.PARAMETER_LIST, true, false, false);
                this.rollbackTo(testMark);
                if (declaration != DeclarationParsingResult.PARSED) {
                    this.advance();
                } else {
                    return DeclaratorParsingResult.parsed(empty, function);
                }
            }
        }
        while (OCTokenTypes.TYPE_QUALIFIERS.contains(this.tt())) {
            this.advance();
        }
        if (this.myIsCppSupport && (context == DeclarationContext.STRUCT || context == DeclarationContext.PARAMETER_LIST) && function && (this.tt() == OCTokenTypes.AND || this.tt() == OCTokenTypes.ANDAND)) {
            this.advance();
        }
        if (this.tt() == OCTokenTypes.THROW_KEYWORD) {
            this.parseExceptionSpecification();
        }
        if (this.tt() == OCTokenTypes.NOEXCEPT_KEYWORD) {
            this.parseNoexceptSpecifier();
        }
        if (this.tt() == OCTokenTypes.TRY_KEYWORD) {
            this.advance();
        }
        if (this.myIsCppSupport && !empty && function && this.tt() == OCTokenTypes.DEREF && (context == DeclarationContext.FILE || context == DeclarationContext.STRUCT || context == DeclarationContext.PARAMETER_LIST || context == DeclarationContext.TRAILING_RETURN_TYPE)) {
            this.advance();
            this.parseTypeExpression(DeclarationContext.TRAILING_RETURN_TYPE, TypeParsingExpectation.ANY);
        }
        while (this.myIsCppSupport && context != DeclarationContext.TRAILING_RETURN_TYPE && this.tt() == OCTokenTypes.IDENTIFIER) {
            String text = this.myBuilder.getTokenText();
            if (OCTokenTypes.OVERRIDE_CPP_KEYWORD.getName().equals(text)) {
                this.remapCurrentToken(OCTokenTypes.OVERRIDE_CPP_KEYWORD);
                this.advance();
                continue;
            }
            if (!OCTokenTypes.FINAL_CPP_KEYWORD.getName().equals(text)) break;
            this.remapCurrentToken(OCTokenTypes.FINAL_CPP_KEYWORD);
            this.advance();
        }
        if (this.tt() == OCTokenTypes.COLON && !this.myIsInsideLoop) {
            this.advance();
            if (context == DeclarationContext.STRUCT) {
                if (isConstr.isEmpty() && this.tt() == OCTokenTypes.IDENTIFIER) {
                    this.parseConstructorInitializationList();
                } else {
                    this.parseConstantExpression();
                }
            } else if (isConstr.isEmpty()) {
                this.parseConstructorInitializationList();
            }
        }
        return DeclaratorParsingResult.parsed(empty, function);
    }

    private void parseExceptionSpecification() {
        PsiBuilder.Marker throwClause = this.mark();
        this.advance();
        if (this.tt() == OCTokenTypes.LPAR) {
            this.advance();
            boolean first = true;
            while (!this.eof() && this.tt() != OCTokenTypes.RPAR) {
                if (!first) {
                    this.expectToken(OCTokenTypes.COMMA, "Expecting ','");
                }
                first = false;
                if (this.tt() == OCTokenTypes.ELLIPSIS) {
                    this.advance();
                    continue;
                }
                if (this.parseTypeName(DeclarationContext.PARAMETER_LIST, TypeParsingExpectation.ANY)) continue;
            }
            this.expectToken(OCTokenTypes.RPAR, "Expecting ')'");
        }
        this.done(throwClause, OCElementTypes.CPP_EXCEPTION_SPECIFICATION);
    }

    private void parseNoexceptSpecifier() {
        assert (this.tt() == OCTokenTypes.NOEXCEPT_KEYWORD);
        PsiBuilder.Marker initializationList = this.mark();
        this.advance();
        if (this.tt() == OCTokenTypes.LPAR) {
            this.advance();
            this.parseExpression(false);
            this.expectToken(OCTokenTypes.RPAR, "Expecting ')'");
        }
        this.done(initializationList, OCElementTypes.CPP_NOEXCEPT_SPECIFIER);
    }

    private void parseConstructorInitializationList() {
        PsiBuilder.Marker initializationList = this.mark();
        boolean isAfterComma = false;
        while (!this.eof() && this.tt() != OCTokenTypes.LBRACE) {
            this.parseConstructorFieldInitializer();
            isAfterComma = false;
            if (this.tt() == OCTokenTypes.COMMA) {
                this.advance();
                isAfterComma = true;
                continue;
            }
            if (this.tt() == OCTokenTypes.ELLIPSIS) {
                this.advance();
                break;
            }
            if (this.tt() == OCTokenTypes.LBRACE) continue;
            this.error("',' or '{' expected");
            break;
        }
        if (isAfterComma) {
            this.error("Initializer expected");
        }
        this.done(initializationList, OCElementTypes.CPP_CONSTRUCTOR_INITIALIZATION_LIST);
    }

    private void parseConstructorFieldInitializer() {
        PsiBuilder.Marker initializer = this.mark();
        PsiBuilder.Marker refElement = this.mark();
        this.parseQualifiedCppType();
        this.done(refElement, OCElementTypes.REFERENCE_ELEMENT);
        if (this.tt() == OCTokenTypes.LPAR) {
            this.parseExpressionList();
            if (this.tt() == OCTokenTypes.SEMICOLON) {
                PsiBuilder.Marker start = this.mark();
                this.advance();
                if (this.tt() == OCTokenTypes.RPAR) {
                    this.advance();
                    start.drop();
                } else {
                    this.rollbackTo(start);
                }
            }
        } else if (this.myIsCppSupport && this.tt() == OCTokenTypes.LBRACE) {
            this.parseCompoundInitializer();
        } else {
            this.error("Expecting '('");
        }
        this.done(initializer, OCElementTypes.CPP_CONSTRUCTOR_FIELD_INITIALIZER);
    }

    private void enterNamespaceOfDeclarator(List<String> declaratorName, String singleName) {
        if (declaratorName != null && declaratorName.size() > 1) {
            int deep = declaratorName.size() - 1;
            for (int i = 0; i < deep; ++i) {
                String name = declaratorName.get(i);
                if (name == null) continue;
                this.myLocalNameScope = this.myLocalNameScope.defineNamespace(name);
            }
        } else if (singleName != null) {
            this.myLocalNameScope = this.myLocalNameScope.defineNamespace(singleName);
        }
    }

    private void leaveNamespaceOfDeclarator(List<String> declaratorName, String singleName) {
        if (declaratorName != null && declaratorName.size() > 1) {
            int deep = declaratorName.size() - 1;
            for (int i = 0; i < deep; ++i) {
                String name = declaratorName.get(i);
                if (name == null) continue;
                this.myLocalNameScope = this.myLocalNameScope.getParent();
                LOG.assertTrue(this.myLocalNameScope != null);
            }
        } else if (singleName != null) {
            this.myLocalNameScope = this.myLocalNameScope.getParent();
        }
    }

    private boolean detectQualifiedIdentifierInConstructor() {
        int size;
        PsiBuilder.Marker start = this.mark();
        List<String> qualifiedName = this.parseQualifiedIdentifier(null, true, false, null);
        boolean par = this.tt() == OCTokenTypes.LPAR;
        this.rollbackTo(start);
        if (par && qualifiedName != null && (size = qualifiedName.size()) > 1) {
            return qualifiedName.get(size - 1).equals(qualifiedName.get(size - 2));
        }
        return false;
    }

    private boolean tryParseQualifiedPointer() {
        int size;
        PsiBuilder.Marker start = this.mark();
        List<String> qualifiedName = this.parseQualifiedIdentifier(null, true, false, null);
        if (qualifiedName != null && (size = qualifiedName.size()) != 0 && "*".equals(qualifiedName.get(size - 1))) {
            this.done(start, OCElementTypes.CPP_QUALIFIED_POINTER);
            return true;
        }
        this.rollbackTo(start);
        return false;
    }

    private List<String> parseQualifiedIdentifier() {
        return this.parseQualifiedIdentifier(null, false, false, null);
    }

    private List<String> parseQualifiedIdentifierInDeclarator(boolean isTemplate, boolean isFriend, String message) {
        return this.parseQualifiedIdentifier(OCParsingNameScope.getTypeKind(isTemplate), true, isFriend, message);
    }

    private List<String> parseQualifiedCppType() {
        return this.parseQualifiedIdentifier(null, true, false, null);
    }

    private List<String> parseQualifiedIdentifier(OCParsingNameScope.Kind kind, boolean sureThatType, boolean isFriend, String message) {
        return this.parseQualifiedIdentifier(kind, sureThatType, false, isFriend, message);
    }

    private List<String> parseQualifiedIdentifier(OCParsingNameScope.Kind kind, boolean sureThatType, boolean isAfterDot, boolean isFriend, String message) {
        IElementType tt;
        boolean isTemplate = false;
        PsiBuilder.Marker expr = this.mark();
        if (this.tt() == OCTokenTypes.TYPENAME_CPP_KEYWORD) {
            sureThatType = true;
            this.advance();
        } else if (this.tt() == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
            isTemplate = true;
            this.advance();
        }
        if (this.ttOrCppEquivalent() == OCTokenTypes.TILDE) {
            this.advance();
        }
        String name = null;
        ArrayList<String> qualifiedName = null;
        if (this.tt() == OCTokenTypes.COLON2X) {
            qualifiedName = new ArrayList<String>();
            qualifiedName.add("");
            this.advance();
        }
        if (kind != null) {
            this.expectIdentifier_lexerHack(message, kind == OCParsingNameScope.Kind.TEMPLATE_TYPE, false, false, isFriend);
            if (this.tt() == OCTokenTypes.LT) {
                this.parseTemplateArgumentList();
            }
        } else {
            if (this.tt() == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
                this.advance();
                isTemplate = true;
            }
            if ((tt = this.tt()) == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
                this.advance();
                this.expectCppOperatorSign();
                this.parseTemplateArgumentListIfPossible(sureThatType, isAfterDot, isTemplate, "operator");
            } else if (tt == OCTokenTypes.IDENTIFIER || this.myIsObjCSupport && this.isValidSelectorName(tt)) {
                OCParsingNameScope.Kind nameKind = this.detectTypeNameKind(false);
                name = this.myBuilder.getTokenText();
                if (qualifiedName != null) {
                    qualifiedName.add(name);
                }
                if (tt != OCTokenTypes.IDENTIFIER) {
                    this.remapCurrentToken(OCTokenTypes.IDENTIFIER);
                }
                this.advance();
                if (nameKind == OCParsingNameScope.Kind.OBJC_INTERFACE) {
                    this.parseGenericArguments(this.detectGenericArgumentList());
                } else {
                    this.parseTemplateArgumentListIfPossible(sureThatType, isAfterDot, isTemplate, name);
                }
            }
        }
        while (this.tt() == OCTokenTypes.COLON2X) {
            if (qualifiedName == null) {
                qualifiedName = new ArrayList();
                qualifiedName.add(name);
            }
            this.done(expr, OCElementTypes.CPP_NAMESPACE_QUALIFIER);
            expr = expr.precede();
            this.advance();
            isTemplate = false;
            if (this.tt() == OCTokenTypes.TYPENAME_CPP_KEYWORD) {
                this.advance();
                isTemplate = true;
            }
            if (this.tt() == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
                this.advance();
                isTemplate = true;
            }
            if (this.ttOrCppEquivalent() == OCTokenTypes.TILDE) {
                this.advance();
            }
            if ((tt = this.tt()) == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
                this.advance();
                this.expectCppOperatorSign();
                qualifiedName.add("operator");
                continue;
            }
            if (tt == OCTokenTypes.MUL) {
                qualifiedName.add("*");
                this.advance();
                continue;
            }
            String tokenText = this.myBuilder.getTokenText();
            if (tokenText != null) {
                qualifiedName.add(tokenText);
            }
            if (!this.expectToken(OCTokenTypes.IDENTIFIER, "Expecting identifier")) break;
            this.parseTemplateArgumentListIfPossible(sureThatType, isAfterDot, isTemplate, qualifiedName);
        }
        expr.drop();
        return qualifiedName;
    }

    private boolean detectGenericArgumentList() {
        PsiBuilder.Marker mark = this.mark();
        if (this.tt() == OCTokenTypes.LT) {
            IElementType tt;
            do {
                this.advance();
            } while ((tt = this.tt()) == OCTokenTypes.IDENTIFIER || tt == OCTokenTypes.COMMA);
            this.rollbackTo(mark);
            return tt != OCTokenTypes.GT && tt != OCTokenTypes.GTGT && tt != OCTokenTypes.SEMICOLON;
        }
        this.rollbackTo(mark);
        return false;
    }

    private <T> void parseTemplateArgumentListIfPossible(boolean sureThatType, boolean isAfterDot, boolean isTemplate, T name) {
        if (this.tt() == OCTokenTypes.LT) {
            if (sureThatType || isTemplate) {
                this.parseTemplateArgumentList();
            } else {
                OCParsingNameScope.Kind nameKind = name instanceof String ? this.isLocalOrGlobalTypename((String)name) : this.isLocalOrGlobalTypename((List)name);
                boolean isTemplateType = OCParsingNameScope.isTemplate(nameKind);
                boolean isValue = OCParsingNameScope.isValue(nameKind);
                if (!isAfterDot && (isTemplateType || !isValue && this.detectTemplateArgumentList(nameKind == null)) || isAfterDot && this.detectTemplateArgumentList(true)) {
                    this.parseTemplateArgumentList();
                }
            }
        }
    }

    private boolean detectTemplateArgumentList(boolean detectFunCall) {
        long offset = this.getCurrentComplexOffset();
        if (this.myTemplateArgumentListCache.containsKey(offset)) {
            return this.myTemplateArgumentListCache.get(offset) == 1;
        }
        PsiBuilder.Marker start = this.mark();
        this.advance();
        while (!this.eof()) {
            IElementType fa = this.tt();
            PsiBuilder.Marker mark = this.mark();
            if (CPP_SPECIFIERS_FIRST.contains(fa) && !detectFunCall && OCParsingNameScope.isCppType(this.detectTypeNameKind(true))) {
                if (this.tt() != OCTokenTypes.LPAR) {
                    break;
                }
            } else if (detectFunCall) {
                this.rollbackTo(mark);
                if (!this.parseAssignmentExpression(false, true)) break;
                fa = this.tt();
                if (fa == OCTokenTypes.ELLIPSIS) {
                    this.advance();
                    fa = this.tt();
                }
                if (fa == OCTokenTypes.GT) {
                    this.advance();
                    if (this.tt() == OCTokenTypes.LPAR || this.tt() == OCTokenTypes.COLON2X || this.tt() == OCTokenTypes.LBRACKET || this.tt() == OCTokenTypes.SEMICOLON) {
                        break;
                    }
                } else if (fa == OCTokenTypes.COMMA) {
                    this.advance();
                    continue;
                }
            }
            this.rollbackTo(start);
            this.myTemplateArgumentListCache.put(offset, (byte)0);
            return false;
        }
        this.myTemplateArgumentListCache.put(offset, (byte)1);
        this.rollbackTo(start);
        return true;
    }

    private void skipQualifiedIdentifier() {
        if (this.tt() == OCTokenTypes.COLON2X) {
            this.advance();
        }
        if (this.ttOrCppEquivalent() == OCTokenTypes.TILDE) {
            this.advance();
        }
        if (this.tt() == OCTokenTypes.IDENTIFIER) {
            this.advance();
            if (this.tt() == OCTokenTypes.COLON2X) {
                this.skipQualifiedIdentifier();
            }
        }
    }

    private void expectCppOperatorSign() {
        IElementType t = this.tt();
        if (OCTokenTypes.OVERLOADED_CPP_OPERATORS.contains(t)) {
            this.advance();
            if ((t == OCTokenTypes.NEW_CPP_KEYWORD || t == OCTokenTypes.DELETE_CPP_KEYWORD) && this.tt() == OCTokenTypes.LBRACKET) {
                this.advance();
                this.expectToken(OCTokenTypes.RBRACKET, "Expecting ']'");
            } else if (t == OCTokenTypes.LPAR && this.tt() == OCTokenTypes.RPAR) {
                this.advance();
            } else if (t == OCTokenTypes.LBRACKET && this.tt() == OCTokenTypes.RBRACKET) {
                this.advance();
            }
        } else {
            this.parseTypeNameInNewExpression();
        }
    }

    private void parseArrayDecl() {
        assert (this.tt() == OCTokenTypes.LBRACKET);
        this.advance();
        while (this.tt() == OCTokenTypes.STATIC_KEYWORD || OCTokenTypes.TYPE_QUALIFIERS.contains(this.tt())) {
            this.advance();
        }
        if (this.tt() == OCTokenTypes.MUL) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            if (this.tt() != OCTokenTypes.RBRACKET) {
                this.rollbackTo(mark);
            } else {
                mark.drop();
            }
        }
        if (this.tt() != OCTokenTypes.RBRACKET) {
            this.parseExpression(true);
        }
        this.expectToken(OCTokenTypes.RBRACKET, "] missing");
    }

    private void parseTemplateArgumentList() {
        assert (this.tt() == OCTokenTypes.LT);
        PsiBuilder.Marker paramlist = this.mark();
        this.advance();
        boolean first = true;
        while (!this.eof() && this.tt() != OCTokenTypes.GT && this.tt() != OCTokenTypes.GTGT) {
            if (!first) {
                this.expectToken(OCTokenTypes.COMMA, "Expecting ','");
            }
            first = false;
            if (this.parseTemplateArgument()) continue;
        }
        this.expectGt();
        this.done(paramlist, OCElementTypes.TEMPLATE_ARGUMENT_LIST);
    }

    private boolean parseTypeFirst() {
        boolean parseTypeFirst;
        long offset = this.getCurrentComplexOffset();
        if (this.myParseTypeFirstCache.containsKey(offset)) {
            return this.myParseTypeFirstCache.get(offset) == 1;
        }
        IElementType tt = this.tt();
        PsiBuilder.Marker start = this.mark();
        if ((tt == OCTokenTypes.COLON2X || CPP_SPECIFIERS_FIRST.contains(tt)) && (tt != OCTokenTypes.IDENTIFIER && tt != OCTokenTypes.COLON2X || this.detectTypeNameOrCommaOrGt())) {
            if (tt != OCTokenTypes.IDENTIFIER && tt != OCTokenTypes.COLON2X && tt != OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
                this.advance();
            }
            if (this.tt() == OCTokenTypes.LPAR) {
                this.advance();
                IElementType tt2 = this.tt();
                parseTypeFirst = tt2 == OCTokenTypes.RPAR || tt2 == OCTokenTypes.MUL || tt2 == OCTokenTypes.AND || tt2 == OCTokenTypes.ANDAND ? true : (tt2 == OCTokenTypes.COLON2X || CPP_SPECIFIERS_FIRST.contains(tt2)) && (tt2 != OCTokenTypes.IDENTIFIER && tt2 != OCTokenTypes.COLON2X || this.detectTypeName(true));
            } else {
                parseTypeFirst = true;
            }
            this.rollbackTo(start);
        } else if (this.tt() == OCTokenTypes.MUL || this.tt() == OCTokenTypes.AND || this.tt() == OCTokenTypes.ANDAND) {
            this.advance();
            if (this.tt() == OCTokenTypes.COMMA || this.tt() == OCTokenTypes.RPAR || this.tt() == OCTokenTypes.GT || this.tt() == OCTokenTypes.GTGT) {
                this.rollbackTo(start);
                parseTypeFirst = true;
            } else {
                parseTypeFirst = false;
                this.rollbackTo(start);
            }
        } else {
            parseTypeFirst = false;
            this.rollbackTo(start);
        }
        if (this.myParseUntilOffset == 0) {
            this.myParseTypeFirstCache.put(offset, (byte)(parseTypeFirst ? 1 : 0));
        }
        return parseTypeFirst;
    }

    private boolean parseTemplateArgument() {
        boolean inTemplateArgument = this.myIsInTemplateArgument;
        this.myIsInTemplateArgument = true;
        PsiBuilder.Marker argumentStart = this.mark();
        if (this.parseTypeFirst()) {
            if (!this.tryParseTypeExpressionInTypeArgument()) {
                this.rollbackTo(argumentStart);
                argumentStart = null;
                if (!this.parseConstantExpressionInTemplate()) {
                    this.myIsInTemplateArgument = inTemplateArgument;
                    return false;
                }
            }
        } else if (!this.tryParseConstantExpressionInTypeArgument()) {
            this.rollbackTo(argumentStart);
            argumentStart = null;
            if (!this.parseTypeExpression()) {
                this.myIsInTemplateArgument = inTemplateArgument;
                return false;
            }
        }
        if (argumentStart != null) {
            argumentStart.drop();
        }
        this.myIsInTemplateArgument = inTemplateArgument;
        return true;
    }

    private boolean tryParseTypeExpressionInTypeArgument() {
        boolean result2;
        long currentLexeme = this.getCurrentComplexOffset();
        if (this.myNonTypeExpressionsCache.contains(currentLexeme)) {
            return false;
        }
        boolean bl = result2 = this.parseTypeExpression() && (this.tt() == OCTokenTypes.COMMA || this.tt() == OCTokenTypes.GT || this.tt() == OCTokenTypes.GTGT);
        if (!result2 && this.myParseUntilOffset == 0) {
            this.myNonTypeExpressionsCache.add(currentLexeme);
        }
        return result2;
    }

    private boolean tryParseConstantExpressionInTypeArgument() {
        boolean result2;
        long currentLexeme = this.getCurrentComplexOffset();
        if (this.myNonConstantExprInTemplateCache.contains(currentLexeme)) {
            return false;
        }
        boolean bl = result2 = this.parseConstantExpressionInTemplate() && (this.tt() == OCTokenTypes.COMMA || this.tt() == OCTokenTypes.GT || this.tt() == OCTokenTypes.GTGT || this.tt() == OCTokenTypes.ELLIPSIS);
        if (!result2 && this.myParseUntilOffset == 0) {
            this.myNonConstantExprInTemplateCache.add(currentLexeme);
        }
        return result2;
    }

    private boolean detectTypeNameOrCommaOrGt() {
        OCParsingNameScope.Kind kind = this.detectTypeNameKind(true);
        return OCParsingNameScope.isType(kind) || kind == null && (this.tt() == OCTokenTypes.COMMA || this.tt() == OCTokenTypes.GT || this.tt() == OCTokenTypes.GTGT || this.tt() == OCTokenTypes.ELLIPSIS);
    }

    private void parseKandRParameterList() {
        PsiBuilder.Marker paramList = this.mark();
        while (!this.eof() && this.tt() != OCTokenTypes.LBRACE) {
            PsiBuilder.Marker paramDecl = this.mark();
            this.parseAttributes();
            TypeParsingResult specifierResult = this.parseDeclarationSpecifiers(DeclarationContext.PARAMETER_LIST);
            if (specifierResult == TypeParsingResult.NONE) {
                paramDecl.drop();
                break;
            }
            if (this.tt() != OCTokenTypes.LBRACE) {
                DeclaratorsParsingResult declaratorResult = this.parseDeclarators(DeclarationContext.PARAMETER_LIST, false, false, TypeParsingResult.TYPE_PARSED_FOR_SURE, null);
                if (specifierResult.isEmpty() && !declaratorResult.myType.isOk()) {
                    paramDecl.drop();
                    break;
                }
            }
            this.expectToken(OCTokenTypes.SEMICOLON, "expecting ';'");
            this.done(paramDecl, OCElementTypes.PARAMETER_DECLARATION);
        }
        this.done(paramList, OCElementTypes.PARAMETER_LIST);
    }

    private void parseParameterList() {
        this.parseParameterList(TypeParsingExpectation.ANY);
    }

    private void parseParameterList(TypeParsingExpectation typeExpectation) {
        assert (this.tt() == OCTokenTypes.LPAR);
        PsiBuilder.Marker paramlist = this.mark();
        this.advance();
        boolean first = true;
        while (!this.eof() && this.tt() != OCTokenTypes.RPAR) {
            if (!first) {
                this.expectToken(OCTokenTypes.COMMA, ", expected");
            }
            first = false;
            if (this.tt() == OCTokenTypes.RPAR) {
                this.error("Expecting parameter");
                break;
            }
            if (this.tt() == OCTokenTypes.ELLIPSIS) {
                PsiBuilder.Marker paramDecl = this.mark();
                PsiBuilder.Marker declMarler = this.mark();
                this.advance();
                this.done(declMarler, OCElementTypes.DECLARATOR);
                this.done(paramDecl, OCElementTypes.PARAMETER_DECLARATION);
                break;
            }
            if (this.parseParameterDeclaration(false, typeExpectation)) continue;
        }
        this.expectToken(OCTokenTypes.RPAR, ") expected");
        this.done(paramlist, OCElementTypes.PARAMETER_LIST);
    }

    private boolean parseParameterDeclaration(boolean inTemplate) {
        return this.parseParameterDeclaration(inTemplate, TypeParsingExpectation.ANY);
    }

    private boolean parseParameterDeclaration(boolean inTemplate, TypeParsingExpectation typeExpectation) {
        PsiBuilder.Marker param = this.mark();
        this.parseAttributes();
        TypeParsingResult specifierResult = this.parseSpecifierQualifierList(DeclarationContext.PARAMETER_LIST, null, false, false, false, false, true, typeExpectation);
        if (specifierResult == TypeParsingResult.NONE) {
            param.drop();
            return false;
        }
        PsiBuilder.Marker declMarler = this.mark();
        if (this.tt() != OCTokenTypes.COMMA && this.tt() != OCTokenTypes.RPAR) {
            DeclaratorParsingResult declaratorResult = this.parseDeclarator(DeclarationContext.PARAMETER_LIST);
            if (specifierResult.isEmpty() && declaratorResult.isEmpty()) {
                declMarler.drop();
                param.drop();
                return false;
            }
        }
        while (this.tt() == OCTokenTypes.__ASM_KEYWORD || this.tt() == OCTokenTypes.__ATTRIBUTE_KEYWORD) {
            this.parseGccAttrubutes();
        }
        this.parseCpp11Attributes();
        if (this.myIsCppSupport && this.tt() == OCTokenTypes.EQ) {
            this.advance();
            if (inTemplate) {
                this.parseConstantExpressionInTemplate();
            } else {
                this.parseAssignmentExpression(false);
            }
        }
        this.done(declMarler, OCElementTypes.DECLARATOR);
        this.done(param, OCElementTypes.PARAMETER_DECLARATION);
        return true;
    }

    private TypeParsingResult parseDeclarationSpecifiers(DeclarationContext context) {
        return this.parseDeclarationSpecifiers(context, false, false, false, TypeParsingExpectation.ANY);
    }

    private TypeParsingResult parseDeclarationSpecifiers(DeclarationContext context, boolean isTypedef, boolean isTemplate, boolean wasAuto, TypeParsingExpectation typeExpectation) {
        if (context == DeclarationContext.CODE_BLOCK && !CPP_SPECIFIERS_FIRST.contains(this.tt()) && this.tt() != OCTokenTypes.COLON2X) {
            return TypeParsingResult.NONE;
        }
        return this.parseSpecifierQualifierList(context, null, isTypedef, isTemplate, wasAuto, false, true, typeExpectation);
    }

    private boolean parseCppAccessSpecifier() {
        if (CPP_ACCESS_SPECIFIERS.contains(this.tt())) {
            this.advance();
            this.expectToken(OCTokenTypes.COLON, "':' expected");
            return true;
        }
        return false;
    }

    private TypeParsingResult parseSpecifierQualifierList(boolean createTypeElement, DeclarationContext context, TypeParsingExpectation typeExpectation) {
        return this.parseSpecifierQualifierList(context == DeclarationContext.TRAILING_RETURN_TYPE ? context : DeclarationContext.CODE_BLOCK, null, false, false, false, false, createTypeElement, typeExpectation);
    }

    private TypeParsingResult parseSpecifierQualifierList(DeclarationContext context, String structName, boolean isTypedef, boolean isTemplate, boolean isAuto, boolean isFriend, boolean createTypeElement, TypeParsingExpectation typeExpectation) {
        PsiBuilder.Marker typeElement = this.mark();
        TypeParsingResult bareMinimumTypeParsed = TypeParsingResult.NONE;
        boolean isTypeForSure = false;
        boolean newTypeParsed = false;
        boolean sureCppTypename = false;
        Boolean unknown = null;
        while (true) {
            this.parseAttributes(false);
            IElementType token = this.tt();
            if (context == DeclarationContext.STRUCT && !isTypedef && token == OCTokenTypes.IDENTIFIER && this.myBuilder.getTokenText().equals(structName)) {
                if (this.detectCppConstructor()) {
                    bareMinimumTypeParsed = TypeParsingResult.EMPTY_TYPE_PARSED;
                    break;
                }
            } else if (!isTypedef && token == OCTokenTypes.TILDE) {
                bareMinimumTypeParsed = TypeParsingResult.EMPTY_TYPE_PARSED;
                break;
            }
            if (BULLSHIT_TYPE_MODIFIERS.contains(token)) {
                sureCppTypename |= token == OCTokenTypes.TYPENAME_CPP_KEYWORD;
                this.advance();
                unknown = false;
                if (bareMinimumTypeParsed != TypeParsingResult.UNKNOWN) continue;
                bareMinimumTypeParsed = TypeParsingResult.TYPE_PARSED;
                continue;
            }
            if (token == OCTokenTypes.TYPEOF_KEYWORD || token == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
                if (newTypeParsed) {
                    this.error("Expecting ';'");
                    break;
                }
                this.parseTypeOfExpression();
                bareMinimumTypeParsed = TypeParsingResult.TYPE_PARSED;
                break;
            }
            if (token == OCTokenTypes.ALIGNAS_CPP_KEYWORD) {
                this.advance();
                this.parseTypeOrExprInParents();
                continue;
            }
            if (token == OCTokenTypes.UNDERLYING_TYPE_KEYWORD) {
                this.advance();
                this.parseTypeInParens(false);
                bareMinimumTypeParsed = TypeParsingResult.TYPE_PARSED_FOR_SURE;
                continue;
            }
            if (!OCTokenTypes.TYPE_SPECIFIERS.contains(token) && token != OCTokenTypes.LT && token != OCTokenTypes.COLON2X && token != OCTokenTypes.OPERATOR_CPP_KEYWORD) break;
            boolean emptyName = false;
            if (token == OCTokenTypes.IDENTIFIER || token == OCTokenTypes.OPERATOR_CPP_KEYWORD || token == OCTokenTypes.LT || token == OCTokenTypes.COLON2X) {
                if (bareMinimumTypeParsed != TypeParsingResult.NONE) break;
                PsiBuilder.Marker ref = this.mark();
                if (sureCppTypename) {
                    isTypeForSure = true;
                } else {
                    OCParsingNameScope.Kind kind = this.detectTypeNameKind(false);
                    boolean isValue = OCParsingNameScope.isValue(kind) && kind != OCParsingNameScope.Kind.UNKNOWN;
                    boolean isType = OCParsingNameScope.isType(kind);
                    isTypeForSure = isType && !isValue;
                    sureCppTypename = OCParsingNameScope.isCppType(kind);
                    if (kind == null && unknown == null) {
                        unknown = true;
                    }
                    if (typeExpectation == TypeParsingExpectation.NON_VALUES && isValue || typeExpectation == TypeParsingExpectation.NON_EXACT_VALUES && isValue && !isType) {
                        ref.drop();
                        typeElement.drop();
                        return TypeParsingResult.NONE;
                    }
                }
                if (token == OCTokenTypes.LT) {
                    emptyName = true;
                    this.done(this.mark(), OCElementTypes.EMPTY_NAME);
                } else if ((token == OCTokenTypes.IDENTIFIER || token == OCTokenTypes.OPERATOR_CPP_KEYWORD) && !isTypedef && this.detectDeclarationWithoutType(context, isAuto)) {
                    this.done(this.mark(), OCElementTypes.EMPTY_NAME);
                    bareMinimumTypeParsed = TypeParsingResult.EMPTY_TYPE_PARSED;
                } else if (createTypeElement && !isTypedef && this.detectQualifiedIdentifierInConstructor()) {
                    this.done(this.mark(), OCElementTypes.EMPTY_NAME);
                    bareMinimumTypeParsed = TypeParsingResult.EMPTY_TYPE_PARSED;
                } else if (sureCppTypename) {
                    List<String> qualifiedName = this.parseQualifiedCppType();
                    if (qualifiedName != null && "*".equals(ContainerUtil.getLastItem(qualifiedName))) {
                        ref.drop();
                        bareMinimumTypeParsed = TypeParsingResult.NONE;
                        break;
                    }
                } else {
                    this.parseQualifiedIdentifier();
                }
                if (this.tt() == OCTokenTypes.LT) {
                    boolean needRevertAndParseCppType = false;
                    boolean markAsTemplateArgList = false;
                    PsiBuilder.Marker argListMarker = this.mark();
                    this.advance();
                    while (true) {
                        if (this.tt() == OCTokenTypes.IDENTIFIER) {
                            PsiBuilder.Marker protocolRef = this.mark();
                            this.parseQualifiedCppType();
                            IElementType tt = this.tt();
                            if (!emptyName && this.myIsCppSupport && tt != OCTokenTypes.COMMA && tt != OCTokenTypes.SEMICOLON && tt != OCTokenTypes.GT && tt != OCTokenTypes.GTGT) {
                                this.rollbackTo(protocolRef);
                                needRevertAndParseCppType = true;
                                break;
                            }
                            this.done(protocolRef, OCElementTypes.REFERENCE_ELEMENT);
                        } else if (this.myIsCppSupport && this.parseTemplateArgument()) {
                            markAsTemplateArgList = true;
                        } else {
                            this.error("Protocol name expected");
                        }
                        if (this.tt() != OCTokenTypes.COMMA) break;
                        this.advance();
                    }
                    if (!needRevertAndParseCppType) {
                        IElementType tt;
                        if (isTypeForSure && this.tt() == OCTokenTypes.SEMICOLON) {
                            this.advance();
                        }
                        if ((tt = this.tt()) != OCTokenTypes.GT && tt != OCTokenTypes.GTGT) {
                            argListMarker.drop();
                            if (!isTypeForSure) {
                                this.rollbackTo(ref);
                                break;
                            }
                            this.error("Missing '>'");
                        } else {
                            this.advance();
                            if (tt == OCTokenTypes.GTGT) {
                                this.myTemplateGTGT = true;
                            }
                            if (markAsTemplateArgList) {
                                this.done(argListMarker, OCElementTypes.TEMPLATE_ARGUMENT_LIST);
                            } else {
                                argListMarker.drop();
                            }
                            if (this.tt() == OCTokenTypes.COLON2X && !emptyName) {
                                this.rollbackTo(ref);
                                ref = this.mark();
                                this.parseQualifiedCppType();
                            }
                        }
                    } else {
                        argListMarker.drop();
                        this.rollbackTo(ref);
                        ref = this.mark();
                        if (sureCppTypename || context != DeclarationContext.CODE_BLOCK) {
                            this.parseQualifiedCppType();
                        } else {
                            this.parseQualifiedIdentifier();
                        }
                    }
                }
                if (bareMinimumTypeParsed == TypeParsingResult.EMPTY_TYPE_PARSED) {
                    ref.drop();
                } else {
                    this.done(ref, OCElementTypes.REFERENCE_ELEMENT);
                }
            } else if (SINGLE_TOKEN_SPECIFIER.contains(token)) {
                if (token == OCTokenTypes.IDENTIFIER || token == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
                    this.parseQualifiedIdentifier();
                } else {
                    if (OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(token) && newTypeParsed) {
                        this.error("Expecting ';'");
                        break;
                    }
                    this.advance();
                    isTypeForSure = true;
                }
            } else if (token == OCTokenTypes.STRUCT_KEYWORD || token == OCTokenTypes.CLASS_KEYWORD || token == OCTokenTypes.UNION_KEYWORD || token == OCTokenTypes.ENUM_KEYWORD) {
                if (newTypeParsed) {
                    this.error("Expecting ';'");
                    break;
                }
                if (this.parseStructOrUnionOrEnumOrCppClass(isTemplate, isFriend, context)) {
                    newTypeParsed = true;
                }
                isTypeForSure = true;
            }
            if (bareMinimumTypeParsed != TypeParsingResult.NONE) continue;
            if (isTypeForSure) {
                bareMinimumTypeParsed = TypeParsingResult.TYPE_PARSED_FOR_SURE;
                continue;
            }
            if (typeExpectation == TypeParsingExpectation.NON_EXACT_VALUES && unknown == Boolean.TRUE) {
                bareMinimumTypeParsed = TypeParsingResult.UNKNOWN;
                continue;
            }
            bareMinimumTypeParsed = TypeParsingResult.TYPE_PARSED;
        }
        this.parseAttributes(false);
        if (createTypeElement) {
            this.done(typeElement, OCElementTypes.TYPE_ELEMENT);
        } else {
            typeElement.drop();
        }
        return typeExpectation == TypeParsingExpectation.ONLY_TYPES && bareMinimumTypeParsed != TypeParsingResult.TYPE_PARSED_FOR_SURE ? TypeParsingResult.NONE : bareMinimumTypeParsed;
    }

    private boolean detectCppConstructor() {
        PsiBuilder.Marker mark = this.mark();
        this.advance();
        if (this.tt() == OCTokenTypes.LT) {
            this.parseTemplateArgumentList();
        }
        if (this.tt() == OCTokenTypes.LPAR) {
            this.advance();
            IElementType tt = this.tt();
            if (tt == OCTokenTypes.MUL || tt == OCTokenTypes.XOR || this.myIsCppSupport && (tt == OCTokenTypes.AND || tt == OCTokenTypes.ANDAND)) {
                this.rollbackTo(mark);
                return false;
            }
            if (this.tt() == OCTokenTypes.IDENTIFIER && this.detectTypeNameKind(false) == null) {
                this.advance();
                if (this.tt() == OCTokenTypes.RPAR) {
                    this.advance();
                    if (this.tt() == OCTokenTypes.EQ || this.tt() == OCTokenTypes.SEMICOLON) {
                        this.rollbackTo(mark);
                        return false;
                    }
                } else if (this.tt() == OCTokenTypes.LPAR) {
                    this.rollbackTo(mark);
                    return false;
                }
            }
            this.rollbackTo(mark);
            return true;
        }
        this.rollbackTo(mark);
        return false;
    }

    private boolean detectDeclarationWithoutType(DeclarationContext context, boolean wasAuto) {
        boolean result2 = false;
        if (context == DeclarationContext.FILE || context == DeclarationContext.STRUCT || wasAuto) {
            PsiBuilder.Marker start = this.mark();
            String singleName = this.myBuilder.getTokenText();
            List<String> name = this.parseQualifiedCppType();
            if (this.myIsCppSupport) {
                if (name != null) {
                    singleName = name.get(name.size() - 1);
                }
                if ("operator".equals(singleName)) {
                    result2 = true;
                }
            }
            if (!result2) {
                if (this.tt() == OCTokenTypes.SEMICOLON || this.tt() == OCTokenTypes.EQ || this.tt() == OCTokenTypes.COLON) {
                    result2 = true;
                } else if (this.tt() == OCTokenTypes.LPAR) {
                    this.advance();
                    if (this.tt() == OCTokenTypes.RPAR) {
                        result2 = true;
                    } else {
                        IElementType next = this.tt();
                        if (next != OCTokenTypes.IDENTIFIER && CPP_SPECIFIERS_FIRST.contains(next)) {
                            result2 = true;
                        }
                    }
                }
            }
            this.rollbackTo(start);
        }
        return result2;
    }

    private boolean detectCppInitializer(DeclarationContext context, boolean skip, boolean innerCall, boolean defaultValue) {
        boolean result2 = false;
        if (context == DeclarationContext.CODE_BLOCK || context == DeclarationContext.FILE) {
            PsiBuilder.Marker start = null;
            if (!skip) {
                start = this.mark();
                this.advance();
            }
            this.parseAttributes();
            IElementType tt = this.tt();
            while (innerCall && (tt == OCTokenTypes.MUL || tt == OCTokenTypes.AND || tt == OCTokenTypes.XOR)) {
                this.advance();
                tt = this.tt();
            }
            if (tt == OCTokenTypes.RPAR || tt == OCTokenTypes.ELLIPSIS) {
                result2 = false;
            } else if (tt == OCTokenTypes.LPAR) {
                this.advance();
                result2 = this.detectCppInitializer(context, true, innerCall, true);
                if (this.tt() == OCTokenTypes.RPAR) {
                    this.advance();
                    if (!result2 && this.tt() != OCTokenTypes.RPAR && this.tt() != OCTokenTypes.COMMA) {
                        result2 = true;
                    }
                }
            } else if (innerCall && tt == OCTokenTypes.ANDAND || tt == OCTokenTypes.XOR) {
                result2 = false;
            } else if (!CPP_SPECIFIERS_FIRST.contains(tt) && tt != OCTokenTypes.COLON2X) {
                result2 = true;
            } else if (tt == OCTokenTypes.IDENTIFIER || tt == OCTokenTypes.COLON2X) {
                if (CPP_EXPRESSIONS_FIRST.contains(this.tt())) {
                    result2 = true;
                } else {
                    PsiBuilder.Marker mark = this.mark();
                    TypeParsingResult typeResult = this.parseTypeNameWithResult(context, TypeParsingExpectation.NON_EXACT_VALUES, false);
                    if (typeResult != TypeParsingResult.NONE && this.tt() != OCTokenTypes.COMMA && this.tt() != OCTokenTypes.RPAR && this.tt() != OCTokenTypes.IDENTIFIER) {
                        result2 = true;
                    } else if (typeResult == TypeParsingResult.TYPE_PARSED_FOR_SURE) {
                        result2 = false;
                    } else if (typeResult == TypeParsingResult.NONE && !innerCall) {
                        result2 = true;
                    } else {
                        defaultValue &= !innerCall && typeResult == TypeParsingResult.UNKNOWN;
                        if (this.tt() == OCTokenTypes.RPAR) {
                            this.advance();
                            result2 = defaultValue && (this.tt() == OCTokenTypes.SEMICOLON || this.tt() == OCTokenTypes.EQ || this.tt() == OCTokenTypes.COMMA);
                        } else if (this.tt() == OCTokenTypes.COMMA) {
                            if (context == DeclarationContext.CODE_BLOCK) {
                                result2 = true;
                            } else {
                                this.advance();
                                result2 = this.detectCppInitializer(context, true, innerCall, defaultValue);
                            }
                        } else {
                            this.rollbackTo(mark);
                            mark = null;
                            this.advance();
                            boolean bl = result2 = typeResult.isEmpty() && this.tt() != OCTokenTypes.RPAR;
                        }
                    }
                    if (mark != null) {
                        mark.drop();
                    }
                }
            } else if (!this.parseTypeName(DeclarationContext.PARAMETER_LIST, TypeParsingExpectation.ANY) && this.tt() == OCTokenTypes.LPAR) {
                this.advance();
                result2 = this.detectCppInitializer(context, true, true, true);
                if (!result2 && this.tt() == OCTokenTypes.COMMA) {
                    result2 = this.detectCppInitializer(context, true, true, true);
                }
            }
            if (!skip) {
                this.rollbackTo(start);
            }
        }
        return result2;
    }

    private boolean parseStructOrUnionOrEnumOrCppClass(boolean isTemplate, boolean isFriend, DeclarationContext context) {
        boolean hasBody;
        boolean isCppClass;
        IElementType token = this.tt();
        boolean isStruct = token == OCTokenTypes.STRUCT_KEYWORD;
        boolean isUnion = token == OCTokenTypes.UNION_KEYWORD;
        boolean isEnum = token == OCTokenTypes.ENUM_KEYWORD;
        boolean bl = isCppClass = token == OCTokenTypes.CLASS_KEYWORD;
        assert (isStruct || isUnion || isEnum || isCppClass);
        PsiBuilder.Marker structMarker = this.mark();
        this.advance();
        if (isEnum && (this.tt() == OCTokenTypes.CLASS_KEYWORD || this.tt() == OCTokenTypes.STRUCT_KEYWORD)) {
            this.advance();
        }
        if (this.tt() == OCTokenTypes.ALIGNAS_CPP_KEYWORD) {
            this.advance();
            this.parseTypeOrExprInParents();
        }
        this.parseAttributes();
        PsiBuilder.Marker refMarker = this.mark();
        boolean hasName = this.tt() == OCTokenTypes.IDENTIFIER || this.tt() == OCTokenTypes.COLON2X;
        List<String> name = null;
        String singleName = null;
        if (hasName) {
            singleName = this.myBuilder.getTokenText();
            name = this.parseQualifiedIdentifierInDeclarator(isTemplate, isFriend, "class/struct/union/enum name expected");
            if (this.myIsCppSupport && this.tt() == OCTokenTypes.IDENTIFIER) {
                String text = this.myBuilder.getTokenText();
                if (OCTokenTypes.FINAL_CPP_KEYWORD.getName().equals(text)) {
                    this.remapCurrentToken(OCTokenTypes.FINAL_CPP_KEYWORD);
                    this.advance();
                }
            }
        }
        IElementType bodyMarker = this.tt();
        boolean bl2 = hasBody = context != DeclarationContext.TRAILING_RETURN_TYPE && (bodyMarker == OCTokenTypes.LBRACE || bodyMarker == OCTokenTypes.COLON);
        if (hasBody) {
            refMarker.drop();
            if (isEnum) {
                this.parseEnumBody();
            } else if (hasName) {
                this.enterNamespaceOfDeclarator(name, singleName);
                singleName = name != null && name.size() > 0 ? name.get(name.size() - 1) : singleName;
                this.parseStructBody(singleName);
                this.leaveNamespaceOfDeclarator(name, singleName);
            } else {
                this.parseStructBody(null);
            }
        } else if (!isTemplate) {
            this.done(refMarker, OCElementTypes.REFERENCE_ELEMENT);
        } else {
            refMarker.drop();
        }
        if (!hasName && !hasBody) {
            if (isStruct) {
                this.error("struct name and/or body expected");
            } else if (isUnion) {
                this.error("union name and/or body expected");
            } else {
                this.error("enum name and/or body expected");
            }
        }
        this.parseAttributes();
        this.done(structMarker, isEnum ? OCElementTypes.ENUM : (isUnion ? OCElementTypes.UNION : OCElementTypes.STRUCT));
        return hasBody;
    }

    private void parseEnumBody() {
        this.parseBaseClause(true);
        if (this.tt() != OCTokenTypes.LBRACE) {
            return;
        }
        this.advance();
        while (!this.eof() && this.tt() != OCTokenTypes.RBRACE) {
            this.parseEnumConstant();
            if (this.tt() == OCTokenTypes.RBRACE) break;
            if (this.tt() == OCTokenTypes.COMMA) {
                this.advance();
                continue;
            }
            if (this.tt() == OCTokenTypes.IDENTIFIER) {
                this.error("Missing comma between enum constants");
                continue;
            }
            this.errorAndSkipToken("Expecting comma between enum constants", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE);
        }
        this.expectToken(OCTokenTypes.RBRACE, "} expected");
    }

    private void parseEnumConstant() {
        PsiBuilder.Marker constMarker = this.mark();
        PsiBuilder.Marker declarator = this.mark();
        if (OCTokenTypes.IDENTIFIER == this.tt()) {
            this.myLocalNameScope.defineValue(this.myBuilder.getTokenText(), false, this.myBuilder.getCurrentOffset());
            this.advance();
        } else {
            this.error("Enum constant name expected");
        }
        this.parseAttributes();
        if (this.tt() == OCTokenTypes.EQ) {
            this.advance();
            this.parseConstantExpression();
        }
        this.done(declarator, OCElementTypes.DECLARATOR);
        this.done(constMarker, OCElementTypes.DECLARATION);
    }

    private void parseStructBody(String structName) {
        this.parseBaseClause(false);
        this.advance();
        while (!this.eof() && this.tt() != OCTokenTypes.RBRACE) {
            if (this.parseStructEntry(structName)) continue;
            if (this.tt() == OCTokenTypes.LBRACE) {
                this.error("Syntax error");
                PsiBuilder.Marker erroneousCode = this.mark();
                this.parseCompoundStatement();
                this.done(erroneousCode, OCElementTypes.UNKNOWN_CPP_CODE);
                continue;
            }
            this.errorAndSkipToken("Syntax error", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE);
        }
        this.expectToken(OCTokenTypes.RBRACE, "} expected");
    }

    private void parseBaseClause(boolean isEnum) {
        PsiBuilder.Marker baseClauseList = this.mark();
        if (this.tt() == OCTokenTypes.COLON) {
            this.advance();
            boolean needComma = false;
            while (this.tt() != null && this.tt() != OCTokenTypes.LBRACE) {
                if (needComma) {
                    this.expectToken(OCTokenTypes.COMMA, "Expecting ','");
                    needComma = false;
                }
                PsiBuilder.Marker baseClause = this.mark();
                this.parseAttributes();
                while (this.tt() == OCTokenTypes.VIRTUAL_CPP_KEYWORD || CPP_ACCESS_SPECIFIERS.contains(this.tt())) {
                    this.advance();
                }
                IElementType tt = this.tt();
                if (tt == OCTokenTypes.COLON2X || tt == OCTokenTypes.IDENTIFIER || tt == OCTokenTypes.TYPENAME_CPP_KEYWORD || tt == OCTokenTypes.DECLTYPE_CPP_KEYWORD || OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(tt)) {
                    PsiBuilder.Marker baseType = this.mark();
                    if (OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(tt) && tt != OCTokenTypes.IDENTIFIER || tt == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
                        this.parseTypeName(DeclarationContext.PARAMETER_LIST, TypeParsingExpectation.ANY);
                        this.done(baseType, OCElementTypes.TYPE_ELEMENT);
                    } else {
                        this.parseQualifiedCppType();
                        this.done(baseType, OCElementTypes.REFERENCE_ELEMENT);
                    }
                    if (this.tt() == OCTokenTypes.ELLIPSIS) {
                        this.advance();
                    }
                    needComma = true;
                    this.done(baseClause, OCElementTypes.CPP_BASE_CLAUSE);
                    if (!isEnum) continue;
                    break;
                }
                this.done(baseClause, OCElementTypes.CPP_BASE_CLAUSE);
                this.errorAndSkipToken("Unexpected token", this.TOP_LEVEL_DECLARATIONS_PARSER, OCElementTypes.UNKNOWN_CPP_CODE);
            }
            if (!needComma) {
                this.error("Expecting base type");
            }
        }
        this.done(baseClauseList, OCElementTypes.CPP_BASE_CLAUSE_LIST);
    }

    private boolean parseStructEntry(String structName) {
        if (this.parseCppAccessSpecifier()) {
            return true;
        }
        if (this.tt() == OCTokenTypes.SEMICOLON) {
            this.advance();
            return true;
        }
        return this.tryMarkStructFieldDeclaration(structName, false);
    }

    private boolean tryMarkStructFieldDeclaration(String structName, boolean objcClass) {
        PsiBuilder.Marker structEntry = this.mark();
        this.parseAttributes();
        boolean isAuto = false;
        boolean isFriend = false;
        while (OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES.contains(this.tt()) || !this.myIsCppSupport && this.tt() == OCTokenTypes.AUTO_KEYWORD) {
            if (this.tt() == OCTokenTypes.AUTO_KEYWORD) {
                isAuto = true;
            }
            if (this.tt() == OCTokenTypes.FRIEND_CPP_KEYWORD) {
                isFriend = true;
            }
            this.advance();
        }
        ArrayList<String> localTypenames = null;
        ArrayList localTypenamesKind = null;
        boolean isTemplate = false;
        while (this.tt() == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
            isTemplate = true;
            if (localTypenames == null) {
                localTypenames = new ArrayList<String>();
                localTypenamesKind = new ArrayList();
            }
            this.parseTemplateParameterList(localTypenames, localTypenamesKind);
        }
        if (this.tt() == OCTokenTypes.USING_CPP_KEYWORD) {
            this.parseUsingStatement(structEntry, isTemplate);
            return true;
        }
        if (this.myIsCppSupport && this.tt() == OCTokenTypes.STATIC_ASSERT_KEYWORD) {
            this.parseStaticAssert(structEntry);
            return true;
        }
        while (OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES.contains(this.tt()) || !this.myIsCppSupport && this.tt() == OCTokenTypes.AUTO_KEYWORD) {
            if (this.tt() == OCTokenTypes.AUTO_KEYWORD) {
                isAuto = true;
            }
            if (this.tt() == OCTokenTypes.FRIEND_CPP_KEYWORD) {
                isFriend = true;
            }
            this.advance();
        }
        IElementType first = this.tt();
        boolean isTypedef = first == OCTokenTypes.TYPEDEF_KEYWORD;
        TypeParsingResult result2 = this.parseSpecifierQualifierList(DeclarationContext.STRUCT, structName, isTypedef, isTemplate, isAuto, isFriend, true, TypeParsingExpectation.ANY);
        if (result2 == TypeParsingResult.NONE && !isTemplate) {
            this.rollbackTo(structEntry);
            return false;
        }
        DeclaratorsParsingResult parseResult = this.parseDeclarators(DeclarationContext.STRUCT, isTypedef, isTemplate, result2, structName);
        if (!parseResult.myType.isOk() && this.tt() != OCTokenTypes.SEMICOLON) {
            if (result2 == TypeParsingResult.EMPTY_TYPE_PARSED && !isTemplate) {
                this.rollbackTo(structEntry);
                return false;
            }
            this.error("Declarator expected");
        }
        if (this.tt() == OCTokenTypes.LBRACE) {
            List<String> name = this.myLastDeclaratorName;
            String singleName = this.myLastDeclaratorSingleName;
            this.enterNamespaceOfDeclarator(name, singleName);
            this.myLastDeclaratorSingleName = null;
            this.parseOrSkipCompoundStatement(false);
            while (this.tt() == OCTokenTypes.CATCH_KEYWORD) {
                this.parseCatchSection();
            }
            this.leaveNamespaceOfDeclarator(name, singleName);
            this.done(structEntry, OCElementTypes.FUNCTION_DEFINITION);
        } else {
            if (this.tt() == OCTokenTypes.SEMICOLON) {
                this.advance();
            } else {
                this.error("Missing ;");
            }
            boolean function = !isTypedef && !objcClass && parseResult.myType == DeclaratorsParsingResult.Type.PARSED_FUNCTION;
            this.done(structEntry, function ? OCElementTypes.FUNCTION_DECLARATION : OCElementTypes.DECLARATION);
        }
        return true;
    }

    private boolean parseAssignmentExpression(boolean allowEmpty) {
        return this.parseAssignmentExpression(allowEmpty, false);
    }

    private boolean parseAssignmentExpression(boolean allowEmpty, boolean inTemplate) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseConditionalExpression(allowEmpty, inTemplate)) {
            expr.drop();
            return false;
        }
        if (OCTokenTypes.ASSIGNMENT_OPERATIONS.contains(this.ttOrCppEquivalent())) {
            this.advance();
            this.parseAssignmentExpression(false, inTemplate);
            this.done(expr, OCElementTypes.ASSIGNMENT_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseConditionalExpression(boolean allowEmpty, boolean inTemplate) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseOrOrExpression(allowEmpty, inTemplate)) {
            expr.drop();
            return false;
        }
        if (this.tt() == OCTokenTypes.QUEST) {
            this.advance();
            MessagePassingContext insideMessage = this.myIsInMessagePassingParameter;
            this.myIsInMessagePassingParameter = MessagePassingContext.None;
            try {
                this.parseExpression(true);
            }
            finally {
                this.myIsInMessagePassingParameter = insideMessage;
            }
            this.expectToken(OCTokenTypes.COLON, "Expecting ':'");
            this.parseAssignmentExpression(false, inTemplate);
            this.done(expr, OCElementTypes.CONDITIONAL_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    private boolean parseOrOrExpression(boolean allowEmpty, boolean inTemplate) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseAndAndExpression(allowEmpty, inTemplate)) {
            expr.drop();
            return false;
        }
        while (this.tt() == OCTokenTypes.OROR) {
            this.advance();
            this.parseAndAndExpression(false, inTemplate);
            this.done(expr, OCElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseAndAndExpression(boolean allowEmpty, boolean inTemplate) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseOrExpression(allowEmpty, inTemplate)) {
            expr.drop();
            return false;
        }
        while (this.ttOrCppEquivalent() == OCTokenTypes.ANDAND) {
            this.advance();
            this.parseOrExpression(false, inTemplate);
            this.done(expr, OCElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseOrExpression(boolean allowEmpty, boolean inTemplate) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseXorExpression(allowEmpty, inTemplate)) {
            expr.drop();
            return false;
        }
        while (this.ttOrCppEquivalent() == OCTokenTypes.OR) {
            this.advance();
            this.parseXorExpression(false, inTemplate);
            this.done(expr, OCElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseXorExpression(boolean allowEmpty, boolean inTemplate) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseAndExpression(allowEmpty, inTemplate)) {
            expr.drop();
            return false;
        }
        while (this.ttOrCppEquivalent() == OCTokenTypes.XOR) {
            this.advance();
            this.parseAndExpression(false, inTemplate);
            this.done(expr, OCElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseAndExpression(boolean allowEmpty, boolean inTemplate) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseEqualityExpression(allowEmpty, inTemplate)) {
            expr.drop();
            return false;
        }
        while (this.ttOrCppEquivalent() == OCTokenTypes.AND) {
            this.advance();
            this.parseEqualityExpression(false, inTemplate);
            this.done(expr, OCElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseEqualityExpression(boolean allowEmpty, boolean inTemplate) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseRelationalExpression(allowEmpty, inTemplate)) {
            expr.drop();
            return false;
        }
        while (this.tt() == OCTokenTypes.EQEQ || this.ttOrCppEquivalent() == OCTokenTypes.EXCLEQ) {
            this.advance();
            this.parseRelationalExpression(false, inTemplate);
            this.done(expr, OCElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseRelationalExpression(boolean allowEmpty, boolean inTemplate) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseShiftExpression(allowEmpty, inTemplate)) {
            expr.drop();
            return false;
        }
        IElementType tt = this.tt();
        while (tt == OCTokenTypes.LT || !inTemplate && !this.myTemplateGTGT && tt == OCTokenTypes.GT || tt == OCTokenTypes.LTEQ || tt == OCTokenTypes.GTEQ) {
            this.advance();
            this.parseShiftExpression(false, inTemplate);
            this.done(expr, OCElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
            tt = this.tt();
        }
        expr.drop();
        return true;
    }

    private boolean parseShiftExpression(boolean allowEmpty, boolean inTemplate) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseAdditiveExpression(allowEmpty)) {
            expr.drop();
            return false;
        }
        while (this.tt() == OCTokenTypes.LTLT || !inTemplate && this.tt() == OCTokenTypes.GTGT) {
            this.advance();
            this.parseAdditiveExpression(false);
            this.done(expr, OCElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseAdditiveExpression(boolean allowEmpty) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseMultiplicativeExpression(allowEmpty)) {
            expr.drop();
            return false;
        }
        while (this.tt() == OCTokenTypes.PLUS || this.tt() == OCTokenTypes.MINUS) {
            this.advance();
            this.parseMultiplicativeExpression(false);
            this.done(expr, OCElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseMultiplicativeExpression(boolean allowEmpty) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parsePmExpression(allowEmpty)) {
            expr.drop();
            return false;
        }
        while (this.tt() == OCTokenTypes.MUL || this.tt() == OCTokenTypes.DIV || this.tt() == OCTokenTypes.PERC) {
            this.advance();
            this.parsePmExpression(false);
            this.done(expr, OCElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parsePmExpression(boolean allowEmpty) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseCastExpression(allowEmpty)) {
            expr.drop();
            return false;
        }
        while (this.tt() == OCTokenTypes.DOT_MUL || this.tt() == OCTokenTypes.DEREF_MUL) {
            this.advance();
            this.parseCastExpression(false);
            this.done(expr, OCElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseCppCastExpression() {
        IElementType tt = this.tt();
        if (OCTokenTypes.CPP_CAST_OPERATIONS.contains(tt)) {
            PsiBuilder.Marker expr = this.mark();
            this.advance();
            this.expectToken(OCTokenTypes.LT, "Expecting '<'");
            this.parseTypeExpression();
            this.expectToken(OCTokenTypes.GT, "Expecting '>'");
            this.expectToken(OCTokenTypes.LPAR, "Expecting '('");
            this.parseExpression(false);
            this.expectToken(OCTokenTypes.RPAR, "Expecting ')'");
            this.done(expr, OCElementTypes.CAST_EXPRESSION);
            return true;
        }
        return false;
    }

    private boolean parseCastExpression(boolean allowEmpty) {
        IElementType tt = this.tt();
        if (tt == OCTokenTypes.LPAR) {
            PsiBuilder.Marker typeTest = this.mark();
            this.advance();
            IElementType typeFirst = this.ttOrTypeName();
            boolean wasIdentifier = typeFirst == OCTokenTypes.IDENTIFIER || typeFirst == OCTokenTypes.COLON2X;
            OCParsingNameScope.Kind isType = this.detectTypeNameKind(false);
            this.rollbackTo(typeTest);
            PsiBuilder.Marker expr = this.mark();
            if (!this.tryParseTypeInParens(TypeParsingExpectation.NON_EXACT_VALUES)) {
                this.rollbackTo(expr);
                return this.parseUnaryExpression(allowEmpty);
            }
            if (this.tt() == OCTokenTypes.LBRACE) {
                this.parseCompoundInitializer();
            } else {
                if (this.tt() == OCTokenTypes.RPAR || this.tt() == OCTokenTypes.COMMA || this.tt() == OCTokenTypes.SEMICOLON || (typeFirst == OCTokenTypes.IDENTIFIER || typeFirst == OCTokenTypes.OPERATOR_CPP_KEYWORD || typeFirst == OCTokenTypes.COLON2X) && !OCParsingNameScope.isType(isType) && !OCTokenTypes.LITERALS.contains(this.tt()) && this.tt() != OCTokenTypes.IDENTIFIER) {
                    this.rollbackTo(expr);
                    return this.parseUnaryExpression(false);
                }
                if (this.tt() == OCTokenTypes.IDENTIFIER) {
                    boolean inParameterOrReiceiver;
                    PsiBuilder.Marker check = this.mark();
                    this.advance();
                    boolean inReiceiver = this.myIsInMessagePassingParameter == MessagePassingContext.InReiceiver;
                    boolean bl = inParameterOrReiceiver = inReiceiver || this.myIsInMessagePassingParameter == MessagePassingContext.InParameter;
                    if (inParameterOrReiceiver && this.tt() == OCTokenTypes.COLON || inReiceiver && this.tt() == OCTokenTypes.RBRACKET) {
                        this.rollbackTo(expr);
                        return this.parseUnaryExpression(allowEmpty);
                    }
                    this.rollbackTo(check);
                }
                if (!(this.parseCastExpression(false) || wasIdentifier && !OCParsingNameScope.isValue(isType))) {
                    this.rollbackTo(expr);
                    return this.parseUnaryExpression(false);
                }
            }
            this.done(expr, OCElementTypes.CAST_EXPRESSION);
            return true;
        }
        if (this.myIsCppSupport && (OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(tt) && tt != OCTokenTypes.IDENTIFIER || tt == OCTokenTypes.DECLTYPE_CPP_KEYWORD || tt == OCTokenTypes.UNDERLYING_TYPE_KEYWORD)) {
            PsiBuilder.Marker expr = this.mark();
            PsiBuilder.Marker typeElement = this.mark();
            if (tt == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
                this.parseTypeOfExpression();
            } else if (tt == OCTokenTypes.UNDERLYING_TYPE_KEYWORD) {
                this.advance();
                this.parseTypeInParens(false);
            } else {
                this.advance();
            }
            this.done(typeElement, OCElementTypes.TYPE_ELEMENT);
            if (this.tt() == OCTokenTypes.LPAR) {
                this.parseExpressionList();
            } else if (this.myIsCppSupport && this.tt() == OCTokenTypes.LBRACE) {
                this.parseCompoundInitializer();
            } else {
                this.error("Expected '('");
            }
            this.done(expr, OCElementTypes.CAST_EXPRESSION);
            return true;
        }
        return this.parseUnaryExpression(allowEmpty);
    }

    private boolean parseTypeName(DeclarationContext context, TypeParsingExpectation typeExpectation) {
        return !this.parseTypeNameWithResult(context, typeExpectation, true).isEmpty();
    }

    private TypeParsingResult parseTypeNameWithResult(DeclarationContext context, TypeParsingExpectation typeExpectation, boolean skipEllipsis) {
        if (this.tt() == OCTokenTypes.TYPEOF_KEYWORD || this.tt() == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
            return this.parseTypeOfExpression() ? TypeParsingResult.TYPE_PARSED_FOR_SURE : TypeParsingResult.NONE;
        }
        TypeParsingResult typeParsingResult = this.parseSpecifierQualifierList(false, context, typeExpectation);
        if (typeParsingResult == TypeParsingResult.NONE) {
            return typeParsingResult;
        }
        boolean old = this.myIsInsideTypeNameParsing;
        this.myIsInsideTypeNameParsing = true;
        DeclaratorParsingResult declaratorParsingResult = this.parseDeclarator(context, true, false, false, skipEllipsis, typeParsingResult != TypeParsingResult.UNKNOWN, TypeParsingResult.TYPE_PARSED_FOR_SURE);
        this.myIsInsideTypeNameParsing = old;
        if (!declaratorParsingResult.isOk()) {
            return TypeParsingResult.NONE;
        }
        if (typeParsingResult.isEmpty() && !declaratorParsingResult.isEmpty()) {
            return TypeParsingResult.TYPE_PARSED;
        }
        if (declaratorParsingResult != DeclaratorParsingResult.PARSED_EMPTY && typeParsingResult == TypeParsingResult.UNKNOWN) {
            return TypeParsingResult.TYPE_PARSED;
        }
        return typeParsingResult;
    }

    private boolean parseTypeNameInNewExpression() {
        PsiBuilder.Marker mark = this.mark();
        boolean result2 = true;
        if (this.tt() == OCTokenTypes.TYPEOF_KEYWORD || this.tt() == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
            this.parseTypeOfExpression();
        } else if (this.parseSpecifierQualifierList(DeclarationContext.CODE_BLOCK, null, false, true, false, false, false, TypeParsingExpectation.ANY) == TypeParsingResult.NONE) {
            result2 = false;
        } else {
            this.parseDeclarator(DeclarationContext.CPP_NEW_EXPRESSION, true, false, false, true, true, TypeParsingResult.TYPE_PARSED_FOR_SURE);
        }
        this.done(mark, OCElementTypes.TYPE_ELEMENT);
        return result2;
    }

    private boolean parseUnaryExpression(boolean allowEmpty) {
        IElementType tt = this.tt();
        if (tt == OCTokenTypes.PLUSPLUS || tt == OCTokenTypes.MINUSMINUS) {
            PsiBuilder.Marker expr = this.mark();
            this.advance();
            this.parseUnaryExpression(false);
            this.done(expr, OCElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        if (tt == OCTokenTypes.SIZEOF_KEYWORD || tt == OCTokenTypes.ALIGNOF_KEYWORD || tt == OCTokenTypes.ALIGNOF_CPP_KEYWORD) {
            return this.parseSizeofOrTypeidExpression();
        }
        if (this.tt() == OCTokenTypes.NOEXCEPT_KEYWORD) {
            return this.parseNoexceptOperator();
        }
        if (this.myIsCppSupport) {
            PsiBuilder.Marker start = this.mark();
            if (tt == OCTokenTypes.COLON2X) {
                this.advance();
            }
            if ((tt = this.tt()) == OCTokenTypes.NEW_CPP_KEYWORD) {
                this.parseCppNewExpression();
                this.done(start, OCElementTypes.CPP_NEW_EXPRESSION);
                return true;
            }
            if (tt == OCTokenTypes.DELETE_CPP_KEYWORD) {
                this.parseCppDeleteExpression();
                this.done(start, OCElementTypes.CPP_DELETE_EXPRESSION);
                return true;
            }
            this.rollbackTo(start);
        }
        if (OCTokenTypes.UNARY_OPERATIONS.contains(this.ttOrCppEquivalent())) {
            PsiBuilder.Marker expr = this.mark();
            this.advance();
            this.parseCastExpression(false);
            this.done(expr, OCElementTypes.UNARY_EXPRESSION);
            return true;
        }
        return this.parsePostfixExpression(allowEmpty);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parsePostfixExpression(boolean allowEmpty) {
        PsiBuilder.Marker expr = this.mark();
        if (OCTokenTypes.CPP_CAST_OPERATIONS.contains(this.tt())) {
            this.parseCppCastExpression();
        } else if (!this.parsePrimaryExpression(allowEmpty)) {
            expr.drop();
            return false;
        }
        while (true) {
            block12: {
                IElementType token;
                if ((token = this.tt()) == OCTokenTypes.LBRACKET) {
                    PsiBuilder.Marker copy = this.mark();
                    this.advance();
                    MessagePassingContext insideMessage = this.myIsInMessagePassingParameter;
                    this.myIsInMessagePassingParameter = MessagePassingContext.None;
                    this.parseExpression(false);
                    this.myIsInMessagePassingParameter = insideMessage;
                    if (this.tt() == OCTokenTypes.SEMICOLON) {
                        this.error("Expecting ']'");
                        this.advance();
                    }
                    if (this.tt() == OCTokenTypes.RBRACKET) {
                        copy.drop();
                        this.advance();
                        this.done(expr, OCElementTypes.ARRAY_SLICE_EXPRESSION);
                        break block12;
                    } else {
                        this.rollbackTo(copy);
                        break;
                    }
                }
                if (token == OCTokenTypes.LPAR) {
                    this.parseExpressionList();
                    this.done(expr, OCElementTypes.CALL_EXPRESSION);
                } else if (token == OCTokenTypes.DOT || token == OCTokenTypes.DEREF) {
                    PsiBuilder.Marker accessor = this.mark();
                    this.advance();
                    this.done(accessor, OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR);
                    this.parseQualifiedIdentifier(null, false, true, false, null);
                    this.done(expr, OCElementTypes.QUALIFIED_EXPRESSION);
                } else {
                    if (token != OCTokenTypes.PLUSPLUS && token != OCTokenTypes.MINUSMINUS) break;
                    this.advance();
                    this.done(expr, OCElementTypes.POSTFIX_EXPRESSION);
                }
            }
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parsePrimaryExpression(boolean allowEmpty) {
        PsiBuilder.Marker expr = this.mark();
        this.parseCpp11Attributes();
        IElementType token = this.tt();
        if (token == OCTokenTypes.__ATTRIBUTE_KEYWORD) {
            this.error("Expecting expression");
            this.parseGccAttrubutes();
            this.done(expr, OCElementTypes.REFERENCE_EXPRESSION);
            return true;
        }
        if (token == OCTokenTypes.TYPEID_CPP_KEYWORD) {
            this.parseSizeofOrTypeidExpression();
            expr.drop();
            return true;
        }
        if (token == OCTokenTypes.IDENTIFIER || token == OCTokenTypes.COLON2X || token == OCTokenTypes.THIS_CPP_KEYWORD || token == OCTokenTypes.OPERATOR_CPP_KEYWORD || token == OCTokenTypes.TYPENAME_CPP_KEYWORD) {
            String text = this.myBuilder.getTokenText();
            if (this.myParsingInsideMacro && "defined".equals(text)) {
                PsiBuilder.Marker defined = this.mark();
                this.advance();
                PsiBuilder.Marker ref = this.mark();
                boolean result2 = this.parsePrimaryExpression(false);
                this.done(ref, OCElementTypes.MACRO_REF);
                this.done(defined, OCElementTypes.DEFINED_DIRECTIVE);
                expr.drop();
                return result2;
            }
            PsiBuilder.Marker typeElement = this.mark();
            PsiBuilder.Marker refElement = this.mark();
            if (token == OCTokenTypes.THIS_CPP_KEYWORD) {
                this.advance();
            } else {
                this.parseQualifiedIdentifier();
            }
            this.done(refElement, OCElementTypes.REFERENCE_ELEMENT);
            if (this.myIsCppSupport && this.tt() == OCTokenTypes.LBRACE) {
                this.done(typeElement, OCElementTypes.TYPE_ELEMENT);
                this.parseCompoundInitializer();
                this.done(expr, OCElementTypes.CAST_EXPRESSION);
            } else {
                this.done(expr, OCElementTypes.REFERENCE_EXPRESSION);
                typeElement.drop();
            }
            return true;
        }
        if (token == OCTokenTypes.LPAR) {
            this.advance();
            if (this.tt() == OCTokenTypes.LBRACE) {
                this.parseCompoundStatement();
                this.expectToken(OCTokenTypes.RPAR, "Missing ')'");
                this.done(expr, OCElementTypes.STATEMENT_EXPRESSION);
            } else {
                boolean inner = this.parseExpression(allowEmpty);
                if (!this.expectToken(OCTokenTypes.RPAR, "Missing ')'") && !inner) {
                    this.rollbackTo(expr);
                    return false;
                }
                this.done(expr, OCElementTypes.PAREN_EXPRESSION);
            }
            return true;
        }
        if (OCTokenTypes.LITERALS.contains(token) || OCTokenTypes.CPP_LITERALS.contains(token) || OCTokenTypes.RAW_STRING_LITERALS.contains(token)) {
            block51: {
                if (OCTokenTypes.AT == token || OCTokenTypes.ALL_STRINGS.contains(token)) {
                    PsiBuilder.Marker beforeAt;
                    boolean hasAt;
                    while (true) {
                        hasAt = this.tt() == OCTokenTypes.AT;
                        beforeAt = null;
                        if (hasAt) {
                            beforeAt = this.mark();
                            this.advance();
                        }
                        IElementType tt = this.tt();
                        if (hasAt && tt == OCTokenTypes.LPAR) {
                            this.parseExpressionInParens();
                            this.done(beforeAt, OCElementTypes.BOXED_EXPRESSION);
                            expr.drop();
                            return true;
                        }
                        if (OCTokenTypes.ALL_STRINGS.contains(tt) || tt == OCTokenTypes.INTEGER_LITERAL || tt == OCTokenTypes.FLOAT_LITERAL || tt == OCTokenTypes.CHARACTER_LITERAL || tt == OCTokenTypes.WRONG_INTEGER_LITERAL || tt == OCTokenTypes.WRONG_FLOAT_LITERAL) {
                            this.advance();
                            if (beforeAt != null) {
                                beforeAt.drop();
                            }
                            if (OCTokenTypes.ALL_STRINGS.contains(tt)) continue;
                            break block51;
                        }
                        if (hasAt && (tt == OCTokenTypes.MINUS || tt == OCTokenTypes.PLUS)) {
                            PsiBuilder.Marker unary = this.mark();
                            this.advance();
                            if (this.tt() == OCTokenTypes.INTEGER_LITERAL || this.tt() == OCTokenTypes.FLOAT_LITERAL || this.tt() == OCTokenTypes.CHARACTER_LITERAL || this.tt() == OCTokenTypes.WRONG_INTEGER_LITERAL || this.tt() == OCTokenTypes.WRONG_FLOAT_LITERAL) {
                                this.parsePrimaryExpression(false);
                            } else {
                                this.error("Expecting integer or float literal");
                            }
                            this.done(unary, OCElementTypes.UNARY_EXPRESSION);
                            this.done(beforeAt, OCElementTypes.BOXED_EXPRESSION);
                            expr.drop();
                            return true;
                        }
                        if (hasAt && tt == OCTokenTypes.LBRACKET) {
                            this.advance();
                            while (!this.eof() && this.tt() != OCTokenTypes.RBRACKET) {
                                this.parseAssignmentExpression(false);
                                if (this.tt() == OCTokenTypes.COMMA) {
                                    this.advance();
                                    if (this.tt() != OCTokenTypes.RBRACKET) continue;
                                    break;
                                }
                                if (this.tt() == OCTokenTypes.RBRACKET) continue;
                                this.error("',' or ']' expected");
                                break;
                            }
                            this.expectToken(OCTokenTypes.RBRACKET, "']' missing");
                            this.done(beforeAt, OCElementTypes.NS_ARRAY_LITERAL);
                            continue;
                        }
                        if (!hasAt || tt != OCTokenTypes.LBRACE) break;
                        this.advance();
                        MessagePassingContext old = this.myIsInMessagePassingParameter;
                        this.myIsInMessagePassingParameter = MessagePassingContext.None;
                        while (!this.eof() && this.tt() != OCTokenTypes.RBRACE) {
                            this.parseAssignmentExpression(false);
                            this.expectToken(OCTokenTypes.COLON, "Expecting ':'");
                            this.parseAssignmentExpression(false);
                            if (this.tt() == OCTokenTypes.COMMA) {
                                this.advance();
                                if (this.tt() != OCTokenTypes.RBRACE) continue;
                                break;
                            }
                            if (this.tt() == OCTokenTypes.RBRACE) continue;
                            this.errorAndSkipTokenUntil("',' or '}' expected", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE, OCTokenTypes.RBRACE);
                        }
                        this.expectToken(OCTokenTypes.RBRACE, "'}' missing");
                        this.myIsInMessagePassingParameter = old;
                        this.done(beforeAt, OCElementTypes.NS_DICTIONARY_LITERAL);
                    }
                    if (hasAt) {
                        this.error("Expecting string literal");
                    }
                    if (beforeAt != null) {
                        beforeAt.drop();
                    }
                } else {
                    this.advance();
                }
            }
            this.done(expr, OCElementTypes.LITERAL_EXPRESSION);
            return true;
        }
        if (token == OCTokenTypes.LBRACKET) {
            if (this.myIsCppSupport) {
                PsiBuilder.Marker test = this.mark();
                this.advance();
                if (this.tt() == OCTokenTypes.AND || this.tt() == OCTokenTypes.EQ || this.tt() == OCTokenTypes.RBRACKET) {
                    this.rollbackTo(test);
                    return this.parseLambdaExpression(expr);
                }
                if (this.tt() == OCTokenTypes.IDENTIFIER || this.tt() == OCTokenTypes.THIS_CPP_KEYWORD) {
                    if (this.tt() == OCTokenTypes.THIS_CPP_KEYWORD) {
                        this.advance();
                    } else {
                        this.parseQualifiedCppType();
                    }
                    if (this.tt() == OCTokenTypes.COMMA || this.tt() == OCTokenTypes.ELLIPSIS) {
                        this.rollbackTo(test);
                        return this.parseLambdaExpression(expr);
                    }
                    if (this.tt() == OCTokenTypes.RBRACKET) {
                        this.advance();
                        if (this.tt() == OCTokenTypes.LPAR || this.tt() == OCTokenTypes.LBRACE) {
                            this.rollbackTo(test);
                            return this.parseLambdaExpression(expr);
                        }
                    }
                }
                this.rollbackTo(test);
            }
            if (this.myIsObjCSupport) {
                return this.parseMessagePassingExpression(expr);
            }
        } else {
            if (token == OCTokenTypes.LBRACE) {
                this.parseCompoundInitializer();
                expr.drop();
                return true;
            }
            if (OCElementTypes.OBJC_ERROR_KEYWORD == token) {
                this.advance();
                expr.drop();
                return false;
            }
            if (token == OCTokenTypes.SELECTOR_KEYWORD) {
                return this.parseSelectorExpression(expr);
            }
            if (token == OCTokenTypes.ENCODE_KEYWORD) {
                return this.parseEncodeTypeExpression(expr);
            }
            if (token == OCTokenTypes.PROTOCOL_KEYWORD) {
                return this.parseProtocolExpression(expr);
            }
            if (token == OCTokenTypes.THROW_KEYWORD && this.ttOrTypeName() == OCTokenTypes.THROW_KEYWORD && this.myIsCppSupport) {
                return this.parseThrowExpression(expr);
            }
            if (token == OCTokenTypes.XOR) {
                return this.parseBlockExpression(expr);
            }
            if (token == OCTokenTypes.TEMPLATE_START_MARK) {
                do {
                    this.advance();
                } while (this.tt() != OCTokenTypes.TEMPLATE_STOP_MARK && this.tt() != null);
                this.advance();
                this.done(expr, OCElementTypes.LITERAL_EXPRESSION);
                return true;
            }
        }
        if (!allowEmpty) {
            this.error("Expression expected");
        }
        expr.drop();
        return false;
    }

    private boolean parseLambdaExpression(PsiBuilder.Marker expr) {
        boolean hasParams;
        this.parseLambdaExpressionIntroducer();
        boolean bl = hasParams = this.tt() == OCTokenTypes.LPAR;
        if (hasParams) {
            this.parseParameterList();
        }
        if (this.tt() == OCTokenTypes.MUTABLE_CPP_KEYWORD) {
            if (!hasParams) {
                this.error("Lambda requires '()' before 'mutable'");
            }
            this.advance();
        }
        if (this.tt() == OCTokenTypes.THROW_KEYWORD) {
            this.parseExceptionSpecification();
        }
        if (this.tt() == OCTokenTypes.NOEXCEPT_KEYWORD) {
            this.parseNoexceptSpecifier();
        }
        this.parseCpp11Attributes();
        if (this.tt() == OCTokenTypes.DEREF) {
            this.advance();
            this.parseTypeExpression();
        }
        this.parseOrSkipCompoundStatement(false);
        this.done(expr, OCElementTypes.CPP_LAMBDA_EXPRESSION);
        return true;
    }

    private void parseLambdaExpressionIntroducer() {
        PsiBuilder.Marker mark = this.mark();
        this.expectToken(OCTokenTypes.LBRACKET, "'[' expecting");
        boolean first = true;
        while (!this.eof() && this.tt() != OCTokenTypes.RBRACKET) {
            PsiBuilder.Marker refelement;
            if (!first) {
                this.expectToken(OCTokenTypes.COMMA, ", expected");
            }
            first = false;
            if (this.tt() == OCTokenTypes.RBRACKET) {
                this.error("Expecting lambda capture");
                break;
            }
            if (this.tt() == OCTokenTypes.AND) {
                this.advance();
                if (this.tt() != OCTokenTypes.IDENTIFIER) continue;
                refelement = this.mark();
                this.parseQualifiedCppType();
                this.done(refelement, OCElementTypes.REFERENCE_ELEMENT);
                continue;
            }
            if (this.tt() == OCTokenTypes.EQ) {
                this.advance();
                continue;
            }
            if (this.tt() == OCTokenTypes.IDENTIFIER) {
                refelement = this.mark();
                this.parseQualifiedCppType();
                this.done(refelement, OCElementTypes.REFERENCE_ELEMENT);
                if (this.tt() != OCTokenTypes.ELLIPSIS) continue;
                this.advance();
                continue;
            }
            if (this.tt() == OCTokenTypes.THIS_CPP_KEYWORD) {
                this.advance();
                continue;
            }
            this.errorAndSkipToken("Syntax error", this.BLOCK_STATEMENT_PARSER, OCElementTypes.EAGER_BLOCK_STATEMENT);
        }
        if (this.tt() == OCTokenTypes.RBRACKET) {
            this.advance();
        }
        this.done(mark, OCElementTypes.CPP_LAMBDA_INTRODUCER);
    }

    private boolean parseBlockExpression(PsiBuilder.Marker expr) {
        assert (this.tt() == OCTokenTypes.XOR);
        this.advance();
        if (this.tt() != OCTokenTypes.LPAR && this.tt() != OCTokenTypes.LBRACE) {
            PsiBuilder.Marker typeElement = this.mark();
            this.parseSpecifierQualifierList(false, DeclarationContext.CODE_BLOCK, TypeParsingExpectation.ANY);
            while (this.tt() == OCTokenTypes.MUL) {
                this.advance();
            }
            this.done(typeElement, OCElementTypes.TYPE_ELEMENT);
        }
        if (this.tt() == OCTokenTypes.LPAR) {
            this.parseParameterList();
        }
        if (this.tt() == OCTokenTypes.LBRACE) {
            this.parseCompoundStatement();
        } else {
            this.error("Expecting a block");
        }
        this.done(expr, OCElementTypes.BLOCK_EXPRESSION);
        return true;
    }

    private boolean parseEncodeTypeExpression(PsiBuilder.Marker expr) {
        assert (this.tt() == OCTokenTypes.ENCODE_KEYWORD);
        this.advance();
        if (!this.tryParseTypeInParens(TypeParsingExpectation.ANY)) {
            this.error("Expecting typename");
        }
        this.done(expr, OCElementTypes.ENCODE_TYPE_EXPRESSION);
        return true;
    }

    private boolean parseProtocolExpression(PsiBuilder.Marker expr) {
        assert (this.tt() == OCTokenTypes.PROTOCOL_KEYWORD);
        this.advance();
        this.expectToken(OCTokenTypes.LPAR, "Expecting '('");
        if (!this.parseTypeExpression()) {
            this.error("Expecting protocol name");
        }
        this.expectToken(OCTokenTypes.RPAR, "Expecting ')");
        this.done(expr, OCElementTypes.PROTOCOL_EXPRESSION);
        return true;
    }

    private boolean parseThrowExpression(PsiBuilder.Marker expr) {
        assert (this.tt() == OCTokenTypes.THROW_KEYWORD);
        this.advance();
        this.parseAssignmentExpression(true);
        this.done(expr, OCElementTypes.THROW_EXPRESSION);
        return true;
    }

    private boolean parseMessagePassingExpression(PsiBuilder.Marker expr) {
        assert (this.tt() == OCTokenTypes.LBRACKET);
        this.advance();
        MessagePassingContext insideMessage = this.myIsInMessagePassingParameter;
        this.myIsInMessagePassingParameter = MessagePassingContext.InReiceiver;
        this.parseExpression(false);
        this.myIsInMessagePassingParameter = insideMessage;
        PsiBuilder.Marker arg = this.mark();
        PsiBuilder.Marker argumentSelector = this.mark();
        IElementType tt1 = this.tt();
        if (this.isValidSelectorName(tt1)) {
            if (tt1 != OCTokenTypes.IDENTIFIER) {
                this.remapCurrentToken(OCTokenTypes.IDENTIFIER);
            }
            this.advance();
            if (this.tt() == OCTokenTypes.COLON) {
                IElementType tt;
                argumentSelector.drop();
                this.rollbackTo(arg);
                while ((tt = this.tt()) != OCTokenTypes.RBRACKET && tt != null && tt != OCTokenTypes.SEMICOLON && tt != OCTokenTypes.RBRACE) {
                    if (tt == OCTokenTypes.RPAR) {
                        this.errorAndSkipToken("Unexpected ')'", this.BLOCK_STATEMENT_PARSER, OCElementTypes.EAGER_BLOCK_STATEMENT);
                    }
                    if (this.parseMessageArgument()) continue;
                    break;
                }
            } else {
                this.done(argumentSelector, OCElementTypes.ARGUMENT_SELECTOR);
                this.done(arg, OCElementTypes.MESSAGE_ARGUMENT);
            }
        } else {
            argumentSelector.drop();
            arg.drop();
            IElementType tt = this.tt();
            if (tt != OCTokenTypes.RBRACE && tt != OCTokenTypes.RPAR && tt != OCTokenTypes.RBRACKET) {
                this.errorAndSkipToken("Message select", this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE);
            }
        }
        this.expectToken(OCTokenTypes.RBRACKET, "']' missing");
        this.done(expr, OCElementTypes.MESSAGE_EXPRESSION);
        return true;
    }

    private boolean isValidSelectorName(IElementType tt) {
        return tt == OCTokenTypes.IDENTIFIER || OCTokenTypes.CPP_KEYWORDS.contains(tt) || OCTokenTypes.NULLABILITY_KEYWORDS.contains(tt) || OCTokenTypes.C_KEYWORDS.contains(tt) && tt != OCTokenTypes.__ATTRIBUTE_KEYWORD || OCElementUtil.isAlternativeCppPunctuator(tt, this.myBuilder.getTokenText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseMessageArgument() {
        PsiBuilder.Marker savedLastMacro = this.myLastMacro;
        IElementType savedKeyword = null;
        PsiBuilder.Marker arg = this.mark();
        PsiBuilder.Marker argumentSelector = this.mark();
        IElementType tt = this.tt();
        if (this.isValidSelectorName(tt)) {
            if (tt != OCTokenTypes.IDENTIFIER) {
                savedKeyword = tt;
                this.remapCurrentToken(OCTokenTypes.IDENTIFIER);
            }
            this.advance();
        }
        if (this.tt() != OCTokenTypes.COLON && this.tt() != OCTokenTypes.RBRACKET && this.tt() != OCTokenTypes.SEMICOLON) {
            this.rollbackTo(argumentSelector);
            this.rollbackTo(arg);
            this.myLastMacro = savedLastMacro;
            if (savedKeyword != null) {
                this.remapCurrentToken(savedKeyword);
            }
            this.error("Message selector expected");
            return false;
        }
        this.advance();
        this.done(argumentSelector, OCElementTypes.ARGUMENT_SELECTOR);
        this.myIsInMessagePassingParameter = MessagePassingContext.InParameter;
        boolean missingExpression = false;
        if (this.tt() == OCTokenTypes.IDENTIFIER) {
            PsiBuilder.Marker test = this.mark();
            this.advance();
            if (this.tt() == OCTokenTypes.COLON) {
                missingExpression = true;
            }
            this.rollbackTo(test);
            if (missingExpression) {
                boolean bl = missingExpression = this.detectTypeNameKind(false) == null;
                if (missingExpression) {
                    this.error("Expecting message argument");
                }
            }
        }
        try {
            if (!missingExpression) {
                this.parseAssignmentExpression(false);
            }
        }
        finally {
            this.myIsInMessagePassingParameter = MessagePassingContext.None;
        }
        this.done(arg, OCElementTypes.MESSAGE_ARGUMENT);
        while (this.tt() == OCTokenTypes.COMMA) {
            this.advance();
            PsiBuilder.Marker ellipsisArg = this.mark();
            this.done(this.mark(), OCElementTypes.ARGUMENT_SELECTOR);
            this.parseAssignmentExpression(false);
            this.done(ellipsisArg, OCElementTypes.MESSAGE_ARGUMENT);
        }
        return true;
    }

    private boolean parseSelectorExpression(PsiBuilder.Marker expr) {
        assert (this.tt() == OCTokenTypes.SELECTOR_KEYWORD);
        this.advance();
        if (this.expectToken(OCTokenTypes.LPAR, "'(' required")) {
            while (this.isValidSelectorName(this.tt()) || this.tt() == OCTokenTypes.COLON || this.tt() == OCTokenTypes.COLON2X) {
                if (this.tt() != OCTokenTypes.IDENTIFIER && this.tt() != OCTokenTypes.COLON && this.tt() != OCTokenTypes.COLON2X) {
                    this.remapCurrentToken(OCTokenTypes.IDENTIFIER);
                }
                this.advance();
            }
            this.expectToken(OCTokenTypes.RPAR, "')' required");
        }
        this.done(expr, OCElementTypes.SELECTOR_EXPRESSION);
        return true;
    }

    private void parseCppDeleteExpression() {
        assert (this.tt() == OCTokenTypes.DELETE_CPP_KEYWORD);
        this.advance();
        if (this.tt() == OCTokenTypes.LBRACKET) {
            this.advance();
            this.expectToken(OCTokenTypes.RBRACKET, "Expecting ']'");
        }
        this.parseCastExpression(false);
    }

    private void parseCppNewExpression() {
        assert (this.tt() == OCTokenTypes.NEW_CPP_KEYWORD);
        this.advance();
        if (this.tt() == OCTokenTypes.LPAR) {
            if (!this.tryParseTypeInParens(TypeParsingExpectation.ONLY_TYPES)) {
                this.parseExpressionList();
                if (this.tt() == OCTokenTypes.LPAR) {
                    this.parseTypeInParens(false);
                } else if (!this.parseTypeNameInNewExpression()) {
                    this.error("Type name expected");
                }
            }
            if (this.tt() == OCTokenTypes.LBRACE) {
                this.parseCompoundInitializer();
            }
        } else if (!this.parseTypeNameInNewExpression()) {
            this.error("Type name expected");
        }
        if (this.tt() == OCTokenTypes.LPAR) {
            this.parseExpressionList();
        }
    }

    private boolean tryParseTypeInSizeOfExpression() {
        PsiBuilder.Marker startMarker = this.mark();
        if (!this.parseTypeExpression(DeclarationContext.SIZEOF, TypeParsingExpectation.ANY) || this.tt() != OCTokenTypes.RPAR) {
            this.rollbackTo(startMarker);
            return false;
        }
        startMarker.drop();
        return true;
    }

    private boolean parseSizeofOrTypeidExpression() {
        boolean typeid;
        IElementType tt = this.tt();
        boolean bl = typeid = tt == OCTokenTypes.TYPEID_CPP_KEYWORD;
        assert (tt == OCTokenTypes.SIZEOF_KEYWORD || tt == OCTokenTypes.ALIGNOF_KEYWORD || tt == OCTokenTypes.ALIGNOF_CPP_KEYWORD || typeid);
        PsiBuilder.Marker stmt = this.mark();
        this.advance();
        if (this.tt() == OCTokenTypes.ELLIPSIS) {
            this.advance();
        }
        if (this.tt() == OCTokenTypes.LPAR) {
            this.parseTypeOrExprInParents();
        } else if (!this.parseUnaryExpression(true)) {
            this.error("Expecting expression or '('");
        }
        this.done(stmt, typeid ? OCElementTypes.CPP_TYPEID_EXPRESSION : OCElementTypes.SIZEOF_EXPRESSION);
        return true;
    }

    private void parseTypeOrExprInParents() {
        this.expectToken(OCTokenTypes.LPAR, "Expecting '('");
        IElementType tt = this.tt();
        if (CPP_SPECIFIERS_FIRST.contains(tt) && (tt != OCTokenTypes.IDENTIFIER || this.detectTypeName())) {
            if (!this.tryParseTypeInSizeOfExpression() && !this.parseExpression(true)) {
                this.error("Expecting typename or expression");
            }
        } else if (!this.parseExpression(true) && !this.tryParseTypeInSizeOfExpression()) {
            this.error("Expecting typename or expression");
        }
        this.expectToken(OCTokenTypes.RPAR, "Expecting ')'");
    }

    private boolean parseNoexceptOperator() {
        assert (this.tt() == OCTokenTypes.NOEXCEPT_KEYWORD);
        this.advance();
        this.expectToken(OCTokenTypes.LPAR, "Expecting '('");
        this.parseExpression(false);
        this.expectToken(OCTokenTypes.RPAR, "Expecting ')'");
        return true;
    }

    private boolean parseTypeOfExpression() {
        this.advance();
        if (this.expectToken(OCTokenTypes.LPAR, "expecting '('")) {
            this.parseExpression(false);
            this.expectToken(OCTokenTypes.RPAR, "missing ')'");
        }
        return true;
    }

    private void parseExpressionList() {
        assert (this.tt() == OCTokenTypes.LPAR);
        PsiBuilder.Marker paramList = this.mark();
        this.advance();
        if (this.tt() == OCTokenTypes.LT && this.myIsInsideDirective) {
            this.skipTokenUntil(OCTokenTypes.GT);
            this.advance();
        } else {
            while (!this.eof() && this.tt() != OCTokenTypes.RPAR) {
                this.parseAssignmentExpression(false);
                if (this.tt() == OCTokenTypes.ELLIPSIS) {
                    this.advance();
                }
                if (this.tt() == OCTokenTypes.COMMA) {
                    this.advance();
                    if (this.tt() != OCTokenTypes.RPAR) continue;
                    this.error("Expecting expression");
                    break;
                }
                if (this.tt() == OCTokenTypes.RPAR) continue;
                this.error("',' or ')' expected");
                break;
            }
        }
        this.expectToken(OCTokenTypes.RPAR, "')' missing");
        this.done(paramList, OCElementTypes.ARGUMENT_LIST);
    }

    private void parseConstantExpression() {
        this.parseConditionalExpression(false, false);
    }

    private boolean parseConstantExpressionInTemplate() {
        boolean result2 = this.parseConditionalExpression(false, true);
        if (this.tt() == OCTokenTypes.ELLIPSIS) {
            this.advance();
        }
        return result2;
    }

    private boolean parseExpression(boolean allowEmpty) {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseAssignmentExpression(allowEmpty)) {
            expr.drop();
            return false;
        }
        if (this.tt() == OCTokenTypes.ELLIPSIS) {
            this.advance();
        }
        while (this.tt() == OCTokenTypes.COMMA) {
            OCMacroReferenceTokenType token = this.asMacroToken();
            if (this.myIsInsideMacro && token != null && !token.isParamToken()) break;
            this.advance();
            this.parseAssignmentExpression(false);
            this.done(expr, OCElementTypes.COMMA_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private void parseExpressionInParens() {
        this.expectToken(OCTokenTypes.LPAR, "Expecting '('");
        if (!this.parseExpression(false)) {
            this.error("Expecting expression");
        }
        this.expectToken(OCTokenTypes.RPAR, "Expecting ')'");
    }

    private void done(PsiBuilder.Marker marker, IElementType type) {
        if (this.myLastMacro != null) {
            marker.doneBefore(type, this.myLastMacro);
        } else {
            marker.done(type);
        }
        if (COMMENTS_BINDABLE_SET.contains(type)) {
            marker.setCustomEdgeTokenBinders(this.COMMENT_BINDER, null);
        }
    }

    private void rollbackTo(PsiBuilder.Marker mark) {
        this.myLastMacro = null;
        this.myTemplateGTGT = false;
        mark.rollbackTo();
    }

    private PsiBuilder.Marker mark() {
        this.myLastMacro = null;
        return this.myBuilder.mark();
    }

    private boolean eof() {
        return this.tt() == null;
    }

    private void error(String message) {
        if (!this.myDisableErrors) {
            if (this.myLastMacro != null) {
                this.myLastMacro.precede().errorBefore(message, this.myLastMacro);
            } else {
                this.myBuilder.error(message);
            }
        }
    }

    private boolean expectToken(IElementType token, String message) {
        if (token != this.tt()) {
            this.error(message);
            return false;
        }
        this.advance();
        return true;
    }

    private void expectGt() {
        if (this.tt() == OCTokenTypes.GTGT) {
            this.advance();
            this.myTemplateGTGT = true;
        } else {
            this.expectToken(OCTokenTypes.GT, "Expected '>'");
        }
    }

    long getCurrentComplexOffset() {
        IElementType tt = this.myBuilder.getTokenType();
        int subst = 0;
        if (tt instanceof OCMacroForeignLeafType) {
            subst = ((OCMacroForeignLeafType)tt).getOffsetInTopSubstitution();
        }
        return OCSymbolOffsetUtil.getComplexOffset(this.myBuilder.getCurrentOffset(), subst);
    }

    private void remapCurrentToken(IElementType newType) {
        this.myBuilder.remapCurrentToken(this.cloneTTwithBase(this.myBuilder.getTokenType(), newType));
    }

    private IElementType cloneTTwithBase(IElementType oldType, IElementType newType) {
        if (oldType instanceof OCMacroForeignLeafType) {
            OCMacroForeignLeafType type = (OCMacroForeignLeafType)oldType;
            IElementType newDelegate = this.cloneTTwithBase(type.getDelegate(), newType);
            int index = type.getMacroArgumentIndex();
            TextRange range = type.getRangeInMacroArgument();
            int subst = type.getOffsetInTopSubstitution();
            return new OCMacroForeignLeafType(newDelegate, type.getValue(), type.getMacroName(), index, range, subst);
        }
        if (oldType instanceof OCMacroReferenceTokenType) {
            OCMacroReferenceTokenType type = (OCMacroReferenceTokenType)oldType;
            IElementType newDelegate = this.cloneTTwithBase(type.getDelegate(), newType);
            return new OCMacroReferenceTokenType(newDelegate, type.getValue(), type.isParamToken(), type.getMacroLevel(), type.isRoot());
        }
        return newType;
    }

    private static boolean isAtRvalue(IElementType tt) {
        return tt != OCTokenTypes.AT && (OCTokenTypes.LITERALS.contains(tt) || tt == OCTokenTypes.LBRACE || tt == OCTokenTypes.LPAR || tt == OCTokenTypes.LBRACKET || tt == OCTokenTypes.MINUS || tt == OCTokenTypes.PLUS);
    }

    @Nullable
    private IElementType tt() {
        return this.remapIfNeeded(this.ttOrTypeName());
    }

    private IElementType remapIfNeeded(IElementType tt) {
        if (!this.myIsCppSupport && !this.myIsObjCSupport && (OCTokenTypes.CPP_KEYWORDS.contains(tt) || OCTokenTypes.OBJC_KEYWORDS.contains(tt) || OCElementUtil.isAlternativeCppPunctuator(tt, this.myBuilder.getTokenText()))) {
            return this.remapToIdentifier();
        }
        if (!this.myIsCppSupport && (OCTokenTypes.CPP_KEYWORDS.contains(tt) || OCElementUtil.isAlternativeCppPunctuator(tt, this.myBuilder.getTokenText())) && !OCTokenTypes.OBJC_KEYWORDS.contains(tt)) {
            return this.remapToIdentifier();
        }
        if (!this.myIsObjCSupport && OCTokenTypes.OBJC_KEYWORDS.contains(tt) && !OCTokenTypes.CPP_KEYWORDS.contains(tt)) {
            return this.remapToIdentifier();
        }
        if (this.myIsObjCSupport && tt == OCTokenTypes.AT) {
            PsiBuilder.Marker marker = this.mark();
            this.baseAdvance();
            tt = this.ttOrTypeName();
            this.rollbackTo(marker);
            if (tt == OCTokenTypes.CLASS_KEYWORD) {
                return OBJC_CLASS_KEYWORD;
            }
            return OCTokenTypes.KEYWORDS_WITH_DOGS.contains(tt) ? tt : (OCParsing.isAtRvalue(tt) ? OCTokenTypes.AT : OCElementTypes.OBJC_ERROR_KEYWORD);
        }
        if (!(!OCTokenTypes.KEYWORDS_WITH_DOGS.contains(tt) || this.myIsCppSupport && OCTokenTypes.CPP_KEYWORDS.contains(tt))) {
            return this.remapToIdentifier();
        }
        return tt;
    }

    private IElementType remapToIdentifier() {
        this.remapCurrentToken(OCTokenTypes.IDENTIFIER);
        return OCTokenTypes.IDENTIFIER;
    }

    @Nullable
    private IElementType ttOrTypeName() {
        if (this.myParseUntilOffset != 0 && this.myBuilder.getCurrentOffset() > this.myParseUntilOffset) {
            return null;
        }
        if (this.myParsingInsideMacro && OCParsing.isEndOfDirective(this.baseToken())) {
            return null;
        }
        while (true) {
            IElementType token;
            if ((token = this.baseToken()) instanceof OCMacroReferenceTokenType) {
                OCMacroReferenceTokenType macroToken = (OCMacroReferenceTokenType)token;
                if (!this.myIsInsideMacro) {
                    this.myIsInsideMacro = true;
                    if (!this.parseMacroCall()) {
                        this.baseAdvance();
                    }
                    this.myIsInsideMacro = false;
                    continue;
                }
                IElementType delegate = macroToken.getDelegate();
                if (OCTokenTypes.WHITESPACES.contains(delegate) || OCTokenTypes.COMMENTS.contains(delegate) || delegate == OCTokenTypes.EOL_ESCAPE) {
                    this.baseAdvance();
                    continue;
                }
                return delegate;
            }
            if (OCTokenTypes.DIRECTIVES.contains(token)) {
                this.parseDirective();
                continue;
            }
            if (OCTokenTypes.CPP_PRAGMA_KEYWORD == token) {
                PsiBuilder.Marker pragmaStart = this.mark();
                this.baseAdvance();
                this.skipBlock(OCTokenTypes.LPAR, OCTokenTypes.RPAR, true);
                this.done(pragmaStart, OCElementTypes.CPP_PRAGMA);
                continue;
            }
            if (token != OCTokenTypes.EOL_ESCAPE) break;
            this.baseAdvance();
        }
        IElementType result2 = this.baseToken();
        return this.myParsingInsideMacro && OCTokenTypes.KEYWORDS.contains(result2) ? OCTokenTypes.IDENTIFIER : result2;
    }

    @Nullable
    private OCParsingNameScope.Kind isLocalOrGlobalTypename(String name) {
        if (this.myIsObjCSupport && "id".equals(name)) {
            return OCParsingNameScope.Kind.OBJC_INTERFACE;
        }
        return this.myLocalNameScope.getKind(name);
    }

    @Nullable
    private OCParsingNameScope.Kind isLocalOrGlobalTypename(List<String> name) {
        return this.myLocalNameScope.getKind(name);
    }

    private boolean detectTypeName() {
        return this.detectTypeName(false);
    }

    private boolean detectTypeName(boolean skip) {
        return OCParsingNameScope.isType(this.detectTypeNameKind(skip));
    }

    @Nullable
    private OCParsingNameScope.Kind detectTypeNameKind(boolean skip) {
        OCParsingNameScope.Kind result2;
        String name;
        long currentLexeme = this.getCurrentComplexOffset();
        if (!skip && this.myTypeKindsCache.containsKey(currentLexeme)) {
            return this.myTypeKindsCache.get(currentLexeme);
        }
        IElementType tt = this.tt();
        if (tt != OCTokenTypes.IDENTIFIER && tt != OCTokenTypes.COLON2X) {
            return null;
        }
        String string = name = tt == OCTokenTypes.COLON2X ? "" : this.myBuilder.getTokenText();
        if (!this.myIsCppSupport) {
            return this.isLocalOrGlobalTypename(name);
        }
        PsiBuilder.Marker start = this.mark();
        if (tt != OCTokenTypes.COLON2X) {
            this.advance();
        }
        if (this.tt() == OCTokenTypes.LT && OCParsingNameScope.isTemplate(this.isLocalOrGlobalTypename(name))) {
            this.parseTemplateArgumentList();
        }
        if (this.tt() != OCTokenTypes.COLON2X) {
            result2 = this.isLocalOrGlobalTypename(name);
        } else {
            this.advance();
            boolean isOperatorCall = false;
            if (this.myIsCppSupport && (this.tt() == OCTokenTypes.OPERATOR_CPP_KEYWORD || this.tt() == OCTokenTypes.NEW_CPP_KEYWORD || this.tt() == OCTokenTypes.DELETE_CPP_KEYWORD)) {
                isOperatorCall = true;
            }
            ArrayList<String> qualifiedName = new ArrayList<String>(2);
            qualifiedName.add(name);
            if (this.tt() == OCTokenTypes.IDENTIFIER) {
                qualifiedName.add(this.myBuilder.getTokenText());
                this.advance();
                if (this.tt() == OCTokenTypes.LT && OCParsingNameScope.isTemplate(this.isLocalOrGlobalTypename(qualifiedName))) {
                    this.parseTemplateArgumentList();
                }
                while (this.tt() == OCTokenTypes.COLON2X) {
                    this.advance();
                    if (this.tt() != OCTokenTypes.IDENTIFIER) {
                        if (!this.myIsCppSupport || this.tt() != OCTokenTypes.OPERATOR_CPP_KEYWORD) break;
                        isOperatorCall = true;
                        break;
                    }
                    qualifiedName.add(this.myBuilder.getTokenText());
                    this.advance();
                    if (this.tt() != OCTokenTypes.LT || !OCParsingNameScope.isTemplate(this.isLocalOrGlobalTypename(qualifiedName))) continue;
                    this.parseTemplateArgumentList();
                }
            }
            OCParsingNameScope.Kind kind = result2 = isOperatorCall ? OCParsingNameScope.Kind.NON_TYPE : this.isLocalOrGlobalTypename(qualifiedName);
        }
        if (skip) {
            start.drop();
        } else {
            this.rollbackTo(start);
        }
        if (!skip && this.myParseUntilOffset == 0) {
            this.myTypeKindsCache.put(currentLexeme, result2);
        }
        return result2;
    }

    @Nullable
    private IElementType ttOrCppEquivalent() {
        IElementType tt = this.tt();
        if (!this.myIsCppSupport || tt != OCTokenTypes.IDENTIFIER || this.baseToken() instanceof OCMacroReferenceTokenType) {
            return tt;
        }
        OCPunctuatorElementType keyword = OCPunctuatorElementType.findByKeyword(this.myBuilder.getTokenText());
        if (keyword == null) {
            return tt;
        }
        this.remapCurrentToken(keyword);
        return keyword;
    }

    @Nullable
    private IElementType baseToken() {
        IElementType base;
        if (this.myTemplateGTGT) {
            return OCTokenTypes.GT;
        }
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(base = OCElementUtil.getUnwrappedTokeType(this.myBuilder.getTokenType()))) {
            this.myBuilder.advanceLexer();
        }
        return base;
    }

    private void advance() {
        boolean isObjcKeyword;
        ProgressManager.checkCanceled();
        IElementType originTt = this.ttOrTypeName();
        IElementType tt = this.remapIfNeeded(originTt);
        PsiBuilder.Marker mark = this.mark();
        this.baseAdvance();
        if (this.myIsObjCSupport && OCTokenTypes.AT == originTt && ((isObjcKeyword = OCTokenTypes.KEYWORDS_WITH_DOGS.contains(tt) || tt == OBJC_CLASS_KEYWORD) || tt == OCElementTypes.OBJC_ERROR_KEYWORD)) {
            if (!isObjcKeyword) {
                this.error("Illegal Objective-C keyword");
            }
            boolean hasWrongKeyword = true;
            if (tt == OCElementTypes.OBJC_ERROR_KEYWORD) {
                PsiBuilder.Marker markAt = this.mark();
                int idCount = 0;
                for (idCount = 0; idCount < 3 && OCTokenTypes.IDENTIFIER == this.ttOrTypeName(); ++idCount) {
                    this.baseAdvance();
                }
                this.rollbackTo(markAt);
                boolean bl = hasWrongKeyword = idCount == 1 || idCount == 3;
            }
            if (hasWrongKeyword) {
                this.ttOrTypeName();
                this.baseAdvance();
            }
            this.myLastMacro = null;
            this.done(mark, isObjcKeyword ? OCElementTypes.OBJC_KEYWORD : OCElementTypes.OBJC_ERROR_KEYWORD);
        } else {
            this.myLastMacro = null;
            mark.drop();
        }
    }

    private void baseAdvance() {
        if (this.myTemplateGTGT) {
            this.myTemplateGTGT = false;
        } else {
            this.myBuilder.advanceLexer();
        }
    }

    @Nullable
    private OCMacroReferenceTokenType asMacroToken() {
        IElementType token = OCElementUtil.getUnwrappedTokeType(this.baseToken());
        return token instanceof OCMacroReferenceTokenType ? (OCMacroReferenceTokenType)token : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseMacroCall() {
        OCMacroReferenceTokenType token = this.asMacroToken();
        if (token == null) {
            return false;
        }
        IElementType delegate = token.getDelegate();
        if (delegate != OCTokenTypes.IDENTIFIER && !OCTokenTypes.KEYWORDS.contains(delegate) || !token.isRoot()) {
            return false;
        }
        this.myDisableErrors = true;
        int level = token.getMacroLevel();
        PsiBuilder.Marker macroCall = this.mark();
        PsiBuilder.Marker ref = this.mark();
        this.baseAdvance();
        ref.done((IElementType)OCElementTypes.MACRO_REF);
        token = this.asMacroToken();
        PsiBuilder.Marker param = null;
        while (token != null && token.getMacroLevel() >= level && !token.isRoot()) {
            if (token.isParamToken() && param == null) {
                OCMacroReferenceTokenType nextToken;
                param = this.mark();
                int offset = this.myBuilder.getCurrentOffset();
                boolean wasStatement = false;
                while (this.tryParseStatement() && this.myBuilder.getCurrentOffset() > offset) {
                    offset = this.myBuilder.getCurrentOffset();
                    wasStatement = true;
                }
                if ((wasStatement || this.detectTypeName() && this.parseTypeName(DeclarationContext.PARAMETER_LIST, TypeParsingExpectation.ANY) || this.parseAssignmentExpression(false)) && (nextToken = this.asMacroToken()) != null) {
                    token = nextToken;
                    continue;
                }
                this.rollbackTo(param);
                param = this.mark();
            } else if (!token.isParamToken()) {
                IElementType tokenType = token.getDelegate();
                if ((tokenType == OCTokenTypes.COMMA || tokenType == OCTokenTypes.RPAR) && param == null) {
                    param = this.mark();
                }
                if (param != null) {
                    param.done((IElementType)OCElementTypes.MACRO_ARGUMENT);
                    param = null;
                }
            }
            if (token.getMacroLevel() > level) {
                if (!this.parseMacroCall()) {
                    this.baseAdvance();
                }
            } else {
                this.baseAdvance();
            }
            token = this.asMacroToken();
        }
        if (param != null) {
            param.done((IElementType)OCElementTypes.MACRO_ARGUMENT);
        }
        if (token == null) {
            IElementType foreignToken = this.baseToken();
            while (foreignToken instanceof OCMacroReferenceTokenType && ((OCMacroReferenceTokenType)foreignToken).getMacroLevel() == level) {
                this.baseAdvance();
                foreignToken = this.baseToken();
            }
        }
        macroCall.done((IElementType)OCElementTypes.MACRO_CALL);
        try {
            if (token != null && token.isRoot()) {
                boolean bl = this.parseMacroCall();
                return bl;
            }
        }
        finally {
            this.myLastMacro = macroCall;
        }
        this.myDisableErrors = false;
        return true;
    }

    private void parseDirective() {
        this.myIsInsideDirective = true;
        PsiBuilder.Marker lastMacro = this.myLastMacro;
        IElementType headerToken = this.baseToken();
        assert (OCTokenTypes.DIRECTIVES.contains(headerToken));
        PsiBuilder.Marker marker = this.mark();
        this.baseAdvance();
        if (headerToken == OCTokenTypes.IFDEF_DIRECTIVE || headerToken == OCTokenTypes.IFNDEF_DIRECTIVE) {
            if (this.tt() != OCTokenTypes.IDENTIFIER && !OCTokenTypes.KEYWORDS.contains(this.tt())) {
                this.error("Expecting macro name");
            } else {
                PsiBuilder.Marker ref = this.mark();
                this.advance();
                this.done(ref, OCElementTypes.REFERENCE_ELEMENT);
                if (!this.eof() && !OCParsing.isEndOfDirective(this.tt())) {
                    this.error("Unexpected token");
                }
            }
            while (!this.eof() && !OCParsing.isEndOfDirective(this.tt())) {
                this.advance();
            }
            this.advance();
            marker.done((IElementType)OCElementTypes.DIRECTIVE);
        } else if (headerToken == OCTokenTypes.IF_DIRECTIVE || headerToken == OCTokenTypes.ELIF_DIRECTIVE) {
            this.myParsingInsideMacro = true;
            this.parseExpression(false);
            this.myParsingInsideMacro = false;
            while (!this.eof() && !OCParsing.isEndOfDirective(this.tt())) {
                this.advance();
            }
            this.advance();
            marker.done((IElementType)OCElementTypes.DIRECTIVE);
        } else if (headerToken == OCTokenTypes.DEFINE_DIRECTIVE || headerToken == OCTokenTypes.UNDEF_DIRECTIVE) {
            PsiBuilder.Marker ref;
            List params = Collections.emptyList();
            IElementType tokenType = this.myBuilder.getTokenType();
            if (headerToken == OCTokenTypes.UNDEF_DIRECTIVE) {
                if (tokenType == OCTokenTypes.IDENTIFIER) {
                    ref = this.mark();
                    this.advance();
                    this.done(ref, OCElementTypes.MACRO_REF);
                }
            } else if (tokenType == OCTokenTypes.IDENTIFIER) {
                params = new ArrayList();
                this.baseAdvance();
                if (this.myBuilder.rawLookup(0) == OCTokenTypes.LPAR) {
                    PsiBuilder.Marker paramList = this.mark();
                    this.advance();
                    while (!this.eof() && this.tt() != OCTokenTypes.RPAR) {
                        if (this.tt() == OCTokenTypes.ELLIPSIS) {
                            this.advance();
                        } else if (this.tt() == OCTokenTypes.IDENTIFIER) {
                            PsiBuilder.Marker param = this.mark();
                            params.add(this.myBuilder.getTokenText());
                            this.advance();
                            if (this.tt() == OCTokenTypes.ELLIPSIS) {
                                this.advance();
                            }
                            this.done(param, OCElementTypes.MACRO_PARAMETER);
                        } else {
                            this.error("Expecting macro parameter");
                            if (this.tt() != OCTokenTypes.COMMA) {
                                this.advance();
                            }
                        }
                        if (this.tt() == OCTokenTypes.COMMA) {
                            this.advance();
                            continue;
                        }
                        if (this.tt() == OCTokenTypes.RPAR) continue;
                        this.error("',' or ')' expected");
                        break;
                    }
                    this.expectToken(OCTokenTypes.RPAR, "')' missing");
                    this.done(paramList, OCElementTypes.MACRO_PARAMETER_LIST);
                }
            }
            while (!this.eof() && !OCParsing.isEndOfDirective(this.tt())) {
                if (headerToken == OCTokenTypes.DEFINE_DIRECTIVE && this.tt() == OCTokenTypes.IDENTIFIER && params != null && params.contains(this.myBuilder.getTokenText())) {
                    ref = this.mark();
                    this.advance();
                    this.done(ref, OCElementTypes.REFERENCE_ELEMENT);
                    continue;
                }
                this.advance();
            }
            this.advance();
            marker.done((IElementType)(headerToken == OCTokenTypes.DEFINE_DIRECTIVE ? OCElementTypes.MACRO_DEFINITION : OCElementTypes.MACRO_UNDEFINITION));
        } else if (headerToken == OCTokenTypes.INCLUDE_DIRECTIVE || headerToken == OCTokenTypes.IMPORT_DIRECTIVE || headerToken == OCTokenTypes.INCLUDE_NEXT_DIRECTIVE) {
            this.skipDirectiveContent();
            marker.done((IElementType)OCElementTypes.IMPORT_DIRECTIVE);
        } else {
            while (!this.eof() && !OCParsing.isEndOfDirective(this.tt())) {
                this.advance();
            }
            this.advance();
            marker.done((IElementType)(headerToken == OCTokenTypes.PRAGMA_DIRECTIVE ? OCElementTypes.PRAGMA : OCElementTypes.DIRECTIVE));
        }
        this.myIsInsideDirective = false;
        this.myLastMacro = lastMacro == null ? marker : lastMacro;
    }

    private void skipDirectiveContent() {
        IElementType token;
        while ((token = this.baseToken()) == OCTokenTypes.DIRECTIVE_CONTENT || token == OCTokenTypes.CODE_DIRECTIVE_CONTENT || token == OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT) {
            this.baseAdvance();
        }
    }

    private static boolean isEndOfDirective(IElementType type) {
        return type == OCTokenTypes.END_OF_DIRECTIVE_CONTENT || type == OCTokenTypes.CODE_DIRECTIVE_CONTENT || type == OCTokenTypes.DIRECTIVE_CONTENT;
    }

    public String toString() {
        PsiBuilder.Marker revertPoint = this.mark();
        this.advance();
        this.advance();
        this.advance();
        this.advance();
        this.advance();
        this.advance();
        this.advance();
        String result2 = "|>" + revertPoint;
        this.rollbackTo(revertPoint);
        return result2;
    }

    @NotNull
    public OCParsingNameScope getLocalNameScope() {
        OCParsingNameScope oCParsingNameScope = this.myLocalNameScope;
        if (oCParsingNameScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParsing", "getLocalNameScope"));
        }
        return oCParsingNameScope;
    }

    @Contract(value="null->false")
    public static boolean isEOFError(@Nullable Object maybeError) {
        return maybeError instanceof PsiErrorElement && ((PsiErrorElement)maybeError).getErrorDescription() == MSG_UNEXPECTED_END_OF_FILE;
    }

    private static enum TypeParsingExpectation {
        ANY,
        NON_VALUES,
        NON_EXACT_VALUES,
        ONLY_TYPES;

    }

    private static enum TypeParsingResult {
        TYPE_PARSED_FOR_SURE,
        TYPE_PARSED,
        EMPTY_TYPE_PARSED,
        NONE,
        UNKNOWN;


        public boolean isEmpty() {
            return this == NONE || this == EMPTY_TYPE_PARSED;
        }
    }

    private static enum DeclaratorParsingResult {
        PARSED_FUNCTION,
        PARSED,
        FAIL,
        PARSED_EMPTY,
        FAIL_EMPTY;


        public boolean isOk() {
            return this == PARSED_FUNCTION || this == PARSED || this == PARSED_EMPTY;
        }

        public boolean isEmpty() {
            return this == PARSED_EMPTY || this == FAIL_EMPTY;
        }

        public static DeclaratorParsingResult parsed(boolean empty, boolean function) {
            return function ? PARSED_FUNCTION : (empty ? PARSED_EMPTY : PARSED);
        }

        public static DeclaratorParsingResult fail(boolean empty) {
            return empty ? FAIL_EMPTY : FAIL;
        }
    }

    private static enum DeclarationContext {
        FILE,
        STRUCT,
        PARAMETER_LIST,
        CODE_BLOCK,
        CPP_NEW_EXPRESSION,
        SIZEOF,
        TRAILING_RETURN_TYPE;

    }

    static class DeclaratorsParsingResult {
        Type myType = Type.FAIL;
        List<String> mySingleNames;

        DeclaratorsParsingResult(Type type, List<String> names) {
            this.myType = type;
            this.mySingleNames = names;
        }

        public static enum Type {
            PARSED_FUNCTION,
            PARSED,
            FAIL;


            public boolean isOk() {
                return this == PARSED_FUNCTION || this == PARSED;
            }
        }
    }

    private static enum LoopType {
        C_FOR_LOOP,
        OBJ_FOREACH_LOOP,
        C11_FOREACH_LOOP;

    }

    private static enum StatementParsingResult {
        PARSED,
        PARSED_WITHOUT_SEMICOLON,
        FAIL;

    }

    private static enum DeclarationParsingResult {
        PARSED,
        PARSED_WITHOUT_SEMICOLON,
        FAIL;

    }

    private static class DumbNodeInfo {
        final PsiBuilder.Marker marker;
        final int childDepth;
        int childCount;

        public DumbNodeInfo(PsiBuilder.Marker marker, int childDepth) {
            this.marker = marker;
            this.childDepth = childDepth;
        }
    }

    private class ClassParsingScope {
        private boolean myHasGenericParametersForSure = false;
        private boolean myHasProtocolListForSure = false;
        private Set<String> myGenericParameterNames = ContainerUtil.newHashSet();

        private ClassParsingScope() {
        }

        public boolean parseClass() {
            boolean allowGenericsInsteadOfProtocolList;
            AngleBracketedExpressionType type;
            boolean isProtocol;
            PsiBuilder.Marker klass = OCParsing.this.mark();
            OCParsing.this.parseAttributes();
            if (OCParsing.this.tt() == OCTokenTypes.EXTERN_KEYWORD) {
                OCParsing.this.advance();
                if (OCParsing.this.tt() == OCTokenTypes.STRING_LITERAL) {
                    OCParsing.this.advance();
                }
                OCParsing.this.parseAttributes();
            }
            boolean isInterface = OCParsing.this.tt() == OCTokenTypes.INTERFACE_KEYWORD;
            boolean isImplementation = OCParsing.this.tt() == OCTokenTypes.IMPLEMENTATION_KEYWORD;
            boolean bl = isProtocol = OCParsing.this.tt() == OCTokenTypes.PROTOCOL_KEYWORD;
            if (!(isInterface || isImplementation || isProtocol)) {
                OCParsing.this.rollbackTo(klass);
                return false;
            }
            OCParsing.this.advance();
            OCParsing.this.expectIdentifier_lexerHack("class/category/protocol name expected", false, !isProtocol, isProtocol, false);
            if (isInterface && (type = OCParsing.this.detectAngleBracketedExpressionType()) == AngleBracketedExpressionType.GENERIC_PARAMETER_LIST) {
                this.parseGenericParameters(null);
            }
            PsiBuilder.Marker stubsEnd = OCParsing.this.mark();
            if (isProtocol && (OCParsing.this.tt() == OCTokenTypes.COMMA || OCParsing.this.tt() == OCTokenTypes.SEMICOLON)) {
                OCParsing.this.rollbackTo(klass);
                this.parseClassForeReflist();
                return true;
            }
            boolean bl2 = allowGenericsInsteadOfProtocolList = !this.myHasGenericParametersForSure;
            if (OCParsing.this.tt() == OCTokenTypes.LPAR) {
                PsiBuilder.Marker categoryName = OCParsing.this.mark();
                OCParsing.this.advance();
                if (OCParsing.this.tt() == OCTokenTypes.IDENTIFIER) {
                    OCParsing.this.advance();
                }
                OCParsing.this.expectToken(OCTokenTypes.RPAR, "')' expected");
                categoryName.done((IElementType)OCElementTypes.CATEGORY_NAME);
                stubsEnd.drop();
                stubsEnd = OCParsing.this.mark();
                allowGenericsInsteadOfProtocolList = false;
            }
            Ref protocolParseResult = new Ref();
            stubsEnd = this.parseSuperRef(stubsEnd);
            do {
                stubsEnd = this.parseProtocolList(stubsEnd, (Ref<Boolean>)protocolParseResult);
            } while (protocolParseResult.get() == Boolean.TRUE);
            if (allowGenericsInsteadOfProtocolList && isInterface && protocolParseResult.get() == Boolean.FALSE) {
                stubsEnd = this.parseGenericParameters(stubsEnd);
            }
            stubsEnd = OCParsing.this.parseMemberVariables(stubsEnd);
            stubsEnd.drop();
            while (!(OCParsing.this.eof() || OCParsing.this.tt() == OCTokenTypes.END_KEYWORD || OCTokenTypes.OBJC_CLASS_KEYWORDS.contains(OCParsing.this.tt()) && OCParsing.this.tt() != OBJC_CLASS_KEYWORD)) {
                if (OCParsing.this.tt() == OCTokenTypes.OPTIONAL_KEYWORD || OCParsing.this.tt() == OCTokenTypes.REQUIRED_KEYWORD) {
                    if (!isProtocol) {
                        OCParsing.this.error("'@optional/@required' is allowed in protocol declarations only");
                    }
                    OCParsing.this.advance();
                    continue;
                }
                if (OCParsing.this.tt() == OBJC_CLASS_KEYWORD) {
                    this.parseClassForeReflist();
                    continue;
                }
                if (OCParsing.this.tt() == OCTokenTypes.MINUS || OCParsing.this.tt() == OCTokenTypes.PLUS) {
                    OCParsing.this.parseMethod();
                    continue;
                }
                if (OCParsing.this.tt() == OCTokenTypes.PROPERTY_KEYWORD) {
                    OCParsing.this.parseProperty();
                    continue;
                }
                if (OCParsing.this.tt() == OCTokenTypes.SYNTHESIZE_KEYWORD || OCParsing.this.tt() == OCTokenTypes.DYNAMIC_KEYWORD) {
                    OCParsing.this.parseSynthesizedPropertiesList();
                    continue;
                }
                if (OCParsing.this.tt() == OCTokenTypes.SEMICOLON) {
                    OCParsing.this.advance();
                    continue;
                }
                if (OCParsing.this.parseDeclaration(DeclarationContext.FILE) != DeclarationParsingResult.FAIL) continue;
                OCParsing.this.errorAndSkipToken("Method or declaration expected", OCParsing.this.BLOCK_STATEMENT_PARSER, OCElementTypes.UNKNOWN_CPP_CODE);
            }
            if (isImplementation) {
                if (OCParsing.this.tt() == OCTokenTypes.END_KEYWORD) {
                    OCParsing.this.advance();
                }
            } else {
                OCParsing.this.expectToken(OCTokenTypes.END_KEYWORD, "@end missing");
            }
            OCParsing.this.done(klass, isInterface ? OCElementTypes.INTERFACE : (isImplementation ? OCElementTypes.IMPLEMENTATION : OCElementTypes.PROTOCOL));
            return true;
        }

        private void parseClassForeReflist() {
            PsiBuilder.Marker dcl = OCParsing.this.mark();
            boolean isProtocol = OCParsing.this.tt() == OCTokenTypes.PROTOCOL_KEYWORD;
            OCParsing.this.advance();
            while (true) {
                PsiBuilder.Marker declarator = OCParsing.this.mark();
                OCParsing.this.expectIdentifier_lexerHack("Expecting class name", false, !isProtocol, isProtocol, false);
                this.parseGenericParameters(null);
                OCParsing.this.done(declarator, OCElementTypes.CLASS_PREDEF);
                if (OCParsing.this.tt() != OCTokenTypes.COMMA) break;
                OCParsing.this.advance();
            }
            OCParsing.this.expectToken(OCTokenTypes.SEMICOLON, "Missing ';'");
            OCParsing.this.done(dcl, OCElementTypes.CLASS_PREDEF_LIST);
        }

        private PsiBuilder.Marker parseGenericParameters(@Nullable PsiBuilder.Marker stubsEnd) {
            if (OCParsing.this.tt() != OCTokenTypes.LT) {
                return stubsEnd;
            }
            PsiBuilder.Marker list = OCParsing.this.mark();
            OCParsing.this.advance();
            while (true) {
                PsiBuilder.Marker parameter = OCParsing.this.mark();
                if (OCParsing.this.tt() == OCTokenTypes.COVARIANT_KEYWORD || OCParsing.this.tt() == OCTokenTypes.CONTRAVARIANT_KEYWORD) {
                    OCParsing.this.advance();
                }
                this.myGenericParameterNames.add(OCParsing.this.expectIdentifier_lexerHack("Expected type parameter name", false, true, false, false));
                OCParsing.this.parseGenericRestriction();
                OCParsing.this.done(parameter, OCElementTypes.GENERIC_PARAMETER);
                if (OCParsing.this.tt() != OCTokenTypes.COMMA) break;
                OCParsing.this.advance();
            }
            OCParsing.this.expectGt();
            OCParsing.this.done(list, OCElementTypes.GENERIC_PARAMETERS_LIST);
            this.myHasGenericParametersForSure = true;
            if (stubsEnd != null) {
                stubsEnd.drop();
                return OCParsing.this.mark();
            }
            return null;
        }

        private PsiBuilder.Marker parseProtocolList(PsiBuilder.Marker stubsEnd, Ref<Boolean> protocolsParseResult) {
            if (OCParsing.this.tt() == OCTokenTypes.LT) {
                PsiBuilder.Marker list = OCParsing.this.mark();
                OCParsing.this.advance();
                while (true) {
                    PsiBuilder.Marker protocolRef = OCParsing.this.mark();
                    if (OCParsing.this.tt() == OCTokenTypes.COVARIANT_KEYWORD || OCParsing.this.tt() == OCTokenTypes.CONTRAVARIANT_KEYWORD) {
                        protocolRef.drop();
                        OCParsing.this.rollbackTo(list);
                        protocolsParseResult.set((Object)false);
                        if (!this.myHasProtocolListForSure) {
                            this.myHasProtocolListForSure = true;
                            stubsEnd.precede().doneBefore((IElementType)OCElementTypes.PROTOCOL_LIST, stubsEnd);
                        }
                        return stubsEnd;
                    }
                    OCParsing.this.expectToken(OCTokenTypes.IDENTIFIER, "protocol name expected");
                    OCParsing.this.done(protocolRef, OCElementTypes.REFERENCE_ELEMENT);
                    if (OCParsing.this.tt() != OCTokenTypes.COMMA) break;
                    OCParsing.this.advance();
                }
                this.myHasProtocolListForSure = true;
                OCParsing.this.expectToken(OCTokenTypes.GT, "Missing '>'");
                OCParsing.this.done(list, OCElementTypes.PROTOCOL_LIST);
                stubsEnd.drop();
                protocolsParseResult.set((Object)true);
                return OCParsing.this.mark();
            }
            protocolsParseResult.set(null);
            if (!this.myHasProtocolListForSure) {
                this.myHasProtocolListForSure = true;
                stubsEnd.precede().doneBefore((IElementType)OCElementTypes.PROTOCOL_LIST, stubsEnd);
            }
            return stubsEnd;
        }

        private PsiBuilder.Marker parseSuperRef(PsiBuilder.Marker stubsEnd) {
            if (OCParsing.this.tt() == OCTokenTypes.COLON) {
                PsiBuilder.Marker supRef = OCParsing.this.mark();
                OCParsing.this.advance();
                PsiBuilder.Marker superClassRef = OCParsing.this.mark();
                OCParsing.this.expectToken(OCTokenTypes.IDENTIFIER, "super class name expected");
                PsiBuilder.Marker dummy = OCParsing.this.mark();
                if (OCParsing.this.tt() == OCTokenTypes.LT) {
                    boolean isMoreThanOneBracketedExpression;
                    boolean bl = isMoreThanOneBracketedExpression = OCParsing.this.detectAngleBracketedExpressionCount() > 1;
                    if (isMoreThanOneBracketedExpression || OCParsing.this.detectAngleBracketedExpressionType() != AngleBracketedExpressionType.PROTOCOL_LIST) {
                        OCParsing.this.parseGenericArguments(isMoreThanOneBracketedExpression);
                    }
                    dummy.drop();
                } else {
                    OCParsing.this.rollbackTo(dummy);
                }
                OCParsing.this.done(superClassRef, OCElementTypes.REFERENCE_ELEMENT);
                OCParsing.this.done(supRef, OCElementTypes.SUPER_CLASS_REF);
                stubsEnd.drop();
                return OCParsing.this.mark();
            }
            stubsEnd.precede().doneBefore((IElementType)OCElementTypes.SUPER_CLASS_REF, stubsEnd);
            return stubsEnd;
        }
    }

    private static enum AngleBracketedExpressionType {
        GENERIC_PARAMETER_LIST,
        GENERIC_ARGUMENT_LIST,
        PROTOCOL_LIST,
        UNKNOWN,
        NOT_AN_ANGLE_BRACKETED_EXPRESSION;

    }

    private static interface BlockParser {
        public void parseBlock();
    }

    private static enum MessagePassingContext {
        None,
        InReiceiver,
        InParameter;

    }

    public static enum BlockParsingMode {
        EAGER,
        LAZY,
        SKIP;

    }
}

