/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.parser;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.NotNullFunction;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.OCInjectionListener;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCParser;
import com.jetbrains.cidr.lang.parser.OCPsiElementType;
import com.jetbrains.cidr.lang.parser.OCStubElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import org.jetbrains.annotations.NotNull;

public class OCParserDefinition
implements ParserDefinition {
    private static final NotNullLazyKey<PsiFile, Project> DUMMY_FILE = NotNullLazyKey.create((String)"PARSER_DEFINITION_DUMMY", (NotNullFunction)new NotNullFunction<Project, PsiFile>(){

        @NotNull
        public PsiFile fun(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/parser/OCParserDefinition$1", "fun"));
            }
            PsiFile psiFile = OCParserDefinition.createDummyFile(project);
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParserDefinition$1", "fun"));
            }
            return psiFile;
        }
    });

    @NotNull
    public Lexer createLexer(Project project) {
        PsiFile file2 = (PsiFile)DUMMY_FILE.getValue((UserDataHolder)project);
        OCInclusionContext context = OCInclusionContext.empty(OCLanguageKindCalculator.calculateLanguageKindFast(file2), file2);
        OCPreprocessingLexer oCPreprocessingLexer = new OCPreprocessingLexer(context, (OCFile)file2);
        if (oCPreprocessingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParserDefinition", "createLexer"));
        }
        return oCPreprocessingLexer;
    }

    public PsiParser createParser(Project project) {
        return OCParser.getInstance();
    }

    public IFileElementType getFileNodeType() {
        return OCTokenTypes.OC_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = OCTokenTypes.WHITESPACES;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = OCTokenTypes.COMMENTS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = OCTokenTypes.ALL_STRINGS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof OCPsiElementType) {
            PsiElement psiElement = ((OCPsiElementType)type).createPsi(node);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParserDefinition", "createElement"));
            }
            return psiElement;
        }
        if (type instanceof OCStubElementType) {
            PsiElement psiElement = ((OCStubElementType)type).createPsi(node);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParserDefinition", "createElement"));
            }
            return psiElement;
        }
        ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
        if (aSTWrapperPsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/parser/OCParserDefinition", "createElement"));
        }
        return aSTWrapperPsiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        Project project = viewProvider.getManager().getProject();
        if (project.getUserData(OCLanguage.LANGUAGE_SUPPORT_DISABLED) == Boolean.TRUE) {
            return new PsiPlainTextFileImpl(viewProvider);
        }
        if (viewProvider instanceof InjectedFileViewProvider) {
            OCCodeFragmentImpl fragment = new OCCodeFragmentImpl(viewProvider, true, (IElementType)OCElementTypes.EXPRESSION_CODE_FRAGMENT);
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)InjectedLanguageUtil.getShreds(viewProvider).getHostPointer().getElement();
            ((OCInjectionListener)project.getMessageBus().syncPublisher(OCInjectionListener.INJECTION_TOPIC)).didInject(fragment, host);
            return fragment;
        }
        return new OCFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static PsiFile createDummyFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/parser/OCParserDefinition", "createDummyFile"));
        }
        CLanguageKind kind = CLanguageKind.maxLanguage(project);
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        String name = "dummy." + kind.getDefaultSourceExtension();
        return factory.createFileFromText(name, (Language)OCLanguage.getInstance(), (CharSequence)"");
    }
}

