/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSwitchToHeaderOrSourceRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/navigation/OCSwitchToHeaderOrSourceRelatedProvider", "getItems"));
        }
        PsiFile file2 = context.getContainingFile();
        OCFile target = file2 instanceof OCFile ? ((OCFile)file2).getAssociatedFile() : null;
        final NavigatablePsiElement counter = OCSwitchToHeaderOrSourceRelatedProvider.findCounterPartInFile(context, target);
        if (counter != null) {
            List<1> list = Collections.singletonList(new GotoRelatedItem((PsiElement)counter, target != null && target.isHeader() ? "Headers" : "Sources"){

                public void navigate() {
                    NavigationUtil.activateFileWithPsiElement((PsiElement)counter);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/navigation/OCSwitchToHeaderOrSourceRelatedProvider", "getItems"));
            }
            return list;
        }
        if (target != null) {
            List<GotoRelatedItem> list = Collections.singletonList(new GotoRelatedItem((PsiElement)target, target.isHeader() ? "Headers" : "Sources"));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/navigation/OCSwitchToHeaderOrSourceRelatedProvider", "getItems"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/navigation/OCSwitchToHeaderOrSourceRelatedProvider", "getItems"));
        }
        return list;
    }

    @Nullable
    private static NavigatablePsiElement getCounterPartInFile(PsiElement psi, OCFile file2) {
        OCSymbol target;
        if (!(psi instanceof OCSymbolDeclarator) || psi instanceof OCMethodSelectorPart) {
            return null;
        }
        Object symbol = ((OCSymbolDeclarator)psi).getSymbol();
        OCSymbol oCSymbol = target = symbol != null ? symbol.getAssociatedSymbol() : null;
        if (target != null && (file2 == null || file2.equals(target.getContainingOCFile()))) {
            return (NavigatablePsiElement)target.locateDefinition();
        }
        return null;
    }

    @Nullable
    private static NavigatablePsiElement findCounterPartInFile(PsiElement psi, OCFile file2) {
        while (psi != null && !(psi instanceof PsiFile)) {
            NavigatablePsiElement counter = OCSwitchToHeaderOrSourceRelatedProvider.getCounterPartInFile(psi, file2);
            if (counter != null) {
                return counter;
            }
            psi = psi.getParent();
        }
        return null;
    }
}

