/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.lexer;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRawStringLexerBase
extends LexerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lexer.StringLiteralLexer");
    private static final short LQUOTE = 100;
    private static final short PREFIX = 101;
    private static final short INSIDE = 102;
    private static final short SUFFIX = 103;
    private static final short RQUOTE = 104;
    private CharSequence myBuffer;
    private int myStart;
    private int myEnd;
    private int myState;
    private int myPrefixStart;
    private int myPrefixEnd;
    private int mySuffixStart;
    private int mySuffixEnd;
    private int myLastState;
    private int myBufferEnd;
    private final IElementType myMarkerLiteralToken;
    private final IElementType myContentLiteralToken;

    public OCRawStringLexerBase(@NotNull IElementType markerLiteralToken, @NotNull IElementType contentLiteralToken) {
        if (markerLiteralToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerLiteralToken", "com/jetbrains/cidr/lang/lexer/OCRawStringLexerBase", "<init>"));
        }
        if (contentLiteralToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentLiteralToken", "com/jetbrains/cidr/lang/lexer/OCRawStringLexerBase", "<init>"));
        }
        this.myMarkerLiteralToken = markerLiteralToken;
        this.myContentLiteralToken = contentLiteralToken;
    }

    private static boolean isQChar(char c) {
        return "\\\t\f\r\n\u000b ()".indexOf(c) == -1;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        int textEnd;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/cidr/lang/lexer/OCRawStringLexerBase", "start"));
        }
        if (buffer.length() < endOffset) {
            LogMessageEx.error(LOG, "buffer Length: " + buffer.length() + ", endOffset: " + endOffset, buffer.toString());
        }
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.myBufferEnd = endOffset;
        this.myLastState = initialState;
        if (buffer.length() > 0 && buffer.charAt(startOffset) == '\"') {
            this.myEnd = this.myStart + 1;
            this.myState = 100;
            textEnd = buffer.charAt(this.myBufferEnd - 1) == '\"' ? this.myBufferEnd - 1 : this.myBufferEnd;
        } else {
            this.myEnd = this.myStart;
            this.myState = 101;
            textEnd = this.myBufferEnd;
        }
        this.myPrefixEnd = this.myPrefixStart = this.myEnd;
        while (this.myPrefixEnd < this.myBufferEnd && OCRawStringLexerBase.isQChar(this.myBuffer.charAt(this.myPrefixEnd))) {
            ++this.myPrefixEnd;
        }
        this.mySuffixStart = this.mySuffixEnd = textEnd;
        if (this.myPrefixEnd < this.myBufferEnd && this.myBuffer.charAt(this.myPrefixEnd) == '(') {
            String prefix = this.myPrefixEnd == this.myPrefixStart ? "" : this.myBuffer.subSequence(this.myPrefixStart, this.myPrefixEnd).toString();
            ++this.myPrefixEnd;
            String terminator = ")" + prefix;
            int suffixStart = textEnd - terminator.length();
            String beforeRQuote = this.myBuffer.subSequence(suffixStart, textEnd).toString();
            if (beforeRQuote.equals(terminator)) {
                this.mySuffixStart = suffixStart;
                this.mySuffixEnd = textEnd;
            }
        } else {
            this.myPrefixEnd = textEnd;
        }
    }

    public String getRawText() {
        return this.myBuffer.subSequence(this.myPrefixEnd, this.mySuffixStart).toString();
    }

    public int getState() {
        return this.myLastState;
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        switch (this.myState) {
            case 101: 
            case 103: {
                return this.myMarkerLiteralToken;
            }
            case 100: 
            case 102: 
            case 104: {
                return this.myContentLiteralToken;
            }
        }
        return null;
    }

    public int getTokenStart() {
        return this.myStart;
    }

    public int getTokenEnd() {
        return this.myEnd;
    }

    public void advance() {
        this.myLastState = this.myState;
        this.myStart = this.myEnd;
        if (this.myEnd == this.myBufferEnd - 1) {
            this.myState = this.myBuffer.charAt(this.myEnd) == '\"' ? 104 : 101;
            this.myEnd = this.myBufferEnd;
        } else if (this.myEnd == this.myPrefixStart) {
            this.myEnd = this.myPrefixEnd;
            this.myState = 101;
        } else if (this.myEnd == this.mySuffixStart) {
            this.myEnd = this.mySuffixEnd;
            this.myState = 103;
        } else if (this.myEnd == this.myPrefixEnd) {
            this.myEnd = this.mySuffixStart;
            this.myState = 102;
        }
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/lexer/OCRawStringLexerBase", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }
}

