/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.lexer;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPrefixStringLiteralLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lexer.StringLiteralLexer");
    private static final short PREFIX = 99;
    private static final short AFTER_PREFIX = 100;
    public static final char NO_QUOTE_CHAR = '\uffff';
    private CharSequence myBuffer;
    private int myStart;
    private int myEnd;
    private int myState;
    private int myLastState;
    private int myBufferEnd;
    private final char myPrefixStopChar;
    private final LexerBase myRestLexer;
    private final IElementType myPrefixLiteralToken;

    public OCPrefixStringLiteralLexer(char prefixStopChar, @NotNull IElementType prefixLiteralToken, @NotNull LexerBase restLexer) {
        if (prefixLiteralToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixLiteralToken", "com/jetbrains/cidr/lang/lexer/OCPrefixStringLiteralLexer", "<init>"));
        }
        if (restLexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restLexer", "com/jetbrains/cidr/lang/lexer/OCPrefixStringLiteralLexer", "<init>"));
        }
        this.myPrefixStopChar = prefixStopChar;
        this.myPrefixLiteralToken = prefixLiteralToken;
        this.myRestLexer = restLexer;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/cidr/lang/lexer/OCPrefixStringLiteralLexer", "start"));
        }
        if (buffer.length() < endOffset) {
            LogMessageEx.error(LOG, "buffer Length: " + buffer.length() + ", endOffset: " + endOffset, buffer.toString());
        }
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.myBufferEnd = endOffset;
        this.myLastState = initialState;
        this.myEnd = this.myStart;
        if (this.myPrefixStopChar != '\uffff') {
            while (this.myEnd < this.myBufferEnd && this.myBuffer.charAt(this.myEnd) != this.myPrefixStopChar) {
                ++this.myEnd;
            }
        }
        int n = this.myState = this.myEnd == this.myBufferEnd ? this.myLastState : 99;
        if (this.myEnd == this.myStart) {
            this.advance();
        }
    }

    public int getState() {
        return this.myState == 100 ? this.myRestLexer.getState() : this.myLastState;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myState == 100 ? this.myRestLexer.getTokenType() : this.myPrefixLiteralToken;
    }

    public int getTokenStart() {
        return this.myState == 100 ? this.myRestLexer.getTokenStart() : this.myStart;
    }

    public int getTokenEnd() {
        return this.myState == 100 ? this.myRestLexer.getTokenEnd() : this.myEnd;
    }

    public void advance() {
        if (this.myState == 100) {
            this.myRestLexer.advance();
        } else if (this.myState == 99) {
            this.myRestLexer.start(this.myBuffer, this.myEnd, this.myBufferEnd, this.myLastState);
            this.myState = 100;
        }
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/lexer/OCPrefixStringLiteralLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }
}

