/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.surround.OCIfRespondsToSurrounder;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import org.jetbrains.annotations.NotNull;

public class OCSurroundWithIfRespondsIntentionAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getText() {
        if ("Wrap with \"if ([ respondsToSelector: ])\"" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCSurroundWithIfRespondsIntentionAction", "getText"));
        }
        return "Wrap with \"if ([ respondsToSelector: ])\"";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCSurroundWithIfRespondsIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCSurroundWithIfRespondsIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCSurroundWithIfRespondsIntentionAction", "isAvailable"));
        }
        OCSendMessageExpression sendMessage = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCSendMessageExpression.class, (boolean)false);
        if (sendMessage != null) {
            OCSendMessageExpression.ProbableResponders responders = sendMessage.getProbableResponders();
            OCMethodSymbol responder = responders.getKnownResponder();
            return responder == null || responder.isOptional() || ((OCClassSymbol)responder.getParent()).getName().equals("NSObject") && ((OCClassSymbol)responder.getParent()).getCategoryName() != null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCSurroundWithIfRespondsIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCSurroundWithIfRespondsIntentionAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCSendMessageExpression sendMessage = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCSendMessageExpression.class, (boolean)false);
        OCStatement statement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)sendMessage, OCStatement.class);
        if (statement != null) {
            new OCIfRespondsToSurrounder().doSurroundElements(project, new PsiElement[]{statement}, sendMessage);
        }
    }
}

