/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareMembersHandler;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMoveToInterfaceIntentionAction
extends OCDeclareMembersHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Move to interface" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCMoveToInterfaceIntentionAction", "getText"));
        }
        return "Move to interface";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCMoveToInterfaceIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCMoveToInterfaceIntentionAction", "isAvailable"));
        }
        OCMemberSymbol member = this.locateCandidate(project, editor, file2);
        return member != null && member.getParent() instanceof OCInterfaceSymbol && OCSearchScope.isInProjectSources(member) && "".equals(((OCClassSymbol)member.getParent()).getCategoryName());
    }

    @Override
    @NotNull
    protected OCDeclareActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        OCDeclareActionContext context = super.evaluateActionContext(parent, element);
        context.setTarget(OCDeclareActionContext.Target.INTERFACE);
        OCDeclareActionContext oCDeclareActionContext = context;
        if (oCDeclareActionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCMoveToInterfaceIntentionAction", "evaluateActionContext"));
        }
        return oCDeclareActionContext;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMemberSymbol> candidates) {
        return false;
    }

    @Override
    @Nullable
    protected OCMemberSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCMoveToInterfaceIntentionAction", "locateCandidate"));
        }
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCMethod method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)at, OCMethod.class, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
        if (method != null) {
            return (OCMemberSymbol)method.getSymbol();
        }
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(at, OCDeclarator.class);
        if (declarator == null) {
            return null;
        }
        OCSymbol symbol = declarator.getSymbol();
        return symbol instanceof OCPropertySymbol ? (OCPropertySymbol)symbol : null;
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCMoveToInterfaceIntentionAction", "getParent"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/intentions/OCMoveToInterfaceIntentionAction", "getParent"));
        }
        OCMemberSymbol member = this.locateCandidate(project, editor, file2);
        return member != null ? (OCClassSymbol)member.getParent() : null;
    }
}

