/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMoveIvarsToImplementationIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Move instance variables to implementation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCMoveIvarsToImplementationIntentionAction", "getText"));
        }
        return "Move instance variables to implementation";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCMoveIvarsToImplementationIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCMoveIvarsToImplementationIntentionAction", "isAvailable"));
        }
        Pair<OCInstanceVariablesList, OCInstanceVariablesList> pair = this.locateCandidate(editor, file2);
        return OCCompilerHelper.supportsIvarsInImplementation() && pair != null && OCCodeInsightUtil.isValid((PsiElement)pair.getFirst()) && OCCodeInsightUtil.isValid((PsiElement)pair.getSecond()) && !((OCInstanceVariablesList)pair.getFirst()).isEmpty() && ((OCInstanceVariablesList)pair.getSecond()).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCMoveIvarsToImplementationIntentionAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Pair<OCInstanceVariablesList, OCInstanceVariablesList> pair = this.locateCandidate(editor, file2);
        if (pair != null) {
            PsiFile srcFile = ((OCInstanceVariablesList)pair.getFirst()).getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(srcFile)) {
                return;
            }
            PsiFile dstFile = ((OCInstanceVariablesList)pair.getSecond()).getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(dstFile)) {
                return;
            }
            OCChangeUtil.changeText(project, dstFile, ((OCInstanceVariablesList)pair.getSecond()).getTextOffset(), 0, ((OCInstanceVariablesList)pair.getFirst()).getTextWithMacros(), false);
            OCChangeUtil.changeText(project, srcFile, ((OCInstanceVariablesList)pair.getFirst()).getTextOffset(), ((OCInstanceVariablesList)pair.getFirst()).getTextLength(), "", false);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    protected Pair<OCInstanceVariablesList, OCInstanceVariablesList> locateCandidate(Editor editor, PsiFile file2) {
        OCClassDeclarationBase implementation;
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCInstanceVariablesList intfList = OCElementUtil.getAdjacentParentOfType(at, OCInstanceVariablesList.class);
        OCInterface anInterface = (OCInterface)PsiTreeUtil.getParentOfType((PsiElement)intfList, OCInterface.class);
        if (anInterface == null) {
            return null;
        }
        OCInterfaceSymbol interfaceSymbol = anInterface.getSymbol();
        OCImplementationSymbol implementationSymbol = interfaceSymbol != null ? interfaceSymbol.getImplementation() : null;
        OCClassDeclarationBase oCClassDeclarationBase = implementation = implementationSymbol != null ? (OCClassDeclarationBase)implementationSymbol.locateDefinition() : null;
        if (implementation instanceof OCClassDeclaration) {
            return Pair.create((Object)intfList, (Object)((OCClassDeclaration)implementation).getInstanceVariablesList());
        }
        return null;
    }
}

