/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.intentions.OCSplitFunctionIntentionAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMoveFunctionDefinitionToSourceFileIntentionAction
extends OCSplitFunctionIntentionAction {
    @Override
    @NotNull
    public String getText() {
        if ("Move function definition to source file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCMoveFunctionDefinitionToSourceFileIntentionAction", "getText"));
        }
        return "Move function definition to source file";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCMoveFunctionDefinitionToSourceFileIntentionAction", "isAvailable"));
        }
        if (!OCCodeInsightUtil.isValid((PsiElement)file2) || !(file2 instanceof OCFile)) {
            return false;
        }
        OCFunctionDefinition function = OCMoveFunctionDefinitionToSourceFileIntentionAction.getFunction(editor, file2);
        OCFile ocFile = (OCFile)file2;
        return function != null && function.getNamespaceQualifier() == null && ocFile.isHeader() && ocFile.getAssociatedFile() != null;
    }

    @Override
    @Nullable
    protected PsiElement getInsertAnchor(OCFunctionDefinition function) {
        PsiElement parent;
        OCFunctionSymbol symbol = function.getSymbol();
        OCFile file2 = function.getContainingOCFile().getAssociatedFile();
        if (file2 == null || symbol == null) {
            return null;
        }
        OCSymbolWithQualifiedName struct = symbol.getParent();
        if (struct instanceof OCNamespaceSymbol && !((parent = OCChangeUtil.findInsertionParentInFile(file2, (OCNamespaceSymbol)struct)) instanceof OCFile)) {
            return OCChangeUtil.getRealAnchorForInsertion(parent, null);
        }
        return file2.getLastChild();
    }
}

