/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.intentions.OCMergeElseIfIntention;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCMergeIfAndIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCMergeIfAndIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCMergeIfAndIntention", "isAvailable"));
        }
        OCStatement statement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class);
        if (statement == null) {
            return false;
        }
        if (!OCMergeElseIfIntention.checkCursorInAppropriatePosition(editor, statement)) {
            return false;
        }
        if (this.checkStatement(statement)) {
            return true;
        }
        statement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, OCStatement.class);
        while (statement instanceof OCBlockStatement) {
            statement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, OCStatement.class);
        }
        return this.checkStatement(statement);
    }

    @NotNull
    public String getFamilyName() {
        if ("Merge Nested Ifs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCMergeIfAndIntention", "getFamilyName"));
        }
        return "Merge Nested Ifs";
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCMergeIfAndIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/intentions/OCMergeIfAndIntention", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCStatement parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class);
        if (parentStatement == null) {
            return;
        }
        if (!this.checkStatement(parentStatement)) {
            parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, OCIfStatement.class);
        }
        if (parentStatement == null) {
            return;
        }
        OCIfStatement parentIfStatement = (OCIfStatement)parentStatement;
        OCStatement childStatement = OCParenthesesUtils.stripBraces(parentIfStatement.getThenBranch());
        if (!(childStatement instanceof OCIfStatement)) {
            return;
        }
        OCIfStatement childIfStatement = (OCIfStatement)childStatement;
        OCDeclarationOrExpression childCondition = childIfStatement.getCondition();
        OCExpression childExpressionCondition = childCondition.getExpression();
        OCDeclarationOrExpression parentCondition = parentIfStatement.getCondition();
        OCExpression parentExpressionCondition = parentCondition.getExpression();
        OCBinaryExpression newCondition = (OCBinaryExpression)OCElementFactory.expressionFromText("1 && 2", childExpressionCondition);
        OCParenthesesUtils.replaceExpressionAndAppendParentheses(newCondition.getLeft(), parentExpressionCondition);
        OCParenthesesUtils.replaceExpressionAndAppendParentheses(newCondition.getRight(), childExpressionCondition);
        parentExpressionCondition.replace(newCondition);
        parentIfStatement.getThenBranch().replace(childIfStatement.getThenBranch());
    }

    private boolean checkStatement(OCStatement statement) {
        if (statement instanceof OCIfStatement) {
            this.setText(this.getFamilyName());
            OCIfStatement ifStatement = (OCIfStatement)statement;
            OCStatement thenBranch = ifStatement.getThenBranch();
            thenBranch = OCParenthesesUtils.stripBraces(thenBranch);
            OCStatement elseBranch = ifStatement.getElseBranch();
            elseBranch = OCParenthesesUtils.stripBraces(elseBranch);
            if (thenBranch == null || elseBranch != null || !(thenBranch instanceof OCIfStatement)) {
                return false;
            }
            if (ifStatement.getCondition() == null || ifStatement.getCondition().getExpression() == null) {
                return false;
            }
            OCIfStatement childIfStatement = (OCIfStatement)thenBranch;
            if (childIfStatement.getCondition() == null || childIfStatement.getCondition().getExpression() == null) {
                return false;
            }
            return childIfStatement.getElseBranch() == null;
        }
        return false;
    }
}

