/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateIvarsHandler;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCImplementOCMethodsHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImplementPropertyAccessorsIntentionAction
extends OCImplementOCMethodsHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Implement accessor methods" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCImplementPropertyAccessorsIntentionAction", "getText"));
        }
        return "Implement accessor methods";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCImplementPropertyAccessorsIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    protected static OCPropertySymbol locateProperty(@NotNull Project project, @Nullable Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCImplementPropertyAccessorsIntentionAction", "locateProperty"));
        }
        if (editor == null) {
            return null;
        }
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator parent = OCElementUtil.getAdjacentParentOfType(at, OCDeclarator.class);
        if (parent != null) {
            OCSymbol symbol = parent.getSymbol();
            return symbol instanceof OCPropertySymbol && OCGenerateIvarsHandler.isPropertyDefective((OCPropertySymbol)symbol) ? (OCPropertySymbol)symbol : null;
        }
        return null;
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCOverrideImplementActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/intentions/OCImplementPropertyAccessorsIntentionAction", "loadOptions"));
        }
        ArrayList<Pair<OCOption, Object>> result2 = new ArrayList<Pair<OCOption, Object>>();
        result2.add(new Pair((Object)SHOW_OPTIONAL, (Object)false));
        result2.add(new Pair((Object)SHOW_SYNTHESIZED_ACCESSORS, (Object)true));
        return result2;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCImplementPropertyAccessorsIntentionAction", "isAvailable"));
        }
        return OCCompilerHelper.supportsAutosynthesis(file2) && OCSearchScope.isInProjectSources(OCImplementPropertyAccessorsIntentionAction.locateProperty(project, editor, file2));
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCImplementPropertyAccessorsIntentionAction", "getParent"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/intentions/OCImplementPropertyAccessorsIntentionAction", "getParent"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/intentions/OCImplementPropertyAccessorsIntentionAction", "getParent"));
        }
        OCPropertySymbol prop = OCImplementPropertyAccessorsIntentionAction.locateProperty(project, editor, file2);
        return prop != null ? ((OCClassSymbol)prop.getParent()).getMainInterface() : null;
    }

    @Override
    @NotNull
    protected Collection<OCMethodSymbol> getSelectedCandidates(OCOverrideImplementActionContext context, @Nullable Editor editor, PsiFile file2, List<OCMethodSymbol> candidates) {
        PsiElement elementContext = context.getContext();
        final OCPropertySymbol property = OCImplementPropertyAccessorsIntentionAction.locateProperty(elementContext.getProject(), editor, elementContext.getContainingFile());
        CommonProcessors.CollectProcessor<OCMethodSymbol> collector = new CommonProcessors.CollectProcessor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol method) {
                if (method.getGeneratedFromProperty() == property) {
                    return super.process((Object)method);
                }
                return true;
            }
        };
        if (property != null) {
            ((OCClassSymbol)property.getParent()).processMembers(OCMethodSymbol.class, collector);
        }
        Collection collection = collector.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCImplementPropertyAccessorsIntentionAction", "getSelectedCandidates"));
        }
        return collection;
    }
}

