/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareMembersHandler;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclareMethodInInterfaceIntentionAction
extends OCDeclareMembersHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Declare method in interface" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCDeclareMethodInInterfaceIntentionAction", "getText"));
        }
        return "Declare method in interface";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCDeclareMethodInInterfaceIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected OCMethodSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCDeclareMethodInInterfaceIntentionAction", "locateCandidate"));
        }
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCMethod method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)at, OCMethod.class, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
        return method != null ? (OCMethodSymbol)method.getSymbol() : null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCDeclareMethodInInterfaceIntentionAction", "isAvailable"));
        }
        OCMethodSymbol method = this.locateCandidate(project, editor, file2);
        return method != null && OCSearchScope.isInProjectSources(method) && method.isDefinition() && method.getAssociatedSymbol() == null;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMemberSymbol> candidates) {
        return false;
    }

    @Override
    @NotNull
    protected OCDeclareActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        OCDeclareActionContext context = super.evaluateActionContext(parent, element);
        context.setTarget(OCDeclareActionContext.Target.INTERFACE);
        OCDeclareActionContext oCDeclareActionContext = context;
        if (oCDeclareActionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCDeclareMethodInInterfaceIntentionAction", "evaluateActionContext"));
        }
        return oCDeclareActionContext;
    }
}

