/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeGuesser;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCCreateMissingSwitchCasesIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Create missing switch cases" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCCreateMissingSwitchCasesIntentionAction", "getText"));
        }
        return "Create missing switch cases";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCCreateMissingSwitchCasesIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCCreateMissingSwitchCasesIntentionAction", "isAvailable"));
        }
        return !this.getMissingCases(editor, file2).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        OCBlockStatement switchBlock;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCCreateMissingSwitchCasesIntentionAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCSwitchStatement stmt = this.getSwitchStatement(editor, file2);
        if (stmt != null && OCCodeInsightUtil.isValid(stmt) && (switchBlock = stmt.getBody()) != null) {
            this.invoke(switchBlock, this.getMissingCases(editor, file2));
        }
    }

    protected OCSwitchStatement getSwitchStatement(Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        return OCElementUtil.getAdjacentParentOfType(element, OCSwitchStatement.class);
    }

    protected void invoke(OCBlockStatement switchBlock, List<OCDeclaratorSymbol> missingCases) {
        for (OCDeclaratorSymbol missingCase : missingCases) {
            OCReferenceElement ref;
            String name = missingCase.getName();
            if (missingCase.getParent() != null) {
                name = missingCase.getParent().getQualifiedName().getNameWithParent() + "::" + name;
            }
            OCCaseStatement statement = (OCCaseStatement)OCElementFactory.statementFromText("case " + name + ":break;", switchBlock);
            OCReferenceExpression expression = (OCReferenceExpression)(statement = OCChangeUtil.add(switchBlock, statement)).getExpression();
            if (expression == null || (ref = expression.getReferenceElement()) == null) continue;
            OCBindUtil.setShortestPossibleName(missingCase.getResolvedQualifiedName(), ref, missingCase);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private List<OCDeclaratorSymbol> getMissingCases(Editor editor, PsiFile file2) {
        OCSwitchStatement stmt = this.getSwitchStatement(editor, file2);
        if (stmt != null && OCCodeInsightUtil.isValid(stmt)) {
            OCBlockStatement body = stmt.getBody();
            ArrayList<Pair<Integer, Integer>> ranges = new ArrayList<Pair<Integer, Integer>>();
            ArrayList<OCCaseStatement> caseStmts = new ArrayList<OCCaseStatement>();
            boolean wasDefaultOrUnresolved = true;
            if (body != null) {
                wasDefaultOrUnresolved = OCCreateMissingSwitchCasesIntentionAction.findCaseStatements(body, ranges, caseStmts);
            }
            if (this.proceedIfDefaultOrUnresolved(wasDefaultOrUnresolved)) {
                return OCCreateMissingSwitchCasesIntentionAction.getMissingCases(stmt, ranges, (Ref<Boolean>)Ref.create((Object)false));
            }
        }
        return Collections.emptyList();
    }

    protected boolean proceedIfDefaultOrUnresolved(boolean defaultOrUnresolved) {
        return defaultOrUnresolved;
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getMissingCases(final @NotNull OCSwitchStatement stmt, final List<Pair<Integer, Integer>> ranges, final Ref<Boolean> wasField) {
        if (stmt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stmt", "com/jetbrains/cidr/lang/intentions/OCCreateMissingSwitchCasesIntentionAction", "getMissingCases"));
        }
        OCDeclarationOrExpression expr = stmt.getExpression();
        if (expr == null) {
            List<OCDeclaratorSymbol> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCCreateMissingSwitchCasesIntentionAction", "getMissingCases"));
            }
            return list;
        }
        OCType type = expr.getResolvedType();
        final ArrayList<OCDeclaratorSymbol> missingCases = new ArrayList<OCDeclaratorSymbol>();
        final HashSet missingValues = new HashSet();
        Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){

            public boolean process(OCSymbol field) {
                Integer value = OCExpressionEvaluator.evaluateEnumConst(field, stmt.getContainingFile());
                boolean wasHandled = false;
                wasField.set((Object)true);
                if (value != null) {
                    for (Pair range : ranges) {
                        if ((Integer)range.getFirst() > value || value > (Integer)range.getSecond()) continue;
                        wasHandled = true;
                        break;
                    }
                    if (!wasHandled && !missingValues.contains(value)) {
                        missingCases.add((OCDeclaratorSymbol)field);
                        missingValues.add(value);
                    }
                }
                return true;
            }
        };
        if (type.getTerminalType() instanceof OCStructType) {
            OCStructType structType = (OCStructType)type.getTerminalType();
            for (OCDeclaratorSymbol field : structType.getFields()) {
                processor2.process((Object)field);
            }
        } else if (type.getTerminalType() instanceof OCIntType) {
            OCTypeGuesser.processGuessedEnumConsts((OCIntType)type.getTerminalType(), processor2, stmt);
        }
        Collections.sort(missingCases, new Comparator<OCDeclaratorSymbol>(){

            @Override
            public int compare(OCDeclaratorSymbol o1, OCDeclaratorSymbol o2) {
                return OCSymbolOffsetUtil.compare(o1.getComplexOffset(), o2.getComplexOffset());
            }
        });
        ArrayList<OCDeclaratorSymbol> arrayList = missingCases;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCCreateMissingSwitchCasesIntentionAction", "getMissingCases"));
        }
        return arrayList;
    }

    public static boolean findCaseStatements(@NotNull OCBlockStatement body, final List<Pair<Integer, Integer>> ranges, final List<OCCaseStatement> caseStmts) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/jetbrains/cidr/lang/intentions/OCCreateMissingSwitchCasesIntentionAction", "findCaseStatements"));
        }
        final Ref wasDefault = Ref.create((Object)false);
        final Ref wasUnresolved = Ref.create((Object)false);
        body.accept(new OCRecursiveVisitor(){

            @Override
            public void visitCaseStatement(OCCaseStatement stmt) {
                super.visitCaseStatement(stmt);
                Pair range = null;
                if (stmt.getExpression() != null) {
                    Number integer = OCExpressionEvaluator.evaluate(stmt.getExpression());
                    if (integer != null) {
                        range = Pair.create((Object)integer.intValue(), (Object)integer.intValue());
                    } else {
                        wasUnresolved.set((Object)true);
                    }
                } else if (stmt.getRangeFirst() != null && stmt.getRangeSecond() != null) {
                    Number first = OCExpressionEvaluator.evaluate(stmt.getRangeFirst());
                    Number second = OCExpressionEvaluator.evaluate(stmt.getRangeSecond());
                    if (first != null && second != null) {
                        range = Pair.create((Object)first.intValue(), (Object)second.intValue());
                    } else {
                        wasUnresolved.set((Object)true);
                    }
                } else if (stmt.isDefault()) {
                    wasDefault.set((Object)true);
                }
                if (range != null) {
                    ranges.add(range);
                    caseStmts.add(stmt);
                }
            }

            @Override
            public void visitSwitchStatement(OCSwitchStatement stmt) {
            }
        });
        return (Boolean)wasDefault.get() != false || (Boolean)wasUnresolved.get() != false;
    }
}

